/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.seckill.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.config.BizvaneSecurityContext;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.MarketActivityEnum;
import com.wmeimob.fastboot.bizvane.enums.seckill.MarketActivitySecKillStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsSecKillPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityMomentPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityOrdersSecKillStockPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MsgWxSubScribePOMapper;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsSecKillPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsSecKillPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityMomentPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityMomentPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersSecKillStockPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPOExample;
import com.wmeimob.fastboot.bizvane.po.MsgWxSubScribePOExample;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillService;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.seckill.GoodsMarketActivityVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityGoodsSecKillConditionVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityGoodsSecKillRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityGoodsSecKillResponseVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityGoodsSecKillVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityTheLatestRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityTheLatestResponseVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityTodayVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MomentHaveNotStartVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MomentOnGoingNowVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MomentOnGoingVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MarketActivitySecKillServiceImpl
implements MarketActivitySecKillService {
    private static final Logger log = LoggerFactory.getLogger(MarketActivitySecKillServiceImpl.class);
    @Resource
    private MarketActivityPOMapper marketActivityPOMapper;
    @Resource
    private MarketActivityMomentPOMapper marketActivityMomentPOMapper;
    @Resource
    private MarketActivityGoodsSecKillPOMapper marketActivityGoodsSecKillPOMapper;
    @Resource
    private MarketActivityOrdersSecKillStockPOMapper marketActivityOrdersSecKillStockPOMapper;
    @Resource
    private MsgWxSubScribePOMapper msgWxSubScribePOMapper;
    @Resource
    private MarketActivityGoodsPOMapper marketActivityGoodsPOMapper;
    @Resource
    private GoodsSkuDetailPOMapper goodsSkuDetailPOMapper;

    public ResponseData<MarketActivityTodayVO> queryMarketActivityMomentToday(Integer merchantId) {
        MarketActivityTodayVO marketActivityTodayVO = new MarketActivityTodayVO();
        Date date = new Date();
        Calendar start = Calendar.getInstance();
        start.setTime(date);
        start.set(13, 0);
        start.set(12, 0);
        start.set(11, 0);
        start.set(14, 0);
        Date startDateOfDay = start.getTime();
        Calendar end = Calendar.getInstance();
        end.setTime(date);
        end.set(13, 59);
        end.set(12, 59);
        end.set(14, 999);
        Date endDateOfDay = end.getTime();
        String formatDate = DateUtil.format((Date)date, (String)DateUtil.ymd);
        String marketActivityType = MarketActivityEnum.SEC_KILL.getType().toString();
        MarketActivityPOExample marketActivityPOExample = new MarketActivityPOExample();
        marketActivityPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andActivityTypeEqualTo(marketActivityType).andActivityStatusValueEqualTo(MarketActivitySecKillStatusEnum.ON_GOING.getCode()).andActivityBeginTimeBetween(startDateOfDay, endDateOfDay);
        List marketActivityPOS = this.marketActivityPOMapper.selectByExample(marketActivityPOExample);
        if (CollectionUtils.isEmpty((Collection)marketActivityPOS)) {
            log.info("\u5546\u6237:{}\u65e5\u671f:{}\u4e0d\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u79d2\u6740\u6d3b\u52a8", (Object)merchantId, (Object)formatDate);
        } else {
            List currentList = marketActivityPOS.stream().filter(marketActivityPO -> DateUtil.getCurrentHour().equals(DateUtil.getCurrentHour((Date)marketActivityPO.getActivityBeginTime()))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(currentList)) {
                MarketActivityPO marketActivityPO2 = (MarketActivityPO)currentList.get(0);
                MarketActivityMomentPO marketActivityMomentPO2 = this.marketActivityMomentPOMapper.selectByPrimaryKey(marketActivityPO2.getMarketActivityMomentId());
                MomentOnGoingNowVO momentOnGoingNowVO = new MomentOnGoingNowVO();
                BeanUtils.copyProperties((Object)marketActivityMomentPO2, (Object)momentOnGoingNowVO);
                momentOnGoingNowVO.setMarketActivityBeginDate(date);
                marketActivityTodayVO.setOnGoingNow(momentOnGoingNowVO);
                marketActivityPOS.removeAll(currentList);
                log.info("\u75af\u62a2\u4e2d:{}", (Object)JSON.toJSONString((Object)momentOnGoingNowVO));
            }
            if (!CollectionUtils.isEmpty((Collection)marketActivityPOS)) {
                List momentId = marketActivityPOS.stream().map(marketActivityPO -> marketActivityPO.getMarketActivityMomentId()).distinct().collect(Collectors.toList());
                MarketActivityMomentPOExample marketActivityMomentPOExample = new MarketActivityMomentPOExample();
                marketActivityMomentPOExample.createCriteria().andMarketActivityMomentIdIn(momentId).andValidEqualTo(Boolean.TRUE);
                List marketActivityMomentPOS = this.marketActivityMomentPOMapper.selectByExample(marketActivityMomentPOExample);
                ArrayList<MomentOnGoingVO> momentOnGoingVOS = new ArrayList<MomentOnGoingVO>();
                for (MarketActivityMomentPO marketActivityMomentPO3 : marketActivityMomentPOS) {
                    MomentOnGoingVO momentOnGoingVO = new MomentOnGoingVO();
                    BeanUtils.copyProperties((Object)marketActivityMomentPO3, (Object)momentOnGoingVO);
                    momentOnGoingVO.setMarketActivityBeginDate(date);
                    momentOnGoingVOS.add(momentOnGoingVO);
                }
                marketActivityTodayVO.setOnGoing(momentOnGoingVOS);
                log.info("\u8fdb\u884c\u4e2d:{}", (Object)JSON.toJSONString(momentOnGoingVOS));
            }
        }
        marketActivityPOExample = new MarketActivityPOExample();
        marketActivityPOExample.setOrderByClause("activity_begin_time asc");
        marketActivityPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andActivityTypeEqualTo(marketActivityType).andActivityStatusValueEqualTo(MarketActivitySecKillStatusEnum.HAVE_NOT_START.getCode()).andActivityBeginTimeGreaterThan(endDateOfDay);
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)marketActivityPOExample), Map.class);
        map.put("groupBy", "DATE_FORMAT(activity_begin_time,\"%Y%m%d\"),market_activity_moment_id");
        PageHelper.startPage((int)1, (int)10);
        List marketActivityNotStartPOS = this.marketActivityPOMapper.selectByExampleGroupByCondition(map);
        PageInfo marketActivityPOPageInfo = new PageInfo(marketActivityNotStartPOS);
        List notStartList = marketActivityPOPageInfo.getList();
        if (!CollectionUtils.isEmpty((Collection)notStartList)) {
            List notStartMomentIds = notStartList.stream().map(MarketActivityPO::getMarketActivityMomentId).collect(Collectors.toList());
            MarketActivityMomentPOExample marketActivityMomentPOExample = new MarketActivityMomentPOExample();
            marketActivityMomentPOExample.createCriteria().andMarketActivityMomentIdIn(notStartMomentIds).andValidEqualTo(Boolean.TRUE);
            List marketActivityMomentPOS = this.marketActivityMomentPOMapper.selectByExample(marketActivityMomentPOExample);
            Map<Integer, MarketActivityMomentPO> momentPOMap = marketActivityMomentPOS.stream().collect(Collectors.toMap(MarketActivityMomentPO::getMarketActivityMomentId, marketActivityMomentPO -> marketActivityMomentPO));
            List collect = notStartList.stream().map(marketActivityPO -> DateUtil.format((Date)marketActivityPO.getActivityBeginTime(), (String)DateUtil.yyyyMMdd_yd)).distinct().collect(Collectors.toList());
            ArrayList<MomentHaveNotStartVO> momentHaveNotStartVOS = new ArrayList<MomentHaveNotStartVO>();
            for (String yyyyMMdd : collect) {
                MomentHaveNotStartVO momentHaveNotStartVO2 = new MomentHaveNotStartVO();
                Date parse = DateUtil.parse((String)yyyyMMdd, (String)DateUtil.yyyyMMdd_yd);
                start = Calendar.getInstance();
                start.setTime(parse);
                start.set(13, 0);
                start.set(12, 0);
                start.set(11, 0);
                start.set(14, 0);
                startDateOfDay = start.getTime();
                end = Calendar.getInstance();
                end.setTime(parse);
                end.set(11, 23);
                end.set(13, 59);
                end.set(12, 59);
                end.set(14, 999);
                endDateOfDay = end.getTime();
                marketActivityPOExample = new MarketActivityPOExample();
                marketActivityPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andActivityTypeEqualTo(marketActivityType).andActivityStatusValueEqualTo(MarketActivitySecKillStatusEnum.HAVE_NOT_START.getCode()).andActivityBeginTimeBetween(startDateOfDay, endDateOfDay);
                List marketActivityPOList = this.marketActivityPOMapper.selectByExample(marketActivityPOExample);
                if (CollectionUtils.isEmpty((Collection)marketActivityPOList)) continue;
                List momentIds = marketActivityPOList.stream().map(marketActivityPO -> marketActivityPO.getMarketActivityMomentId()).distinct().collect(Collectors.toList());
                ArrayList<MarketActivityMomentPO> marketActivityMomentPOArrayList = new ArrayList<MarketActivityMomentPO>();
                for (Integer momentId : momentIds) {
                    MarketActivityMomentPO marketActivityMomentPO4 = momentPOMap.get(momentId);
                    if (marketActivityMomentPO4 == null) continue;
                    marketActivityMomentPOArrayList.add(marketActivityMomentPO4);
                }
                Date beginDate = notStartList.stream().filter(marketActivityPO -> DateUtil.format((Date)marketActivityPO.getActivityBeginTime(), (String)DateUtil.yyyyMMdd_yd).equals(yyyyMMdd)).map(marketActivityPO -> marketActivityPO.getActivityBeginTime()).max(Date::compareTo).get();
                List marketActivityMomentList = marketActivityMomentPOArrayList.stream().sorted(Comparator.comparing(marketActivityMomentPO -> Integer.valueOf(marketActivityMomentPO.getMarketActivityMomentDate()))).collect(Collectors.toList());
                momentHaveNotStartVO2.setMarketActivityBeginDate(beginDate);
                momentHaveNotStartVO2.setList(marketActivityMomentList);
                momentHaveNotStartVOS.add(momentHaveNotStartVO2);
            }
            if (!CollectionUtils.isEmpty(momentHaveNotStartVOS)) {
                List notStartVOList = momentHaveNotStartVOS.stream().sorted(Comparator.comparing(momentHaveNotStartVO -> momentHaveNotStartVO.getMarketActivityBeginDate().getTime())).collect(Collectors.toList());
                marketActivityTodayVO.setHaveNotStart(notStartVOList);
                log.info("\u672a\u5f00\u59cb\u7684\u573a\u6b21:{}", (Object)JSON.toJSONString(notStartVOList));
            }
        }
        return ResponseUtil.getSuccessData((Object)marketActivityTodayVO);
    }

    public ResponseData<MarketActivityGoodsSecKillResponseVO> queryMarketActivityGoodsSecKillByMomentId(MarketActivityGoodsSecKillRequestVO requestVO, Integer merchantId) {
        Date date = new Date();
        Date marketActivityDate = requestVO.getMarketActivityDate();
        if (marketActivityDate != null) {
            date = marketActivityDate;
        }
        Calendar start = Calendar.getInstance();
        start.setTime(date);
        start.set(13, 0);
        start.set(12, 0);
        start.set(11, 0);
        start.set(14, 0);
        Date startDateOfDay = start.getTime();
        start.add(5, 1);
        Date endDateOfDay = start.getTime();
        String formatDate = DateUtil.format((Date)date, (String)DateUtil.ymd);
        List marketActivityMomentIds = requestVO.getMarketActivityMomentIds();
        if (CollectionUtils.isEmpty((Collection)marketActivityMomentIds)) {
            return ResponseUtil.getFailedMsg((String)"\u8425\u9500\u6d3b\u52a8\u573a\u6b21id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String marketActivityType = MarketActivityEnum.SEC_KILL.getType().toString();
        ArrayList<Integer> activityStatusValidList = new ArrayList<Integer>();
        activityStatusValidList.add(MarketActivitySecKillStatusEnum.HAVE_NOT_START.getCode());
        activityStatusValidList.add(MarketActivitySecKillStatusEnum.ON_GOING.getCode());
        MarketActivityPOExample marketActivityPOExample = new MarketActivityPOExample();
        marketActivityPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andActivityTypeEqualTo(marketActivityType).andActivityStatusValueIn(activityStatusValidList).andActivityBeginTimeGreaterThanOrEqualTo(startDateOfDay).andMarketActivityMomentIdIn(marketActivityMomentIds).andActivityEndTimeLessThan(endDateOfDay);
        List marketActivityPOS = this.marketActivityPOMapper.selectByExample(marketActivityPOExample);
        if (CollectionUtils.isEmpty((Collection)marketActivityPOS)) {
            log.info("\u5546\u6237id:{},\u573a\u6b21id:{},\u4e0d\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u6d3b\u52a8", (Object)merchantId, (Object)JSON.toJSONString((Object)marketActivityMomentIds));
            return ResponseUtil.getSuccessData(null);
        }
        Integer secKillType = requestVO.getSecKillType();
        MarketActivityGoodsSecKillConditionVO conditionVO = new MarketActivityGoodsSecKillConditionVO();
        conditionVO.setSecKillType(secKillType);
        conditionVO.setMomentIds(marketActivityMomentIds);
        conditionVO.setTimeSearch(Boolean.TRUE);
        conditionVO.setBeginTime(startDateOfDay);
        conditionVO.setEndTime(endDateOfDay);
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        List marketActivityGoodsSecKillVOS = this.marketActivityGoodsSecKillPOMapper.queryMarketActivityVOByMomentId(conditionVO);
        PageInfo marketActivityGoodsSecKillVOPageInfo = new PageInfo(marketActivityGoodsSecKillVOS);
        List list = marketActivityGoodsSecKillVOPageInfo.getList();
        log.info("\u5f53\u524dlist:{}", (Object)list.size());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (int i = 0; i < list.size(); ++i) {
                MarketActivityGoodsSecKillVO marketActivityGoodsSecKillVO = (MarketActivityGoodsSecKillVO)list.get(i);
                List goodsSkuDetailWithSecKillStockVOS = this.marketActivityGoodsPOMapper.queryMarketActivityGoodsWithStock(marketActivityGoodsSecKillVO.getMarketActivityGoodsSeckillId());
                int goodsStock = 0;
                if (CollectionUtils.isEmpty((Collection)goodsSkuDetailWithSecKillStockVOS)) {
                    log.warn("goods_id:{}\u4e0b\u90fd\u662f\u65e0\u6548\u5546\u54c1", (Object)marketActivityGoodsSecKillVO.getGoodsId());
                } else {
                    BigDecimal maxMarketPrice = goodsSkuDetailWithSecKillStockVOS.stream().map(goodsSkuDetailPO -> goodsSkuDetailPO.getMarketPrice()).max(BigDecimal::compareTo).get();
                    marketActivityGoodsSecKillVO.setMarketPrice(maxMarketPrice);
                    goodsStock = goodsSkuDetailWithSecKillStockVOS.stream().map(goodsSkuDetailPO -> Math.min(goodsSkuDetailPO.getStock(), goodsSkuDetailPO.getSecKillStock())).mapToInt(stock -> stock).sum();
                }
                MarketActivityGoodsPOExample marketActivityGoodsPOExample = new MarketActivityGoodsPOExample();
                marketActivityGoodsPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andMarketActivityGoodsSeckillIdEqualTo(marketActivityGoodsSecKillVO.getMarketActivityGoodsSeckillId()).andValidEqualTo(Boolean.TRUE);
                List marketActivityGoodsPOList = this.marketActivityGoodsPOMapper.selectByExample(marketActivityGoodsPOExample);
                if (CollectionUtils.isEmpty((Collection)marketActivityGoodsPOList)) {
                    log.warn("goods_id:{}\u4e0b\u90fd\u662f\u65e0\u6548\u5546\u54c1,\u4e0d\u5b58\u5728sku\u4fe1\u606f", (Object)marketActivityGoodsSecKillVO.getGoodsId());
                } else {
                    BigDecimal secKillPrice = marketActivityGoodsPOList.stream().map(marketActivityGoodsPO -> marketActivityGoodsPO.getAmount()).min(BigDecimal::compareTo).get();
                    marketActivityGoodsSecKillVO.setSecKillPrice(secKillPrice);
                }
                MarketActivityOrdersSecKillStockPOExample marketActivityOrdersSecKillStockPOExample = new MarketActivityOrdersSecKillStockPOExample();
                marketActivityOrdersSecKillStockPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andMarketActivityIdEqualTo(marketActivityGoodsSecKillVO.getMarketActivityId()).andMarketActivityGoodsSeckillIdEqualTo(marketActivityGoodsSecKillVO.getMarketActivityGoodsSeckillId()).andValidEqualTo(Boolean.TRUE).andStatusEqualTo(Boolean.FALSE);
                List marketActivityOrdersSecKillStockPOList = this.marketActivityOrdersSecKillStockPOMapper.selectByExample(marketActivityOrdersSecKillStockPOExample);
                int goodsSecKillStock = 0;
                if (!CollectionUtils.isEmpty((Collection)marketActivityOrdersSecKillStockPOList)) {
                    goodsSecKillStock = marketActivityOrdersSecKillStockPOList.size();
                }
                if (goodsStock > goodsSecKillStock) {
                    marketActivityGoodsSecKillVO.setStocks(Integer.valueOf(goodsSecKillStock));
                } else {
                    marketActivityGoodsSecKillVO.setStocks(Integer.valueOf(goodsStock));
                }
                if (secKillType != 2) continue;
                User user = BizvaneSecurityContext.getUser();
                MsgWxSubScribePOExample msgWxSubScribePOExample = new MsgWxSubScribePOExample();
                msgWxSubScribePOExample.createCriteria().andMerchantIdEqualTo(merchantId).andTouserEqualTo(user.getOpenid()).andMarketActivityGoodsSeckillIdEqualTo(marketActivityGoodsSecKillVO.getMarketActivityGoodsSeckillId()).andValidEqualTo(Boolean.TRUE);
                List msgWxSubScribePOS = this.msgWxSubScribePOMapper.selectByExample(msgWxSubScribePOExample);
                if (!CollectionUtils.isEmpty((Collection)msgWxSubScribePOS)) {
                    marketActivityGoodsSecKillVO.setSubScribe(Integer.valueOf(1));
                    continue;
                }
                marketActivityGoodsSecKillVO.setSubScribe(Integer.valueOf(0));
            }
            marketActivityGoodsSecKillVOPageInfo.setList(list);
        }
        MarketActivityGoodsSecKillResponseVO marketActivityGoodsSecKillResponseVO = new MarketActivityGoodsSecKillResponseVO();
        marketActivityGoodsSecKillResponseVO.setPageInfo(marketActivityGoodsSecKillVOPageInfo);
        return ResponseUtil.getSuccessData((Object)marketActivityGoodsSecKillResponseVO);
    }

    public ResponseData<MarketActivityTheLatestResponseVO> queryTheLatestMarketActivity(MarketActivityTheLatestRequestVO requestVO, Integer merchantId) {
        Date date = new Date();
        Calendar theDayHourStart = Calendar.getInstance();
        theDayHourStart.setTime(date);
        Integer currentHour = theDayHourStart.get(11);
        theDayHourStart.set(13, 0);
        theDayHourStart.set(12, 0);
        theDayHourStart.set(14, 0);
        Date time = theDayHourStart.getTime();
        Date startDateOfDay = DateUtil.getStartDateOfDay((Date)date);
        Date endDateOfDay = DateUtil.getEndDateOfDay((Date)date);
        String marketActivityType = MarketActivityEnum.SEC_KILL.getType().toString();
        ArrayList<Integer> activityStatusValidList = new ArrayList<Integer>();
        activityStatusValidList.add(MarketActivitySecKillStatusEnum.HAVE_NOT_START.getCode());
        activityStatusValidList.add(MarketActivitySecKillStatusEnum.ON_GOING.getCode());
        MarketActivityPOExample marketActivityPOExample = new MarketActivityPOExample();
        marketActivityPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andActivityTypeEqualTo(marketActivityType).andActivityStatusValueIn(activityStatusValidList).andActivityBeginTimeBetween(startDateOfDay, endDateOfDay);
        List marketActivityPOS = this.marketActivityPOMapper.selectByExample(marketActivityPOExample);
        if (!CollectionUtils.isEmpty((Collection)marketActivityPOS)) {
            List collectOnGoing = marketActivityPOS.stream().filter(marketActivityPO -> MarketActivitySecKillStatusEnum.ON_GOING.getCode().equals(marketActivityPO.getActivityStatusValue())).sorted(Comparator.comparing(MarketActivityPO::getActivityBeginTime).reversed()).collect(Collectors.toList());
            List collectNotStart = marketActivityPOS.stream().filter(marketActivityPO -> MarketActivitySecKillStatusEnum.HAVE_NOT_START.getCode().equals(marketActivityPO.getActivityStatusValue())).sorted(Comparator.comparing(MarketActivityPO::getActivityBeginTime)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collectOnGoing)) {
                MarketActivityPO marketActivityPO2 = (MarketActivityPO)collectOnGoing.get(0);
                if (DateUtil.getCurrentHour((Date)marketActivityPO2.getActivityBeginTime()).equals(DateUtil.getCurrentDay((Date)date))) {
                    MarketActivityTheLatestResponseVO goodsListByMarketActivityInfo = this.getGoodsListByMarketActivityInfo(requestVO, marketActivityPO2);
                    goodsListByMarketActivityInfo.setMarketActivityPO(marketActivityPO2);
                    if (!CollectionUtils.isEmpty(collectNotStart)) {
                        MarketActivityPO marketActivityPONext = (MarketActivityPO)collectNotStart.get(0);
                        goodsListByMarketActivityInfo.setNextMarketActivityPO(marketActivityPONext);
                    }
                    return ResponseUtil.getSuccessData((Object)goodsListByMarketActivityInfo);
                }
                marketActivityPO2 = (MarketActivityPO)collectOnGoing.stream().sorted(Comparator.comparing(MarketActivityPO::getActivityEndTime).reversed()).collect(Collectors.toList()).get(0);
                MarketActivityTheLatestResponseVO goodsListByMarketActivityInfo = this.getGoodsListByMarketActivityInfo(requestVO, marketActivityPO2);
                return ResponseUtil.getSuccessData((Object)goodsListByMarketActivityInfo);
            }
            MarketActivityPO marketActivityPO3 = (MarketActivityPO)collectNotStart.get(0);
            MarketActivityTheLatestResponseVO goodsListByMarketActivityInfo = this.getGoodsListByMarketActivityInfo(requestVO, marketActivityPO3);
            goodsListByMarketActivityInfo.setMarketActivityPO(marketActivityPO3);
            if (collectOnGoing.size() > 1) {
                MarketActivityPO marketActivityPONext = (MarketActivityPO)collectNotStart.get(1);
                goodsListByMarketActivityInfo.setNextMarketActivityPO(marketActivityPONext);
            }
            return ResponseUtil.getSuccessData((Object)goodsListByMarketActivityInfo);
        }
        marketActivityPOExample = new MarketActivityPOExample();
        marketActivityPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andActivityTypeEqualTo(marketActivityType).andActivityStatusValueIn(activityStatusValidList).andActivityBeginTimeGreaterThanOrEqualTo(endDateOfDay);
        marketActivityPOS = this.marketActivityPOMapper.selectByExample(marketActivityPOExample);
        if (CollectionUtils.isEmpty((Collection)marketActivityPOS)) {
            log.info("\u5f53\u524d\u6ca1\u6709\u8fdb\u884c\u4e2d\u7684\u79d2\u6740\u6d3b\u52a8");
            return ResponseUtil.getSuccessData(null, (String)"\u5f53\u524d\u5546\u6237\u6ca1\u6709\u6709\u6548\u7684\u79d2\u6740\u6d3b\u52a8");
        }
        List collectNotStart = marketActivityPOS.stream().sorted(Comparator.comparing(MarketActivityPO::getActivityBeginTime)).collect(Collectors.toList());
        MarketActivityPO marketActivityPO4 = (MarketActivityPO)collectNotStart.get(0);
        MarketActivityTheLatestResponseVO goodsListByMarketActivityInfo = this.getGoodsListByMarketActivityInfo(requestVO, marketActivityPO4);
        if (collectNotStart.size() > 1) {
            MarketActivityPO marketActivityPONotStart = (MarketActivityPO)collectNotStart.get(1);
            goodsListByMarketActivityInfo.setNextMarketActivityPO(marketActivityPONotStart);
        }
        return ResponseUtil.getSuccessData((Object)goodsListByMarketActivityInfo);
    }

    public GoodsMarketActivityVO queryMarketActivityByGoodsId(Integer merchantId, Integer goodsId) {
        GoodsMarketActivityVO goodsMarketActivityVO = new GoodsMarketActivityVO();
        MarketActivityGoodsPOExample marketActivityGoodsPOExample = new MarketActivityGoodsPOExample();
        marketActivityGoodsPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andGoodsIdEqualTo(goodsId).andValidEqualTo(Boolean.TRUE);
        List marketActivityGoodsPOList = this.marketActivityGoodsPOMapper.selectByExample(marketActivityGoodsPOExample);
        if (CollectionUtils.isEmpty((Collection)marketActivityGoodsPOList)) {
            return null;
        }
        List activityNoList = marketActivityGoodsPOList.stream().map(marketActivityGoodsPO -> marketActivityGoodsPO.getMarketActivityNo()).distinct().collect(Collectors.toList());
        ArrayList<Integer> integers = new ArrayList<Integer>();
        integers.add(MarketActivitySecKillStatusEnum.HAVE_NOT_START.getCode());
        integers.add(MarketActivitySecKillStatusEnum.ON_GOING.getCode());
        MarketActivityPOExample marketActivityPOExample = new MarketActivityPOExample();
        marketActivityPOExample.createCriteria().andActivityNoIn(activityNoList).andActivityTypeEqualTo(MarketActivityEnum.SEC_KILL.getType().toString()).andActivityStatusValueIn(integers).andValidEqualTo(Boolean.TRUE);
        List marketActivityPOList = this.marketActivityPOMapper.selectByExample(marketActivityPOExample);
        if (CollectionUtils.isEmpty((Collection)marketActivityPOList)) {
            return null;
        }
        MarketActivityPO marketActivityPO = marketActivityPOList.stream().sorted(Comparator.comparing(MarketActivityPO::getActivityBeginTime)).findFirst().get();
        goodsMarketActivityVO.setMarketActivityPO(marketActivityPO);
        MarketActivityGoodsSecKillPOExample marketActivityGoodsSecKillPOExample = new MarketActivityGoodsSecKillPOExample();
        marketActivityGoodsSecKillPOExample.createCriteria().andMarketActivityIdEqualTo(marketActivityPO.getId()).andGoodsIdEqualTo(goodsId).andValidEqualTo(Boolean.TRUE);
        List marketActivityGoodsSecKillPOList = this.marketActivityGoodsSecKillPOMapper.selectByExample(marketActivityGoodsSecKillPOExample);
        if (CollectionUtils.isEmpty((Collection)marketActivityGoodsSecKillPOList)) {
            return null;
        }
        MarketActivityGoodsSecKillPO marketActivityGoodsSecKillPO = (MarketActivityGoodsSecKillPO)marketActivityGoodsSecKillPOList.get(0);
        goodsMarketActivityVO.setMarketActivityGoodsSecKillPO(marketActivityGoodsSecKillPO);
        return goodsMarketActivityVO;
    }

    private MarketActivityTheLatestResponseVO getGoodsListByMarketActivityInfo(MarketActivityTheLatestRequestVO requestVO, MarketActivityPO marketActivityPONext) {
        MarketActivityTheLatestResponseVO marketActivityTheLatestResponseVO = new MarketActivityTheLatestResponseVO();
        marketActivityTheLatestResponseVO.setMarketActivityPO(marketActivityPONext);
        ArrayList<Integer> momentIds = new ArrayList<Integer>();
        momentIds.add(marketActivityPONext.getMarketActivityMomentId());
        MarketActivityGoodsSecKillConditionVO conditionVO = new MarketActivityGoodsSecKillConditionVO();
        conditionVO.setMomentIds(momentIds);
        Date activityBeginTime = marketActivityPONext.getActivityBeginTime();
        Integer activityPONextId = marketActivityPONext.getId();
        Date startDateOfDay = DateUtil.getStartDateOfDay((Date)activityBeginTime);
        Date endDateOfDay = DateUtil.getEndDateOfDay((Date)activityBeginTime);
        conditionVO.setTimeSearch(Boolean.TRUE);
        conditionVO.setBeginTime(startDateOfDay);
        conditionVO.setEndTime(endDateOfDay);
        conditionVO.setMarketActivityId(activityPONextId);
        MarketActivityMomentPO marketActivityMomentPO = this.marketActivityMomentPOMapper.selectByPrimaryKey(marketActivityPONext.getMarketActivityMomentId());
        marketActivityTheLatestResponseVO.setMarketActivityMomentPO(marketActivityMomentPO);
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        List marketActivityGoodsSecKillVOS = this.marketActivityGoodsSecKillPOMapper.queryMarketActivityVOByMomentId(conditionVO);
        PageInfo marketActivityGoodsSecKillVOPageInfo = new PageInfo(marketActivityGoodsSecKillVOS);
        marketActivityTheLatestResponseVO.setPageInfo(marketActivityGoodsSecKillVOPageInfo);
        return marketActivityTheLatestResponseVO;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getCurrentHour());
    }
}

