/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.seckill;

import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PayStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.enums.seckill.MarketActivitySecKillStatusEnum;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityGoodsSecKillPO;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.vo.seckill.order.SecKillOrderItemsConfirmVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.order.SecKillOrdersConfirmVO;
import com.wmeimob.fastboot.util.DateUtil;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.RandomCodeUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SecKillOrderCheck {
    private static final Logger log = LoggerFactory.getLogger(SecKillOrderCheck.class);

    public static void checkUserInfo(User user) {
        if (user == null || StringUtils.isEmpty((Object)user.getUserNo())) {
            throw new UserException("\u79d2\u6740\u4e0b\u5355-\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
    }

    public static void checkSecKillGoods(MarketActivityGoodsSecKillPO marketActivityGoodsSecKillPO) {
        if (marketActivityGoodsSecKillPO == null) {
            throw new MallWechatException("\u79d2\u6740\u6d3b\u52a8\u5546\u54c1\u65e0\u6cd5\u4e0b\u5355!");
        }
    }

    public static void checkGoods(GoodsPO goodsPO) {
        if (goodsPO == null) {
            throw new MallWechatException("\u5546\u54c1\u4e0d\u5b58\u5728!");
        }
        if (!goodsPO.getValid().booleanValue() || goodsPO.getIsDel().booleanValue()) {
            throw new MallWechatException("\u5546\u54c1\u5df2\u88ab\u7981\u7528!");
        }
    }

    public static void checkActivityTime(MarketActivityPO marketActivityPO) {
        if (marketActivityPO == null) {
            throw new MallWechatException("\u79d2\u6740\u6d3b\u52a8\u4e0d\u5b58\u5728!");
        }
        if (!marketActivityPO.getValid().booleanValue()) {
            throw new MallWechatException("\u79d2\u6740\u6d3b\u52a8\u5df2\u88ab\u7981\u7528!");
        }
        Integer activityStatusValue = marketActivityPO.getActivityStatusValue();
        if (MarketActivitySecKillStatusEnum.HAVE_NOT_START.getCode().equals(activityStatusValue)) {
            throw new MallWechatException("\u79d2\u6740\u6d3b\u52a8\u672a\u5f00\u59cb!");
        }
        if (MarketActivitySecKillStatusEnum.HAS_ENDED.getCode().equals(activityStatusValue)) {
            throw new MallWechatException("\u79d2\u6740\u6d3b\u52a8\u5df2\u7ed3\u675f!");
        }
        if (MarketActivitySecKillStatusEnum.HAS_BEEN_STOP.getCode().equals(activityStatusValue)) {
            throw new MallWechatException("\u79d2\u6740\u6d3b\u52a8\u5df2\u505c\u7528!");
        }
        Date activityBeginTime = marketActivityPO.getActivityBeginTime();
        Date activityEndTime = marketActivityPO.getActivityEndTime();
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis < activityBeginTime.getTime() || currentTimeMillis > activityEndTime.getTime()) {
            throw new MallWechatException("\u79d2\u6740\u6d3b\u52a8\u4e0d\u5728\u65f6\u95f4\u8303\u56f4\u5185!");
        }
    }

    public static void checkGoodsItem(MarketActivityPO marketActivityPO, SecKillOrderItemsConfirmVO secKillOrderItemsConfirmRequest, Long buyCountNow) {
        Integer saleQuantity = secKillOrderItemsConfirmRequest.getSaleQuantity();
        if (saleQuantity <= 0) {
            throw new MallWechatException("\u5546\u54c1" + secKillOrderItemsConfirmRequest.getGoodsNo() + "[" + secKillOrderItemsConfirmRequest.getSkuNo() + "]\u6570\u91cf\u6709\u8bef");
        }
        Integer marketActivityBuyNum = marketActivityPO.getMarketActivityBuyNum();
        if (marketActivityBuyNum != 0) {
            if (saleQuantity > marketActivityBuyNum) {
                throw new MallWechatException("\u79d2\u6740\u4e0b\u5355-\u5546\u54c1\u9650\u8d2d\u6570\u91cf:" + marketActivityBuyNum + ",\u672c\u6b21\u8d2d\u4e70\u6570\u91cf" + saleQuantity);
            }
            if ((long)saleQuantity.intValue() + buyCountNow > (long)marketActivityBuyNum.intValue()) {
                throw new MallWechatException("\u79d2\u6740\u4e0b\u5355-\u5546\u54c1\u9650\u8d2d\u6570\u91cf:" + marketActivityBuyNum + ",\u672c\u6b21\u8d2d\u4e70\u6570\u91cf" + saleQuantity + ",\u5df2\u8d2d\u4e70\u6570\u91cf:" + buyCountNow);
            }
        }
    }

    public static void checkOrdersShippingInfo(SecKillOrdersConfirmVO orders) {
        InputValidator.checkEmpty((Object)orders.getShippingName(), (String)"\u6536\u8d27\u4eba\u59d3\u540d");
        InputValidator.checkEmpty((Object)orders.getShippingMobile(), (String)"\u624b\u673a\u53f7\u7801");
        InputValidator.checkEmpty((Object)orders.getShippingProvince(), (String)"\u7701\u4efd");
        InputValidator.checkEmpty((Object)orders.getShippingCity(), (String)"\u57ce\u5e02");
        InputValidator.checkEmpty((Object)orders.getShippingDistrict(), (String)"\u5730\u533a");
        InputValidator.checkEmpty((Object)orders.getShippingAddress(), (String)"\u8be6\u7ec6\u5730\u5740");
    }

    public static void fillOrder(SecKillOrdersConfirmVO orders) {
        if (orders.getGmtCreate() != null) {
            return;
        }
        Date now = new Date();
        orders.setPayStatus(PayStatusEnum.UN_PAY);
        orders.setRepayCount(Integer.valueOf(0));
        orders.setIsVisable(Boolean.valueOf(true));
        orders.setIsComment(Boolean.valueOf(false));
        orders.setOrderStatus(OrdersStatusEnum.TRADE);
        orders.setLogisticsStatus(LogisticsStatusEnum.UN_SEND);
        orders.setGmtCreate(now);
        orders.setGmtModified(now);
        orders.setActiveDeduction(BigDecimal.ZERO);
        orders.setUserDeduction(BigDecimal.ZERO);
        orders.setCouponDeduction(BigDecimal.ZERO);
        List secKillOrderItems = orders.getSecKillOrderItems();
        for (SecKillOrderItemsConfirmVO secKillOrderItem : secKillOrderItems) {
            secKillOrderItem.setRefundStatus(RefundStatus.NONE);
            secKillOrderItem.setGmtCreate(now);
            secKillOrderItem.setShippingFee(BigDecimal.ZERO);
            secKillOrderItem.setItemsShippingDeduction(BigDecimal.ZERO);
            secKillOrderItem.setCouponDiscount(BigDecimal.ONE);
            secKillOrderItem.setUserDiscount(BigDecimal.ONE);
            secKillOrderItem.setActiveDiscount(BigDecimal.ONE);
            secKillOrderItem.setItemsCouponDeduction(BigDecimal.ZERO);
            secKillOrderItem.setItemsPointDeduction(BigDecimal.ZERO);
        }
    }

    public static void fillOrderNo(SecKillOrdersConfirmVO orders) {
        String orderNo = orders.getOrderNo();
        if (StringUtils.isEmpty((Object)orderNo)) {
            orders.setOrderNo(DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss") + RandomCodeUtil.randCode((int)10));
        }
    }

    public static String filterRegionName(String name, String filter) {
        if (com.mzlion.core.lang.StringUtils.isEmpty((String)name)) {
            return name;
        }
        int filterId = name.lastIndexOf(filter);
        if (filterId != -1) {
            return name.substring(0, filterId);
        }
        return name;
    }
}

