/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.orderpush.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.service.orderpush.OrderPushCheckService;
import com.wmeimob.fastboot.bizvane.service.orderpush.OrderPushService;
import com.wmeimob.fastboot.bizvane.vo.order.OrderPushCheckRequestVO;
import com.wmeimob.fastboot.bizvane.vo.order.OrderPushRequestVO;
import com.wmeimob.fastboot.util.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderPushServiceImpl
implements OrderPushService {
    private static final Logger log = LoggerFactory.getLogger(OrderPushServiceImpl.class);
    @Autowired
    private OrderPushCheckService orderPushCheckService;

    public void orderPushErp(OrderPushRequestVO orderPushRequestVO) {
        log.info("OrderPushServiceImpl#orderPushErp\u8ba2\u5355\u63a8\u9001\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)orderPushRequestVO));
        Integer merchantId = orderPushRequestVO.getMerchantId();
        String orderNo = orderPushRequestVO.getOrderNo();
        try {
            InputValidator.checkEmpty((Object)orderNo, (String)"\u8ba2\u5355\u53f7");
            boolean isPush = this.orderPushCheckService.orderPushCheckMerchantId(new OrderPushCheckRequestVO(merchantId, orderNo));
            if (!isPush) {
                log.warn("\u8ba2\u5355[" + orderNo + "]\u95e8\u5e97\u7ea7\u68c0\u67e5false,\u4e0d\u8fdb\u884cerp\u63a8\u9001");
            }
        }
        catch (Exception e) {
            log.warn("\u8ba2\u5355\u63a8\u9001OrderPushServiceImpl#orderPushErp\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
        }
    }
}

