/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.orderpush.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.enums.order.OrderPushEnum;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.ConfigPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPOExample;
import com.wmeimob.fastboot.bizvane.service.mallconfig.ConfigService;
import com.wmeimob.fastboot.bizvane.service.orderpush.OrderPushCheckService;
import com.wmeimob.fastboot.bizvane.vo.order.OrderPushCheckRequestVO;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OrderPushCheckServiceImpl
implements OrderPushCheckService {
    private static final Logger log = LoggerFactory.getLogger(OrderPushCheckServiceImpl.class);
    @Autowired
    private ConfigService configService;
    @Resource
    private OrdersPOMapper ordersPoMapper;

    public boolean orderPushCheckMerchantId(OrderPushCheckRequestVO pushCheckRequestParams) {
        log.info("OrderPushServiceImpl#\u63a8\u9001\u68c0\u67e5\u95e8\u5e97\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)pushCheckRequestParams));
        String orderNo = pushCheckRequestParams.getOrderNo();
        Integer merchantId = pushCheckRequestParams.getMerchantId();
        try {
            InputValidator.checkEmpty((Object)orderNo, (String)"\u63a8\u9001\u68c0\u67e5\u95e8\u5e97\u5165\u53c2\u8ba2\u5355\u53f7");
            if (StringUtils.isEmpty((Object)merchantId)) {
                OrdersPOExample example = new OrdersPOExample();
                example.createCriteria().andOrderNoEqualTo(orderNo).andValidEqualTo(Boolean.TRUE);
                List ordersPoList = this.ordersPoMapper.selectByExample(example);
                log.info("ordersPoList:{}", (Object)JSON.toJSONString((Object)ordersPoList));
                if (CollectionUtils.isEmpty((Collection)ordersPoList)) {
                    log.info("\u6ca1\u6709\u8ba2\u5355\u53f7\u4e3a[" + orderNo + "]\u7684\u8ba2\u5355");
                    return false;
                }
                if (ordersPoList.size() > 1) {
                    log.info("\u5355\u53f7\uff1a" + orderNo + "\u7684\u8ba2\u5355\u5355\u53f7\u91cd\u590d");
                    return false;
                }
                OrdersPO ordersPo = (OrdersPO)ordersPoList.get(0);
                merchantId = ordersPo.getMerchantId();
            }
            ConfigPO configPo = this.configService.queryConfigByMerchantId(merchantId);
            String erpSystem = configPo.getErpSystem();
            return OrderPushEnum.PUSH_ERP_TARGET.getPushTarget().equals(erpSystem);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u68c0\u67e5\u95e8\u5e97\u65f6\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e.getStackTrace());
            return false;
        }
    }
}

