/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.order.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.GoodsPreSellTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderActivityTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderPreSellPayStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderPreSellPayTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderPreSellStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrderPresellExpandPOMapper;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPOExample;
import com.wmeimob.fastboot.bizvane.po.OrderPresellExpandPO;
import com.wmeimob.fastboot.bizvane.service.OrderPresellExpandService;
import com.wmeimob.fastboot.bizvane.service.order.OrderPayConfirmService;
import com.wmeimob.fastboot.starter.wechat.dto.WechatJsPayDTO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderPayConfirmServiceImpl
implements OrderPayConfirmService {
    private static final Logger log = LoggerFactory.getLogger(OrderPayConfirmServiceImpl.class);
    @Resource
    private OrderPresellExpandPOMapper orderPresellExpandPOMapper;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Autowired
    private OrderPresellExpandService orderPresellExpandService;
    @Resource
    private WechatProperties wechatProperties;
    @Resource
    private GoodsSkuDetailPOMapper goodsSkuDetailPOMapper;

    public Orders partOfSellPayConfirm(Orders payOrders) {
        List items = payOrders.getItems();
        Boolean flag = Boolean.FALSE;
        GoodsPO goodsPO = null;
        for (OrderItems orderItems2 : items) {
            Integer goodsId = orderItems2.getGoodsId();
            goodsPO = this.goodsPOMapper.selectByPrimaryKey(goodsId);
            Integer presellType = goodsPO.getPresellType();
            if (!GoodsPreSellTypeEnum.PART.getCode().equals(presellType)) continue;
            flag = Boolean.TRUE;
            break;
        }
        log.info("\u8ba2\u5355\u5b58\u5728\u5b9a\u91d1\u9884\u552e\u5546\u54c1:{}", (Object)flag);
        if (!flag.booleanValue()) {
            return payOrders;
        }
        if (items.size() != 1) {
            throw new IllegalArgumentException("\u5b9a\u91d1\u9884\u552e\u5546\u54c1\u53ea\u80fd\u5355\u4e2a\u4e0b\u5355!");
        }
        String goodsSkuNo = ((OrderItems)items.get(0)).getGoodsSkuNo();
        Integer goodsId = ((OrderItems)items.get(0)).getGoodsId();
        Integer saleQuantity = ((OrderItems)items.get(0)).getSaleQuantity();
        GoodsSkuDetailPOExample goodsSkuDetailPOExample = new GoodsSkuDetailPOExample();
        goodsSkuDetailPOExample.createCriteria().andGoodsIdEqualTo(goodsId).andSkuNoEqualTo(goodsSkuNo).andValidEqualTo(Boolean.TRUE).andIsDelEqualTo(Boolean.FALSE);
        List goodsSkuDetailPOS = this.goodsSkuDetailPOMapper.selectByExample(goodsSkuDetailPOExample);
        if (CollectionUtils.isEmpty((Collection)goodsSkuDetailPOS)) {
            throw new IllegalArgumentException("\u5b58\u5728\u91cd\u590dsku\u6570\u636e,\u6682\u65f6\u65e0\u6cd5\u4e0b\u5355!");
        }
        BigDecimal presellPriceOne = ((GoodsSkuDetailPO)goodsSkuDetailPOS.get(0)).getPresellPrice();
        BigDecimal presellPrice = presellPriceOne.multiply(BigDecimal.valueOf(saleQuantity.intValue()));
        BigDecimal payAmount = payOrders.getPayAmount();
        long beginTime = goodsPO.getPresellFirstBegin().getTime();
        long currentTimeMillis = System.currentTimeMillis();
        BigDecimal balancePayment = payAmount.subtract(presellPrice);
        items.stream().forEach(orderItems -> orderItems.setPresellPrice(presellPriceOne));
        if (beginTime > currentTimeMillis) {
            return payOrders;
        }
        payOrders.setPartAmount(presellPrice);
        payOrders.setBalancePayment(balancePayment);
        payOrders.setPresellStatus(OrderPreSellStatusEnum.PART_DEFAULT.getCode());
        payOrders.setOrdersActivityType(OrderActivityTypeEnum.YS.getCode().toString());
        return payOrders;
    }

    public Orders partOfSellAdd(Orders payOrders) {
        Integer presellStatus = payOrders.getPresellStatus();
        if (!OrderPreSellStatusEnum.PART_DEFAULT.getCode().equals(presellStatus)) {
            return payOrders;
        }
        BigDecimal partAmount = payOrders.getPartAmount();
        BigDecimal payAmount = payOrders.getPayAmount();
        BigDecimal balancePayment = payAmount.subtract(partAmount);
        if (balancePayment.compareTo(BigDecimal.ZERO) != 1) {
            throw new MallWechatException("\u5c3e\u6b3e\u8ba1\u7b97\u6709\u8bef,\u6682\u65f6\u65e0\u6cd5\u4e0b\u5355!");
        }
        OrderItems orderItems = (OrderItems)payOrders.getItems().get(0);
        Integer goodsId = orderItems.getGoodsId();
        GoodsPO goodsPO = this.goodsPOMapper.selectByPrimaryKey(goodsId);
        Date presellFirstEnd = goodsPO.getPresellFirstEnd();
        Date presellFirstBegin = goodsPO.getPresellFirstBegin();
        Date presellSecondBegin = goodsPO.getPresellSecondBegin();
        Date presellSecondEnd = goodsPO.getPresellSecondEnd();
        OrderPresellExpandPO orderPresellExpandPOFirst = new OrderPresellExpandPO();
        orderPresellExpandPOFirst.setMerchantId(payOrders.getMerchantId());
        orderPresellExpandPOFirst.setOrderId(payOrders.getId());
        orderPresellExpandPOFirst.setOrderNo(payOrders.getOrderNo());
        orderPresellExpandPOFirst.setOrderPresellNo(payOrders.getOrderNo() + "FIRST");
        orderPresellExpandPOFirst.setPayType(OrderPreSellPayTypeEnum.PART_PAY_PORTION.getCode());
        orderPresellExpandPOFirst.setPayAmount(partAmount);
        orderPresellExpandPOFirst.setPayUtilAt(presellFirstEnd);
        orderPresellExpandPOFirst.setPayBeginAt(presellFirstBegin);
        orderPresellExpandPOFirst.setGmtCreate(new Date());
        this.orderPresellExpandPOMapper.insertSelective(orderPresellExpandPOFirst);
        OrderPresellExpandPO orderPresellExpandPOLast = new OrderPresellExpandPO();
        orderPresellExpandPOLast.setMerchantId(payOrders.getMerchantId());
        orderPresellExpandPOLast.setOrderId(payOrders.getId());
        orderPresellExpandPOLast.setOrderNo(payOrders.getOrderNo());
        orderPresellExpandPOLast.setOrderPresellNo(payOrders.getOrderNo() + "LAST");
        orderPresellExpandPOLast.setPayType(OrderPreSellPayTypeEnum.PART_PAY_ALL.getCode());
        orderPresellExpandPOLast.setPayAmount(balancePayment);
        orderPresellExpandPOLast.setPayUtilAt(presellSecondEnd);
        orderPresellExpandPOLast.setPayBeginAt(presellSecondBegin);
        orderPresellExpandPOLast.setGmtCreate(new Date());
        this.orderPresellExpandPOMapper.insertSelective(orderPresellExpandPOLast);
        List orderPresellExpandPOS = this.orderPresellExpandService.queryByOrderNo(payOrders.getOrderNo());
        payOrders.setOrderPresellExpandPOList(orderPresellExpandPOS);
        return payOrders;
    }

    public WechatJsPayDTO payment(Orders orders, String appid) {
        Integer ordersId = orders.getId();
        String orderNo = orders.getOrderNo();
        List orderPresellExpandPOS = this.orderPresellExpandService.queryByOrderId(ordersId);
        if (CollectionUtils.isEmpty((Collection)orderPresellExpandPOS)) {
            throw new MallWechatException("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u5df2\u5931\u6548,\u652f\u4ed8\u5931\u8d25");
        }
        OrderPresellExpandPO orderPresellExpandPOFirst = orderPresellExpandPOS.stream().filter(e -> OrderPreSellPayTypeEnum.PART_PAY_PORTION.getCode().equals(e.getPayType())).findFirst().get();
        if (orderPresellExpandPOFirst == null) {
            throw new MallWechatException(orderNo + "\u652f\u4ed8\u5b9a\u91d1\u5931\u8d25");
        }
        Integer payStatus = orderPresellExpandPOFirst.getPayStatus();
        if (OrderPreSellPayStatusEnum.NONE.getCode().equals(payStatus)) {
            log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u672a\u652f\u4ed8\u8ba2\u5355,check\u662f\u5426\u53ef\u4ee5\u652f\u4ed8");
            long beginTime = orderPresellExpandPOFirst.getPayBeginAt().getTime();
            long utilTime = orderPresellExpandPOFirst.getPayUtilAt().getTime();
            long currentTimeMillis = System.currentTimeMillis();
            if (beginTime > currentTimeMillis || currentTimeMillis > utilTime) {
                throw new MallWechatException("\u9884\u552e\u8ba2\u5355\u4e0d\u5728\u652f\u4ed8\u65f6\u95f4\u8303\u56f4\u5185,\u65e0\u6cd5\u652f\u4ed8!");
            }
            String orderPresellNo = orderPresellExpandPOFirst.getOrderPresellNo();
            BigDecimal payAmount = orderPresellExpandPOFirst.getPayAmount();
            WechatJsPayDTO wechatJsPayDTO = WechatJsPayDTO.builder().appid(appid).isTest(Boolean.valueOf(this.wechatProperties.isTest())).body(this.wechatProperties.getPay().getBody()).notifyUrl((String)this.wechatProperties.getUrls().get("pay-notify")).openid(orders.getWechatOpenid()).orderNo(orderPresellNo).totalFee(payAmount).build();
            log.info("\u83b7\u53d6\u5b9a\u91d1\u652f\u4ed8\u8ba2\u5355:{}\u5b9a\u91d1\u5355\u53f7:{}\u7b7e\u540d:{}", new Object[]{orderNo, orderPresellNo, JSON.toJSONString((Object)wechatJsPayDTO)});
            return wechatJsPayDTO;
        }
        OrderPresellExpandPO orderPresellExpandPOLast = orderPresellExpandPOS.stream().filter(e -> OrderPreSellPayTypeEnum.PART_PAY_ALL.getCode().equals(e.getPayType())).findFirst().get();
        if (orderPresellExpandPOLast == null) {
            throw new MallWechatException(orderNo + "\u652f\u4ed8\u5c3e\u6b3e\u5931\u8d25");
        }
        payStatus = orderPresellExpandPOLast.getPayStatus();
        if (!OrderPreSellPayStatusEnum.NONE.getCode().equals(payStatus)) {
            throw new MallWechatException(orderNo + "\u652f\u4ed8\u5b9a\u91d1\u5931\u8d25");
        }
        log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u672a\u652f\u4ed8\u8ba2\u5355,check\u662f\u5426\u53ef\u4ee5\u652f\u4ed8");
        Date payBeginAt = orderPresellExpandPOLast.getPayBeginAt();
        Date payUtilAt = orderPresellExpandPOLast.getPayUtilAt();
        Date date = new Date();
        String orderPresellNo = orderPresellExpandPOLast.getOrderPresellNo();
        BigDecimal payAmount = orderPresellExpandPOLast.getPayAmount();
        long payBeginAtTimeInMillis = DateUtils.toCalendar((Date)payBeginAt).getTimeInMillis();
        long payUtilAtTimeInMillis = DateUtils.toCalendar((Date)payUtilAt).getTimeInMillis();
        long dateTimeInMillis = DateUtils.toCalendar((Date)date).getTimeInMillis();
        if (payBeginAtTimeInMillis > dateTimeInMillis || dateTimeInMillis > payUtilAtTimeInMillis) {
            throw new MallWechatException(orderNo + "\u4e0d\u5728\u5c3e\u6b3e\u652f\u4ed8\u65f6\u95f4\u5185\uff0c\u65e0\u6cd5\u652f\u4ed8\u5c3e\u6b3e");
        }
        WechatJsPayDTO wechatJsPayDTO = WechatJsPayDTO.builder().appid(appid).isTest(Boolean.valueOf(this.wechatProperties.isTest())).body(this.wechatProperties.getPay().getBody()).notifyUrl((String)this.wechatProperties.getUrls().get("pay-notify")).openid(orders.getWechatOpenid()).orderNo(orderPresellNo).totalFee(payAmount).build();
        log.info("\u83b7\u53d6\u5b9a\u91d1\u652f\u4ed8\u8ba2\u5355:{}\u5c3e\u6b3e\u5355\u53f7:{}\u7b7e\u540d:{}", new Object[]{orderNo, orderPresellNo, JSON.toJSONString((Object)wechatJsPayDTO)});
        return wechatJsPayDTO;
    }
}

