/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.order.impl;

import com.wmeimob.fastboot.bizvane.enums.order.OrderCancelSourceEnum;
import com.wmeimob.fastboot.bizvane.enums.order.OrderPreSellOrderStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.WechatMchPOMapper;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.po.WechatMchPO;
import com.wmeimob.fastboot.bizvane.po.WechatMchPOExample;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.order.OrderOperationService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderOperationServiceImpl
implements OrderOperationService {
    private static final Logger log = LoggerFactory.getLogger(OrderOperationServiceImpl.class);
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Autowired
    private OrdersService ordersService;
    @Resource
    private WechatMchPOMapper wechatMchPOMapper;

    public ResponseData notifyForCloseOrderById(Integer orderId) {
        OrdersPO ordersPO = this.ordersPOMapper.selectByPrimaryKey(orderId);
        if (ordersPO == null) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        Long userId = ordersPO.getUserId();
        String source = OrderCancelSourceEnum.INTERFACE_CLOSE.getSource();
        Integer merchantId = ordersPO.getMerchantId();
        Integer presellOrderStatus = ordersPO.getPresellOrderStatus();
        if (!OrderPreSellOrderStatusEnum.APPROVED.getCode().equals(presellOrderStatus)) {
            return ResponseUtil.getFailedMsg((String)"\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u672a\u5ba1\u6838\u901a\u8fc7!");
        }
        WechatMchPOExample wechatMchPOExample = new WechatMchPOExample();
        wechatMchPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List wechatMchPOS = this.wechatMchPOMapper.selectByExample(wechatMchPOExample);
        String appId = ((WechatMchPO)wechatMchPOS.get(0)).getAppId();
        this.ordersService.cancel(appId, userId, orderId, source);
        return ResponseUtil.getSuccessData(null, (String)"\u5b9a\u91d1\u9884\u552e\u8ba2\u5355\u9000\u5355\u6210\u529f!");
    }
}

