/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.mallconfig.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.enums.common.CommonTipsEnum;
import com.wmeimob.fastboot.bizvane.newmapper.ConfigPOMapper;
import com.wmeimob.fastboot.bizvane.po.ConfigPO;
import com.wmeimob.fastboot.bizvane.po.ConfigPOExample;
import com.wmeimob.fastboot.bizvane.service.mallconfig.ConfigService;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConfigServiceImpl
implements ConfigService {
    private static final Logger log = LoggerFactory.getLogger(ConfigServiceImpl.class);
    @Resource
    private ConfigPOMapper configPoMapper;

    public ConfigPO queryConfigByMerchantId(Integer merchantId) {
        log.info("\u6839\u636e\u5546\u6237ID\u67e5\u8be2\u914d\u7f6e:merchantId=[{}]", (Object)merchantId);
        try {
            InputValidator.checkEmpty((Object)merchantId, (String)CommonTipsEnum.MERCHANT_ID.getDesc());
            ConfigPOExample example = new ConfigPOExample();
            example.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
            List configPoList = this.configPoMapper.selectByExample(example);
            log.info("configPoList:{}", (Object)JSON.toJSONString((Object)configPoList));
            return CollectionUtils.isEmpty((Collection)configPoList) ? null : (ConfigPO)configPoList.get(0);
        }
        catch (Exception e) {
            log.warn("ConfigServiceImpl#\u6839\u636e\u5546\u6237ID\u67e5\u8be2\u914d\u7f6e\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e.getStackTrace());
            return null;
        }
    }
}

