/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.logistics.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mzlion.easyokhttp.HttpClient;
import com.mzlion.easyokhttp.request.PostRequest;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.exception.MallCommonException;
import com.wmeimob.fastboot.bizvane.newmapper.CourierPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.IntegralCourierCompanyPOMapper;
import com.wmeimob.fastboot.bizvane.po.CourierPO;
import com.wmeimob.fastboot.bizvane.po.IntegralCourierCompanyPO;
import com.wmeimob.fastboot.bizvane.service.logistics.LogisticsService;
import com.wmeimob.fastboot.bizvane.vo.logistics.CourierCompanyCodeResponseVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.CourierCompanyInfoResponseVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.CourierInfo;
import com.wmeimob.fastboot.bizvane.vo.logistics.LogisticsInfoDetailsResponseVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.QueryCourierCompanyByConditionVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.QueryLogisticsInfoDetailsRequestVO;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class LogisticsServiceImpl
implements LogisticsService {
    private static final Logger log = LoggerFactory.getLogger(LogisticsServiceImpl.class);
    private static final String STR_A = "[";
    private static final String STR_B = "]";
    @Value(value="${kuaidi100.key}")
    private String key;
    @Value(value="${kuaidi100.customer}")
    private String customer;
    @Value(value="${kuaidi100.urlA}")
    private String urlA;
    @Value(value="${kuaidi100.urlB}")
    private String urlB;
    @Resource
    private IntegralCourierCompanyPOMapper integralCourierCompanyPoMapper;
    @Resource
    private CourierPOMapper courierPoMapper;

    public CourierCompanyCodeResponseVO courierCompanyCodeTirByCourierCode(String courierCode) {
        log.info("LogisticsServiceImpl#courierCompanyCodeTirByCourierCode:\u5feb\u9012\u5355\u53f7={}", (Object)courierCode);
        try {
            InputValidator.checkEmpty((Object)this.urlB, (String)"url");
            InputValidator.checkEmpty((Object)this.key, (String)"key\u4e3a\u7a7a");
            InputValidator.checkEmpty((Object)courierCode, (String)"\u5feb\u9012\u5355\u53f7\u4e3a\u7a7a");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("num", courierCode);
            map.put("key", "\"" + this.key + "\"");
            PostRequest post = HttpClient.post((String)this.urlB).param(map);
            String resultDta = post.asString();
            log.info("\u6839\u636e\u5355\u53f7\u8bc6\u522b\u5feb\u9012\u516c\u53f8\u8fd4\u56de\uff1a{}", (Object)resultDta);
            CourierCompanyCodeResponseVO responseVo = new CourierCompanyCodeResponseVO();
            if (resultDta.startsWith(STR_A) && resultDta.endsWith(STR_B)) {
                JSONArray jsonArray = (JSONArray)post.asBean(JSONArray.class);
                List courierInfos = jsonArray.toJavaList(CourierInfo.class);
                responseVo.setCourierInfoList(courierInfos);
            } else {
                JSONObject jsonObject = (JSONObject)post.asBean(JSONObject.class);
                responseVo = (CourierCompanyCodeResponseVO)jsonObject.toJavaObject(CourierCompanyCodeResponseVO.class);
            }
            log.info("\u5feb\u9012100\u667a\u80fd\u5355\u53f7\u8bc6\u522bAPI\u6700\u540e\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)responseVo));
            return responseVo;
        }
        catch (Exception e) {
            log.warn("\u5feb\u9012100\u667a\u80fd\u5355\u53f7\u8bc6\u522bAPI\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallCommonException(e.getMessage(), (Throwable)e);
        }
    }

    public List<CourierCompanyInfoResponseVO> queryCourierCompany() {
        try {
            List integralCourierCompanyList = this.integralCourierCompanyPoMapper.selectByExample(null);
            if (CollectionUtils.isEmpty((Collection)integralCourierCompanyList)) {
                return null;
            }
            List list = this.convertPoToVo(integralCourierCompanyList);
            log.info("list:{}", (Object)JSON.toJSONString((Object)list));
            return list;
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u5feb\u9012\u516c\u53f8\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallCommonException(e.getMessage());
        }
    }

    public static void main(String[] args) {
        String urlA = "https://poll.kuaidi100.com/poll/query.do";
        JSONObject json = new JSONObject();
        json.put("com", (Object)"shentong");
        json.put("num", (Object)"773041150886874");
        json.put("phone", (Object)"17621885377");
        String param = json.toJSONString();
        String sign = new LogisticsServiceImpl().buildSign(param, "NFFfsVSO6034", "8A2A50D8402E1D9089F686E4745E9650");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param", param);
        params.put("sign", sign);
        params.put("customer", "8A2A50D8402E1D9089F686E4745E9650");
        log.info("\u5feb\u9012100\u53c2\u6570===>{}", (Object)params.toString());
        String replace = urlA.replace("https", "http");
        JSONObject res = (JSONObject)HttpClient.post((String)replace).param(params).asBean(JSONObject.class);
        log.info("\u5feb\u9012\u67e5\u8be2\u7ed3\u679c{}", (Object)res.toString());
        LogisticsInfoDetailsResponseVO result = null;
        try {
            result = (LogisticsInfoDetailsResponseVO)JSONObject.parseObject((String)res.toString(), LogisticsInfoDetailsResponseVO.class);
            log.info("result:{}", (Object)JSON.toJSONString((Object)result));
        }
        catch (Exception e) {
            log.warn("JSONObject----->bean\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public LogisticsInfoDetailsResponseVO queryLogisticsInfoDetailsBy100(QueryLogisticsInfoDetailsRequestVO requestVo) {
        log.info("LogisticsServiceImpl#queryLogisticsInfoDetailsBy100:{}", (Object)JSON.toJSONString((Object)requestVo));
        try {
            InputValidator.checkEmpty((Object)requestVo.getMerchantId(), (String)"\u5546\u6237ID");
            InputValidator.checkEmpty((Object)requestVo.getCourierCode(), (String)"\u5feb\u9012\u5355\u53f7");
            String courierCompanyCode = requestVo.getCourierCompanyCode();
            JSONObject json = new JSONObject();
            json.put("com", (Object)courierCompanyCode);
            json.put("num", (Object)requestVo.getCourierCode());
            json.put("phone", (Object)requestVo.getConsigneePhone());
            String param = json.toJSONString();
            String sign = this.buildSign(param, this.key, this.customer);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("param", param);
            params.put("sign", sign);
            params.put("customer", this.customer);
            log.info("\u5feb\u9012100\u53c2\u6570===>{}", (Object)params.toString());
            String replace = this.urlA.replace("https", "http");
            JSONObject res = (JSONObject)HttpClient.post((String)replace).param(params).asBean(JSONObject.class);
            log.info("\u5feb\u9012\u67e5\u8be2\u7ed3\u679c{}", (Object)res.toString());
            LogisticsInfoDetailsResponseVO result = null;
            try {
                result = (LogisticsInfoDetailsResponseVO)JSONObject.parseObject((String)res.toString(), LogisticsInfoDetailsResponseVO.class);
            }
            catch (Exception e) {
                log.warn("JSONObject----->bean\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            }
            log.info("\u7269\u6d41\u8be6\u60c5\u6700\u540e\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)result));
            return result;
        }
        catch (Exception e) {
            log.warn("\u901a\u8fc7\u5feb\u9012100\u516c\u5171API\u83b7\u53d6\u7269\u6d41\u8be6\u60c5\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallCommonException(e.getMessage(), (Throwable)e);
        }
    }

    public List<CourierCompanyInfoResponseVO> queryCourierCompanyByCondition(QueryCourierCompanyByConditionVO queryCourierCompanyByConditionVo) {
        log.info("LogisticsServiceImpl#queryCourierCompanyByCondition:{}", (Object)JSON.toJSONString((Object)queryCourierCompanyByConditionVo));
        Integer merchantId = queryCourierCompanyByConditionVo.getMerchantId();
        Integer courierCompanyId = queryCourierCompanyByConditionVo.getCourierCompanyId();
        try {
            InputValidator.checkEmpty((Object)merchantId, (String)"\u5546\u6237ID");
            InputValidator.checkEmpty((Object)courierCompanyId, (String)"\u5feb\u9012\u516c\u53f8id");
            if (!StringUtils.isEmpty((Object)courierCompanyId)) {
                CourierPO courierPo = this.courierPoMapper.selectByPrimaryKey(courierCompanyId);
                return this.convertcourierPoToVo(courierPo);
            }
            return null;
        }
        catch (Exception e) {
            log.warn("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5feb\u9012\u516c\u53f8\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallWechatException(e.getMessage(), (Throwable)e);
        }
    }

    private List<CourierCompanyInfoResponseVO> convertcourierPoToVo(CourierPO courierPo) {
        ArrayList<CourierCompanyInfoResponseVO> courierCompanyInfoResponseVoS = new ArrayList<CourierCompanyInfoResponseVO>();
        if (StringUtils.isEmpty((Object)courierPo)) {
            return null;
        }
        CourierCompanyInfoResponseVO vo = new CourierCompanyInfoResponseVO();
        vo.setName(courierPo.getName());
        vo.setCode(courierPo.getCode());
        courierCompanyInfoResponseVoS.add(vo);
        return courierCompanyInfoResponseVoS;
    }

    private String buildSign(String param, String key, String customer) {
        StringBuffer sb = new StringBuffer(param);
        sb.append(key).append(customer);
        log.info(sb.toString());
        String sign = DigestUtils.md5Hex((String)sb.toString()).toUpperCase();
        log.info("\u7ec4\u88c5\u7b7e\u540d\u7ed3\u679c==>:{}", (Object)sign);
        return sign;
    }

    private List<CourierCompanyInfoResponseVO> convertPoToVo(List<IntegralCourierCompanyPO> integralCourierCompanyList) {
        ArrayList<CourierCompanyInfoResponseVO> courierCompanyInfoResponseVoS = new ArrayList<CourierCompanyInfoResponseVO>();
        integralCourierCompanyList.forEach(po -> {
            CourierCompanyInfoResponseVO vo = new CourierCompanyInfoResponseVO();
            vo.setName(po.getName());
            vo.setCode(po.getCode());
            courierCompanyInfoResponseVoS.add(vo);
        });
        return courierCompanyInfoResponseVoS;
    }
}

