/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.jobhandler;

import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.WechatMchPOMapper;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.po.WechatMchPO;
import com.wmeimob.fastboot.bizvane.po.WechatMchPOExample;
import com.wmeimob.fastboot.bizvane.service.OrderPresellExpandService;
import com.wmeimob.fastboot.bizvane.service.OrdersServiceImpl;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="preSellOrderCancel")
@Component
public class OrderCancelJobHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(OrderCancelJobHandler.class);
    @Autowired
    private OrdersServiceImpl ordersService;
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Resource
    private WechatMchPOMapper wechatMchPOMapper;
    @Autowired
    private OrderPresellExpandService orderPresellExpandService;

    public ReturnT<String> execute(String s) throws Exception {
        log.info("OrderCancelJobHandler#execute param:{}", (Object)s);
        try {
            Integer orderId = Integer.valueOf(s);
            int i = this.orderPresellExpandService.cancelPreSellOrderPreprocessing(orderId);
            log.info("OrderCancelJobHandler#preSellOrderCancel:{}", (Object)i);
            OrdersPO ordersPO = this.ordersPOMapper.selectByPrimaryKey(orderId);
            if (i > 0) {
                log.info("OrderCancelJobHandler#preSellOrderCancel Status:{}", (Object)"return");
                return ReturnT.SUCCESS;
            }
            Integer merchantId = ordersPO.getMerchantId();
            WechatMchPOExample wechatMchPOExample = new WechatMchPOExample();
            wechatMchPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
            List wechatMchPOS = this.wechatMchPOMapper.selectByExample(wechatMchPOExample);
            WechatMchPO wechatMchPO = (WechatMchPO)wechatMchPOS.get(0);
            this.ordersService.cancel(wechatMchPO.getAppId(), ordersPO.getUserId(), orderId, null);
        }
        catch (Exception e) {
            log.error("OrderCancelJobHandler#error:{}", (Throwable)e);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }
}

