/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.goodsgroup.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsGroupByDesignerPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsGroupPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsGroupRelationByDesignerPOMapper;
import com.wmeimob.fastboot.bizvane.po.GoodsGroupPOExample;
import com.wmeimob.fastboot.bizvane.service.goodsgroup.GoodsGroupService;
import com.wmeimob.fastboot.bizvane.vo.GoodsGroup.GoodsGroupSearchGoodsListRequestVO;
import com.wmeimob.fastboot.bizvane.vo.GoodsGroup.GoodsGroupSearchListResponseVO;
import com.wmeimob.fastboot.bizvane.vo.GoodsGroupVO;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GoodsGroupServiceImpl
implements GoodsGroupService {
    private static final Logger log = LoggerFactory.getLogger(GoodsGroupServiceImpl.class);
    @Resource
    private GoodsGroupByDesignerPOMapper goodsGroupByDesignerPOMapper;
    @Resource
    private GoodsGroupRelationByDesignerPOMapper goodsGroupRelationByDesignerPOMapper;
    @Resource
    private GoodsGroupPOMapper goodsGroupPOMapper;

    public PageInfo searchGoodsList(GoodsGroupSearchGoodsListRequestVO vo, Boolean removeJudge) {
        log.info("GoodsGroupServiceImpl checkGroupInUsed vo:{}", JSON.toJSON((Object)vo));
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List goodsPOList = this.goodsGroupRelationByDesignerPOMapper.selectGoodsPagesByGroupId(vo.getId());
        return new PageInfo(goodsPOList);
    }

    public PageInfo searchGoodsGroupList(GoodsGroupSearchListResponseVO vo) {
        log.info("GoodsGroupServiceImpl searchGoodsGroupList vo:{}", JSON.toJSON((Object)vo));
        GoodsGroupPOExample goodsGroupPOExample = new GoodsGroupPOExample();
        GoodsGroupPOExample.Criteria criteria = goodsGroupPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(vo.getMerchantId()).andPidNotEqualTo(Integer.valueOf(0));
        if (vo.getPid() != null) {
            criteria.andPidEqualTo(vo.getPid());
        }
        if (!StringUtils.isEmpty((Object)vo.getGoodsGroupName())) {
            criteria.andGoodsGroupNameLike("%" + vo.getGoodsGroupName() + "%");
        }
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List page = this.goodsGroupByDesignerPOMapper.selectByExample(goodsGroupPOExample);
        PageInfo pageInfo = new PageInfo(page);
        log.info("\u67e5\u8be2\u51fa\u7684\u5206\u9875\u7ed3\u679c:{}", (Object)pageInfo);
        return pageInfo;
    }

    public List<GoodsGroupVO> getGroudList(Integer merchantId) {
        List goodsGroupPOList = this.goodsGroupPOMapper.getGroudList(merchantId);
        log.info("\u67e5\u8be2\u51fa\u5546\u54c1\u5206\u7ec4\u4fe1\u606f\uff1a" + JSON.toJSON(goodsGroupPOList.get(3)));
        return goodsGroupPOList;
    }
}

