/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.customization.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationByDesignerPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationCategoryPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationGoodsRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationRelationPOMapper;
import com.wmeimob.fastboot.bizvane.po.CustomizationCategoryPOExample;
import com.wmeimob.fastboot.bizvane.po.CustomizationDetailPOExample;
import com.wmeimob.fastboot.bizvane.po.CustomizationPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationPOExample;
import com.wmeimob.fastboot.bizvane.po.CustomizationRelationPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationRelationPOExample;
import com.wmeimob.fastboot.bizvane.service.customization.CustomizationService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.customization.CategoryListByGoodIdSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryDetailListSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryListSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationSearchResponseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CustomizationServiceImpl
implements CustomizationService {
    private static final Logger log = LoggerFactory.getLogger(CustomizationServiceImpl.class);
    @Resource
    private CustomizationByDesignerPOMapper customizationByDesignerPOMapper;
    @Resource
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Resource
    private CustomizationRelationPOMapper customizationRelationPOMapper;
    @Resource
    private CustomizationCategoryPOMapper customizationCategoryPOMapper;
    @Resource
    private CustomizationDetailPOMapper customizationDetailPOMapper;
    @Resource
    private CustomizationGoodsRelationPOMapper customizationGoodsRelationPOMapper;

    public ResponseData searchCustomizationList(Integer merchantId) {
        log.info("CustomizationServiceImpl#searchCustomizationList:{}", (Object)merchantId);
        CustomizationPOExample customizationPOExample = new CustomizationPOExample();
        customizationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE);
        List customizationPOS = this.customizationByDesignerPOMapper.selectByExample(customizationPOExample);
        log.info("\u67e5\u8be2\u51fa\u53ef\u7528\u7684\u5b9a\u5236\u670d\u52a1\u5217\u8868:{}", (Object)JSON.toJSONString((Object)customizationPOS));
        if (CollectionUtils.isEmpty((Collection)customizationPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u6ca1\u6709\u53ef\u7528\u7684\u5b9a\u5236\u670d\u52a1");
        }
        ArrayList<CustomizationSearchResponseVO> responseVOS = new ArrayList<CustomizationSearchResponseVO>();
        for (CustomizationPO checkRelation : customizationPOS) {
            Integer relationId;
            CustomizationRelationPOExample customizationRelationPOExample = new CustomizationRelationPOExample();
            customizationRelationPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andCustomizationIdEqualTo(checkRelation.getCustomizationId()).andMerchantIdEqualTo(merchantId);
            List customizationRelationPOS = this.customizationRelationPOMapper.selectByExample(customizationRelationPOExample);
            log.info("\u67e5\u8be2\u51fa\u7684\u5173\u8054\u5173\u7cfb\u7684\u96c6\u5408\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString((Object)customizationRelationPOS));
            if (CollectionUtils.isEmpty((Collection)customizationRelationPOS)) {
                log.info("\u5546\u6237:{}\u7b2c\u4e00\u6b21\u8fdb\u5165\uff1a{}", (Object)merchantId, (Object)checkRelation.getCustomizationName());
                CustomizationRelationPO insertPo = new CustomizationRelationPO();
                insertPo.setCustomizationId(checkRelation.getCustomizationId());
                insertPo.setGmtCreate(new Date());
                insertPo.setMerchantId(merchantId);
                log.info("\u63d2\u5165\u7684\u6570\u636e\u4e3a:{}", JSON.toJSON((Object)insertPo));
                this.customizationRelationPOMapper.insertSelective(insertPo);
                relationId = insertPo.getCustomizationRelationId();
            } else {
                relationId = ((CustomizationRelationPO)customizationRelationPOS.get(0)).getCustomizationRelationId();
            }
            CustomizationSearchResponseVO responseVO = new CustomizationSearchResponseVO();
            BeanUtils.copyProperties((Object)checkRelation, (Object)responseVO);
            responseVO.setCustomizationRelationId(relationId);
            responseVOS.add(responseVO);
        }
        return ResponseUtil.getSuccessData(responseVOS);
    }

    public ResponseData searchCategoryList(CustomizationCategoryListSearchRequestVO vo) {
        log.info("CustomizationServiceImpl#searchCategoryList vo:{}", (Object)JSON.toJSONString((Object)vo));
        CustomizationRelationPOExample checkRelation = new CustomizationRelationPOExample();
        checkRelation.createCriteria().andValidEqualTo(Boolean.TRUE).andCustomizationRelationIdEqualTo(vo.getCustomizationRelationId());
        List customizationRelationPOS = this.customizationRelationPOMapper.selectByExample(checkRelation);
        log.info("\u67e5\u8be2\u51fa\u7684\u5173\u8054\u5173\u7cfb\u96c6\u5408:{}", (Object)JSON.toJSONString((Object)customizationRelationPOS));
        if (CollectionUtils.isEmpty((Collection)customizationRelationPOS)) {
            return ResponseUtil.getFailedMsg((String)"\u5546\u6237\u5b9a\u5236\u670d\u52a1\u5173\u8054\u5173\u7cfb\u672a\u521b\u5efa");
        }
        if (customizationRelationPOS.size() > 1) {
            return ResponseUtil.getFailedMsg((String)"\u5546\u6237\u5b9a\u5236\u670d\u52a1\u5173\u8054\u5173\u7cfb\u8fc7\u591a");
        }
        Integer customizationRelationId = ((CustomizationRelationPO)customizationRelationPOS.get(0)).getCustomizationRelationId();
        CustomizationCategoryPOExample searchListExample = new CustomizationCategoryPOExample();
        CustomizationCategoryPOExample.Criteria criteria = searchListExample.createCriteria().andCustomizationRelationIdEqualTo(customizationRelationId).andValidEqualTo(Boolean.TRUE);
        PageInfo pageInfo = new PageInfo();
        if (!StringUtils.isEmpty((Object)vo.getCustomizationCategoryName())) {
            criteria.andCustomizationCategoryNameLike("%" + vo.getCustomizationCategoryName() + "%");
        }
        searchListExample.setOrderByClause("gmt_create desc");
        List customizationCategoryPOS = new ArrayList();
        if (vo.getPageJudge().booleanValue()) {
            PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
            customizationCategoryPOS = this.customizationCategoryPOMapper.selectByExample(searchListExample);
            pageInfo = new PageInfo(customizationCategoryPOS);
        } else {
            customizationCategoryPOS = this.customizationCategoryPOMapper.selectByExample(searchListExample);
            pageInfo.setList(customizationCategoryPOS);
        }
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData searchCategoryDetailList(CustomizationCategoryDetailListSearchRequestVO vo) {
        log.info("CustomizationServiceImpl#searchCategoryDetailLis vo:{}", (Object)JSON.toJSONString((Object)vo));
        CustomizationDetailPOExample searchListExample = new CustomizationDetailPOExample();
        searchListExample.createCriteria().andCustomizationCategoryIdEqualTo(vo.getCustomizationCategoryId()).andValidEqualTo(Boolean.TRUE);
        searchListExample.setOrderByClause("sort asc");
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List customizationDetailPOS = this.customizationDetailPOMapper.selectByExample(searchListExample);
        PageInfo pageInfo = new PageInfo(customizationDetailPOS);
        log.info("customizationDetailPOS:{}", (Object)JSON.toJSONString((Object)customizationDetailPOS));
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    public ResponseData searchCategoryListByGoodId(CategoryListByGoodIdSearchRequestVO vo) {
        List result = this.customizationByDesignerPOMapper.searchCategoryListByGoodId(vo);
        return ResponseUtil.getSuccessData((Object)result);
    }
}

