/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.activity.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.enums.seckill.MarketActivitySecKillStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityCombinationGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ActivityPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.po.ActivityCombinationGoodsPO;
import com.wmeimob.fastboot.bizvane.po.ActivityCombinationGoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.ActivityPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.service.activity.ActivityNewService;
import com.wmeimob.fastboot.bizvane.vo.CombinationActivityGoodsVO;
import com.wmeimob.fastboot.bizvane.vo.CombinationActivityVO;
import com.wmeimob.fastboot.bizvane.vo.activity.CombinationActivityListVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityNewServiceImpl
implements ActivityNewService {
    private static final Logger log = LoggerFactory.getLogger(ActivityNewServiceImpl.class);
    @Autowired
    private ActivityPOMapper activityPOMapper;
    @Autowired
    private ActivityCombinationGoodsPOMapper activityCombinationGoodsPOMapper;
    @Autowired
    private GoodsPOMapper goodsPOMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;

    public List<CombinationActivityListVO> getPackages(Integer merchantId, Integer goodsId) {
        ActivityCombinationGoodsPOExample activityCombinationGoodsPOExample = new ActivityCombinationGoodsPOExample();
        activityCombinationGoodsPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andGoodsIdEqualTo(goodsId).andIsMainGoodsEqualTo(Boolean.TRUE);
        List activityCombinationGoodsPOList = this.activityCombinationGoodsPOMapper.selectByExample(activityCombinationGoodsPOExample);
        ArrayList<CombinationActivityListVO> combinationActivityListVOS = new ArrayList<CombinationActivityListVO>();
        if (CollectionUtils.isNotEmpty((Collection)activityCombinationGoodsPOList)) {
            log.info("\u8be5\u5546\u54c1\u53c2\u52a0\u7684\u7ec4\u5408\u4ef7\u6d3b\u52a8\uff1a{}", (Object)JSON.toJSONString((Object)activityCombinationGoodsPOList));
            activityCombinationGoodsPOList.stream().forEach(e -> {
                CombinationActivityListVO combinationActivityListVO = new CombinationActivityListVO();
                ActivityPO activityPO = this.activityPOMapper.selectByPrimaryKey(e.getActivityId());
                if (MarketActivitySecKillStatusEnum.ON_GOING.getCode().equals(activityPO.getActivityStatusValue()) && activityPO.getStatus().booleanValue()) {
                    ActivityCombinationGoodsPOExample combinationGoodsPOExample = new ActivityCombinationGoodsPOExample();
                    combinationGoodsPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andActivityIdEqualTo(e.getActivityId()).andPidEqualTo(e.getGoodsId());
                    List activityCombinationGoodsPOS = this.activityCombinationGoodsPOMapper.selectByExample(combinationGoodsPOExample);
                    BigDecimal totalPrice = new BigDecimal("0.00");
                    BigDecimal markPrice = new BigDecimal("0.00");
                    if (CollectionUtils.isNotEmpty((Collection)activityCombinationGoodsPOS)) {
                        for (ActivityCombinationGoodsPO combinationGoodsPO : activityCombinationGoodsPOS) {
                            totalPrice = totalPrice.add(combinationGoodsPO.getSalePrice());
                            GoodsPO goodsPO = this.goodsPOMapper.selectByPrimaryKey(combinationGoodsPO.getGoodsId());
                            markPrice = markPrice.add(goodsPO.getSalePrice());
                        }
                    }
                    totalPrice = totalPrice.add(e.getSalePrice());
                    markPrice = markPrice.add(this.goodsPOMapper.selectByPrimaryKey(e.getGoodsId()).getSalePrice());
                    combinationActivityListVO.setTotalPrice(totalPrice);
                    combinationActivityListVO.setDiscount(markPrice.subtract(totalPrice));
                    combinationActivityListVO.setImages(activityPO.getImages());
                    combinationActivityListVO.setName(activityPO.getName());
                    combinationActivityListVOS.add(combinationActivityListVO);
                }
            });
        }
        return combinationActivityListVOS;
    }

    public List<CombinationActivityVO> getMorePackagesList(Integer merchantId, Integer goodsId) {
        ActivityCombinationGoodsPOExample activityCombinationGoodsPOExample = new ActivityCombinationGoodsPOExample();
        activityCombinationGoodsPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andGoodsIdEqualTo(goodsId).andIsMainGoodsEqualTo(Boolean.TRUE);
        List activityCombinationGoodsPOList = this.activityCombinationGoodsPOMapper.selectByExample(activityCombinationGoodsPOExample);
        ArrayList<CombinationActivityVO> combinationActivityVOList = new ArrayList<CombinationActivityVO>();
        if (CollectionUtils.isNotEmpty((Collection)activityCombinationGoodsPOList)) {
            log.info("\u5546\u54c1\uff1a{}\u4f5c\u4e3a\u4e3b\u5546\u54c1\u53c2\u52a0\u7684\u7ec4\u5408\u4ef7\u6d3b\u52a8\uff1a{}", (Object)goodsId, (Object)JSON.toJSONString((Object)activityCombinationGoodsPOList));
            activityCombinationGoodsPOList.stream().forEach(e -> {
                ActivityCombinationGoodsPOExample combinationGoodsPOExample = new ActivityCombinationGoodsPOExample();
                ActivityPO activityPO = this.activityPOMapper.selectByPrimaryKey(e.getActivityId());
                if (MarketActivitySecKillStatusEnum.ON_GOING.getCode().equals(activityPO.getActivityStatusValue()) && activityPO.getStatus().booleanValue()) {
                    combinationGoodsPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andActivityIdEqualTo(e.getActivityId());
                    List activityCombinationGoodsPOS = this.activityCombinationGoodsPOMapper.selectByExample(combinationGoodsPOExample);
                    log.info("\u5546\u54c1\uff1a{}\u53c2\u52a0\u7684\u7ec4\u5408\u4ef7\u6d3b\u52a8\u4e0b\u6240\u6709\u5546\u54c1\uff1a{}", (Object)e.getActivityId(), (Object)JSON.toJSONString((Object)activityCombinationGoodsPOS));
                    if (CollectionUtils.isNotEmpty((Collection)activityCombinationGoodsPOS)) {
                        CombinationActivityVO combinationActivityVO = new CombinationActivityVO();
                        ArrayList goodsList = new ArrayList();
                        activityCombinationGoodsPOS.stream().forEach(goods -> {
                            GoodsPO goodsPO = this.goodsPOMapper.selectByPrimaryKey(goods.getGoodsId());
                            List goodsSkuDetailPOList = this.goodsSkuDetailMapper.findByGoodsId(goodsPO.getId());
                            CombinationActivityGoodsVO combinationActivityGoodsVO = new CombinationActivityGoodsVO();
                            combinationActivityGoodsVO.setGoodsId(goods.getGoodsId());
                            combinationActivityGoodsVO.setGoodsName(goodsPO.getGoodsName());
                            combinationActivityGoodsVO.setGoodsNo(goodsPO.getGoodsNo());
                            combinationActivityGoodsVO.setImage(goodsPO.getCoverImg());
                            combinationActivityGoodsVO.setCombinationPrice(goods.getSalePrice());
                            combinationActivityGoodsVO.setIsMainGoods(goods.getIsMainGoods());
                            combinationActivityGoodsVO.setIsMustSale(goods.getIsMustBuy());
                            combinationActivityGoodsVO.setMarketPrice(goodsPO.getSalePrice());
                            combinationActivityGoodsVO.setIsShelved(goodsPO.getIsShelved());
                            if (CollectionUtils.isNotEmpty((Collection)goodsSkuDetailPOList)) {
                                BigDecimal minPrice = goodsSkuDetailPOList.stream().filter(o -> o.getSalesPrice() != null).map(GoodsSkuDetail::getSalesPrice).min(BigDecimal::compareTo).get();
                                combinationActivityGoodsVO.setMarketPrice(minPrice);
                                Integer stock = goodsSkuDetailPOList.stream().filter(g -> g.getStock() != null).mapToInt(GoodsSkuDetail::getStock).sum();
                                combinationActivityGoodsVO.setHsaStock(Boolean.FALSE);
                                if (stock > 0) {
                                    combinationActivityGoodsVO.setHsaStock(Boolean.TRUE);
                                }
                            }
                            goodsList.add(combinationActivityGoodsVO);
                            combinationActivityVO.setActivityPO(activityPO);
                            combinationActivityVO.setGoodsList(goodsList);
                        });
                        combinationActivityVOList.add(combinationActivityVO);
                    }
                }
            });
        }
        log.info("\u5546\u54c1\u7ec4\u5408\uff1a{}", (Object)JSON.toJSONString(combinationActivityVOList));
        return combinationActivityVOList;
    }
}

