/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.autoconfigure.qiniu.QiNiuProperties;
import com.wmeimob.fastboot.bizvane.dto.MallOpenCardRequestVo;
import com.wmeimob.fastboot.bizvane.dto.MallOpenCardResponseVo;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.BizvaneRole;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.open.service.MiniprogramUserService;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@Primary
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private UserCommissionService userCommissionService;
    @Resource
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Resource
    private QiNiuProperties qiNiuProperties;
    @Autowired
    private MiniprogramUserService miniprogramUserService;

    public User findOneByCondition(User loginUserInfo) {
        log.info("\u67e5\u8be2crm\u4f1a\u5458\u4fe1\u606f\u7684\u5165\u53c2\u662f{}", JSON.toJSON((Object)loginUserInfo));
        User remoteUser = this.bizvaneInterface.getSingleMemberInfo(loginUserInfo);
        log.info("\u83b7\u53d6\u7684crm\u4f1a\u5458\u4fe1\u606f[1]\u662f{}", JSON.toJSON((Object)remoteUser));
        ArrayList<Object> authorities = new ArrayList<Object>();
        authorities.add(() -> ((BizvaneRole)BizvaneRole.WECHAT_USER).role());
        if (remoteUser != null && !StringUtils.isEmpty((Object)remoteUser.getUserNo())) {
            authorities.add(() -> ((BizvaneRole)BizvaneRole.USER).role());
            loginUserInfo.setUserNo(remoteUser.getUserNo());
            loginUserInfo.setFullName(remoteUser.getFullName());
            loginUserInfo.setUserId(remoteUser.getUserId());
            loginUserInfo.setBrandId(remoteUser.getBrandId());
            loginUserInfo.setLevelId(remoteUser.getLevelId());
            loginUserInfo.setHeadImgUrl(remoteUser.getHeadImgUrl());
            loginUserInfo.setEnabledCommission(remoteUser.getEnabledCommission());
            loginUserInfo.setUserPhone(remoteUser.getUserPhone());
            loginUserInfo.setSysStoreId(remoteUser.getSysStoreId());
            loginUserInfo.setOfflineStoreId(remoteUser.getOfflineStoreId());
            loginUserInfo.setSysCompanyId(remoteUser.getSysCompanyId());
            try {
                this.userCommissionService.getUserCommissionAccounts(loginUserInfo);
            }
            catch (Exception e) {
                log.warn("\u4f63\u91d1\u5f02\u5e38\uff1a" + e.getLocalizedMessage(), (Throwable)e);
            }
            loginUserInfo.setMerchantId(remoteUser.getMerchantId());
        } else {
            loginUserInfo.setMerchantId(loginUserInfo.getBrandId());
        }
        loginUserInfo = this.mergeUserWithCache(loginUserInfo);
        loginUserInfo.setAuthorities(authorities);
        return loginUserInfo;
    }

    public User mergeUserWithCache(User source) {
        String appid = source.getAppid();
        String openid = source.getOpenid();
        User remote = this.miniprogramUserService.getUser(appid, openid);
        log.info("BizvaneStartUp # remote  {}", (Object)JSON.toJSONString((Object)remote));
        if (remote != null) {
            User result = this.mergeUser(source, remote);
            log.info("BizvaneStartUp # result{}", (Object)JSON.toJSONString((Object)result));
            return result;
        }
        return source;
    }

    private User mergeUser(User source, User remote) {
        if (source.getUserId() == null) {
            source.setUserId(remote.getUserId());
        }
        if (StringUtils.isEmpty((Object)source.getUserNo())) {
            source.setUserNo(remote.getUserNo());
        }
        if (source.getWechatUserId() == null) {
            source.setWechatUserId(remote.getWechatUserId());
        }
        if (StringUtils.isEmpty((Object)source.getOpenid())) {
            source.setOpenid(remote.getOpenid());
        }
        if (remote.getMerchantId() != null) {
            source.setMerchantId(remote.getMerchantId());
        }
        if (source.getBrandId() == null) {
            source.setBrandId(remote.getBrandId());
        }
        if (source.getLevelId() == null) {
            source.setLevelId(remote.getLevelId());
        }
        if (StringUtils.isEmpty((Object)source.getFullName())) {
            source.setFullName(remote.getFullName());
        }
        if (StringUtils.isEmpty((Object)source.getHeadImgUrl())) {
            source.setHeadImgUrl(remote.getHeadImgUrl());
        }
        if (source.getEnabledCommission() == null) {
            source.setEnabledCommission(remote.getEnabledCommission());
        }
        if (source.getCountIntegral() == null) {
            source.setCountIntegral(remote.getCountIntegral());
        }
        if (StringUtils.isEmpty((Object)source.getMemberLevelName())) {
            source.setMemberLevelName(remote.getMemberLevelName());
        }
        if (StringUtils.isEmpty((Object)source.getUserPhone())) {
            source.setUserPhone(remote.getUserPhone());
        }
        if (source.getSysCompanyId() == null) {
            source.setSysCompanyId(remote.getSysCompanyId());
        }
        if (source.getSysStoreId() == null) {
            source.setSysStoreId(remote.getSysStoreId());
        }
        if (source.getOfflineStoreId() == null) {
            source.setOfflineStoreId(remote.getOfflineStoreId());
        }
        return source;
    }

    public User findOneByCondition(User loginUserInfo, MallOpenCardRequestVo requestVo, MallOpenCardResponseVo responseVo) {
        String name;
        log.info("\u67e5\u8be2crm\u4f1a\u5458\u4fe1\u606f\u7684\u5165\u53c2\u662f{},\u53c2\u6570{}", JSON.toJSON((Object)loginUserInfo), (Object)JSON.toJSONString((Object)responseVo));
        User remoteUser = new User();
        remoteUser.setUserNo(responseVo.getMemberCode());
        remoteUser.setUserId(responseVo.getMbrMemberId());
        remoteUser.setBrandId(Integer.valueOf(responseVo.getBrandId().intValue()));
        Long levelId = responseVo.getLevelId();
        if (levelId != null) {
            remoteUser.setLevelId(Integer.valueOf(levelId.intValue()));
        }
        if (StringUtils.isEmpty((Object)(name = responseVo.getName()))) {
            name = requestVo.getName();
        }
        remoteUser.setFullName(name);
        remoteUser.setOpenid(loginUserInfo.getOpenid());
        remoteUser.setUserPhone(responseVo.getPhone());
        String headPortraits = responseVo.getHeadPortraits();
        if (!StringUtils.isEmpty((Object)headPortraits)) {
            if (!headPortraits.contains("http")) {
                headPortraits = "https://" + this.qiNiuProperties.getDomain() + "/" + headPortraits;
            }
        } else {
            headPortraits = requestVo.getHeadPortraits();
        }
        remoteUser.setHeadImgUrl(headPortraits);
        Integer distributionState = responseVo.getDistributionState();
        if (distributionState == null) {
            remoteUser.setEnabledCommission(Boolean.FALSE);
        } else {
            remoteUser.setEnabledCommission(distributionState == 1 ? Boolean.TRUE : Boolean.FALSE);
        }
        remoteUser.setCountIntegral(responseVo.getCountIntegral());
        remoteUser.setMerchantId(Integer.valueOf(responseVo.getMerchantId().intValue()));
        log.info("\u83b7\u53d6\u7684crm\u4f1a\u5458\u4fe1\u606f[2]\u662f{}", JSON.toJSON((Object)remoteUser));
        ArrayList<Object> authorities = new ArrayList<Object>();
        authorities.add(() -> ((BizvaneRole)BizvaneRole.WECHAT_USER).role());
        if (remoteUser != null && !StringUtils.isEmpty((Object)remoteUser.getUserNo())) {
            authorities.add(() -> ((BizvaneRole)BizvaneRole.USER).role());
            if (!StringUtils.isEmpty((Object)requestVo.getHeadPortraits())) {
                remoteUser.setHeadImgUrl(requestVo.getHeadPortraits());
            }
            if (!StringUtils.isEmpty((Object)responseVo.getName())) {
                remoteUser.setFullName(requestVo.getName());
            }
            try {
                this.userCommissionService.getUserCommissionAccounts(remoteUser);
            }
            catch (Exception e) {
                log.warn("\u4f63\u91d1\u5f02\u5e38\uff1a" + e.getLocalizedMessage(), (Throwable)e);
            }
            remoteUser.setMerchantId(remoteUser.getMerchantId());
        } else {
            remoteUser.setMerchantId(loginUserInfo.getBrandId());
        }
        remoteUser.setAuthorities(authorities);
        return remoteUser;
    }

    public UserDiscountDTO getUserDiscountInfo(User user) {
        User remoteUser = (User)SecurityContext.getUser();
        if (remoteUser != null) {
            UserDiscountDTO userDiscountDTO = this.bizvaneInterface.userLevelDiscountInfo(remoteUser.getLevelId());
            return userDiscountDTO;
        }
        return null;
    }

    public CompanyBrandRelation getCompany(Integer merchantId) {
        Example example = new Example(CompanyBrandRelation.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOneByExample((Object)example);
        return companyBrandRelation;
    }
}

