/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.config.BizvaneSecurityContext;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.bizvane.service.UserServiceImpl;
import com.wmeimob.fastboot.bizvane.utils.WXBizMsgCrypt;
import com.wmeimob.fastboot.open.service.MiniprogramUserService;
import com.wmeimob.fastboot.starter.security.JwtAuthenticationFilter;
import java.util.HashMap;
import java.util.Map;
import me.hao0.wechat.core.Wechat;
import me.hao0.wechat.core.WechatBuilder;
import me.hao0.wechat.model.base.EncryptWatermark;
import me.hao0.wechat.model.user.MiniprogramUserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UserLoginService {
    private static final Logger log = LoggerFactory.getLogger(UserLoginService.class);
    @Autowired
    private MiniprogramUserService miniprogramUserService;
    @Autowired
    private UserServiceImpl userService;
    @Autowired
    private JwtAuthenticationFilter jwtAuthenticationFilter;

    public static void main(String[] args) {
        Wechat wechat = WechatBuilder.newBuilder((String)"wx2c6a6ee11bf89d43").build();
        EncryptWatermark encryptWatermark = new EncryptWatermark();
        encryptWatermark.setSessionKey("w6toN8VdfzLDdETZqF2hRw==");
        encryptWatermark.setEncryptedData("Y0HmM5KFYFXBlTZSHc8HwsYu6fyRAFW2bqFGxqV6SybzeTGFVXdvmwSmSAxgqtjV3YUbQ5RNaOfsjSqImSxY4ZsGGYLq2opxVJjMWGk/8kA5R4NiY1CIsv8yZ1aMVq/mRR7YoThXfJyq+CEY0jX9y6Q8Gqa7GmgI+PThUFcrlQoHsTWIIEsbDGFkk6//VxalS+o6Qzi7uv/sdGgY3VcVyp4F4tulyx5VjjofE0WCJF1sXz3bwZF22bvp+O+aKOhkDZ1b0kblTdzBPniysz/iQAOS22INSMfvhPc61EOE6GxFH6J3wnrsKNb0odXHT+t6uYRnlJEGnydTwJxqBMGaaCJPrjzHrQnxaGqq/jcx0AXSZqcPwgJzK280VhnqQtU3JFhp0FFUvZF8NIR/iCTxnEb4Zv8oIcUs+/AUkxVQLYW5Yu26+jN5U92RhypaVNgB7BtjU/D4bd6h4+1kxVDPMBS4AtfadXi1jixsj6/EMUrWts4cfe/kckZEVU0irOG9");
        encryptWatermark.setIv("8FLW6px5OQLlHZrAity//Q==");
        MiniprogramUserInfo userInfo = WXBizMsgCrypt.encryptedData((EncryptWatermark)encryptWatermark);
        System.out.println(JSON.toJSONString((Object)userInfo));
    }

    public Map<String, Object> getUser(String appid, Integer brandId, EncryptWatermark encryptWatermark) {
        log.info("\u5165\u53c2appid:[{}],mechantId:[{}],encryptWatermark:[{}]", new Object[]{appid, brandId, JSON.toJSON((Object)encryptWatermark)});
        User user = BizvaneSecurityContext.getUser();
        log.info("user:[{}]", JSON.toJSON((Object)user));
        Wechat wechat = WechatBuilder.newBuilder((String)appid).build();
        encryptWatermark.setSessionKey(this.miniprogramUserService.get(appid, user.getOpenid()).getSession_key());
        log.info("encryptWatermark:[{}]", JSON.toJSON((Object)encryptWatermark));
        MiniprogramUserInfo userInfo = wechat.user().decodeEncryptUserInfo(encryptWatermark);
        log.info("decrypt user info => {}", (Object)userInfo);
        if (StringUtils.isEmpty((Object)userInfo)) {
            throw new UserException("\u83b7\u53d6\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
        }
        if (StringUtils.isEmpty((Object)userInfo.getUnionId())) {
            throw new UserException("\u83b7\u53d6\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5173\u6ce8\u672c\u54c1\u724c\u7684\u516c\u4f17\u53f7\uff0c\u8c22\u8c22\u5408\u4f5c");
        }
        User queryParams = User.builder().openid(userInfo.getOpenId()).unionid(userInfo.getUnionId()).appid(appid).brandId(brandId).build();
        log.info("=====queryParams=======>{}", (Object)queryParams);
        User remoteUser = this.userService.findOneByCondition(queryParams);
        remoteUser.setAppid(appid);
        String decrypt = this.jwtAuthenticationFilter.getJsonWebTokenHandler().generateToken((UserDetails)remoteUser);
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("decrypt", decrypt);
        info.put("user", remoteUser);
        return info;
    }
}

