/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccounts;
import com.wmeimob.fastboot.bizvane.mapper.UserCommissionAccountsMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@Primary
public class UserCommissionServiceImpl
implements UserCommissionService {
    @Autowired
    private UserCommissionAccountsMapper userCommissionAccountsMapper;
    @Resource
    private BizvaneInterface bizvaneInterface;

    public synchronized UserCommissionAccounts getUserCommissionAccounts(User user) {
        if (StringUtils.isEmpty((Object)user.getUserNo())) {
            throw new CustomException("\u53c2\u6570\u4e22\u5931");
        }
        UserCommissionAccounts uc = new UserCommissionAccounts();
        uc.setUserNo(user.getUserNo());
        uc = (UserCommissionAccounts)this.userCommissionAccountsMapper.selectOne((Object)uc);
        if (uc == null) {
            uc = new UserCommissionAccounts();
            uc.setUserNo(user.getUserNo());
            uc.setAmount(new BigDecimal("0"));
            uc.setHistoryAmount(new BigDecimal("0"));
            uc.setBindOpenId(user.getOpenid());
            uc.setMerchantId(user.getMerchantId());
            uc.setHeadImgUrl(user.getHeadImgUrl());
            uc.setNickname(user.getFullName());
            uc.setGmtCreate(new Date());
            uc.setGmtModified(new Date());
            this.userCommissionAccountsMapper.insertSelective((Object)uc);
        } else {
            UserCommissionAccounts update = new UserCommissionAccounts();
            update.setId(uc.getId());
            update.setHeadImgUrl(user.getHeadImgUrl());
            update.setNickname(user.getFullName());
            this.userCommissionAccountsMapper.updateByPrimaryKeySelective((Object)update);
        }
        return uc;
    }

    public UserCommissionAccounts findById(String userNo) {
        Assert.notNull((Object)userNo, (String)"query user commission params missing");
        Example example = new Example(UserCommissionAccounts.class);
        example.createCriteria().orEqualTo("userNo", (Object)userNo);
        UserCommissionAccounts userCommissionAccounts = (UserCommissionAccounts)this.userCommissionAccountsMapper.selectOneByExample((Object)example);
        if (userCommissionAccounts == null) {
            throw new CustomException("\u4f63\u91d1\u8d26\u6237\u672a\u627e\u5230");
        }
        return userCommissionAccounts;
    }

    public List<UserCommissionAccounts> findByCondition(UserCommissionAccounts condition) {
        return this.userCommissionAccountsMapper.selectLowerListByUserNo(condition);
    }

    public void binding(String myUserNo, String parentUserNo) {
        UserCommissionAccounts parent = this.findById(parentUserNo);
        UserCommissionAccounts user = this.findById(myUserNo);
        if (user.getPid() != null) {
            throw new CustomException("\u5df2\u7ed1\u5b9a\u5176\u4ed6\u8d26\u6237");
        }
        if (parent.getId().equals(user.getId())) {
            throw new CustomException("\u4e0d\u53ef\u7ed1\u5b9a\u81ea\u5df1");
        }
        if (user.getId() < parent.getId()) {
            throw new CustomException("\u6b64\u7528\u6237\u5df2\u5f00\u5361\uff0c\u4e0d\u53ef\u7ed1\u5b9a");
        }
        user.setPid(parent.getId());
        int result = this.userCommissionAccountsMapper.updateByPrimaryKeySelective((Object)user);
        if (result < 1) {
            throw new CustomException("\u7ed1\u5b9a\u5931\u8d25");
        }
    }

    public UserCommissionAccounts findOneByCondition(UserCommissionAccounts condition) {
        Assert.notNull((Object)condition.getUserNo(), (String)"condition user no is null");
        return (UserCommissionAccounts)this.userCommissionAccountsMapper.selectOne((Object)condition);
    }

    public Boolean findParentState(String userNo) {
        UserCommissionAccounts accounts = this.findById(userNo);
        if (accounts == null || accounts.getPid() == null || accounts.getPid().equals(0)) {
            return false;
        }
        UserCommissionAccounts parentAccount = (UserCommissionAccounts)this.userCommissionAccountsMapper.selectByPrimaryKey((Object)accounts.getPid());
        if (parentAccount == null) {
            return false;
        }
        User memberInfo = this.bizvaneInterface.getMemberInfo(User.builder().userNo(parentAccount.getUserNo()).build());
        if (memberInfo == null) {
            return false;
        }
        return memberInfo.getEnabledCommission();
    }

    public UserCommissionAccounts selectUserCommissionAccountByUserNo(String userNo) {
        return this.userCommissionAccountsMapper.selectUserCommissionAccountsByUserNo(userNo);
    }
}

