/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.StorePriceStockMapper;
import com.wmeimob.fastboot.bizvane.service.huairen.vo.GetStockResponseVO;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class StoreGoodsConvertHandler {
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private StorePriceStockMapper storePriceStockMapper;

    public List<GoodsSkuDetail> convert(List<GoodsSkuDetail> goodsSkuDetailList, Long sysStoreId) {
        if (goodsSkuDetailList.stream().filter(e -> e.getId() == null).findAny().isPresent()) {
            throw new CustomException("\u95e8\u5e97\u7ea7\u522b\u67e5\u8be2\u5546\u54c1\u5fc5\u8981\u53c2\u6570skuId\u4e3a\u7a7a");
        }
        return this.goodsSkuDetailMapper.selectStoreGoodsSkuInfo(goodsSkuDetailList, sysStoreId);
    }

    public List<GoodsSkuDetail> checkAndGetStoreSkuInfo(List<GoodsSkuDetail> customSkuInfoList, Long sysStoreId) {
        List dbSkuInfoList = this.convert(customSkuInfoList, sysStoreId);
        StoreGoodsConvertHandler.checkStoreGoods(customSkuInfoList, (List)dbSkuInfoList);
        return dbSkuInfoList;
    }

    public static void checkStoreGoods(List<GoodsSkuDetail> customSkuInfoList, List<GoodsSkuDetail> dbSkuInfoList) {
        InputValidator.checkEmpty(dbSkuInfoList, (String)"\u5546\u54c1");
        for (GoodsSkuDetail customSku : customSkuInfoList) {
            GoodsSkuDetail extract = StoreGoodsConvertHandler.extractSkuInfoFromSkuList((GoodsSkuDetail)customSku, dbSkuInfoList);
            Assert.notNull((Object)extract, (String)("\u5546\u54c1[" + StoreGoodsConvertHandler.getGoodsSkuName((GoodsSkuDetail)customSku) + "]\u4e0d\u5b58\u5728"));
            if (extract.getStock() - customSku.getStock() >= 0) continue;
            throw new CustomException("\u5546\u54c1[" + StoreGoodsConvertHandler.getGoodsSkuName((GoodsSkuDetail)customSku) + "]\u5e93\u5b58\u4e0d\u8db3");
        }
    }

    public static String getGoodsSkuName(GoodsSkuDetail orderItems) {
        return orderItems.getGoodsName() + " " + orderItems.getSkuNo();
    }

    public static GoodsSkuDetail extractSkuInfoFromSkuList(GoodsSkuDetail goodsSkuDetail, List<GoodsSkuDetail> goodsSkuDetailList) {
        for (GoodsSkuDetail gsd : goodsSkuDetailList) {
            if (!gsd.getSkuNo().equals(goodsSkuDetail.getSkuNo()) || !gsd.getGoodsId().equals(goodsSkuDetail.getGoodsId())) continue;
            return gsd;
        }
        return null;
    }

    public static List<GoodsSkuDetail> staticConvert(List<GoodsSkuDetail> customeSkuInfo, List<GetStockResponseVO> offlineDbSkuInfo) {
        int flag = 0;
        for (GetStockResponseVO offline : offlineDbSkuInfo) {
            for (GoodsSkuDetail custome : customeSkuInfo) {
                if (!offline.getSkuCode().equals(custome.getSkuNo())) continue;
                custome.setStock(offline.getStock());
                ++flag;
            }
        }
        if (flag != customeSkuInfo.size()) {
            throw new CustomException("\u7ebf\u4e0b\u56de\u4f20\u6570\u636e\u9519\u8bef");
        }
        return customeSkuInfo;
    }
}

