/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.config.BizvaneProperties;
import com.wmeimob.fastboot.bizvane.config.BizvaneSecurityContext;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.dto.ShopCartDTO;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.ShopCart;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.PurchasedTypeEnum;
import com.wmeimob.fastboot.bizvane.event.purchased.GoodPurchasedEvent;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.HotGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.ShopCartMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CompanyBrandRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationByDesignerPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationCategoryPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSyncRecordPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ShopCartPOMapper;
import com.wmeimob.fastboot.bizvane.po.CustomizationCategoryPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationDetailPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationRelationPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPO;
import com.wmeimob.fastboot.bizvane.po.ShopCartPO;
import com.wmeimob.fastboot.bizvane.po.ShopCartPOExample;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.bizvane.service.ShopCartService;
import com.wmeimob.fastboot.bizvane.service.StorePriceStockService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.bizvane.service.wrapper.BrowseWrapperService;
import com.wmeimob.fastboot.bizvane.vo.ViewShareGoodsInformRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CategoryListByGoodIdSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryGoodRelationResponseVO;
import com.wmeimob.fastboot.bizvane.vo.purchased.PurchasedEventVO;
import com.wmeimob.fastboot.core.context.PageContext;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.fastboot.util.InputValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class ShopCartServiceImpl
implements ShopCartService {
    private static final Logger log = LoggerFactory.getLogger(ShopCartServiceImpl.class);
    @Resource
    private CustomizationRelationPOMapper customizationRelationPOMapper;
    @Resource
    private CustomizationCategoryPOMapper customizationCategoryPOMapper;
    @Resource
    private CustomizationDetailPOMapper customizationDetailPOMapper;
    @Resource
    private ShopCartMapper shopCartMapper;
    @Resource
    private GoodsSkuDetailService goodsSkuDetailService;
    @Resource
    private CustomizationByDesignerPOMapper customizationByDesignerPOMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Autowired
    private StorePriceStockService storePriceStockService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private UserService userService;
    @Autowired
    private BizvaneProperties bizvaneProperties;
    @Autowired
    private HotGoodsMapper hotGoodsMapper;
    @Autowired
    private CompanyBrandRelationPOMapper companyBrandRelationPOMapper;
    @Autowired
    private GoodsSyncRecordPOMapper goodsSyncRecordPOMapper;
    @Autowired
    private GoodsSkuDetailPOMapper goodsSkuDetailPOMapper;
    @Autowired
    private BrowseWrapperService browseWrapperService;
    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private ShopCartPOMapper shopCartPOMapper;

    private boolean isEmptyUser(ShopCart shopCart) {
        return StringUtils.isEmpty((Object)shopCart.getUserNo()) && StringUtils.isEmpty((Object)shopCart.getWechatOpenid()) && shopCart.getUserId() == null;
    }

    private boolean isLogin(ShopCart shopCart) {
        return StringUtils.isEmpty((Object)shopCart.getUserNo()) && shopCart.getUserId() == null;
    }

    private String getUserFlag(ShopCart shopCart) {
        if (StringUtils.isEmpty((Object)shopCart.getWechatOpenid())) {
            return StringUtils.isEmpty((Object)shopCart.getUserNo()) ? shopCart.getUserId() + "" : shopCart.getUserNo();
        }
        return shopCart.getWechatOpenid();
    }

    private void assertUserInfo(ShopCart shopCart) {
        if (this.isEmptyUser(shopCart)) {
            throw new UserException("user info is missing");
        }
    }

    private void assertUserLogin(ShopCart shopCart) {
        if (this.isLogin(shopCart)) {
            throw new UserException("user info is missing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShopCart add(ShopCart shopCart) {
        GoodsSkuDetail skuDetail;
        boolean b;
        log.info("\u6dfb\u52a0\u8d2d\u7269\u8f66\u5165\u53c2:[{}]", JSON.toJSON((Object)shopCart));
        this.assertUserLogin(shopCart);
        if (shopCart.getMerchantId() == null) {
            throw new CustomException("\u54c1\u724cID\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (shopCart.getGoodsId() == null) {
            throw new CustomException("\u5546\u54c1ID\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)shopCart.getSkuNo())) {
            throw new CustomException("\u5546\u54c1\u89c4\u683c\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (shopCart.getQuantity() == null) {
            throw new CustomException("\u6570\u91cf\u4e0d\u53ef\u4e3a\u7a7a");
        }
        GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
        goodsSkuDetail.setGoodsId(shopCart.getGoodsId());
        goodsSkuDetail.setSkuNo(shopCart.getSkuNo());
        Integer[] storeSelfPrice = this.bizvaneProperties.getStoreSelfPrice();
        if (storeSelfPrice != null && storeSelfPrice.length != 0 && Arrays.asList(storeSelfPrice).contains(shopCart.getMerchantId()) ? !(b = this.storePriceStockService.checkStockLocal(shopCart.getSkuNo(), Integer.valueOf(Integer.parseInt(shopCart.getSysStoreId())), shopCart.getQuantity())) : (skuDetail = (GoodsSkuDetail)this.goodsSkuDetailService.findOneByCondition((Serializable)goodsSkuDetail)).getStock() < 1) {
            throw new MallWechatException("\u5e93\u5b58\u4e0d\u8db3");
        }
        String key = String.format("user:%s:cartCheck:%s", this.getUserFlag(shopCart), shopCart.getSkuNo());
        try {
            if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"").booleanValue()) {
                throw new MallWechatException("\u60a8\u7684\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
            }
            ShopCart checkCountDTO = new ShopCart();
            checkCountDTO.setGoodsId(shopCart.getGoodsId());
            checkCountDTO.setSkuNo(shopCart.getSkuNo());
            checkCountDTO.setWechatOpenid(shopCart.getWechatOpenid());
            int selectCount = this.shopCartMapper.selectCount((Object)checkCountDTO);
            if (selectCount == 0) {
                shopCart.setGmtCreate(new Date());
                shopCart.setIsInvalid(Boolean.valueOf(false));
                this.shopCartMapper.insertSelective((Object)shopCart);
                try {
                    shopCart.setSysStaffId(shopCart.getGuiderStaffId());
                    shopCart.setSysStoreId(shopCart.getGuiderStoreId());
                    this.sendEventAdd(shopCart);
                    this.notifyAddCartInfoQW(shopCart);
                }
                catch (Exception e) {
                    log.warn("\u6dfb\u52a0\u8d2d\u7269\u8f66\u901a\u77e5\u4f01\u5fae\u5931\u8d25:msg[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                }
                ShopCart e = shopCart;
                return e;
            }
            shopCart.setGmtModified(new Date());
            log.info("ShopCartServiceImpl#add shopCart:{}", (Object)JSON.toJSONString((Object)shopCart));
            int result = this.shopCartMapper.incrementCount(shopCart);
            if (result == 0) {
                throw new CustomException("\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25");
            }
            try {
                ShopCart shopCartSearch = (ShopCart)this.shopCartMapper.selectOne((Object)checkCountDTO);
                shopCart.setSysStaffId(shopCart.getGuiderStaffId());
                shopCart.setSysStoreId(shopCart.getGuiderStoreId());
                this.sendEventAdd(shopCartSearch);
                this.notifyAddCartInfoQW(shopCartSearch);
            }
            catch (Exception e) {
                log.warn("\u6dfb\u52a0\u8d2d\u7269\u8f66\u901a\u77e5\u4f01\u5fae\u5931\u8d25:msg[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            }
            ShopCart shopCart2 = shopCart;
            return shopCart2;
        }
        finally {
            this.stringRedisTemplate.delete((Object)key);
        }
    }

    private void notifyAddCartInfoQW(ShopCart shopCart) {
        log.info("\u6dfb\u52a0\u8d2d\u7269\u8f66\u63a8\u9001\u4f01\u5fae\u5165\u53c2:[{}]", JSON.toJSON((Object)shopCart));
        Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)shopCart.getGoodsId());
        CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
        companyBrandRelation.setMerchantId(shopCart.getMerchantId());
        companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne((Object)companyBrandRelation);
        if (goods == null || companyBrandRelation == null) {
            throw new CustomException("\u67e5\u8be2\u5546\u54c1\u6216companyId\u5931\u8d25,\u8bf7\u68c0\u67e5");
        }
        User user = BizvaneSecurityContext.getUser();
        ViewShareGoodsInformRequestVO build = ViewShareGoodsInformRequestVO.builder().goodsName(goods.getGoodsName()).goodsNo(goods.getGoodsNo()).sysStaffId(shopCart.getSysStaffId()).sysStoreId(shopCart.getSysStoreId()).memberCode(user.getUserNo()).sysCompanyId(companyBrandRelation.getCompanyId()).build();
        log.info("\u6dfb\u52a0\u8d2d\u7269\u8f66\u63a8\u9001\u4f01\u5fae\u6570\u636e\u5904\u7406\u5b8c\u6210:[{}]", JSON.toJSON((Object)shopCart));
        this.browseWrapperService.fillBrowse(shopCart, user);
        this.browseWrapperService.fillBrowse(build, user);
        this.bizvaneInterface.notifyAddCartInfoQW(build);
    }

    private void sendEventAdd(ShopCart shopCart) {
        try {
            Integer shopCartId = shopCart.getId();
            ShopCartPO shopCartPO = this.shopCartPOMapper.selectByPrimaryKey(shopCartId);
            User user = (User)SecurityContext.getUser();
            PurchasedEventVO purchasedEventVO = new PurchasedEventVO();
            purchasedEventVO.setMerchantId(user.getMerchantId());
            purchasedEventVO.setMemberCode(user.getUserNo());
            purchasedEventVO.setUser(user);
            ArrayList<ShopCartPO> shopCartPOS = new ArrayList<ShopCartPO>();
            shopCartPOS.add(shopCartPO);
            purchasedEventVO.setShopCartPOs(shopCartPOS);
            GoodPurchasedEvent goodPurchasedEvent = new GoodPurchasedEvent((Object)this.applicationContext, PurchasedTypeEnum.ADD.getCode(), purchasedEventVO);
            this.applicationContext.publishEvent((ApplicationEvent)goodPurchasedEvent);
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u52a0\u8d2d\u4e8b\u4ef6\u8c03\u7528error:{}", (Throwable)e);
        }
    }

    private void sendEventDel(List<ShopCartPO> shopCartPOS) {
        try {
            User user = (User)SecurityContext.getUser();
            PurchasedEventVO purchasedEventVO = new PurchasedEventVO();
            purchasedEventVO.setMerchantId(user.getMerchantId());
            purchasedEventVO.setMemberCode(user.getUserNo());
            purchasedEventVO.setUser(user);
            purchasedEventVO.setShopCartPOs(shopCartPOS);
            GoodPurchasedEvent goodPurchasedEvent = new GoodPurchasedEvent((Object)this.applicationContext, PurchasedTypeEnum.DEL.getCode(), purchasedEventVO);
            this.applicationContext.publishEvent((ApplicationEvent)goodPurchasedEvent);
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u52a0\u8d2d\u4e8b\u4ef6\u8c03\u7528error:{}", (Throwable)e);
        }
    }

    public int delete(Integer id, ShopCart condition) {
        this.assertUserInfo(condition);
        InputValidator.checkNull((Object)condition.getId(), (String)"shop cart id");
        ShopCartPO shopCartPO = this.shopCartPOMapper.selectByPrimaryKey(condition.getId());
        Example example = new Example(ShopCart.class);
        example.createCriteria().andEqualTo("wechatOpenid", (Object)condition.getWechatOpenid()).andEqualTo("id", (Object)condition.getId());
        int result = this.shopCartMapper.deleteByExample((Object)example);
        if (result == 0) {
            throw new CustomException("\u5220\u9664\u5931\u8d25");
        }
        ArrayList<ShopCartPO> shopCartPOS = new ArrayList<ShopCartPO>();
        shopCartPOS.add(shopCartPO);
        this.sendEventDel(shopCartPOS);
        return result;
    }

    public List<ShopCartDTO> queryShopCartGoods(ShopCart condition) {
        this.assertUserInfo(condition);
        List cartList = this.shopCartMapper.selects(condition);
        return cartList;
    }

    public int delete(Integer[] idArr) {
        if (idArr == null || idArr.length == 0) {
            throw new CustomException("\u6ca1\u6709\u5220\u9664\u4efb\u4f55\u9009\u9879");
        }
        List<Integer> integers = Arrays.asList(idArr);
        ShopCartPOExample shopCartPOExample = new ShopCartPOExample();
        shopCartPOExample.createCriteria().andIdIn(integers);
        List shopCartPOS = this.shopCartPOMapper.selectByExample(shopCartPOExample);
        Example example = new Example(ShopCart.class);
        example.createCriteria().andIn("id", integers);
        int result = this.shopCartMapper.deleteByExample((Object)example);
        if (result == 0) {
            throw new CustomException("\u6ca1\u6709\u5220\u9664\u4efb\u4f55\u9009\u9879");
        }
        this.sendEventDel(shopCartPOS);
        return result;
    }

    public Integer queryCount(ShopCart condition) {
        this.assertUserInfo(condition);
        List cartList = this.shopCartMapper.selects(condition);
        return cartList.size();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PageInfo<ShopCartDTO> getAllShopCard(Integer merchantId, Integer brandId) {
        log.info("ShopCartServiceImpl#getAllShopCard merchantId:{},brandId:{}", (Object)merchantId, (Object)brandId);
        User user = (User)SecurityContext.getUser();
        log.info("ShopCartServiceImpl#getAllShopCard user:{}", (Object)JSON.toJSONString((Object)user));
        ShopCart shopCart = new ShopCart();
        shopCart.setWechatOpenid(user.getOpenid());
        shopCart.setMerchantId(merchantId);
        shopCart.setBrandId(brandId);
        PageContext.startPage();
        List list = this.queryShopCartGoods(shopCart);
        log.info("ShopCartServiceImpl#getAllShopCard list:{}", (Object)JSON.toJSONString((Object)list));
        List mainGoodsList = this.goodsSyncRecordPOMapper.selectMainGoods(merchantId);
        log.info("ShopCartServiceImpl#getAllShopCard mainGoodsList:{}", (Object)JSON.toJSONString((Object)mainGoodsList));
        list.forEach(cart -> {
            log.info("ShopCartServiceImpl#getAllShopCard cart:{}", (Object)JSON.toJSONString((Object)cart));
            Goods goods = this.goodsMapper.selectSalePriceByMerchantId(merchantId, cart.getGoodsNo());
            log.info("ShopCartServiceImpl#getAllShopCard goods:{}", JSON.toJSON((Object)goods));
            if (goods != null) {
                cart.setIsValidGood(Boolean.valueOf(true));
                cart.setCoverImg(goods.getCoverImg());
                cart.setGoodsName(goods.getGoodsName());
                cart.setShippingMode(goods.getShippingMode());
            } else {
                cart.setIsValidGood(Boolean.valueOf(false));
            }
        });
        log.info("ShopCartServiceImpl#getAllShopCard aftre foreach list:{}", (Object)JSONObject.toJSONString((Object)list));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Config config = this.configService.findSysConfig(merchantId);
            log.info("ShopCartServiceImpl#getAllShopCard config:{}", JSON.toJSON((Object)config));
            if (config != null && config.getPriceDisplay().equals(2)) {
                List skuNos = list.stream().map(ShopCart::getSkuNo).collect(Collectors.toList());
                log.info("ShopCartServiceImpl#getAllShopCard skuNos:{}", JSON.toJSON(skuNos));
                List storePriceStocks = this.storePriceStockService.listBySkuNos(skuNos, user.getSysStoreId(), merchantId);
                log.info("ShopCartServiceImpl#getAllShopCard storePriceStocks:{}", JSON.toJSON((Object)storePriceStocks));
                list.forEach(shopCartDTO -> {
                    if (shopCartDTO.getCustomizationDetailId() != null) {
                        shopCartDTO.setCustomizationCategoryId(this.shopCartAddCusDetailId(shopCartDTO.getCustomizationDetailId()));
                    }
                    this.addShopCartCustomization(shopCartDTO);
                    shopCartDTO.setStock(Integer.valueOf(0));
                    shopCartDTO.setSaleOut(Integer.valueOf(0));
                    storePriceStocks.forEach(priceStock -> {
                        if (priceStock.getSkuCode().equals(shopCartDTO.getSkuNo())) {
                            shopCartDTO.setSaleOut(priceStock.getStoreStock());
                            shopCartDTO.setStock(priceStock.getStoreStock());
                            shopCartDTO.setSalesPrice(priceStock.getStorePrice());
                        }
                    });
                });
            } else {
                list.forEach(e -> {
                    log.info("ShopCartServiceImpl#getAllShopCard e:{}", JSON.toJSON((Object)e));
                    if (e.getIsValidGood().booleanValue()) {
                        Goods goods1 = this.goodsMapper.selectSalePriceByMerchantId(merchantId, e.getGoodsNo());
                        log.info("ShopCartServiceImpl#getAllShopCard goods1:{}", JSON.toJSON((Object)goods1));
                        if (goods1 == null) {
                            return;
                        }
                        e.setMerchantId(merchantId);
                        GoodsSkuDetailPO goodsSkuDetailPO = this.goodsSkuDetailPOMapper.selectBySkuNoAndMerchantId(goods1.getId(), e.getSkuNo(), merchantId);
                        log.info("ShopCartServiceImpl#getAllShopCard goodsSkuDetailPO:{}", JSON.toJSON((Object)goodsSkuDetailPO));
                        if (goodsSkuDetailPO == null) {
                            return;
                        }
                        e.setGoodsId(goodsSkuDetailPO.getGoodsId());
                        e.setMarketPrice(goodsSkuDetailPO.getMarketPrice());
                        e.setSalesPrice(goodsSkuDetailPO.getSalesPrice());
                        e.setStock(goodsSkuDetailPO.getStock());
                        if (e.getGifts().size() > 0) {
                            List gifts = e.getGifts();
                            gifts.forEach(gift -> {
                                Goods gift1 = this.goodsMapper.selectSalePriceByMerchantId(merchantId, gift.getGoodsNo());
                                log.info("gift1:{}", JSON.toJSON((Object)gift1));
                                if (gift1 == null) {
                                    e.setGifts(null);
                                }
                            });
                        }
                    }
                    if (e.getCustomizationDetailId() != null) {
                        e.setCustomizationCategoryId(this.shopCartAddCusDetailId(e.getCustomizationDetailId()));
                    }
                    this.addShopCartCustomization(e);
                });
            }
            if (config != null && user != null && config.getPriceDisplay().equals(1)) {
                UserDiscountDTO userDiscountDTO = this.userService.getUserDiscountInfo(user);
                log.info("userDiscountDTO:{}", JSON.toJSON((Object)userDiscountDTO));
                if (userDiscountDTO != null && userDiscountDTO.getDiscount() != null) {
                    list.forEach(shopCartDTO -> shopCartDTO.setVipPrice(shopCartDTO.getSalesPrice().multiply(userDiscountDTO.getDiscount()).setScale(2, 4)));
                }
            }
        }
        list.sort((s1, s2) -> {
            boolean good2;
            boolean good1 = s1.getIsValidGood();
            if (good1 ^ (good2 = s2.getIsValidGood().booleanValue())) {
                return good1 ? -1 : 1;
            }
            return 0;
        });
        PageInfo pageInfo = new PageInfo(list);
        log.info("ShopCartServiceImpl#getAllShopCard pageInfo:{}", (Object)pageInfo);
        return pageInfo;
    }

    private Integer shopCartAddCusDetailId(Integer customizationDetailId) {
        CustomizationDetailPO customizationDetailPO = this.customizationDetailPOMapper.selectByPrimaryKey(customizationDetailId);
        return customizationDetailPO.getCustomizationCategoryId();
    }

    private void addShopCartCustomization(ShopCartDTO shopCart) {
        log.info("addGoodCustomization");
        CategoryListByGoodIdSearchRequestVO searchRequestVO = new CategoryListByGoodIdSearchRequestVO();
        searchRequestVO.setGoodId(shopCart.getGoodsId());
        List customizationCategoryPOS = this.customizationByDesignerPOMapper.searchCategoryListByGoodId(searchRequestVO);
        log.info("customizationCategoryPOS_pos:{}", (Object)JSON.toJSONString((Object)customizationCategoryPOS));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customizationCategoryPOS)) {
            ArrayList<Integer> customizationRelationIds = new ArrayList<Integer>();
            ArrayList<CustomizationCategoryGoodRelationResponseVO> customizationCategoryGoodRelationResponseVOS = new ArrayList<CustomizationCategoryGoodRelationResponseVO>();
            for (CustomizationCategoryPO categoryPo : customizationCategoryPOS) {
                CustomizationCategoryPO customizationCategoryPO = this.customizationCategoryPOMapper.selectByPrimaryKey(categoryPo.getCustomizationCategoryId());
                log.info("customizationCategoryPO:{}", (Object)JSON.toJSONString((Object)customizationCategoryPO));
                if (!customizationRelationIds.contains(categoryPo.getCustomizationRelationId())) {
                    CustomizationCategoryGoodRelationResponseVO categoryGoodRelationResponseVO = new CustomizationCategoryGoodRelationResponseVO();
                    customizationRelationIds.add(categoryPo.getCustomizationRelationId());
                    CustomizationRelationPO customizationRelationPO = this.customizationRelationPOMapper.selectByPrimaryKey(categoryPo.getCustomizationRelationId());
                    CustomizationPO customizationPO = this.customizationByDesignerPOMapper.selectByPrimaryKey(customizationRelationPO.getCustomizationId());
                    log.info("customizationRelationPO:{},customizationPO:{}", (Object)JSON.toJSONString((Object)customizationRelationPO), (Object)JSON.toJSONString((Object)customizationPO));
                    categoryGoodRelationResponseVO.setCustomizationRelationId(categoryPo.getCustomizationRelationId());
                    categoryGoodRelationResponseVO.setCustomizationId(customizationRelationPO.getCustomizationId());
                    categoryGoodRelationResponseVO.setCustomizationName(customizationPO.getCustomizationName());
                    ArrayList<CustomizationCategoryPO> categoryPOList = new ArrayList<CustomizationCategoryPO>();
                    categoryPOList.add(customizationCategoryPO);
                    categoryGoodRelationResponseVO.setCustomizationCategories(categoryPOList);
                    customizationCategoryGoodRelationResponseVOS.add(categoryGoodRelationResponseVO);
                    continue;
                }
                for (CustomizationCategoryGoodRelationResponseVO goodRelationResponseVO : customizationCategoryGoodRelationResponseVOS) {
                    if (!goodRelationResponseVO.getCustomizationRelationId().equals(categoryPo.getCustomizationRelationId())) continue;
                    goodRelationResponseVO.getCustomizationCategories().add(customizationCategoryPO);
                }
            }
            shopCart.setCustomizationCategoryGoodRelations(customizationCategoryGoodRelationResponseVOS);
        }
    }
}

