/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.OrderGift;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.mapper.OrderGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderItemsMapper;
import com.wmeimob.fastboot.bizvane.mapper.RefundOrderMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPOExample;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class RefundOrderServiceImpl
implements RefundOrderService {
    private static final Logger log = LoggerFactory.getLogger(RefundOrderServiceImpl.class);
    @Autowired
    private RefundOrderMapper refundOrderMapper;
    @Autowired
    private OrderItemsMapper orderItemsMapper;
    @Autowired
    private OrderGiftMapper orderGiftMapper;
    @Resource
    private OrdersPOMapper ordersPOMapper;

    public List<RefundOrder> findByCondition(RefundOrder condition) {
        return this.refundOrderMapper.selectRefundOrderList(condition);
    }

    public RefundOrder findById(Integer id) {
        RefundOrder refundOrder = this.refundOrderMapper.selectRefundOrderById(id);
        List items = refundOrder.getItems();
        items.forEach(orderItems -> {
            Example example = new Example(OrderGift.class);
            example.createCriteria().andEqualTo("orderItemId", (Object)orderItems.getId());
            List orderGifts = this.orderGiftMapper.selectByExample((Object)example);
            orderItems.setGifts(orderGifts);
            refundOrder.setGifts(orderGifts);
        });
        if (refundOrder.getRefundShippingFee() == null) {
            OrdersPOExample ordersPOExample = new OrdersPOExample();
            ordersPOExample.createCriteria().andOrderNoEqualTo(refundOrder.getOrderNo());
            List ordersPOList = this.ordersPOMapper.selectByExample(ordersPOExample);
            OrdersPO ordersPO = (OrdersPO)ordersPOList.get(0);
            Example orderItemsExample = new Example(OrderItems.class);
            Example.Criteria criteria = orderItemsExample.createCriteria();
            criteria.andEqualTo("orderNo", (Object)refundOrder.getOrderNo());
            int orderItemsCount = this.orderItemsMapper.selectCountByExample((Object)orderItemsExample);
            criteria.andEqualTo("refundStatus", (Object)RefundStatus.SUCCESS);
            int orderItemsAlreadyRefundCount = this.orderItemsMapper.selectCountByExample((Object)orderItemsExample);
            if (orderItemsCount - orderItemsAlreadyRefundCount == 1 && LogisticsStatusEnum.UN_SEND.toString().equals(ordersPO.getLogisticsStatus())) {
                refundOrder.setRefundShippingFee(ordersPO.getShippingFee());
            } else {
                refundOrder.setRefundShippingFee(new BigDecimal("0.00"));
            }
        }
        return refundOrder;
    }

    public RefundOrder findRefundOrderById(Integer itemId) {
        return this.refundOrderMapper.findRefundOrderById(itemId);
    }

    public RefundOrder findById(String refundNo) {
        Example example = new Example(RefundOrder.class);
        example.createCriteria().andEqualTo("refundNo", (Object)refundNo);
        RefundOrder refundOrder = (RefundOrder)this.refundOrderMapper.selectOneByExample((Object)example);
        if (refundOrder != null) {
            OrderItems items = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)refundOrder.getItemId());
            refundOrder.setItem(items);
        }
        return refundOrder;
    }
}

