/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.config.BizvaneProperties;
import com.wmeimob.fastboot.bizvane.config.BizvaneSecurityContext;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.dto.GoodsQueryDTO;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.Collect;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.IndexSubjectImg;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationByDesignerPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationCategoryPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationGoodsRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CustomizationRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsServiceDescRelationPOMapper;
import com.wmeimob.fastboot.bizvane.po.CustomizationCategoryPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationPO;
import com.wmeimob.fastboot.bizvane.po.CustomizationRelationPO;
import com.wmeimob.fastboot.bizvane.po.GoodsServiceDescPO;
import com.wmeimob.fastboot.bizvane.po.GoodsServiceDescRelationPOExample;
import com.wmeimob.fastboot.bizvane.service.CollectService;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.HotGoodsService;
import com.wmeimob.fastboot.bizvane.service.IndexSubjectService;
import com.wmeimob.fastboot.bizvane.service.StorePriceStockService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillService;
import com.wmeimob.fastboot.bizvane.vo.customization.CategoryListByGoodIdSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryGoodRelationResponseVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.GoodsMarketActivityVO;
import com.wmeimob.fastboot.starter.common.entity.RichText;
import com.wmeimob.fastboot.starter.common.service.RichTextService;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.fastboot.util.InputValidator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class IndexV3ServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(IndexV3ServiceImpl.class);
    @Resource
    private CustomizationGoodsRelationPOMapper customizationGoodsRelationPOMapper;
    @Resource
    private CustomizationCategoryPOMapper customizationCategoryPOMapper;
    @Resource
    private CustomizationByDesignerPOMapper customizationByDesignerPOMapper;
    @Resource
    private CustomizationRelationPOMapper customizationRelationPOMapper;
    @Autowired
    private StorePriceStockService storePriceStockService;
    @Resource(name="commonConfigService")
    private ConfigService configService;
    @Resource
    private IndexSubjectService indexSubjectService;
    @Resource
    private HotGoodsService hotGoodsService;
    @Autowired
    private UserService userService;
    @Resource(name="richTextCommonServiceImpl")
    private RichTextService richTextService;
    @Resource
    private CollectService collectService;
    @Resource
    private GoodsService goodsService;
    @Autowired
    private BizvaneProperties bizvaneProperties;
    @Autowired
    private OrdersMapper ordersMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private GoodsServiceDescRelationPOMapper goodsServiceDescRelationPOMapper;
    @Autowired
    private MarketActivitySecKillService marketActivitySecKillService;

    public Map<String, Object> indexV2(Integer merchantId) {
        log.info("IndexV3ServiceImpl # indexV2:{}", (Object)merchantId);
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        IndexSubjectImg indexSubjectImg = this.indexSubjectService.getIndexSubjectImg(merchantId);
        map.put("indexSubjectImg", indexSubjectImg);
        List list = this.hotGoodsService.getIndexHotGoods(merchantId);
        Config config = this.configService.findSysConfig(merchantId);
        try {
            UserDiscountDTO userDiscountDTO;
            User user = BizvaneSecurityContext.getUser();
            if (Objects.nonNull(config) && Objects.nonNull(user) && config.getPriceDisplay().equals(1) && (userDiscountDTO = this.userService.getUserDiscountInfo(user)) != null && userDiscountDTO.getDiscount() != null) {
                list.forEach(hotGoods -> hotGoods.setVipPrice(hotGoods.getSalePrice().multiply(userDiscountDTO.getDiscount()).setScale(2, 4)));
            }
        }
        catch (Exception e) {
            log.warn("\u5904\u7406\u4f1a\u5458\u4ef7\u663e\u793a\u5931\u8d25msg:[{}],[{}]", (Object)e.getMessage(), (Object)e);
        }
        if (Objects.nonNull(config)) {
            map.put("title", config.getTitle());
            map.put("priceDisplay", config.getPriceDisplay());
        }
        map.put("list", list);
        return map;
    }

    public Map<String, Object> indexWrapper(Integer merchantId, Integer storeId) {
        Integer[] storeSelfPrice = this.bizvaneProperties.getStoreSelfPrice();
        log.info("IndexV3ServiceImpl # indexWrapper :{}", (Object)JSON.toJSONString((Object)storeSelfPrice));
        if (storeSelfPrice != null && storeSelfPrice.length != 0 && Arrays.asList(storeSelfPrice).contains(merchantId)) {
            return this.indexV3(merchantId, storeId);
        }
        return this.indexV2(merchantId);
    }

    public Map<String, Object> indexV3(Integer merchantId, Integer storeId) {
        log.info("IndexV3ServiceImpl # indexV3:{},storeId:{}", (Object)merchantId, (Object)storeId);
        Map map = this.indexV2(merchantId);
        log.info("indexV2\uff1a{}", (Object)JSON.toJSONString((Object)map));
        if (map.containsKey("priceDisplay") && map.get("priceDisplay").equals(2)) {
            ArrayList ids = new ArrayList();
            ((List)map.get("list")).forEach(hotGoods -> ids.add(hotGoods.getGoodsId().longValue()));
            log.info("ids:{}", (Object)JSON.toJSONString(ids));
            List priceStockList = this.storePriceStockService.listByStoreId((long)merchantId.intValue(), (long)storeId.intValue(), ids);
            ((List)map.get("list")).forEach(hotGoods -> {
                hotGoods.setSaleOut(Integer.valueOf(0));
                priceStockList.forEach(storePriceStock -> {
                    if (hotGoods.getGoodsId().longValue() == storePriceStock.getGoodsId().longValue()) {
                        hotGoods.setSalePrice(storePriceStock.getStorePrice());
                        hotGoods.setSaleOut(storePriceStock.getStoreStock());
                    }
                });
            });
            log.info("indexV3:{}", (Object)JSON.toJSONString((Object)map));
        }
        log.info("\u5f53\u524d\u7528\u6237\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)map));
        return map;
    }

    public Map<String, Object> goodDetailWrapper(Integer merchantId, Integer goodsId, Integer storeId, String memberCode) {
        Integer[] storeSelfPrice = this.bizvaneProperties.getStoreSelfPrice();
        log.info("IndexV3ServiceImpl # goodDetailWrapper :{}", (Object)JSON.toJSONString((Object)storeSelfPrice));
        if (storeSelfPrice != null && storeSelfPrice.length != 0 && Arrays.asList(storeSelfPrice).contains(merchantId)) {
            return this.goodDetailV3(merchantId, goodsId, storeId, memberCode);
        }
        return this.goodDetail(merchantId, goodsId, memberCode);
    }

    public Map<String, Object> goodDetail(Integer merchantId, Integer goodsId, String memberCode) {
        log.info("IndexV3ServiceImp # goodDetail:{}", (Object)goodsId);
        User user = BizvaneSecurityContext.getUser();
        log.info("goodDetail #  user:{}", (Object)JSON.toJSONString((Object)user));
        InputValidator.checkEmpty((Object)merchantId, (String)"merchantId");
        InputValidator.checkEmpty((Object)goodsId, (String)"goodsId");
        Goods condition = new Goods();
        condition.setMerchantId(merchantId);
        condition.setId(goodsId);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        Goods goods = (Goods)this.goodsService.findOneByCondition((Serializable)condition);
        if (null == goods) {
            throw new MallWechatException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (goods.getLimitation() != 0) {
            Integer boughtCount = this.ordersMapper.selectBoughtCount(merchantId, memberCode, goodsId);
            goods.setRemnantCount(Integer.valueOf(goods.getLimitation() - boughtCount));
        }
        this.handleGoodsService(goods);
        this.addGoodCustomization(goods);
        map.put("goods", goods);
        log.info("\u5546\u54c1\u8be6\u60c5\u9650\u8d2d\u6570\u91cf\uff1a{}", (Object)JSONObject.toJSONString((Object)goods));
        RichText byId = this.richTextService.findById(goods.getIntroId());
        map.put("richText", byId);
        List list = this.goodsService.getGoodsGiftsByGoodsId(goodsId);
        ArrayList resultList = new ArrayList();
        if (list.size() > 0) {
            resultList.add(list.get(0));
        }
        map.put("goodsGiftsList", resultList);
        List list1 = this.goodsService.getGoodsActivityByGoodsId(goodsId);
        map.put("goodsActivityList", list1);
        List list3 = this.goodsService.getGoodsSkus(goodsId);
        list3.forEach(g -> g.setStock(Integer.valueOf(g.getIsEnabled() != false ? g.getStock() : 0)));
        map.put("goodsSkus", list3);
        log.info("map[1]:{}", (Object)JSON.toJSONString(map));
        if (!goods.getIsUniform().booleanValue()) {
            List list2 = this.goodsService.getGoodsSpecs(goodsId);
            log.info("list2:{}", (Object)JSON.toJSONString((Object)list2));
            List flatSkuIds = list3.stream().map(e -> {
                if (!StringUtils.isEmpty((Object)e.getSpecIds())) {
                    Stream<Integer> stream = Arrays.stream(e.getSpecIds().split(",")).map(f -> Integer.parseInt(f));
                    return stream;
                }
                throw new MallWechatException("\u5546\u54c1:" + e.getGoodsName() + "\u89c4\u683c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }).flatMap(e -> e).distinct().collect(Collectors.toList());
            List collect = list2.stream().filter(e -> flatSkuIds.contains(e.getSpecId()) || e.getPid().equals(0)).collect(Collectors.toList());
            map.put("goodsSpecs", collect);
        }
        Collect collect = new Collect();
        collect.setMerchantId(merchantId);
        collect.setWechatOpenid(user.getOpenid());
        collect.setFavoriteId(goodsId.toString());
        log.info("\u67e5\u8be2collect\u7684\u5165\u53c2:[{}]", JSON.toJSON((Object)collect));
        map.put("isFavorite", this.collectService.isCollected(collect));
        Config config = this.configService.findSysConfig(merchantId);
        HashMap<String, Boolean> configMap = new HashMap<String, Boolean>();
        configMap.put("balanceDeduction", config.getBalanceDeduction());
        configMap.put("integralDeduction", config.getIntegralDeduction());
        map.put("config", configMap);
        if (config != null && config.getPriceDisplay().equals(1)) {
            UserDiscountDTO userDiscountDTO;
            try {
                userDiscountDTO = this.userService.getUserDiscountInfo(user);
            }
            catch (Exception e2) {
                userDiscountDTO = new UserDiscountDTO();
                userDiscountDTO.setDiscount(BigDecimal.ONE);
            }
            BigDecimal discount = userDiscountDTO.getDiscount();
            Goods goods1 = (Goods)map.get("goods");
            goods1.setVipPrice(goods1.getSalePrice().multiply(discount).setScale(2, 4));
            List goodsSkus = (List)map.get("goodsSkus");
            goodsSkus.forEach(goodsSkuDetail -> goodsSkuDetail.setVipPrice(goodsSkuDetail.getSalesPrice().multiply(discount).setScale(2, 4)));
        }
        log.info("\u6839\u636e\u5546\u54c1id\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u3002\u3002\u3002END\u3002\u3002\u3002===\u8fd4\u56de\u7ed3\u679c\u4e3a:{}", map);
        map.put("sysConfig", config);
        GoodsMarketActivityVO goodsMarketActivityVO = this.marketActivitySecKillService.queryMarketActivityByGoodsId(merchantId, goodsId);
        map.put("secKill", goodsMarketActivityVO);
        return map;
    }

    private void addGoodCustomization(Goods goods) {
        log.info("addGoodCustomization");
        CategoryListByGoodIdSearchRequestVO searchRequestVO = new CategoryListByGoodIdSearchRequestVO();
        searchRequestVO.setGoodId(goods.getId());
        List customizationCategoryPOS = this.customizationByDesignerPOMapper.searchCategoryListByGoodId(searchRequestVO);
        log.info("customizationCategoryPOS_pos:{}", (Object)JSON.toJSONString((Object)customizationCategoryPOS));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customizationCategoryPOS)) {
            ArrayList<Integer> customizationRelationIds = new ArrayList<Integer>();
            ArrayList<CustomizationCategoryGoodRelationResponseVO> customizationCategoryGoodRelationResponseVOS = new ArrayList<CustomizationCategoryGoodRelationResponseVO>();
            for (CustomizationCategoryPO categoryPo : customizationCategoryPOS) {
                CustomizationCategoryPO customizationCategoryPO = this.customizationCategoryPOMapper.selectByPrimaryKey(categoryPo.getCustomizationCategoryId());
                log.info("customizationCategoryPO:{}", (Object)JSON.toJSONString((Object)customizationCategoryPO));
                if (!customizationRelationIds.contains(categoryPo.getCustomizationRelationId())) {
                    CustomizationCategoryGoodRelationResponseVO categoryGoodRelationResponseVO = new CustomizationCategoryGoodRelationResponseVO();
                    customizationRelationIds.add(categoryPo.getCustomizationRelationId());
                    CustomizationRelationPO customizationRelationPO = this.customizationRelationPOMapper.selectByPrimaryKey(categoryPo.getCustomizationRelationId());
                    CustomizationPO customizationPO = this.customizationByDesignerPOMapper.selectByPrimaryKey(customizationRelationPO.getCustomizationId());
                    log.info("customizationRelationPO:{},customizationPO:{}", (Object)JSON.toJSONString((Object)customizationRelationPO), (Object)JSON.toJSONString((Object)customizationPO));
                    categoryGoodRelationResponseVO.setCustomizationRelationId(categoryPo.getCustomizationRelationId());
                    categoryGoodRelationResponseVO.setCustomizationId(customizationRelationPO.getCustomizationId());
                    categoryGoodRelationResponseVO.setCustomizationName(customizationPO.getCustomizationName());
                    ArrayList<CustomizationCategoryPO> categoryPOList = new ArrayList<CustomizationCategoryPO>();
                    categoryPOList.add(customizationCategoryPO);
                    categoryGoodRelationResponseVO.setCustomizationCategories(categoryPOList);
                    customizationCategoryGoodRelationResponseVOS.add(categoryGoodRelationResponseVO);
                    continue;
                }
                for (CustomizationCategoryGoodRelationResponseVO goodRelationResponseVO : customizationCategoryGoodRelationResponseVOS) {
                    if (!goodRelationResponseVO.getCustomizationRelationId().equals(categoryPo.getCustomizationRelationId())) continue;
                    goodRelationResponseVO.getCustomizationCategories().add(customizationCategoryPO);
                }
            }
            goods.setCustomizationCategoryGoodRelations(customizationCategoryGoodRelationResponseVOS);
        }
    }

    public Map<String, Object> goodDetailV3(Integer merchantId, Integer goodsId, Integer storeId, String memberCode) {
        log.info("IndexV3ServiceImp # goodDetailV3:{}", (Object)goodsId);
        Map detail = this.goodDetail(merchantId, goodsId, memberCode);
        Config config = (Config)detail.get("sysConfig");
        if (config != null && config.getPriceDisplay() != null && config.getPriceDisplay().equals(2)) {
            Goods goods = (Goods)detail.get("goods");
            goods.setMarketPriceDisplay(config.getMarketPriceDisplay());
            this.handleGoodsService(goods);
            List skuList = (List)detail.get("goodsSkus");
            Integer goodId = goods.getId();
            Integer boughtCount = this.ordersMapper.selectBoughtCount(merchantId, memberCode, goodsId);
            goods.setRemnantCount(Integer.valueOf(goods.getLimitation() - boughtCount));
            log.info("goods_id:" + goodId + "    store_id:" + storeId);
            log.info("\u5546\u54c1\u8be6\u60c5\u9650\u8d2d\u6570\u91cf\uff1a{}", (Object)JSONObject.toJSONString((Object)goods));
            List priceStockList = this.storePriceStockService.listByGoodId(goodId, storeId);
            AtomicInteger goodsStock = new AtomicInteger();
            skuList.forEach(skuDetail -> skuDetail.setStock(Integer.valueOf(0)));
            goods.setStock(Integer.valueOf(0));
            goods.setSaleOut(Integer.valueOf(0));
            priceStockList.forEach(storePriceStock -> {
                goodsStock.addAndGet(storePriceStock.getStoreStock());
                skuList.forEach(sku -> {
                    if (sku.getId().longValue() == storePriceStock.getSkuId().longValue()) {
                        sku.setStock(storePriceStock.getStoreStock());
                        sku.setSalesPrice(storePriceStock.getStorePrice());
                    }
                });
            });
            if (skuList.size() > 0) {
                goods.setSalePrice(((GoodsSkuDetail)skuList.get(0)).getSalesPrice());
            }
            goods.setStock(Integer.valueOf(goodsStock.get()));
            goods.setSaleOut(Integer.valueOf(goodsStock.get()));
        }
        detail.remove("sysConfig");
        return detail;
    }

    private void handleGoodsService(Goods goods) {
        GoodsServiceDescRelationPOExample goodsServiceDescRelationPOExample = new GoodsServiceDescRelationPOExample();
        goodsServiceDescRelationPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andGoodsIdEqualTo(goods.getId()).andMerchantIdEqualTo(goods.getMerchantId());
        List goodsServiceDescRelationPOList = this.goodsServiceDescRelationPOMapper.selectByExample(goodsServiceDescRelationPOExample);
        if (!CollectionUtils.isEmpty((Collection)goodsServiceDescRelationPOList)) {
            ArrayList goodsServiceDescPOList = new ArrayList();
            goodsServiceDescRelationPOList.stream().forEach(e -> {
                GoodsServiceDescPO goodsServiceDescPO = new GoodsServiceDescPO();
                goodsServiceDescPO.setGoodsServiceName(e.getGoodsServiceName());
                goodsServiceDescPO.setId(e.getGoodsServiceDescId());
                goodsServiceDescPO.setGoodsServiceDesc(e.getGoodsServiceDesc());
                goodsServiceDescPOList.add(goodsServiceDescPO);
            });
            goods.setGoodsServiceDescPOList(goodsServiceDescPOList);
        }
    }

    @Deprecated
    public <T extends Goods> T replaceGoods(T goods, int storeId, int merchantId) {
        return goods;
    }

    public PageInfo<Goods> classifyIndex(GoodsQueryDTO goodsQueryDTO, Integer merchantId, Integer storeId) {
        log.info("IndexV3ServiceImpl#classifyIndex goodsQueryDTO:{},merchantId:{},storeId:{}", new Object[]{goodsQueryDTO, merchantId, storeId});
        User user = (User)SecurityContext.getUser();
        goodsQueryDTO.setMerchantId(merchantId);
        if (goodsQueryDTO.getClassifyId() != null) {
            goodsQueryDTO.setIsShow(Integer.valueOf(1));
        }
        Config config = this.configService.findSysConfig(merchantId);
        log.info("IndexV3ServiceImpl#classifyIndex config:{}", (Object)config);
        if (config == null || config.getPriceDisplay() == null || config.getPriceDisplay() < 2) {
            log.info("config == null || config.getPriceDisplay() == null || config.getPriceDisplay() < 2");
            PageHelper.startPage((int)goodsQueryDTO.getPageIndex(), (int)goodsQueryDTO.getPageSize());
            List list = this.goodsService.findByCondition((Object)goodsQueryDTO);
            if (!CollectionUtils.isEmpty((Collection)list) && !StringUtils.isEmpty((Object)user.getUnionid())) {
                log.info("!CollectionUtils.isEmpty(list) && !StringUtils.isEmpty(user.getUnionid())");
                if (config != null && user != null && config.getPriceDisplay().equals(1)) {
                    log.info("config != null && user != null && config.getPriceDisplay().equals(1)");
                    UserDiscountDTO userDiscountDTO = this.userService.getUserDiscountInfo(user);
                    if (userDiscountDTO != null && userDiscountDTO.getDiscount() != null) {
                        log.info("userDiscountDTO != null && userDiscountDTO.getDiscount() != null");
                        list.forEach(hotGoods -> hotGoods.setVipPrice(hotGoods.getSalePrice().multiply(userDiscountDTO.getDiscount()).setScale(2, 4)));
                    }
                }
            }
            return new PageInfo(list);
        }
        if (config != null && config.getPriceDisplay().equals(2)) {
            log.info("config != null && config.getPriceDisplay().equals(2)");
            PageHelper.startPage((int)goodsQueryDTO.getPageIndex(), (int)goodsQueryDTO.getPageSize());
            List list = this.goodsService.findByConditionV1((Object)goodsQueryDTO);
            if (CollectionUtils.isEmpty((Collection)list)) {
                log.info("CollectionUtils.isEmpty(list)");
                return new PageInfo(new ArrayList());
            }
            ArrayList ids = new ArrayList();
            list.forEach(hotGoods -> ids.add(hotGoods.getId().longValue()));
            List priceStockList = this.storePriceStockService.listByStoreId((long)merchantId.intValue(), (long)storeId.intValue(), ids);
            list.forEach(hotGoods -> {
                hotGoods.setSaleOut(Integer.valueOf(0));
                priceStockList.forEach(storePriceStock -> {
                    if (hotGoods.getId().longValue() == storePriceStock.getGoodsId().longValue()) {
                        log.info("hotGoods.getId().longValue() == storePriceStock.getGoodsId().longValue()");
                        hotGoods.setSalePrice(storePriceStock.getStorePrice());
                        hotGoods.setSaleOut(storePriceStock.getStoreStock());
                    }
                });
            });
            return new PageInfo(list);
        }
        return new PageInfo(new ArrayList());
    }
}

