/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mzlion.core.lang.CollectionUtils;
import com.wmeimob.fastboot.bizvane.dto.GoodsQueryDTO;
import com.wmeimob.fastboot.bizvane.entity.Activity;
import com.wmeimob.fastboot.bizvane.entity.Comments;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsGiftRelation;
import com.wmeimob.fastboot.bizvane.entity.GoodsPropValueCustom;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpecRelation;
import com.wmeimob.fastboot.bizvane.mapper.ActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.CommentsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsPropHeadCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecRelationMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsGroupRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.po.GoodsGroupRelationPO;
import com.wmeimob.fastboot.bizvane.po.GoodsGroupRelationPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPOExample;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.vo.GuessGoodsVO;
import com.wmeimob.fastboot.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@Primary
public class GoodsServiceImpl
implements GoodsService {
    private static final Logger log = LoggerFactory.getLogger(GoodsServiceImpl.class);
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsPropHeadCustomMapper goodsPropHeadCustomMapper;
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private GoodsSpecRelationMapper goodsSpecRelationMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private CommentsMapper commentsMapper;
    @Autowired
    private GoodsClassifyCustomMapper goodsClassifyCustomMapper;
    @Autowired
    private GoodsClassifyMapper goodsClassifyMapper;
    @Resource
    private GoodsGroupRelationPOMapper goodsGroupRelationPOMapper;
    @Resource
    private GoodsPOMapper goodsPOMapper;

    public List<Goods> findByCondition(Object condition) {
        GoodsQueryDTO goodsQueryDTO = (GoodsQueryDTO)condition;
        log.info("GoodsServiceImpl#findByCondition goodsQueryDTO:{}", (Object)JSON.toJSONString((Object)goodsQueryDTO));
        List goods = this.goodsMapper.selectGoodsListByClassifyId(goodsQueryDTO);
        log.info("GoodsServiceImpl#findByCondition goods:{}", (Object)JSONObject.toJSONString((Object)goods));
        for (Goods egoods : goods) {
            List goodsSkuDetailList = this.goodsSkuDetailMapper.selectPartSku(egoods.getId());
            egoods.setGoodsSkuDetailList(goodsSkuDetailList);
        }
        ArrayList goodsIdByClassifyId = new ArrayList();
        List classifyIdsByCId = new ArrayList();
        ArrayList Ids = new ArrayList();
        List classifyIdsByCName = new ArrayList();
        ArrayList GoodsIds = new ArrayList();
        if (((GoodsQueryDTO)condition).getClassifyId() != null) {
            goodsIdByClassifyId.addAll(this.goodsClassifyCustomMapper.selectGoodsIdByClassifyId(((GoodsQueryDTO)condition).getClassifyId()));
        }
        log.info("\u5546\u54c1id{}:", (Object)JSONObject.toJSONString(goodsIdByClassifyId));
        if (((GoodsQueryDTO)condition).getFirstClassifyId() != null) {
            classifyIdsByCId = this.goodsClassifyMapper.selectIdByPidNMerchant(((GoodsQueryDTO)condition).getMerchantId(), ((GoodsQueryDTO)condition).getFirstClassifyId());
            for (Integer classId : classifyIdsByCId) {
                Ids.addAll(this.goodsClassifyCustomMapper.selectGoodsIdByClassifyId(classId));
            }
        }
        log.info("Ids:{},", (Object)JSONObject.toJSONString(Ids));
        if (((GoodsQueryDTO)condition).getFirstClassifyName() != null) {
            classifyIdsByCName = this.goodsClassifyMapper.selectIdByCName(goodsQueryDTO);
            for (Integer classId : classifyIdsByCName) {
                GoodsIds.addAll(this.goodsClassifyCustomMapper.selectGoodsIdByClassifyId(classId));
            }
        }
        log.info("GoodsIds:{}", (Object)JSONObject.toJSONString(GoodsIds));
        Iterator car = goods.iterator();
        while (car.hasNext()) {
            Goods goods1 = (Goods)car.next();
            if (!goodsIdByClassifyId.contains(goods1.getId()) && !goodsIdByClassifyId.isEmpty()) {
                car.remove();
                continue;
            }
            if (!Ids.contains(goods1.getId()) && !Ids.isEmpty()) {
                car.remove();
                continue;
            }
            if (!GoodsIds.contains(goods1.getId()) && !GoodsIds.isEmpty()) {
                car.remove();
                continue;
            }
            List goodsSkuDetailList = goods1.getGoodsSkuDetailList();
            Integer skuStock = 0;
            Integer customStart = 0;
            for (GoodsSkuDetail sku : goodsSkuDetailList) {
                skuStock = skuStock + sku.getStock();
                customStart = customStart + sku.getCustomStartSales();
            }
            goods1.setSaleOut(Integer.valueOf(skuStock <= 0 ? 1 : 0));
            goods1.setSumSalesAmount(Integer.valueOf(customStart + goods1.getCustomStartSales() + goods1.getActualSales()));
            log.info("\u5f53\u524dmerchatId:{},GoodsNo:{},id:{}", new Object[]{((GoodsQueryDTO)condition).getMerchantId(), goods1.getGoodsNo(), goods1.getId()});
            if (((GoodsSkuDetail)goods1.getGoodsSkuDetailList().get(0)).getSalesPrice().compareTo(BigDecimal.ZERO) < 0 && !goods1.getGoodsSkuDetailList().isEmpty()) {
                car.remove();
                continue;
            }
            if (((GoodsSkuDetail)goods1.getGoodsSkuDetailList().get(0)).getSalesPrice().compareTo(BigDecimal.ZERO) >= 0 && !goods1.getGoodsSkuDetailList().isEmpty()) {
                goods1.setSalePrice(((GoodsSkuDetail)goods1.getGoodsSkuDetailList().get(0)).getSalesPrice());
            }
            goods1.setMarketPrice(((GoodsSkuDetail)goods1.getGoodsSkuDetailList().get(0)).getMarketPrice());
        }
        log.info("\u7b2c\u4e8c\u7248\u67e5\u8be2Goods\u5217\u88682:{}", (Object)JSONObject.toJSONString((Object)goods));
        return goods;
    }

    public List<Goods> findByConditionV1(Object condition) {
        GoodsQueryDTO goodsQueryDTO = (GoodsQueryDTO)condition;
        return this.goodsMapper.selectGoodsListByClassifyIdV1(goodsQueryDTO);
    }

    public Goods findOneByCondition(Goods condition) {
        return this.goodsMapper.selectGoodsById(condition);
    }

    public List<GoodsPropValueCustom> getGoodsPropsByGoodsId(Integer goodsId) {
        return this.goodsPropHeadCustomMapper.selectGoodsPropsByGoodsId(goodsId);
    }

    public List<GoodsGiftRelation> getGoodsGiftsByGoodsId(Integer goodsId) {
        return this.goodsMapper.selectGoodsGiftsByGoodsId(goodsId);
    }

    public List<Activity> getGoodsActivityByGoodsId(Integer goodsId) {
        return this.activityMapper.selectGoodsActivityByGoodsId(goodsId);
    }

    public List<GoodsSpecRelation> getGoodsSpecs(Integer goodsId) {
        return this.goodsSpecRelationMapper.selectGoodsSpecs(goodsId);
    }

    public List<GoodsSkuDetail> getGoodsSkus(Integer goodsId) {
        GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
        goodsSkuDetail.setGoodsId(goodsId);
        goodsSkuDetail.setIsDel(Boolean.FALSE);
        goodsSkuDetail.setIsEnabled(Boolean.valueOf(true));
        return this.goodsSkuDetailMapper.select((Object)goodsSkuDetail);
    }

    public List<Comments> getGoodsEvaluate(Integer goodsId) {
        return this.commentsMapper.selectGoodsEvaluate(goodsId);
    }

    public Goods findById(Integer id) {
        return (Goods)this.goodsMapper.selectByPrimaryKey((Object)id);
    }

    public List<Goods> findByCondition(Goods condition) {
        List goodsSkuList = condition.getGoodsSkuList();
        ArrayList<Goods> includedGoods = new ArrayList<Goods>();
        goodsSkuList.forEach(sku -> {
            condition.setSkuNo(sku);
            includedGoods.add(this.goodsMapper.selectBySkunoAndMerchantId(condition));
        });
        return includedGoods;
    }

    public List<Goods> findByConditionWithGoodsId(Goods condition) {
        Example example = new Example(Goods.class);
        Example.Criteria criteria = example.createCriteria();
        if (condition.getIdList() != null && !condition.getIdList().isEmpty()) {
            criteria.andIn("id", (Iterable)condition.getIdList());
        }
        criteria.andEqualTo("merchantId", (Object)condition.getMerchantId()).andLike("goodsName", StringUtils.fullFuzzy((String)condition.getGoodsName())).andEqualTo("isDel", (Object)false).andEqualTo("isShelved", (Object)condition.getIsShelved());
        return this.goodsMapper.selectByExample((Object)example);
    }

    public ResponseData findByGroudId(Integer merchantId, Integer groudId, Integer page, Integer pageSize, Boolean pageJudge) {
        if (pageJudge.booleanValue()) {
            PageHelper.startPage((int)page, (int)pageSize);
            List goodsPOList = this.goodsPOMapper.findByGroudId(merchantId, groudId);
            PageInfo pageInfo = new PageInfo(goodsPOList);
            log.info("\u67e5\u8be2\u51fa\u7684\u5206\u7ec4\u5546\u54c1\u5217\u8868\uff1a" + JSON.toJSON((Object)pageInfo));
            return new ResponseData((Object)pageInfo);
        }
        List goodsPOList = this.goodsPOMapper.findByGroudId(merchantId, groudId);
        return new ResponseData((Object)goodsPOList);
    }

    public PageInfo guessGoods(Integer merchantId, GuessGoodsVO guessGoodsVO) {
        if (CollectionUtils.isNotEmpty((Collection)guessGoodsVO.getGroudId())) {
            GoodsGroupRelationPOExample goodsGroupRelationPOExample = new GoodsGroupRelationPOExample();
            GoodsGroupRelationPOExample.Criteria criteria = goodsGroupRelationPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.valueOf(true)).andGoodsGroupIdIn(guessGoodsVO.getGroudId());
            List goodsGroupRelationPOList = this.goodsGroupRelationPOMapper.selectByExample(goodsGroupRelationPOExample);
            log.info("\u8be5\u5206\u7ec4\u4e0b\u7684\u5176\u4ed6\u5546\u54c1{}", JSON.toJSON((Object)goodsGroupRelationPOList));
            if (CollectionUtils.isNotEmpty((Collection)goodsGroupRelationPOList)) {
                List goodsIds = goodsGroupRelationPOList.stream().map(GoodsGroupRelationPO::getGoodsId).collect(Collectors.toList());
                GoodsPOExample goodsPOExample = new GoodsPOExample();
                GoodsPOExample.Criteria criteria1 = goodsPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.valueOf(true)).andIsDelEqualTo(Boolean.FALSE).andIdIn(goodsIds);
                PageHelper.startPage((int)guessGoodsVO.getPage(), (int)guessGoodsVO.getPageSize());
                List goodsPOS = this.goodsPOMapper.selectByExample(goodsPOExample);
                PageInfo pageInfo = new PageInfo(goodsPOS);
                log.info("GoodsServiceImpl_guessGoods{}", JSON.toJSON((Object)pageInfo));
                return pageInfo;
            }
        }
        return null;
    }

    public void incrementSales(List<Goods> collect) {
        this.goodsMapper.incrementSales(collect);
    }

    public GoodsPO findByNo(Integer merchantId, String goodsNo) {
        GoodsPOExample goodsPOExample = new GoodsPOExample();
        goodsPOExample.createCriteria().andMerchantIdEqualTo(merchantId).andGoodsNoEqualTo(goodsNo).andIsDelEqualTo(Boolean.FALSE).andValidEqualTo(Boolean.TRUE).andIsShelvedEqualTo(Boolean.TRUE);
        List goodsPOS = this.goodsPOMapper.selectByExample(goodsPOExample);
        if (CollectionUtils.isEmpty((Collection)goodsPOS)) {
            return null;
        }
        return (GoodsPO)goodsPOS.get(0);
    }
}

