/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.dto.FreightCalcDTO;
import com.wmeimob.fastboot.bizvane.entity.ExpressTemplate;
import com.wmeimob.fastboot.bizvane.entity.ExpressTemplateArea;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.enums.CalcTemplateWay;
import com.wmeimob.fastboot.bizvane.mapper.ExpressTemplateAreaMapper;
import com.wmeimob.fastboot.bizvane.mapper.ExpressTemplateMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.service.ExpressService;
import com.wmeimob.fastboot.util.InputValidator;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ExpressServiceImpl
implements ExpressService {
    private static final Logger log = LoggerFactory.getLogger(ExpressServiceImpl.class);
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private ExpressTemplateMapper expressTemplateMapper;
    @Resource
    private ExpressTemplateAreaMapper expressTemplateAreaMapper;
    @Resource
    private GoodsSkuDetailMapper goodsSkuDetailMapper;

    public static void main(String[] args) {
        BigDecimal expressFee = new BigDecimal("0.00");
        BigDecimal numberOfPackage = new BigDecimal("1.000");
        ExpressTemplateArea expressTemplateArea = new ExpressTemplateArea();
        expressTemplateArea.setStart(new BigDecimal(0));
        expressTemplateArea.setPostage(new BigDecimal(0));
        expressTemplateArea.setPlus(new BigDecimal(0));
        expressTemplateArea.setPostageplus(new BigDecimal(0));
        ExpressServiceImpl expressService = new ExpressServiceImpl();
        System.out.println(expressService.getBigDecimal(expressFee, numberOfPackage, expressTemplateArea));
    }

    private void checkParams(FreightCalcDTO param) {
        try {
            InputValidator.checkEmpty((Object)param.getProvince(), (String)"\u7701\u4efd");
            InputValidator.checkEmpty((Object)param.getCity(), (String)"\u57ce\u5e02");
            InputValidator.checkEmpty((Object)param.getArea(), (String)"\u5730\u533a");
            InputValidator.checkNull((Object)param.getMsg(), (String)"\u5546\u54c1\u5217\u8868");
            for (FreightCalcDTO.Msg msg : param.getMsg()) {
                InputValidator.checkNull((Object)msg, (String)"\u5546\u54c1\u4fe1\u606f");
                InputValidator.checkNull((Object)msg.getGoodsId(), (String)"\u5546\u54c1ID");
                InputValidator.checkEmpty((Object)msg.getSkuNo(), (String)"SKU\u4fe1\u606f");
            }
        }
        catch (Exception e) {
            throw new MallWechatException((Throwable)e);
        }
    }

    public BigDecimal calcTemplate(FreightCalcDTO param) {
        log.info("calcTemplate\u5165\u53c2:{}", JSON.toJSON((Object)param));
        this.checkParams(param);
        BigDecimal expressFee = new BigDecimal("0.00");
        HashSet<Integer> expressTemplateIds = new HashSet<Integer>();
        List list = param.getMsg();
        HashMap<Integer, Goods> goodsMap = new HashMap<Integer, Goods>();
        for (FreightCalcDTO.Msg msg : list) {
            Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)msg.getGoodsId());
            expressTemplateIds.add(goods.getExpressTemplateId());
            goodsMap.put(goods.getId(), goods);
        }
        for (Integer expressTemplateId : expressTemplateIds) {
            BigDecimal numberOfPackage = new BigDecimal("0");
            BigDecimal weight = new BigDecimal("0.000");
            BigDecimal volume = new BigDecimal("0.000");
            ExpressTemplate expressTemplate = null;
            for (FreightCalcDTO.Msg msg : list) {
                Goods goods = (Goods)goodsMap.get(msg.getGoodsId());
                log.info("\u5546\u54c1\u90ae\u8d39\u7684\u5546\u54c1\u6570\u636e:{}", (Object)goods);
                if (!expressTemplateId.equals(goods.getExpressTemplateId())) continue;
                expressTemplate = (ExpressTemplate)this.expressTemplateMapper.selectByPrimaryKey((Object)goods.getExpressTemplateId());
                try {
                    Assert.notNull((Object)expressTemplate, (String)"\u60a8\u65e0\u6cd5\u8d2d\u4e70\u8be5\u5546\u54c1\uff0c\u56e0\u4e3a\u5546\u5bb6\u5bf9\u8be5\u5546\u54c1\u7684\u8fd0\u8d39\u6a21\u677f\u8bbe\u7f6e\u6709\u8bef");
                }
                catch (Exception e) {
                    throw new MallWechatException(e.getMessage());
                }
                if (CalcTemplateWay.SELLER.getValue() == expressTemplate.getFreight().byteValue()) break;
                GoodsSkuDetail goodsSkuDetail = this.goodsSkuDetailMapper.findByGoodsIdAndSkuNo(msg.getGoodsId(), msg.getSkuNo());
                Assert.notNull((Object)goodsSkuDetail, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
                if (CalcTemplateWay.WEIGHT.getValue() == expressTemplate.getValuation().byteValue()) {
                    weight = weight.add(goodsSkuDetail.getWeight().multiply(new BigDecimal(msg.getNum())));
                }
                if (CalcTemplateWay.NUMBER_OF_PACKAGES.getValue() == expressTemplate.getValuation().byteValue()) {
                    numberOfPackage = numberOfPackage.add(this.getBigDecimal((Object)msg.getNum()));
                }
                if (CalcTemplateWay.VOLUME.getValue() != expressTemplate.getValuation().byteValue()) continue;
                volume = volume.add(goodsSkuDetail.getVolume().multiply(new BigDecimal(msg.getNum())));
            }
            Assert.notNull(expressTemplate, (String)"\u672a\u627e\u5230\u5408\u9002\u7684\u8fd0\u8d39\u6a21\u677f");
            log.info("\u6a21\u677fexpressTemplate\u7684\u7ed3\u679c:{}\uff0c\u7701:{}\uff0c\u5e02:{}\uff0c\u533a:{}", new Object[]{JSON.toJSON(expressTemplate), param.getProvince(), param.getCity(), param.getArea()});
            List expressTemplateArea = this.expressTemplateAreaMapper.selectListByTemplateAndAddress(expressTemplate.getId(), param.getProvince(), param.getCity());
            ExpressTemplateArea expressTemplateAreaResult = CollectionUtils.isEmpty((Collection)expressTemplateArea) ? this.expressTemplateAreaMapper.selectCommonTemplate(expressTemplate.getId()) : (ExpressTemplateArea)expressTemplateArea.get(0);
            Assert.notNull((Object)expressTemplateAreaResult, (String)"\u6ca1\u6709\u627e\u5230\u8fd0\u8d39\u6a21\u677f");
            if (CalcTemplateWay.NUMBER_OF_PACKAGES.getValue() == expressTemplate.getValuation().byteValue()) {
                log.info("\u4ef6\u6570\u8ba1\u7b97 \u4ef6\u6570:{}", (Object)numberOfPackage);
                expressFee = this.getBigDecimal(expressFee, numberOfPackage, expressTemplateAreaResult);
                continue;
            }
            if (CalcTemplateWay.WEIGHT.getValue() == expressTemplate.getValuation().byteValue()) {
                log.info("\u91cd\u91cf\u8ba1\u7b97 \u91cd\u91cf:{}", (Object)weight);
                expressFee = this.getBigDecimal(expressFee, weight, expressTemplateAreaResult);
                continue;
            }
            if (CalcTemplateWay.VOLUME.getValue() != expressTemplate.getValuation().byteValue()) continue;
            log.info("\u4f53\u79ef\u8ba1\u7b97 \u4f53\u79ef:{}", (Object)volume);
            expressFee = this.getBigDecimal(expressFee, volume, expressTemplateAreaResult);
        }
        return expressFee;
    }

    private BigDecimal getBigDecimal(BigDecimal expressFee, BigDecimal numberOfPackage, ExpressTemplateArea expressTemplateArea) {
        log.info("get freight params : {},{},{} ", new Object[]{expressFee, numberOfPackage, JSONObject.toJSONString((Object)expressTemplateArea)});
        if (numberOfPackage.compareTo(BigDecimal.ZERO) > 0) {
            if (numberOfPackage.subtract(expressTemplateArea.getStart()).compareTo(BigDecimal.ZERO) > 0) {
                expressFee = expressFee.add(expressTemplateArea.getPostage());
                expressFee = expressFee.add(numberOfPackage.subtract(expressTemplateArea.getStart()).divide(expressTemplateArea.getPlus(), 0, 1).multiply(expressTemplateArea.getPostageplus()));
                if (numberOfPackage.subtract(expressTemplateArea.getStart()).divideAndRemainder(expressTemplateArea.getPlus())[1].compareTo(BigDecimal.ZERO) > 0) {
                    expressFee = expressFee.add(expressTemplateArea.getPostageplus());
                }
            } else if (numberOfPackage.subtract(expressTemplateArea.getStart()).compareTo(BigDecimal.ZERO) <= 0) {
                expressFee = expressFee.add(expressTemplateArea.getPostage());
            }
        }
        return expressFee;
    }

    private BigDecimal getBigDecimal(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal)value;
            } else if (value instanceof String) {
                ret = new BigDecimal(value.toString());
            } else if (value instanceof Integer) {
                ret = new BigDecimal(value.toString());
            } else if (value instanceof Number) {
                ret = BigDecimal.valueOf(((Number)value).doubleValue());
            } else {
                throw new ClassCastException("Not possible to coerce [" + value + "] from class " + value.getClass() + " into a BigDecimal.");
            }
        }
        return ret;
    }
}

