/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.builder.OrdersBuilder;
import com.wmeimob.fastboot.bizvane.dto.SysDimSkuPoDto;
import com.wmeimob.fastboot.bizvane.entity.BargainPlayers;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.OrderActivityTypeEnum;
import com.wmeimob.fastboot.bizvane.mapper.BargainPlayersMapper;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderItemsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.service.AssembleService;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.impl.OffLineInfoHandlerServiceImpl;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.common.entity.RichText;
import com.wmeimob.fastboot.starter.common.service.RichTextService;
import com.wmeimob.fastboot.util.DateUtil;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.RandomCodeUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class CutDownService {
    private static final Logger log = LoggerFactory.getLogger(CutDownService.class);
    @Autowired
    private BargainPlayersMapper bargainPlayersMapper;
    @Autowired
    private MarketActivityMapper marketActivityMapper;
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private MarketActivityOrdersMapper marketActivityOrdersMapper;
    @Autowired
    private OrdersMapper ordersMapper;
    @Resource
    private GoodsService goodsService;
    @Resource
    private GoodsSkuDetailService goodsSkuDetailService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private OrderItemsMapper orderItemsMapper;
    @Resource(name="commonConfigService")
    private ConfigService configService;
    @Resource
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Resource(name="richTextCommonServiceImpl")
    private RichTextService richTextService;
    @Autowired
    private OrdersService ordersService;
    @Autowired
    private OffLineInfoHandlerServiceImpl offLineInfoHandlerServiceImpl;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    private static final String USER_ADD_ORDER_KEY = "user:%s:add_order";
    public static final String REDIS_PRECALULATE_PRICE_ARRAY_KEY = "wx_cut_down_amount_array::";
    public static final String USER_HELP_CUT_KEY = "wx_friend_cut_down::";

    public List<MarketActivityGoods> getActivityGoodList(Integer merchantId) {
        log.info("\u83b7\u53d6\u780d\u4ef7\u6d3b\u52a8\u4e2d\u7684\u5546\u54c1\u5217\u8868");
        ArrayList<MarketActivityGoods> list = new ArrayList<MarketActivityGoods>();
        Example example = new Example(MarketActivity.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("activityType", (Object)"0").andEqualTo("activityStatus", (Object)Boolean.TRUE).andCondition("DATE_FORMAT(NOW(),'%Y-%m-%d %H:%i:%S') BETWEEN DATE_FORMAT(activity_begin_time,'%Y-%m-%d %H:%i:%S') AND DATE_FORMAT(activity_end_time,'%Y-%m-%d %H:%i:%S')");
        List marketActivities = this.marketActivityMapper.selectByExample((Object)example);
        log.info("marketActivities------>:{}", (Object)JSON.toJSONString((Object)marketActivities));
        if (CollectionUtils.isEmpty((Collection)marketActivities)) {
            return null;
        }
        log.info("list------>:{}", (Object)JSON.toJSONString(marketActivities.stream().map(e -> e.getActivityNo()).collect(Collectors.toList())));
        List marketActivityGoods = this.marketActivityGoodsMapper.selectCutDownGoodsList(marketActivities.stream().map(e -> e.getActivityNo()).collect(Collectors.toList()), null);
        marketActivityGoods.forEach(marketActivityGoods1 -> {
            Example goodsExa = new Example(Goods.class);
            Example.Criteria criteria = goodsExa.createCriteria();
            criteria.andEqualTo("goodsNo", (Object)marketActivityGoods1.getGoodsNo()).andEqualTo("isDel", (Object)Boolean.FALSE);
            criteria.andEqualTo("merchantId", (Object)merchantId);
            Goods goods = (Goods)this.goodsMapper.selectOneByExample((Object)goodsExa);
            if (goods != null) {
                marketActivityGoods1.setGoodsPrice(goods.getSalePrice());
                marketActivityGoods1.setGoodsAssembleNum(goods.getAssembleNum());
                marketActivityGoods1.setGoodsName(goods.getGoodsName());
                marketActivityGoods1.setGoodsPicUrl(goods.getCoverImg());
            }
            list.add((MarketActivityGoods)marketActivityGoods1);
        });
        log.info("\u8fd4\u56de\u7684\u780d\u4ef7\u6d3b\u52a8\u4e2d\u7684\u5546\u54c1\u5217\u8868:{}", JSON.toJSON(list));
        return list;
    }

    public List<MarketActivityGoods> getActivityGoodListByMe(String userNo, Integer merchantId) {
        log.info("\u6211\u7684\u780d\u4ef7\u53c2\u6570\u4e3a===>userNo:{},merchantId:{}", (Object)userNo, (Object)merchantId);
        List orders = this.marketActivityOrdersMapper.getReducePriceListByMe(userNo, merchantId);
        this.getMyActivityStatus(orders);
        List magGoodsIds = orders.stream().map(e -> e.getMarketActivityGoodsId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(magGoodsIds)) {
            return null;
        }
        List marketActivityGoods = this.marketActivityGoodsMapper.selectCutDownGoodsList(null, magGoodsIds);
        List<MarketActivityGoods> collect = marketActivityGoods.stream().map(mag -> {
            Example goodsExa = new Example(Goods.class);
            Example.Criteria criteria = goodsExa.createCriteria();
            criteria.andEqualTo("goodsNo", (Object)mag.getGoodsNo()).andEqualTo("isDel", (Object)Boolean.FALSE);
            criteria.andEqualTo("merchantId", (Object)merchantId);
            Goods goods = (Goods)this.goodsMapper.selectOneByExample((Object)goodsExa);
            if (goods != null) {
                mag.setGoodsPrice(goods.getSalePrice());
                mag.setGoodsAssembleNum(goods.getAssembleNum());
                mag.setGoodsName(goods.getGoodsName());
                mag.setGoodsPicUrl(goods.getCoverImg());
            }
            return mag;
        }).collect(Collectors.toList());
        block0: for (MarketActivityGoods mag2 : collect) {
            for (MarketActivityOrders mao : orders) {
                if (!mao.getMarketActivityGoodsId().equals(mag2.getId())) continue;
                mag2.setOrdersStatus(mao.getOrdersStatus());
                mag2.setActivityOrdersId(mao.getId());
                mag2.setMyActivityOrderStatus(mao.getMyActivityOrderStatus());
                mag2.setActivityOrdersId(mao.getId());
                continue block0;
            }
        }
        return collect;
    }

    private void getMyActivityStatus(List<MarketActivityOrders> collect) {
        Date now = new Date();
        log.info("\u5904\u7406\u6211\u7684\u6d3b\u52a8\u72b6\u6001\u5165\u53c2:{}", JSON.toJSON(collect));
        for (MarketActivityOrders mao : collect) {
            long enoughTime = DateUtils.addHours((Date)mao.getGmtCreate(), (int)mao.getActivityTermValidity()).getTime() - now.getTime();
            List goodsFriends = this.getGoodsFriends(mao);
            if ("0".equals(mao.getOrdersStatus())) {
                if (enoughTime >= 0L) {
                    if (!CollectionUtils.isEmpty((Collection)goodsFriends) && goodsFriends.size() == mao.getActivityPersonNum().intValue()) {
                        mao.setMyActivityOrderStatus("2");
                        continue;
                    }
                    mao.setMyActivityOrderStatus("0");
                    continue;
                }
                if (now.after(mao.getActivityEndTime())) {
                    mao.setMyActivityOrderStatus("-1");
                    continue;
                }
                mao.setMyActivityOrderStatus("1");
                continue;
            }
            if ("2".equals(mao.getOrdersStatus())) {
                if (now.after(mao.getActivityEndTime())) {
                    mao.setMyActivityOrderStatus("-1");
                    continue;
                }
                mao.setMyActivityOrderStatus("1");
                continue;
            }
            if (!"1".equals(mao.getOrdersStatus())) continue;
            mao.setMyActivityOrderStatus("-1");
        }
    }

    private BigDecimal calCutAmount(List<BargainPlayers> friendsHelps) {
        return friendsHelps.stream().map(e -> e.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public Map getGoodsDetail(MarketActivityGoods marketActivityGoods) {
        log.info("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u5165\u53c2:{}", JSON.toJSON((Object)marketActivityGoods));
        Goods condition = new Goods();
        condition.setMerchantId(marketActivityGoods.getMerchantId());
        condition.setId(marketActivityGoods.getGoodsId());
        Goods goods = (Goods)this.goodsService.findOneByCondition((Serializable)condition);
        log.info("CutDownService_getGoodsDetail:{}", (Object)JSON.toJSONString((Object)goods));
        Integer goodsId = goods.getId();
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        Example activityGoodsCondition = new Example(MarketActivityGoods.class);
        activityGoodsCondition.createCriteria().andEqualTo("goodsNo", (Object)marketActivityGoods.getGoodsNo()).andEqualTo("marketActivityNo", (Object)marketActivityGoods.getMarketActivityNo());
        if (Objects.isNull(goods)) {
            throw new CustomException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        map.put("goods", goods);
        List tempMag = this.marketActivityGoodsMapper.selectByExample((Object)activityGoodsCondition);
        if (CollectionUtils.isEmpty((Collection)tempMag)) {
            throw new CustomException("\u780d\u4ef7\u6d3b\u52a8\u4e2d\u672a\u627e\u5230\u8be5\u5546\u54c1");
        }
        MarketActivityGoods mag = tempMag.stream().min(Comparator.comparing(MarketActivityGoods::getAmount)).get();
        RichText byId = this.richTextService.findById(goods.getIntroId());
        map.put("richText", byId);
        List goodsSkus = this.goodsService.getGoodsSkus(goodsId);
        goodsSkus.forEach(g -> g.setStock(Integer.valueOf(g.getIsEnabled() != false ? g.getStock() : 0)));
        map.put("goodsSkus", goodsSkus);
        if (!goods.getIsUniform().booleanValue()) {
            List goodsSpecRelations = this.goodsService.getGoodsSpecs(goodsId);
            map.put("goodsSpecs", goodsSpecRelations);
        }
        MarketActivity ma = new MarketActivity();
        ma.setActivityNo(marketActivityGoods.getMarketActivityNo());
        ma = (MarketActivity)this.marketActivityMapper.selectOne((Object)ma);
        map.put("reduceRule", ma.getActivityDetail());
        if (marketActivityGoods.getActivityOrdersId() == null) {
            map.put("alreadInActivity", 0);
        } else {
            MarketActivityOrders alreadInActivity = (MarketActivityOrders)this.marketActivityOrdersMapper.selectByPrimaryKey((Object)marketActivityGoods.getActivityOrdersId());
            map.put("alreadInActivity", 1);
            Long leftTime = this.calLeftTime(alreadInActivity);
            map.put("leafTime", leftTime);
            BigDecimal alreadyCut = this.calCutAmount(this.getGoodsFriends(alreadInActivity));
            map.put("alreadyCut", alreadyCut);
            MarketActivityGoods alreadyGoods = (MarketActivityGoods)this.marketActivityGoodsMapper.selectByPrimaryKey((Object)alreadInActivity.getMarketActivityGoodsId());
            alreadyGoods.setSkuNo(alreadInActivity.getGoodsSkuNo());
            ArrayList<MarketActivityGoods> list = new ArrayList<MarketActivityGoods>();
            alreadInActivity.setMarketActivityGoods(list);
            list.add(alreadyGoods);
            map.put("mao", alreadInActivity);
            mag.setSkuNo(alreadInActivity.getGoodsSkuNo());
        }
        map.put("marketActivityGoods", mag);
        map.put("marketActivityOrdersId", marketActivityGoods.getActivityOrdersId());
        return map;
    }

    private Long calLeftTime(MarketActivityOrders alreadInActivity) {
        MarketActivity ma = new MarketActivity();
        ma.setActivityNo(alreadInActivity.getActivityNo());
        ma = (MarketActivity)this.marketActivityMapper.selectOne((Object)ma);
        return DateUtils.addHours((Date)alreadInActivity.getGmtCreate(), (int)ma.getActivityTermValidity()).getTime() - new Date().getTime();
    }

    private List<BargainPlayers> getGoodsFriends(MarketActivityOrders alreadInActivity) {
        BargainPlayers bp = new BargainPlayers();
        bp.setActivityOrdersNo(alreadInActivity.getActivityOrdersNo());
        return this.bargainPlayersMapper.select((Object)bp);
    }

    public Orders confirm(Orders orders) {
        MarketActivityOrders marketActivityOrders;
        List goodsFriends;
        AssembleService.checkUserInfo((Orders)orders);
        AssembleService.checkGoodsItem((List)orders.getItems());
        AssembleService.checkActivityNo((String)orders.getActivityNo());
        orders.getItems().forEach(od -> od.setMerchantId(orders.getMerchantId()));
        Goods customGood = AssembleService.convertOrderItemsToGoods((List)orders.getItems());
        log.info("CutDownService#confirm customGood:{}", (Object)JSON.toJSONString((Object)customGood));
        List customSkuInfo = AssembleService.convertOrderItemsToSkuInfo((List)orders.getItems());
        log.info("CutDownService#confirm customSkuInfo:{}", (Object)JSON.toJSONString((Object)customSkuInfo));
        List dbSkuInfo = this.checkAndGetSkuInfo(customSkuInfo);
        log.info("CutDownService#confirm dbSkuInfo:{}", (Object)JSON.toJSONString((Object)dbSkuInfo));
        Goods dbGoods = this.checkAndGetGoodsInfo(customGood);
        log.info("CutDownService#confirm dbGoods:{}", (Object)JSON.toJSONString((Object)dbGoods));
        GoodsSkuDetail goodsSkuDetail = (GoodsSkuDetail)dbSkuInfo.get(0);
        Example example = new Example(MarketActivityGoods.class);
        example.createCriteria().andEqualTo("marketActivityNo", (Object)orders.getActivityNo()).andEqualTo("goodsId", (Object)goodsSkuDetail.getGoodsId());
        MarketActivityGoods marketActivityGoods = (MarketActivityGoods)this.marketActivityGoodsMapper.selectOneByExample((Object)example);
        if (marketActivityGoods == null) {
            throw new CustomException("\u6b64\u5546\u54c1\u4e0d\u5b58\u5728\u4e8e\u6d3b\u52a8");
        }
        orders.setMarketActivityGoodsId(marketActivityGoods.getId());
        BigDecimal pay = goodsSkuDetail.getSalesPrice();
        if (orders.getMarketActivityOrdersId() != null && !CollectionUtils.isEmpty((Collection)(goodsFriends = this.getGoodsFriends(marketActivityOrders = (MarketActivityOrders)this.marketActivityOrdersMapper.selectByPrimaryKey((Object)orders.getMarketActivityOrdersId()))))) {
            BigDecimal alreadyCut = this.calCutAmount(goodsFriends);
            pay = goodsSkuDetail.getSalesPrice().subtract(alreadyCut);
        }
        orders.setOrderAmount(pay);
        orders.setPayAmount(pay);
        for (GoodsSkuDetail sku : dbSkuInfo) {
            sku.setGoodsName(dbGoods.getGoodsName());
            sku.setGoodsNo(dbGoods.getGoodsNo());
            sku.setCommission(dbGoods.getCommissionRate().multiply(new BigDecimal("0.01")).multiply(sku.getSalesPrice()).multiply(new BigDecimal(customGood.getCount())));
            for (OrderItems orderItems : orders.getItems()) {
                if (!orderItems.getGoodsSkuNo().equals(sku.getSkuNo())) continue;
                orderItems.setGoodsImg(sku.getSkuImg());
                if (sku.getIsUniform().booleanValue()) {
                    orderItems.setGoodsImg(dbGoods.getCoverImg());
                }
                orderItems.setGoodsNo(sku.getGoodsNo());
                orderItems.setMarketPrice(sku.getMarketPrice());
                orderItems.setSalePrice(sku.getSalesPrice());
                orderItems.setItemsAmount(pay);
                orderItems.setItemsPayAmount(pay);
                orderItems.setWepayAmount(pay);
                orderItems.setItemsActiveDeduction(BigDecimal.ZERO);
                orderItems.setItemsPointDeduction(BigDecimal.ZERO);
                orderItems.setCommission(sku.getCommission());
                orderItems.setGoodsSkuName(sku.getSpecNames());
            }
        }
        log.info("\u780d\u4ef7 confirm orders => {}", (Object)JSONObject.toJSONString((Object)orders));
        return orders;
    }

    private List<GoodsSkuDetail> checkAndGetSkuInfo(List<GoodsSkuDetail> customSkuInfoList) {
        List dbSkuInfoList = this.goodsSkuDetailService.findByCondition(customSkuInfoList);
        InputValidator.checkEmpty((Collection)dbSkuInfoList, (String)"\u5546\u54c1");
        for (GoodsSkuDetail customSku : customSkuInfoList) {
            GoodsSkuDetail extract = this.extractSkuInfoFromSkuList(customSku, dbSkuInfoList);
            Assert.notNull((Object)extract, (String)("\u5546\u54c1[" + this.getGoodsSkuName(customSku) + "]\u4e0d\u5b58\u5728"));
        }
        return dbSkuInfoList;
    }

    private String getGoodsSkuName(GoodsSkuDetail orderItems) {
        return orderItems.getGoodsName() + " " + orderItems.getSkuNo();
    }

    private GoodsSkuDetail extractSkuInfoFromSkuList(GoodsSkuDetail goodsSkuDetail, List<GoodsSkuDetail> goodsSkuDetailList) {
        for (GoodsSkuDetail gsd : goodsSkuDetailList) {
            if (!gsd.getSkuNo().equals(goodsSkuDetail.getSkuNo()) || !gsd.getGoodsId().equals(goodsSkuDetail.getGoodsId())) continue;
            return gsd;
        }
        return null;
    }

    private Goods extractSkuInfoFromSkuList(Goods qg, List<Goods> queryResultGoods) {
        for (Goods goods : queryResultGoods) {
            if (!goods.getId().equals(qg.getId())) continue;
            return goods;
        }
        return null;
    }

    private Goods checkAndGetGoodsInfo(Goods customGoodsList) {
        ArrayList<Integer> goodsIdList = new ArrayList<Integer>();
        goodsIdList.add(customGoodsList.getId());
        Integer merchantId = customGoodsList.getMerchantId();
        Goods queryCondition = new Goods();
        queryCondition.setIdList(goodsIdList);
        queryCondition.setMerchantId(merchantId);
        List dbGoodsInfo = this.goodsService.findByConditionWithGoodsId(queryCondition);
        if (dbGoodsInfo == null) {
            throw new CustomException("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Goods extract = this.extractSkuInfoFromSkuList(customGoodsList, dbGoodsInfo);
        if (extract == null) {
            throw new CustomException("\u5546\u54c1[" + customGoodsList.getGoodsName() + "]\u4e0d\u5b58\u5728");
        }
        if (!extract.getIsShelved().booleanValue()) {
            throw new CustomException("\u5546\u54c1[" + customGoodsList.getGoodsName() + "]\u5df2\u4e0b\u67b6");
        }
        if (!extract.getLimitation().equals(0) && extract.getLimitation().compareTo(customGoodsList.getCount()) < 0) {
            throw new CustomException("\u5546\u54c1[" + customGoodsList.getGoodsName() + "]\u6bcf\u5355\u9650\u8d2d" + extract.getLimitation() + "\u4ef6");
        }
        return (Goods)dbGoodsInfo.get(0);
    }

    @Transactional
    public Map addOrders(Orders orders) {
        log.info("\u8ba2\u5355\u5165\u5e93\u7684\u53c2\u6570======> {}", (Object)JSONObject.toJSONString((Object)orders));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String key = String.format(USER_ADD_ORDER_KEY, orders.getUserId());
        if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"").booleanValue()) {
            log.info("\u7528\u6237ID {} \u4e0b\u5355\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41", (Object)orders.getUserId());
            throw new CustomException("\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
        }
        this.stringRedisTemplate.expire((Object)key, 10L, TimeUnit.SECONDS);
        AssembleService.checkOrdersShippingInfo((Orders)orders);
        Orders newOrder = this.confirm(orders);
        newOrder = this.getOfflineInfo(newOrder);
        newOrder.setMemberLevelName(orders.getMemberLevelName());
        newOrder.setSysBrandId(orders.getSysBrandId());
        newOrder = OrdersBuilder.getBuilder((Orders)newOrder).build();
        OrderItems item = (OrderItems)orders.getItems().get(0);
        Example example = new Example(MarketActivityGoods.class);
        example.createCriteria().andEqualTo("marketActivityNo", (Object)newOrder.getActivityNo()).andEqualTo("goodsId", (Object)item.getGoodsId());
        MarketActivityGoods marketActivityGoods = (MarketActivityGoods)this.marketActivityGoodsMapper.selectOneByExample((Object)example);
        if (marketActivityGoods == null) {
            throw new CustomException("\u6b64\u5546\u54c1\u4e0d\u5b58\u5728\u4e8e\u6d3b\u52a8");
        }
        item.setItemsPayAmount(marketActivityGoods.getAmount());
        orders.setPayAmount(marketActivityGoods.getAmount());
        orders.setOrderAmount(marketActivityGoods.getAmount());
        if (orders.getPayAmount().equals(BigDecimal.ZERO)) {
            throw new CustomException("\u780d\u4ef7\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a0\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        newOrder.setOrdersActivityType(String.valueOf(OrderActivityTypeEnum.KJ.getCode()));
        newOrder.setMarketActivityOrdersId(orders.getMarketActivityOrdersId());
        log.info("insert KJorder info...{}", (Object)JSONObject.toJSONString((Object)newOrder));
        this.ordersMapper.insertSelective((Object)newOrder);
        for (OrderItems orderItems : newOrder.getItems()) {
            orderItems.setOrderId(newOrder.getId());
            orderItems.setOrderNo(newOrder.getOrderNo());
        }
        this.orderItemsMapper.insertList(newOrder.getItems());
        log.info("insert KJorder successfully ! ");
        Config config = new Config();
        config.setMerchantId(newOrder.getMerchantId());
        Config oneByCondition = (Config)this.configService.findOneByCondition((Serializable)config);
        String appid = newOrder.getAppid();
        Long userId = newOrder.getUserId();
        Integer orderId = newOrder.getId();
        this.scheduledThreadPoolExecutor.schedule(() -> {
            log.info("close order {} schedule start ...", (Object)orders.getOrderNo());
            this.ordersService.cancel(appid, userId, orderId, null);
        }, (long)oneByCondition.getAwaitOrderPayMinute().intValue(), TimeUnit.MINUTES);
        map.put("ordersId", newOrder.getId());
        return map;
    }

    @Transactional
    public MarketActivityOrders addMarketOrders(Orders newOrder) {
        if (newOrder.getMarketActivityOrdersId() != null) {
            log.info("\u91cd\u65b0\u53d1\u8d77\u7684\u6d3b\u52a8\u8ba2\u5355\u5904\u7406\uff1a\u5f85\u5220\u9664 OLD:MarketActivityOrdersId:{}", (Object)newOrder.getMarketActivityOrdersId());
            if (!newOrder.getMarketActivityOrdersId().equals(-100)) {
                MarketActivityOrders mao = new MarketActivityOrders();
                mao.setId(newOrder.getMarketActivityOrdersId());
                mao.setValid(Integer.valueOf(0));
                this.marketActivityOrdersMapper.updateByPrimaryKeySelective((Object)mao);
            } else {
                newOrder.setMarketActivityOrdersId(null);
            }
        }
        AssembleService.checkActivityNo((String)newOrder.getActivityNo());
        AssembleService.checkUserInfo((Orders)newOrder);
        MarketActivity ma = new MarketActivity();
        ma.setActivityNo(newOrder.getActivityNo());
        ma.setMerchantId(newOrder.getMerchantId());
        ma.setActivityType("0");
        ma.setActivityStatus(Boolean.valueOf(true));
        ma = (MarketActivity)this.marketActivityMapper.selectOne((Object)ma);
        if (ma == null) {
            throw new CustomException("\u6d3b\u52a8\u672a\u627e\u5230");
        }
        this.checkActivityOrdersInProcessing(newOrder);
        Orders confirm = this.confirm(newOrder);
        List goodsSkuDetails = AssembleService.convertOrderItemsToSkuInfo((List)confirm.getItems());
        List stockResponse = this.goodsSkuDetailService.inventoryReduction(goodsSkuDetails);
        if (!stockResponse.isEmpty()) {
            StringBuffer sb = new StringBuffer("\u5546\u54c1");
            stockResponse.forEach(s -> sb.append(s.getGoodsName()).append("[").append(s.getSkuNo()).append("] "));
            sb.append("\u5e93\u5b58\u4e0d\u8db3");
            throw new CustomException(sb.toString());
        }
        List randomValueArray = this.calcPreHandlePriceArray(ma, confirm);
        String activityOrdersNo = "KJ" + DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss") + RandomCodeUtil.randCode((int)8);
        this.prePriceSetInRedis(randomValueArray, activityOrdersNo);
        OrderItems orderItems = (OrderItems)confirm.getItems().get(0);
        MarketActivityOrders marketActivityOrders = new MarketActivityOrders();
        marketActivityOrders.setActivityOrdersNo(activityOrdersNo);
        marketActivityOrders.setActivityNo(confirm.getActivityNo());
        marketActivityOrders.setOrdersNo(confirm.getOrderNo());
        marketActivityOrders.setGoodsNo(((OrderItems)confirm.getItems().get(0)).getGoodsNo());
        marketActivityOrders.setGoodsName(((OrderItems)confirm.getItems().get(0)).getGoodsName());
        marketActivityOrders.setGoodsSkuNo(((OrderItems)confirm.getItems().get(0)).getGoodsSkuNo());
        marketActivityOrders.setGoodsSkuName(((OrderItems)confirm.getItems().get(0)).getGoodsSkuName());
        marketActivityOrders.setActivityOrdersType("0");
        marketActivityOrders.setOrdersStatus("0");
        marketActivityOrders.setUserNo(confirm.getUserNo());
        marketActivityOrders.setLaunchUserNo(confirm.getUserNo());
        marketActivityOrders.setGmtCreate(new Date());
        marketActivityOrders.setMarketActivityGoodsId(confirm.getMarketActivityGoodsId());
        marketActivityOrders.setBargainBudgetAmount(randomValueArray.toString());
        marketActivityOrders.setMerchantId(orderItems.getMerchantId());
        marketActivityOrders.setGoodsId(orderItems.getGoodsId());
        marketActivityOrders.setGmtModified(marketActivityOrders.getGmtCreate());
        marketActivityOrders.setValid(Integer.valueOf(1));
        this.marketActivityOrdersMapper.insertSelective((Object)marketActivityOrders);
        log.info("\u53d1\u8d77\u7684\u6d3b\u52a8\u8ba2\u5355: NEW :MarketActivityOrdersId{}", (Object)marketActivityOrders.getId());
        this.scheduledThreadPoolExecutor.schedule(() -> {
            log.info("close marketActivityOrder {} schedule start ...", (Object)marketActivityOrders.getActivityOrdersNo());
            this.cutDownReBack(marketActivityOrders.getId(), goodsSkuDetails);
        }, (long)ma.getActivityTermValidity().intValue(), TimeUnit.HOURS);
        return marketActivityOrders;
    }

    public void cutDownReBack(Integer marketActivityOrdersId, List<GoodsSkuDetail> goodsSkuDetails) {
        log.info("");
        MarketActivityOrders mao = (MarketActivityOrders)this.marketActivityOrdersMapper.selectByPrimaryKey((Object)marketActivityOrdersId);
        if (mao == null || mao.getValid().equals(0)) {
            return;
        }
        if ("1".equals(mao.getTradeStatus())) {
            log.info("\u8ba2\u5355\u5df2\u7ecf\u4ed8\u6b3e");
            return;
        }
        MarketActivityOrders condition = new MarketActivityOrders();
        condition.setTradeStatus("0");
        condition.setActivityOrdersNo(mao.getActivityOrdersNo());
        condition.setLaunchUserNo(mao.getLaunchUserNo());
        MarketActivityOrders orders = new MarketActivityOrders();
        orders.setOrdersStatus("2");
        orders.setGmtModified(new Date());
        Example example = new Example(MarketActivityOrders.class);
        example.createCriteria().andEqualTo("tradeStatus", (Object)condition.getTradeStatus()).andEqualTo("activityOrdersNo", (Object)condition.getActivityOrdersNo()).andEqualTo("launchUserNo", (Object)condition.getLaunchUserNo()).andEqualTo("valid", (Object)1);
        int result = this.marketActivityOrdersMapper.updateByExampleSelective((Object)orders, (Object)example);
        if (result == 0) {
            log.warn("\u53d6\u6d88\u8425\u9500\u8ba2\u5355\u5931\u8d25,\u7528\u6237userNo {}, \u8ba2\u5355\u53f7 {}", (Object)mao.getLaunchUserNo(), (Object)mao.getActivityOrdersNo());
            return;
        }
        goodsSkuDetails.forEach(o -> o.setStock(Integer.valueOf(-o.getStock().intValue())));
        this.goodsSkuDetailService.inventoryReduction(goodsSkuDetails);
    }

    private void checkActivityOrdersInProcessing(Orders orders) {
        log.info("checkActivityOrdersInProcessing\u7684\u5165\u53c2\u662f:{}", JSON.toJSON((Object)orders));
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setLaunchUserNo(orders.getLaunchUserNo());
        mao.setGoodsId(((OrderItems)orders.getItems().get(0)).getGoodsId());
        mao.setOrdersStatus("0");
        mao.setTradeStatus("0");
        mao.setActivityOrdersType("0");
        mao.setActivityNo(orders.getActivityNo());
        mao.setValid(Integer.valueOf(1));
        List select = this.marketActivityOrdersMapper.select((Object)mao);
        if (!CollectionUtils.isEmpty((Collection)select)) {
            throw new CustomException("\u60a8\u5df2\u7ecf\u5728\u8be5\u6d3b\u52a8\u4e2d");
        }
    }

    public MarketActivityOrders helpFriendsInfo(MarketActivityOrders marketActivityOrders) {
        MarketActivityOrders temp = (MarketActivityOrders)this.marketActivityOrdersMapper.selectByPrimaryKey((Object)marketActivityOrders.getId());
        this.checkMarketOrdersValid(temp);
        MarketActivity ma = new MarketActivity();
        ma.setActivityNo(temp.getActivityNo());
        ma = (MarketActivity)this.marketActivityMapper.selectOne((Object)ma);
        MarketActivityGoods marketActivityGoods = (MarketActivityGoods)marketActivityOrders.getMarketActivityGoods().get(0);
        Example goodsExa = new Example(Goods.class);
        Example.Criteria criteria = goodsExa.createCriteria();
        criteria.andEqualTo("goodsNo", (Object)marketActivityOrders.getGoodsNo()).andEqualTo("isDel", (Object)Boolean.FALSE);
        criteria.andEqualTo("merchantId", (Object)marketActivityOrders.getMerchantId());
        Goods goods = (Goods)this.goodsMapper.selectOneByExample((Object)goodsExa);
        if (goods != null) {
            GoodsSkuDetail gsd = new GoodsSkuDetail();
            gsd.setGoodsId(temp.getGoodsId());
            gsd.setSkuNo(temp.getGoodsSkuNo());
            gsd = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne((Object)gsd);
            if (gsd != null) {
                log.info("\u5e2e\u52a9\u597d\u53cb\u63a5\u53e3\u83b7\u53d6sku:{}", JSON.toJSON((Object)gsd));
                marketActivityGoods.setGoodsPrice(gsd.getSalesPrice());
            }
        } else {
            log.warn("\u6d3b\u52a8\u5546\u54c1\u6ca1\u6709\u627e\u5230");
            throw new CustomException("\u6d3b\u52a8\u5546\u54c1\u6ca1\u6709\u627e\u5230");
        }
        marketActivityGoods.setGoodsAssembleNum(goods.getAssembleNum());
        marketActivityGoods.setGoodsName(goods.getGoodsName());
        marketActivityGoods.setGoodsPicUrl(goods.getCoverImg());
        marketActivityGoods.setActivityPersonNum(ma.getActivityPersonNum());
        temp.setMarketActivityGoods(marketActivityOrders.getMarketActivityGoods());
        MarketActivityOrders maoTemp = (MarketActivityOrders)this.marketActivityOrdersMapper.selectByPrimaryKey((Object)marketActivityOrders.getId());
        marketActivityOrders.setActivityOrdersNo(maoTemp.getActivityOrdersNo());
        List goodsFriends = this.getGoodsFriends(marketActivityOrders);
        BigDecimal alreadyCut = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)goodsFriends) && !StringUtils.isEmpty((Object)marketActivityOrders.getActivityOrdersNo())) {
            alreadyCut = this.calCutAmount(goodsFriends);
        }
        temp.setAlreadyCut(alreadyCut);
        Long leftTime = this.calLeftTime(temp);
        temp.setLeftTime(leftTime);
        return temp;
    }

    private void checkMarketOrdersValid(MarketActivityOrders temp) {
        if (temp.getValid().equals(0)) {
            throw new CustomException("\u672c\u6b21\u780d\u4ef7\u5df2\u5931\u6548\u4e86");
        }
    }

    @Transactional
    public String helpCut(MarketActivityOrders marketActivityOrders) {
        if (marketActivityOrders.getId() == null) {
            throw new CustomException("\u5e2e\u52a9\u780d\u4ef7\u7684\u5fc5\u8981\u53c2\u6570\u4e3a\u7a7a");
        }
        BargainPlayers bargainPlayers = (BargainPlayers)marketActivityOrders.getBargainPlayers().get(0);
        this.checkHelpCutParam(bargainPlayers);
        String pkey = USER_HELP_CUT_KEY + marketActivityOrders.getUserNo() + "-" + marketActivityOrders.getId();
        log.info("help redis\u7684key:{}", (Object)pkey);
        if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)pkey, (Object)"").booleanValue()) {
            log.info("\u7528\u6237ID {} \u5e2e\u52a9\u780d\u4ef7\u8fc7\u4e8e\u9891\u7e41", (Object)marketActivityOrders.getUserNo());
            throw new CustomException("\u60a8\u5df2\u7ecf\u5e2e\u52a9\u8fc7\u597d\u53cb\u55bd\uff01");
        }
        this.stringRedisTemplate.expire((Object)pkey, 10L, TimeUnit.DAYS);
        Example example = new Example(MarketActivity.class);
        example.createCriteria().andEqualTo("merchantId", (Object)marketActivityOrders.getMerchantId()).andEqualTo("activityNo", (Object)marketActivityOrders.getActivityNo()).andEqualTo("activityType", (Object)"0").andEqualTo("activityStatus", (Object)Boolean.TRUE).andCondition("DATE_FORMAT(NOW(),'%Y-%m-%d %H:%i:%S') BETWEEN DATE_FORMAT(activity_begin_time,'%Y-%m-%d %H:%i:%S') AND DATE_FORMAT(activity_end_time,'%Y-%m-%d %H:%i:%S')");
        MarketActivity ma = (MarketActivity)this.marketActivityMapper.selectOneByExample((Object)example);
        if (ma == null) {
            throw new CustomException("\u6709\u6548\u6d3b\u52a8\u672a\u627e\u5230\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6d3b\u52a8\u8bbe\u7f6e\u60c5\u51b5");
        }
        MarketActivityOrders mao = (MarketActivityOrders)this.marketActivityOrdersMapper.selectByPrimaryKey((Object)marketActivityOrders.getId());
        this.checkMarketOrdersValid(mao);
        mao.setOpenId(marketActivityOrders.getOpenId());
        mao.setActivityPersonNum(ma.getActivityPersonNum());
        List goodsFriends = this.getGoodsFriends(mao);
        this.checkMarketActivityOrdersVaild(mao, goodsFriends);
        String key = REDIS_PRECALULATE_PRICE_ARRAY_KEY + mao.getActivityOrdersNo();
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        RedisConnection connection = this.stringRedisTemplate.getConnectionFactory().getConnection();
        String value = new String(connection.lPop(stringSerializer.serialize((Object)key)));
        if (StringUtils.isEmpty((Object)value)) {
            log.info("\u5904\u7406redis\u83b7\u53d6value\u5f02\u5e38\uff1a{}", (Object)value);
            throw new CustomException("\u5e2e\u52a9\u4eba\u6570\u5df2\u6ee1");
        }
        bargainPlayers.setAmount(BigDecimal.valueOf(Double.parseDouble(value)));
        this.bargainPlayersMapper.insertSelective((Object)bargainPlayers);
        return value;
    }

    private void checkHelpCutParam(BargainPlayers bargainPlayers) {
        if (StringUtils.isEmpty((Object)bargainPlayers.getActivityOrdersNo())) {
            throw new CustomException("\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)bargainPlayers.getWxHeadUrl())) {
            throw new CustomException("\u5fae\u4fe1\u5934\u50cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)bargainPlayers.getWxName())) {
            throw new CustomException("\u5fae\u4fe1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)bargainPlayers.getOpenId())) {
            throw new CustomException("\u5fae\u4fe1openId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkMarketActivityOrdersVaild(MarketActivityOrders mao, List<BargainPlayers> goodsFriends) {
        BargainPlayers bp = new BargainPlayers();
        bp.setActivityOrdersNo(mao.getActivityOrdersNo());
        bp.setOpenId(mao.getOpenId());
        log.info("checkMarketActivityOrdersVaild\u7684\u53c2\u6570:{}", JSON.toJSON((Object)bp));
        bp = (BargainPlayers)this.bargainPlayersMapper.selectOne((Object)bp);
        Long leftTime = this.calLeftTime(mao);
        if (bp != null || leftTime <= 0L || mao.getActivityPersonNum() <= goodsFriends.size()) {
            throw new CustomException("\u6d3b\u52a8\u8fc7\u671f\uff0c\u6216\u8005\u780d\u4ef7\u4eba\u6570\u5df2\u6ee1");
        }
    }

    private List<String> calcPreHandlePriceArray(MarketActivity ma, Orders confirm) {
        OrderItems item = (OrderItems)confirm.getItems().get(0);
        MarketActivityGoods mag = new MarketActivityGoods();
        mag.setMarketActivityNo(ma.getActivityNo());
        mag.setGoodsId(item.getGoodsId());
        List mags = this.marketActivityGoodsMapper.select((Object)mag);
        if (CollectionUtils.isEmpty((Collection)mags)) {
            log.warn("\u6d3b\u52a8\u5546\u54c1\u67e5\u627e\u5f02\u5e38activityNo:{},goodsId:{},skuNo:{}", new Object[]{ma.getActivityNo(), item.getGoodsId(), item.getSkuCode()});
            throw new CustomException("\u6d3b\u52a8\u5546\u54c1\u67e5\u627e\u5f02\u5e38");
        }
        GoodsSkuDetail gsd = new GoodsSkuDetail();
        gsd.setGoodsId(mag.getGoodsId());
        gsd.setSkuNo(item.getGoodsSkuNo());
        gsd.setIsDel(Boolean.valueOf(false));
        gsd.setIsEnabled(Boolean.valueOf(true));
        gsd = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne((Object)gsd);
        if (gsd == null) {
            log.warn("\u8be5\u5546\u54c1\u672a\u627e\u5230\uff0c\u53ef\u80fd\u662f\u4e0b\u67b6\u6216\u8005\u7981\u7528");
            throw new CustomException("\u5546\u54c1\u672a\u627e\u5230");
        }
        mag = (MarketActivityGoods)mags.get(0);
        mag.setPrice(gsd.getSalesPrice());
        BigDecimal canReducePrice = mag.getPrice().subtract(mag.getAmount()).setScale(2, 4);
        return this.doCalHandler(canReducePrice, ma);
    }

    private List<String> doCalHandler(BigDecimal canReducePrice, MarketActivity marketActivity) {
        ArrayList<String> result;
        double v = canReducePrice.doubleValue() / (double)marketActivity.getActivityPersonNum().intValue();
        if ("0".equals(marketActivity.getBargainAmoutType())) {
            result = new ArrayList(marketActivity.getActivityPersonNum());
            if (marketActivity.getActivityPersonNum() <= 1) {
                result.add(canReducePrice.toString());
                return result;
            }
            double renshu = (double)marketActivity.getActivityPersonNum().intValue() - 1.0;
            BigDecimal frontManPrice = BigDecimal.valueOf(v).setScale(2, 4).multiply(BigDecimal.valueOf(renshu));
            BigDecimal lastManPrice = canReducePrice.subtract(frontManPrice);
            for (int i = 0; i < marketActivity.getActivityPersonNum() - 1; ++i) {
                result.add(BigDecimal.valueOf(v).setScale(2, 4).toString());
            }
            result.add(lastManPrice.toString());
        } else {
            result = this.getReduceList(canReducePrice, marketActivity.getActivityPersonNum().intValue(), BigDecimal.ZERO, BigDecimal.valueOf(v * 2.0));
        }
        return result;
    }

    public List<String> getReduceList(BigDecimal totalReduce, int totalReduceTimes, BigDecimal minReduce, BigDecimal maxReduce) {
        ArrayList<String> ret = new ArrayList<String>();
        Random rand = new Random();
        double[] vs = new double[totalReduceTimes];
        double total = 0.0;
        for (int i = 0; i < totalReduceTimes; ++i) {
            double v;
            while (true) {
                int flag = 0;
                v = rand.nextDouble() * totalReduce.doubleValue();
                if (maxReduce.doubleValue() > v && v > minReduce.doubleValue()) break;
                if (flag > 20) {
                    throw new CustomException("\u780d\u4ef7\u9884\u8ba1\u7b97\u968f\u673a\u4ef7\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                ++flag;
            }
            vs[i] = v;
            total += v;
        }
        double minReduceVal = minReduce.doubleValue();
        BigDecimal t = BigDecimal.valueOf(0.0);
        for (int i = 0; i < totalReduceTimes - 1; ++i) {
            double vss = 0.0;
            if (total > 0.0) {
                vss = vs[i] / total * (totalReduce.doubleValue() - minReduceVal * (double)totalReduceTimes) + minReduceVal;
            }
            BigDecimal reduce = BigDecimal.valueOf(vss).setScale(2, RoundingMode.HALF_EVEN);
            t = t.add(reduce);
            ret.add(reduce.toString());
        }
        ret.add(totalReduce.subtract(t).setScale(2, RoundingMode.HALF_EVEN).toString());
        return ret;
    }

    private void prePriceSetInRedis(List<String> list, String uuid) {
        String key = REDIS_PRECALULATE_PRICE_ARRAY_KEY + uuid;
        ListOperations ops = this.stringRedisTemplate.opsForList();
        if (ops.getOperations().hasKey((Object)key).booleanValue()) {
            log.info("redis\u4e2d\u5df2\u7ecf\u5b58\u5728\u8be5key_\u7684\u6d3b\u52a8\u7f16\u53f7:[{}]", (Object)uuid);
            throw new CustomException("\u5df2\u5b58\u5728\u8be5\u6d3b\u52a8\u7f16\u53f7\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d77");
        }
        ops.leftPushAll((Object)key, list);
        log.info(uuid + "\u9884\u8ba1\u7b97\u4ef7\u683c\u63d2\u5165\u5230redis\u4e2d");
    }

    private Orders getOfflineInfo(Orders newOrder) {
        ArrayList<SysDimSkuPoDto> param = new ArrayList<SysDimSkuPoDto>();
        CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
        companyBrandRelation.setMerchantId(newOrder.getMerchantId());
        companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne((Object)companyBrandRelation);
        for (OrderItems item : newOrder.getItems()) {
            SysDimSkuPoDto dto = new SysDimSkuPoDto();
            Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)item.getGoodsId());
            dto.setProductCode(goods.getGoodsNo());
            dto.setSkuCode(item.getGoodsSkuNo());
            dto.setSysBrandId(companyBrandRelation.getMerchantId());
            dto.setSysCompanyId(companyBrandRelation.getCompanyId());
            param.add(dto);
        }
        List list = new ArrayList<Orders>();
        list.add(newOrder);
        try {
            list = this.offLineInfoHandlerServiceImpl.queryOfflineMemberInfoOrders(companyBrandRelation, list);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return (Orders)list.get(0);
    }
}

