/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.dto.CouponDTO;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.enums.ApplianceCommodityTypeEnum;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.CouponService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CouponServiceImpl
implements CouponService {
    private static final Logger log = LoggerFactory.getLogger(CouponServiceImpl.class);
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Lazy
    @Resource
    private OrdersService ordersService;
    private static final long DAY_MILLISECOND = 86400000L;

    public List<CouponDTO> findByCondition(CouponDTO coupon) {
        log.info("CouponServiceImpl#findByCondition coupon:{}", (Object)JSON.toJSONString((Object)coupon));
        try {
            return this.bizvaneInterface.getCouponList(coupon);
        }
        catch (Exception e) {
            log.warn("CouponServiceImpl#findByCondition e:{}", (Throwable)e);
            return new ArrayList<CouponDTO>();
        }
    }

    public Map<String, Object> findMineCoupons(CouponDTO coupon, Integer pageIndex, Orders orders) {
        log.info("CouponServiceImpl#findMineCoupons coupon:{},pageIndex:{},orders:{}", new Object[]{JSON.toJSONString((Object)coupon), pageIndex, JSON.toJSONString((Object)orders)});
        Map customCounponList = this.bizvaneInterface.getCustomCounponList(coupon, pageIndex);
        if (orders.getItems() == null) {
            return customCounponList;
        }
        Orders payConfirm = this.ordersService.payConfirm(orders);
        List myCouponList = (List)customCounponList.get("list");
        for (CouponDTO couponDTO : myCouponList) {
            this.packCouponIsValid(couponDTO, payConfirm);
        }
        return customCounponList;
    }

    public void lock(String couponNo, String userNo) {
        this.bizvaneInterface.lockCoupon(CouponDTO.builder().code(couponNo).userNo(userNo).build());
    }

    public void unLock(String couponNo, String userNo) {
        try {
            if (StringUtils.isEmpty((Object)couponNo)) {
                return;
            }
            this.bizvaneInterface.unLockCoupon(CouponDTO.builder().code(couponNo).userNo(userNo).build());
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }

    public void verify(CouponDTO couponDTO) {
        try {
            this.bizvaneInterface.validCoupon(couponDTO);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }

    public static void main(String[] args) {
        System.out.println(new BigDecimal("844.8").divide(new BigDecimal("1200"), 2, 6));
        System.out.println(BigDecimal.ZERO.compareTo(new BigDecimal("844.8").divide(new BigDecimal("1200"), 2, 6)));
    }

    private void packUseFoldUserCard(CouponDTO couponDTO, Orders orders) {
        if (!couponDTO.getIsAllowFoldUserDiscount().booleanValue() && orders.getUserDeduction().compareTo(BigDecimal.ZERO) > 0) {
            couponDTO.setTip("\u4e0d\u53ef\u4e0e\u4f1a\u5458\u6298\u6263\u53e0\u52a0");
            couponDTO.setCanUse(Boolean.valueOf(false));
        }
    }

    private void packUseAmountState(CouponDTO couponDTO, Orders orders) {
        BigDecimal sumMarketPrice = orders.getItems().stream().map(e -> e.getMarketPrice().multiply(BigDecimal.valueOf(e.getSaleQuantity().intValue()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (BigDecimal.ZERO.equals(sumMarketPrice)) {
            throw new CustomException("\u540a\u724c\u4ef7\u8ba1\u7b97\u4e3a0\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        BigDecimal orderDiscount = orders.getPayAmount().divide(sumMarketPrice, 2, 6);
        if (couponDTO.getCanUseDiscount().compareTo(orderDiscount) > 0) {
            couponDTO.setTip("\u6574\u5355\u6298\u6263\u4e0d\u6ee1\u8db3\u4f7f\u7528\u8981\u6c42");
            couponDTO.setCanUse(Boolean.valueOf(false));
        } else if (couponDTO.getMinConsume().compareTo(orders.getPayAmount()) > 0) {
            couponDTO.setTip("\u8ba2\u5355\u91d1\u989d\u6ee1" + couponDTO.getMinConsume() + "\u5143\u4f7f\u7528");
            couponDTO.setCanUse(Boolean.valueOf(false));
        }
    }

    public void packCouponIsValid(CouponDTO couponDTO, Orders orders) {
        if (couponDTO == null) {
            return;
        }
        couponDTO.setCanUse(Boolean.valueOf(true));
        log.info("validate coupon usable... => {}", (Object)JSONObject.toJSONString((Object)couponDTO));
        this.packUseDateState(couponDTO);
        this.packUseAmountState(couponDTO, orders);
        this.packUseFoldUserCard(couponDTO, orders);
        this.packDeductionIsMoreThanOrderAmount(couponDTO, orders);
        this.packCommodityLimit(couponDTO, orders);
    }

    private void packCommodityLimit(CouponDTO couponDTO, Orders orders) {
        log.info("CouponServiceImpl#packCommodityLimit couponDTO:{}", (Object)JSON.toJSONString((Object)couponDTO));
        if (ApplianceCommodityTypeEnum.PART.getCode().equals(couponDTO.getApplianceCommodityType())) {
            for (OrderItems orderItems : orders.getItems()) {
                log.info("CouponServiceImpl#packCommodityLimit orderItems:{}", (Object)JSON.toJSONString((Object)orderItems));
                if (!StringUtils.isEmpty((Object)couponDTO.getCommodityWhitelist()) && !couponDTO.getCommodityWhitelist().contains(orderItems.getGoodsNo())) {
                    couponDTO.setCanUse(Boolean.valueOf(false));
                    couponDTO.setTip("\u90e8\u5206\u5546\u54c1\u65e0\u6cd5\u4f7f\u7528\u6b64\u5238");
                    break;
                }
                if (StringUtils.isEmpty((Object)couponDTO.getCommodityBlacklist()) || !couponDTO.getCommodityBlacklist().contains(orderItems.getGoodsNo())) continue;
                couponDTO.setCanUse(Boolean.valueOf(false));
                couponDTO.setTip("\u90e8\u5206\u5546\u54c1\u65e0\u6cd5\u4f7f\u7528\u6b64\u5238");
                break;
            }
        }
    }

    private void packDeductionIsMoreThanOrderAmount(CouponDTO couponDTO, Orders orders) {
        if (CouponDTO.CouponTypeEnum.CASH.equals((Object)couponDTO.getCouponType()) && orders.getPayAmount().compareTo(couponDTO.getAmount()) <= 0) {
            couponDTO.setCanUse(Boolean.valueOf(false));
            couponDTO.setTip("\u60a8\u65e0\u6cd5\u4f7f\u7528\u8be5\u5238");
        }
    }

    private void packUseDateState(CouponDTO couponDTO) {
        Date now = new Date();
        if (CouponDTO.CouponValidTypeEnum.RANGE.equals((Object)couponDTO.getCouponValidType())) {
            if (couponDTO.getStartValidDate().getTime() <= now.getTime() && now.getTime() <= couponDTO.getEndValidDate().getTime()) {
                return;
            }
        } else if (couponDTO.getGetDate() != null) {
            couponDTO.setStartValidDate(new Date(couponDTO.getGetDate().getTime()));
            couponDTO.setEndValidDate(new Date(couponDTO.getGetDate().getTime() + (long)couponDTO.getValidDays().intValue() * 86400000L));
            if ((long)couponDTO.getValidDays().intValue() >= (now.getTime() - couponDTO.getGetDate().getTime()) / 86400000L) {
                return;
            }
        }
        couponDTO.setCanUse(Boolean.valueOf(false));
        couponDTO.setTip("\u5238\u4f7f\u7528\u4e0d\u5728\u6709\u6548\u671f\u8303\u56f4\u5185");
    }

    public Map<String, Object> addCoupon(Map<String, Object> map) {
        return this.bizvaneInterface.pickupCoupon(map);
    }

    public CouponDTO findById(Integer id) {
        if (id == null || id == -1) {
            return null;
        }
        try {
            return this.bizvaneInterface.getCouponDetail(id);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
    }
}

