/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.dto.OrdersQueryInfo;
import com.wmeimob.fastboot.bizvane.entity.Comments;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.mapper.CommentsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderItemsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.service.CommentsService;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Primary
public class CommentsServiceImpl
implements CommentsService {
    @Resource
    private OrdersMapper ordersMapper;
    @Resource
    private OrderItemsMapper orderItemsMapper;
    @Resource
    private CommentsMapper commentsMapper;

    public void evaluateOrder(Integer id, OrdersQueryInfo ordersQueryInfo, User user) {
        InputValidator.checkEmpty((Object)ordersQueryInfo.getServiceGrade(), (String)"\u670d\u52a1\u661f\u7ea7");
        InputValidator.checkEmpty((Object)ordersQueryInfo.getLogisticsGrade(), (String)"\u7269\u6d41\u661f\u7ea7");
        Orders orders = (Orders)this.ordersMapper.selectByPrimaryKey((Object)ordersQueryInfo.getId());
        if (null == orders) {
            throw new MallWechatException("\u8ba2\u5355\u5f02\u5e38\uff0c\u4e0d\u53ef\u8bc4\u4ef7");
        }
        if (!orders.getOrderStatus().equals((Object)OrdersStatusEnum.SUCCESS) || orders.getIsComment().booleanValue()) {
            throw new MallWechatException("\u8ba2\u5355\u5f02\u5e38\uff0c\u4e0d\u53ef\u8bc4\u4ef7");
        }
        if (null == ordersQueryInfo.getComments() || ordersQueryInfo.getComments().isEmpty()) {
            throw new MallWechatException("\u672a\u586b\u5199\u8bc4\u4ef7");
        }
        List comments = ordersQueryInfo.getComments();
        for (Comments comment : comments) {
            InputValidator.checkEmpty((Object)comment.getGoodsGrade(), (String)"\u5546\u54c1\u661f\u7ea7");
            comment.setLogisticsGrade(ordersQueryInfo.getLogisticsGrade());
            comment.setServiceGrade(ordersQueryInfo.getServiceGrade());
            comment.setMerchantId(orders.getMerchantId());
            if (StringUtils.isEmpty((Object)comment.getDataId())) {
                throw new MallWechatException("\u53c2\u6570\u4e22\u59311");
            }
            OrderItems items = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)comment.getDataId());
            if (null == items) {
                throw new MallWechatException("\u53c2\u6570\u4e22\u59312");
            }
            Date date = new Date();
            CharSequence[] imgUrl = comment.getImgUrl();
            String join = String.join((CharSequence)",", imgUrl);
            comment.setImgs(join);
            comment.setUserId(orders.getUserId());
            comment.setUserNo(orders.getUserNo());
            comment.setUserName(StringUtils.isEmpty((Object)user.getFullName()) ? "\u533f\u540d\u7528\u6237" : user.getFullName());
            comment.setHeadImg(ordersQueryInfo.getHeadImg());
            comment.setMobile(orders.getMobile());
            comment.setGoodsSpec(items.getGoodsSkuName());
            comment.setGmtCreate(date);
            comment.setGmtModified(date);
            comment.setAuditStatus(Byte.valueOf((byte)0));
            comment.setReplyContent("");
            comment.setFromType(Byte.valueOf((byte)1));
            comment.setAuditor("");
            comment.setIsDel(Boolean.FALSE);
        }
        this.commentsMapper.insertList(comments);
        orders.setIsComment(Boolean.valueOf(true));
        this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
    }
}

