/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.Collect;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.CollectTypeEnum;
import com.wmeimob.fastboot.bizvane.event.collect.GoodCollectEvent;
import com.wmeimob.fastboot.bizvane.mapper.CollectMapper;
import com.wmeimob.fastboot.bizvane.newmapper.CollectPOMapper;
import com.wmeimob.fastboot.bizvane.po.CollectPO;
import com.wmeimob.fastboot.bizvane.po.CollectPOExample;
import com.wmeimob.fastboot.bizvane.service.CollectService;
import com.wmeimob.fastboot.bizvane.vo.collect.CollectEventVO;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class CollectServiceImpl
implements CollectService {
    private static final Logger log = LoggerFactory.getLogger(CollectServiceImpl.class);
    @Resource
    private CollectMapper collectMapper;
    @Autowired
    private ApplicationContext applicationContext;
    @Resource
    private CollectPOMapper collectPOMapper;

    public boolean isCollected(Collect collect) {
        int count = this.collectMapper.selectCount((Object)collect);
        return count > 0;
    }

    public List<Collect> findByCondition(Collect collect) {
        return this.collectMapper.selectCollectGoodsList(collect);
    }

    public int delete(Integer[] idArr) {
        if (idArr == null || idArr.length == 0) {
            throw new CustomException("\u6ca1\u6709\u5220\u9664\u4efb\u4f55\u9009\u9879");
        }
        CollectPOExample collectPOExample = new CollectPOExample();
        collectPOExample.createCriteria().andIdIn(Arrays.asList(idArr));
        List collectPOS = this.collectPOMapper.selectByExample(collectPOExample);
        Example example = new Example(Collect.class);
        example.createCriteria().andIn("id", Arrays.asList(idArr));
        int result = this.collectMapper.deleteByExample((Object)example);
        if (result == 0) {
            throw new CustomException("\u6ca1\u6709\u5220\u9664\u4efb\u4f55\u9009\u9879");
        }
        this.sendEvent(collectPOS);
        return result;
    }

    private void sendEvent(List<CollectPO> collectPOS) {
        try {
            User user = (User)SecurityContext.getUser();
            CollectEventVO collectEventVO = new CollectEventVO();
            collectEventVO.setMerchantId(user.getMerchantId());
            collectEventVO.setMemberCode(user.getUserNo());
            collectEventVO.setUser(user);
            collectEventVO.setCollectPOS(collectPOS);
            GoodCollectEvent goodCollectEvent = new GoodCollectEvent((Object)this.applicationContext, CollectTypeEnum.DEL.getCode(), collectEventVO);
            this.applicationContext.publishEvent((ApplicationEvent)goodCollectEvent);
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u6536\u85cf\u4e8b\u4ef6\u8c03\u7528error:{}", (Throwable)e);
        }
    }

    public Collect add(Collect collect) {
        Integer favoriteType = collect.getFavoriteType();
        String favoriteId = collect.getFavoriteId();
        InputValidator.checkEmpty((Object)collect.getWechatOpenid(), (String)"openid");
        InputValidator.checkNull((Object)favoriteId, (String)"favoriteId");
        InputValidator.checkNull((Object)favoriteType, (String)"favoriteType");
        Example example = new Example(Collect.class);
        example.createCriteria().andEqualTo("wechatOpenid", (Object)collect.getWechatOpenid()).andEqualTo("favoriteId", (Object)favoriteId).andEqualTo("favoriteType", (Object)favoriteType);
        List collects = this.collectMapper.selectByExample((Object)example);
        if (!collects.isEmpty()) {
            List collectIds = collects.stream().map(Collect::getId).collect(Collectors.toList());
            CollectPOExample collectPOExample = new CollectPOExample();
            collectPOExample.createCriteria().andIdIn(collectIds);
            List collectPOS = this.collectPOMapper.selectByExample(collectPOExample);
            this.sendEvent(collectPOS);
            this.collectMapper.deleteByExample((Object)example);
            return collect;
        }
        Date date = new Date();
        collect.setGmtCreate(date);
        this.collectMapper.insertSelective((Object)collect);
        if (favoriteType == 1) {
            try {
                Integer collectId = collect.getId();
                CollectPO collectPO = this.collectPOMapper.selectByPrimaryKey(collectId);
                User user = (User)SecurityContext.getUser();
                CollectEventVO collectEventVO = new CollectEventVO();
                collectEventVO.setMerchantId(user.getMerchantId());
                collectEventVO.setMemberCode(user.getUserNo());
                collectEventVO.setUser(user);
                ArrayList<CollectPO> collectPOS = new ArrayList<CollectPO>();
                collectPOS.add(collectPO);
                collectEventVO.setCollectPOS(collectPOS);
                GoodCollectEvent goodCollectEvent = new GoodCollectEvent((Object)this.applicationContext, CollectTypeEnum.ADD.getCode(), collectEventVO);
                this.applicationContext.publishEvent((ApplicationEvent)goodCollectEvent);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u6536\u85cf\u4e8b\u4ef6\u8c03\u7528error:{}", (Throwable)e);
            }
        }
        return collect;
    }
}

