/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.bizvane.builder.OrdersBuilder;
import com.wmeimob.fastboot.bizvane.dto.SysDimSkuPoDto;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpec;
import com.wmeimob.fastboot.bizvane.entity.MallLogs;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.enums.OrderActivityTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.ConfigMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderItemsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.RefundOrderMapper;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityOrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.po.MarketActivityOrdersPOExample;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.bizvane.service.MallLogsService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.impl.OffLineInfoHandlerServiceImpl;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.common.entity.RichText;
import com.wmeimob.fastboot.starter.common.service.RichTextService;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.fastboot.util.DateUtil;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.RandomCodeUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.exception.WepayException;
import me.hao0.wepay.model.enums.RefundAccount;
import me.hao0.wepay.model.refund.RefundApplyRequest;
import me.hao0.wepay.model.refund.RefundApplyResponse;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AssembleService {
    private static final Logger log = LoggerFactory.getLogger(AssembleService.class);
    @Autowired
    private MarketActivityMapper marketActivityMapper;
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private MarketActivityOrdersMapper marketActivityOrdersMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private OrdersMapper ordersMapper;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Resource
    private GoodsService goodsService;
    @Resource
    private GoodsSkuDetailService goodsSkuDetailService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private OrderItemsMapper orderItemsMapper;
    @Resource(name="commonConfigService")
    private ConfigService configService;
    @Lazy
    @Resource
    private OrdersService ordersService;
    @Resource
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private WechatMchNewMapper wechatMchNewMapper;
    @Resource
    private WechatService wechatService;
    @Resource
    private WechatProperties wechatProperties;
    @Resource(name="richTextCommonServiceImpl")
    private RichTextService richTextService;
    @Autowired
    private ConfigMapper configMapper;
    @Autowired
    private GoodsSpecMapper goodsSpecMapper;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Autowired
    private MallLogsService mallLogsService;
    @Autowired
    private RefundOrderMapper refundOrderMapper;
    @Autowired
    private MarketActivityOrdersPOMapper marketActivityOrdersPOMapper;
    @Autowired
    private OffLineInfoHandlerServiceImpl offLineInfoHandlerServiceImpl;
    private static final String USER_ADD_ORDER_KEY = "user:%s:add_order";

    public List<MarketActivityGoods> getActivityGoodList(Integer merchantId) {
        log.info("\u83b7\u53d6\u62fc\u56e2\u6d3b\u52a8\u4e2d\u7684\u5546\u54c1\u5217\u8868");
        ArrayList<MarketActivityGoods> list = new ArrayList<MarketActivityGoods>();
        Example example = new Example(MarketActivity.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("activityType", (Object)"1").andEqualTo("activityStatus", (Object)Boolean.TRUE).andCondition("DATE_FORMAT(NOW(),'%Y-%m-%d %H:%i:%S') BETWEEN DATE_FORMAT(activity_begin_time,'%Y-%m-%d %H:%i:%S') AND DATE_FORMAT(activity_end_time,'%Y-%m-%d %H:%i:%S')");
        List marketActivities = this.marketActivityMapper.selectByExample((Object)example);
        marketActivities.forEach(marketActivity -> {
            Example hdGoodExa = new Example(MarketActivityGoods.class);
            hdGoodExa.createCriteria().andEqualTo("marketActivityNo", (Object)marketActivity.getActivityNo());
            List marketActivityGoods = this.marketActivityGoodsMapper.selectByExample((Object)hdGoodExa);
            marketActivityGoods.forEach(marketActivityGoods1 -> {
                Example goodsExa = new Example(Goods.class);
                Example.Criteria criteria = goodsExa.createCriteria();
                criteria.andEqualTo("goodsNo", (Object)marketActivityGoods1.getGoodsNo()).andEqualTo("isDel", (Object)Boolean.FALSE);
                criteria.andEqualTo("merchantId", (Object)merchantId);
                Goods goods = (Goods)this.goodsMapper.selectOneByExample((Object)goodsExa);
                if (goods != null) {
                    marketActivityGoods1.setGoodsPrice(goods.getSalePrice());
                    marketActivityGoods1.setGoodsAssembleNum(goods.getAssembleNum());
                    marketActivityGoods1.setGoodsName(goods.getGoodsName());
                    marketActivityGoods1.setGoodsPicUrl(goods.getCoverImg());
                    marketActivityGoods1.setActivityPersonNum(marketActivity.getActivityPersonNum());
                }
            });
            list.addAll(marketActivityGoods);
        });
        return list;
    }

    public List<MarketActivityGoods> getActivityGoodListByMe(String userNo, Integer merchantId) {
        log.info("\u6211\u7684\u62fc\u56e2  \u53c2\u6570\u4e3a===>{},{}", (Object)userNo, (Object)merchantId);
        ArrayList<MarketActivityGoods> list = new ArrayList<MarketActivityGoods>();
        List orders = this.marketActivityOrdersMapper.getActivityOrderListByMe(userNo, merchantId);
        long now = new Date().getTime();
        for (MarketActivityOrders marketActivityOrders : orders) {
            Example hdGoodExa = new Example(MarketActivityGoods.class);
            hdGoodExa.createCriteria().andEqualTo("marketActivityNo", (Object)marketActivityOrders.getActivityNo()).andEqualTo("goodsNo", (Object)marketActivityOrders.getGoodsNo());
            List marketActivityGoods = this.marketActivityGoodsMapper.selectByExample((Object)hdGoodExa);
            marketActivityGoods.forEach(activityGoods -> {
                Example goodsExa = new Example(Goods.class);
                Example.Criteria criteria = goodsExa.createCriteria();
                criteria.andEqualTo("goodsNo", (Object)activityGoods.getGoodsNo()).andEqualTo("isDel", (Object)Boolean.FALSE);
                criteria.andEqualTo("merchantId", (Object)merchantId);
                Goods goods = (Goods)this.goodsMapper.selectOneByExample((Object)goodsExa);
                if (goods != null) {
                    activityGoods.setGoodsPrice(goods.getSalePrice());
                    activityGoods.setGoodsAssembleNum(goods.getAssembleNum());
                    activityGoods.setGoodsName(goods.getGoodsName());
                    activityGoods.setGoodsPicUrl(goods.getCoverImg());
                    activityGoods.setActivityPersonNum(marketActivityOrders.getActivityPersonNum());
                    activityGoods.setOrdersStatus(marketActivityOrders.getOrdersStatus());
                    activityGoods.setActivityOrdersId(marketActivityOrders.getId());
                }
                long leftTime = DateUtils.addHours((Date)marketActivityOrders.getGmtCreate(), (int)marketActivityOrders.getActivityTermValidity()).getTime() - now;
                activityGoods.setLeftTime(Long.valueOf(leftTime));
            });
            list.addAll(marketActivityGoods);
        }
        log.info("\u6211\u7684\u62fc\u56e2  \u7ed3\u679c\u4e3a===>{}", list);
        return list;
    }

    public MarketActivityOrders getOrdersDetail(Integer activityOrdersId, Integer merchantId) {
        MarketActivityOrders marketActivityOrders = (MarketActivityOrders)this.marketActivityOrdersMapper.selectByPrimaryKey((Object)activityOrdersId);
        Example goodsQu = new Example(Goods.class);
        Example.Criteria criteria = goodsQu.createCriteria();
        criteria.andEqualTo("goodsNo", (Object)marketActivityOrders.getGoodsNo()).andEqualTo("isDel", (Object)Boolean.FALSE);
        criteria.andEqualTo("merchantId", (Object)merchantId);
        Goods goods = (Goods)this.goodsMapper.selectOneByExample((Object)goodsQu);
        marketActivityOrders.setAssembleNum(goods.getAssembleNum());
        Example skuQuery = new Example(GoodsSkuDetail.class);
        skuQuery.createCriteria().andEqualTo("skuNo", (Object)marketActivityOrders.getGoodsSkuNo()).andEqualTo("goodsId", (Object)goods.getId());
        GoodsSkuDetail skuDetail = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOneByExample((Object)skuQuery);
        Example ordersQuery = new Example(Orders.class);
        ordersQuery.createCriteria().andEqualTo("orderNo", (Object)marketActivityOrders.getOrdersNo());
        Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)ordersQuery);
        marketActivityOrders.setOrders(orders);
        Example example = new Example(OrderItems.class);
        example.createCriteria().andEqualTo("orderId", (Object)orders.getId()).andEqualTo("goodsSkuNo", (Object)skuDetail.getSkuNo());
        OrderItems orderItems = (OrderItems)this.orderItemsMapper.selectOneByExample((Object)example);
        skuDetail.setPayNum(orderItems.getSaleQuantity());
        marketActivityOrders.setGoodsSkuDetail(skuDetail);
        Example example1 = new Example(MarketActivityOrders.class);
        example1.createCriteria().andEqualTo("launchUserNo", (Object)marketActivityOrders.getLaunchUserNo()).andEqualTo("activityOrdersNo", (Object)marketActivityOrders.getActivityOrdersNo()).andEqualTo("tradeStatus", (Object)"1");
        List marketActivityOrdersList = this.marketActivityOrdersMapper.selectByExample((Object)example1);
        Example activityQuery = new Example(MarketActivity.class);
        activityQuery.createCriteria().andEqualTo("activityNo", (Object)marketActivityOrders.getActivityNo());
        MarketActivity marketActivity = (MarketActivity)this.marketActivityMapper.selectOneByExample((Object)activityQuery);
        int surplusPersonNum = marketActivity.getActivityPersonNum() - marketActivityOrdersList.size();
        surplusPersonNum = surplusPersonNum < 0 ? 0 : surplusPersonNum;
        marketActivityOrders.setSurplusPersonNum(Integer.valueOf(surplusPersonNum));
        ArrayList mapList = new ArrayList();
        long now = new Date().getTime();
        marketActivityOrdersList.forEach(marketActivityOrders1 -> {
            Long startTime = marketActivityOrders1.getGmtCreate().getTime() + (long)(marketActivity.getActivityTermValidity() * 60 * 60 * 1000);
            HashMap<String, String> map = new HashMap<String, String>();
            User loginUserInfo = new User();
            loginUserInfo.setUserNo(marketActivityOrders1.getUserNo());
            loginUserInfo.setMerchantId(orders.getMerchantId());
            log.info("\u652f\u4ed8\u6210\u529f\u5230\u4f1a\u5458\u4e2d\u5fc3\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5165\u53c2:[{}]", JSONObject.toJSON((Object)loginUserInfo));
            User user = this.bizvaneInterface.getMemberInfo(loginUserInfo);
            log.info("\u652f\u4ed8\u6210\u529f\u5230\u4f1a\u5458\u4e2d\u5fc3\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u8fd4\u53c2:[{}]", JSONObject.toJSON((Object)user));
            if (user == null) {
                throw new CustomException("\u4ece\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f1a\u5458\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (marketActivityOrders1.getLaunchUserNo().equals(user.getUserNo())) {
                map.put("type", "main");
                map.put("headUrl", user.getHeadImgUrl());
                Long surplusTime = startTime;
                marketActivityOrders.setSurplusTime(surplusTime);
            } else {
                map.put("type", "servant");
                map.put("headUrl", user.getHeadImgUrl());
            }
            mapList.add(map);
        });
        marketActivityOrders.setPersonUrl(mapList);
        return marketActivityOrders;
    }

    public Map getGoodsDetail(String goodsNo, Integer merchantId, String marketActivityNo, String userNo) {
        Example example = new Example(Goods.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("goodsNo", (Object)goodsNo).andEqualTo("isDel", (Object)Boolean.FALSE);
        Integer goodsId = ((Goods)this.goodsMapper.selectOneByExample((Object)example)).getId();
        Goods condition = new Goods();
        condition.setMerchantId(merchantId);
        condition.setId(goodsId);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        Goods goods = (Goods)this.goodsService.findOneByCondition((Serializable)condition);
        Example activityGoodsCondition = new Example(MarketActivityGoods.class);
        activityGoodsCondition.createCriteria().andEqualTo("goodsNo", (Object)goodsNo).andEqualTo("marketActivityNo", (Object)marketActivityNo);
        MarketActivityGoods marketActivityGoods = (MarketActivityGoods)this.marketActivityGoodsMapper.selectOneByExample((Object)activityGoodsCondition);
        goods.setAssemblePrice(marketActivityGoods.getAmount());
        map.put("goods", goods);
        if (null == goods) {
            throw new CustomException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        RichText byId = this.richTextService.findById(goods.getIntroId());
        map.put("richText", byId);
        List goodsSkus = this.goodsService.getGoodsSkus(goodsId);
        goodsSkus.forEach(g -> g.setStock(Integer.valueOf(g.getIsEnabled() != false ? g.getStock() : 0)));
        map.put("goodsSkus", goodsSkus);
        if (!goods.getIsUniform().booleanValue()) {
            List goodsSpecRelations = this.goodsService.getGoodsSpecs(goodsId);
            map.put("goodsSpecs", goodsSpecRelations);
        }
        Example example1 = new Example(MarketActivity.class);
        example1.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("activityNo", (Object)marketActivityNo);
        MarketActivity marketActivity = (MarketActivity)this.marketActivityMapper.selectOneByExample((Object)example1);
        map.put("marketActivity", marketActivity);
        List marketActivityOrdersList = this.marketActivityOrdersMapper.selectAssemblingOrders(goodsNo);
        Iterator car = marketActivityOrdersList.iterator();
        block0: while (car.hasNext()) {
            MarketActivityOrders marketActivityOrders = (MarketActivityOrders)car.next();
            if (marketActivityOrders.getLaunchUserNo().equals(userNo)) {
                car.remove();
                continue;
            }
            Example orderQuery = new Example(MarketActivityOrders.class);
            orderQuery.createCriteria().andEqualTo("launchUserNo", (Object)marketActivityOrders.getLaunchUserNo()).andEqualTo("activityOrdersNo", (Object)marketActivityOrders.getActivityOrdersNo()).andEqualTo("tradeStatus", (Object)"1");
            List userOrders = this.marketActivityOrdersMapper.selectByExample((Object)orderQuery);
            log.info("\u67e5\u770buserOrder\u65e5\u5fd7:{}", (Object)JSONObject.toJSONString((Object)userOrders));
            int surplusPersonNum = marketActivity.getActivityPersonNum() - userOrders.size();
            surplusPersonNum = surplusPersonNum < 0 ? 0 : surplusPersonNum;
            marketActivityOrders.setSurplusPersonNum(Integer.valueOf(surplusPersonNum));
            if (surplusPersonNum == 0) {
                car.remove();
                continue;
            }
            ArrayList personMaps = new ArrayList();
            for (MarketActivityOrders activityOrders : userOrders) {
                HashMap<String, String> personMap = new HashMap<String, String>();
                User loginUserInfo = new User();
                loginUserInfo.setUserNo(activityOrders.getUserNo());
                loginUserInfo.setMerchantId(marketActivity.getMerchantId());
                User user = this.bizvaneInterface.getMemberInfo(loginUserInfo);
                if (activityOrders.getUserNo().equals(userNo)) {
                    car.remove();
                    continue block0;
                }
                log.info("\u6d3b\u52a8\u8ba2\u5355\u4e2d\u7684\u53c2\u56e2\u4eba\u5458\u5230\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u6570\u636e\u5165\u53c2:activityOrders:[{}]", JSONObject.toJSON((Object)activityOrders));
                if (user == null) {
                    log.warn("\u6d3b\u52a8\u8ba2\u5355\u4e2d\u7684\u53c2\u56e2\u4eba\u5458\u5230\u4f1a\u5458\u4e2d\u5fc3\u672a\u627e\u5230\u6570\u636e:\u8be5\u7528\u6237_[{}]", JSONObject.toJSON((Object)loginUserInfo));
                    throw new CustomException("\u6d3b\u52a8\u8ba2\u5355\u4e2d\u7684\u53c2\u56e2\u4eba\u5458\u5230\u4f1a\u5458\u4e2d\u5fc3\u672a\u627e\u5230\u6570\u636e");
                }
                if (activityOrders.getLaunchUserNo().equals(user.getUserNo())) {
                    Long startTime;
                    Long surplusTime = startTime = Long.valueOf(activityOrders.getGmtCreate().getTime() + (long)(marketActivity.getActivityTermValidity() * 60 * 60 * 1000));
                    Long currentTime = System.currentTimeMillis();
                    if (currentTime > surplusTime) {
                        car.remove();
                        continue block0;
                    }
                    marketActivityOrders.setSurplusTime(surplusTime);
                    personMap.put("type", "main");
                    personMap.put("headUrl", user.getHeadImgUrl());
                    marketActivityOrders.setLaunchUserHeadUrl(user.getHeadImgUrl());
                    marketActivityOrders.setLaunchUserName(user.getFullName());
                } else {
                    personMap.put("type", "servant");
                    personMap.put("headUrl", user.getHeadImgUrl());
                }
                personMaps.add(personMap);
            }
            marketActivityOrders.setPersonUrl(personMaps);
        }
        map.put("assemblingOrders", marketActivityOrdersList);
        return map;
    }

    public Orders confirm(Orders orders) {
        AssembleService.checkUserInfo((Orders)orders);
        AssembleService.checkGoodsItem((List)orders.getItems());
        AssembleService.checkActivityNo((String)orders.getActivityNo());
        orders.getItems().forEach(od -> od.setMerchantId(orders.getMerchantId()));
        Goods customGood = AssembleService.convertOrderItemsToGoods((List)orders.getItems());
        List customSkuInfo = AssembleService.convertOrderItemsToSkuInfo((List)orders.getItems());
        Goods dbGoods = this.checkAndGetGoodsInfo(customGood);
        Example example = new Example(MarketActivityGoods.class);
        example.createCriteria().andEqualTo("marketActivityNo", (Object)orders.getActivityNo()).andEqualTo("goodsNo", (Object)dbGoods.getGoodsNo());
        MarketActivityGoods marketActivityGoods = (MarketActivityGoods)this.marketActivityGoodsMapper.selectOneByExample((Object)example);
        if (marketActivityGoods == null) {
            throw new CustomException("\u6b64\u5546\u54c1\u4e0d\u5b58\u5728\u4e8e\u6d3b\u52a8");
        }
        int launch = this.checkAssembleIsFull(orders);
        if (launch != 0) {
            MarketActivityOrdersPOExample marketActivityOrdersPOExample = new MarketActivityOrdersPOExample();
            marketActivityOrdersPOExample.createCriteria().andValidEqualTo(Integer.valueOf(1)).andActivityOrdersNoEqualTo(orders.getActivityOrdersNo()).andLaunchUserNoEqualTo(orders.getUserNo()).andMerchantIdEqualTo(orders.getMerchantId());
            List marketActivityOrdersPOS = this.marketActivityOrdersPOMapper.selectByExample(marketActivityOrdersPOExample);
            if (!CollectionUtils.isEmpty((Collection)marketActivityOrdersPOS)) {
                throw new CustomException("\u4e0d\u80fd\u53c2\u4e0e\u81ea\u5df1\u53d1\u8d77\u7684\u62fc\u56e2");
            }
        }
        orders.setOrderAmount(marketActivityGoods.getAmount());
        orders.setPayAmount(marketActivityGoods.getAmount());
        List dbSkuInfo = this.checkAndGetSkuInfo(customSkuInfo);
        dbSkuInfo.forEach(sku -> {
            sku.setGoodsName(dbGoods.getGoodsName());
            sku.setGoodsNo(dbGoods.getGoodsNo());
            sku.setGoodsId(dbGoods.getId());
            sku.setCommission(dbGoods.getCommissionRate().multiply(new BigDecimal("0.01")).multiply(sku.getSalesPrice()).multiply(new BigDecimal(customGood.getCount())));
            sku.setShippingMode(dbGoods.getShippingMode());
            orders.getItems().forEach(orderItems -> {
                if (orderItems.getGoodsSkuNo().equals(sku.getSkuNo())) {
                    orderItems.setGoodsImg(sku.getSkuImg());
                    if (sku.getIsUniform().booleanValue()) {
                        orderItems.setGoodsImg(dbGoods.getCoverImg());
                    }
                    orderItems.setGoodsNo(sku.getGoodsNo());
                    orderItems.setMarketPrice(sku.getMarketPrice());
                    orderItems.setSalePrice(sku.getSalesPrice());
                    orderItems.setItemsAmount(marketActivityGoods.getAmount());
                    orderItems.setItemsPayAmount(marketActivityGoods.getAmount());
                    orderItems.setWepayAmount(marketActivityGoods.getAmount());
                    orderItems.setItemsActiveDeduction(BigDecimal.ZERO);
                    orderItems.setItemsPointDeduction(BigDecimal.ZERO);
                    orderItems.setCommission(sku.getCommission());
                    orderItems.setShippingMode(sku.getShippingMode());
                }
            });
        });
        log.info("\u62fc\u56e2 confirm orders => {}", (Object)JSONObject.toJSONString((Object)orders));
        return orders;
    }

    public static void checkUserInfo(Orders orders) {
        if (orders.getUserId() == null && StringUtils.isEmpty((Object)orders.getUserNo())) {
            throw new UserException("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
    }

    public static void checkActivityNo(String activityNo) {
        if (StringUtils.isEmpty((Object)activityNo)) {
            throw new CustomException("\u6d3b\u52a8\u7f16\u53f7\u4e3a\u7a7a");
        }
    }

    public static void checkGoodsItem(List<OrderItems> items) {
        if (items == null || items.isEmpty()) {
            throw new CustomException("\u672a\u9009\u62e9\u5546\u54c1");
        }
        if (items.size() > 1) {
            throw new CustomException("\u62fc\u56e2\u5546\u54c1\u53ea\u80fd\u9009\u62e91\u4ef6");
        }
        for (OrderItems item : items) {
            if (item.getSaleQuantity() > 0) continue;
            throw new CustomException("\u5546\u54c1" + item.getGoodsName() + "[" + item.getGoodsSkuName() + "]\u6570\u91cf\u6709\u8bef");
        }
    }

    public static Goods convertOrderItemsToGoods(List<OrderItems> orderItems) {
        Goods goods = new Goods();
        for (OrderItems orderItem : orderItems) {
            goods.setId(orderItem.getGoodsId());
            goods.setMerchantId(orderItem.getMerchantId());
            goods.setGoodsName(orderItem.getGoodsName());
            goods.setSpecNames(orderItem.getGoodsName());
            goods.setId(orderItem.getGoodsId());
            Integer quantity = orderItem.getSaleQuantity();
            goods.setCount(quantity);
        }
        return goods;
    }

    public static List<GoodsSkuDetail> convertOrderItemsToSkuInfo(List<OrderItems> orderItems) {
        ArrayList<GoodsSkuDetail> skuInfoList = new ArrayList<GoodsSkuDetail>();
        for (OrderItems item : orderItems) {
            GoodsSkuDetail skuInfo = new GoodsSkuDetail();
            skuInfo.setGoodsId(item.getGoodsId());
            skuInfo.setSkuNo(item.getGoodsSkuNo());
            skuInfo.setGoodsName(item.getGoodsName());
            skuInfo.setStock(item.getSaleQuantity());
            skuInfoList.add(skuInfo);
        }
        return skuInfoList;
    }

    private Goods checkAndGetGoodsInfo(Goods customGoodsList) {
        Integer merchantId = null;
        ArrayList<Integer> goodsIdList = new ArrayList<Integer>();
        goodsIdList.add(customGoodsList.getId());
        merchantId = customGoodsList.getMerchantId();
        Goods queryCondition = new Goods();
        queryCondition.setIdList(goodsIdList);
        queryCondition.setMerchantId(merchantId);
        List dbGoodsInfo = this.goodsService.findByConditionWithGoodsId(queryCondition);
        if (dbGoodsInfo == null) {
            throw new CustomException("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Goods extract = this.extractSkuInfoFromSkuList(customGoodsList, dbGoodsInfo);
        if (extract == null) {
            throw new CustomException("\u5546\u54c1[" + customGoodsList.getGoodsName() + "]\u4e0d\u5b58\u5728");
        }
        if (!extract.getIsShelved().booleanValue()) {
            throw new CustomException("\u5546\u54c1[" + customGoodsList.getGoodsName() + "]\u5df2\u4e0b\u67b6");
        }
        if (!extract.getLimitation().equals(0) && extract.getLimitation().compareTo(customGoodsList.getCount()) < 0) {
            throw new CustomException("\u5546\u54c1[" + customGoodsList.getGoodsName() + "]\u6bcf\u5355\u9650\u8d2d" + extract.getLimitation() + "\u4ef6");
        }
        return (Goods)dbGoodsInfo.get(0);
    }

    private List<GoodsSkuDetail> checkAndGetSkuInfo(List<GoodsSkuDetail> customSkuInfoList) {
        List dbSkuInfoList = this.goodsSkuDetailService.findByCondition(customSkuInfoList);
        InputValidator.checkEmpty((Collection)dbSkuInfoList, (String)"\u5546\u54c1");
        for (GoodsSkuDetail customSku : customSkuInfoList) {
            GoodsSkuDetail extract = this.extractSkuInfoFromSkuList(customSku, dbSkuInfoList);
            Assert.notNull((Object)extract, (String)("\u5546\u54c1[" + this.getGoodsSkuName(customSku) + "]\u4e0d\u5b58\u5728"));
            if (extract.getStock() - customSku.getStock() >= 0) continue;
            throw new CustomException("\u5546\u54c1[" + this.getGoodsSkuName(customSku) + "]\u5e93\u5b58\u4e0d\u8db3");
        }
        return dbSkuInfoList;
    }

    private GoodsSkuDetail extractSkuInfoFromSkuList(GoodsSkuDetail goodsSkuDetail, List<GoodsSkuDetail> goodsSkuDetailList) {
        for (GoodsSkuDetail gsd : goodsSkuDetailList) {
            if (!gsd.getSkuNo().equals(goodsSkuDetail.getSkuNo()) || !gsd.getGoodsId().equals(goodsSkuDetail.getGoodsId())) continue;
            return gsd;
        }
        return null;
    }

    private Goods extractSkuInfoFromSkuList(Goods qg, List<Goods> queryResultGoods) {
        for (Goods goods : queryResultGoods) {
            if (!goods.getId().equals(qg.getId())) continue;
            return goods;
        }
        return null;
    }

    private String getGoodsSkuName(GoodsSkuDetail orderItems) {
        return orderItems.getGoodsName() + " " + orderItems.getSkuNo();
    }

    @Transactional
    public Map addOrders(Orders orders) {
        log.info("AssembleService#addOrders orders:{}", (Object)JSONObject.toJSONString((Object)orders));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String key = String.format("user:%s:add_order", orders.getUserId());
        if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"").booleanValue()) {
            log.info("\u7528\u6237ID {} \u4e0b\u5355\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41", (Object)orders.getUserId());
            throw new CustomException("\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
        }
        this.stringRedisTemplate.expire((Object)key, 10L, TimeUnit.SECONDS);
        AssembleService.checkOrdersShippingInfo((Orders)orders);
        Orders newOrder = this.confirm(orders);
        List stockResponse = this.goodsSkuDetailService.inventoryReduction(AssembleService.convertOrderItemsToSkuInfo((List)newOrder.getItems()));
        if (!stockResponse.isEmpty()) {
            StringBuffer sb = new StringBuffer("\u5546\u54c1");
            stockResponse.forEach(s -> sb.append(s.getGoodsName()).append("[").append(s.getSkuNo()).append("] "));
            sb.append("\u5e93\u5b58\u4e0d\u8db3");
            throw new CustomException(sb.toString());
        }
        newOrder = OrdersBuilder.getBuilder((Orders)newOrder).build();
        Integer marketActivityGoodsId = null;
        for (OrderItems items : newOrder.getItems()) {
            Example example = new Example(MarketActivityGoods.class);
            example.createCriteria().andEqualTo("marketActivityNo", (Object)newOrder.getActivityNo()).andEqualTo("goodsNo", (Object)items.getGoodsNo());
            MarketActivityGoods marketActivityGoods = (MarketActivityGoods)this.marketActivityGoodsMapper.selectOneByExample((Object)example);
            if (marketActivityGoods == null) {
                throw new CustomException("\u6b64\u5546\u54c1\u4e0d\u5b58\u5728\u4e8e\u6d3b\u52a8");
            }
            marketActivityGoodsId = marketActivityGoods.getId();
            items.setItemsPayAmount(marketActivityGoods.getAmount());
            BigDecimal orderPayAmount = orders.getPayAmount() == null ? BigDecimal.ZERO : orders.getPayAmount();
            newOrder.setPayAmount(orderPayAmount.add(items.getItemsPayAmount()));
        }
        newOrder.setOrderAmount(orders.getPayAmount());
        newOrder.setOrdersActivityType(String.valueOf(OrderActivityTypeEnum.PIT.getCode()));
        String launchUserNo = "";
        String activityOrdersNo = "";
        if (StringUtils.isEmpty((Object)newOrder.getLaunchUserNo())) {
            launchUserNo = newOrder.getUserNo();
            activityOrdersNo = "PT" + DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss") + RandomCodeUtil.randCode((int)8);
        } else {
            launchUserNo = newOrder.getLaunchUserNo();
            activityOrdersNo = newOrder.getActivityOrdersNo();
        }
        MarketActivityOrders marketActivityOrders = new MarketActivityOrders();
        marketActivityOrders.setActivityOrdersNo(activityOrdersNo);
        marketActivityOrders.setActivityNo(newOrder.getActivityNo());
        marketActivityOrders.setOrdersNo(newOrder.getOrderNo());
        marketActivityOrders.setGoodsNo(((OrderItems)newOrder.getItems().get(0)).getGoodsNo());
        marketActivityOrders.setGoodsName(((OrderItems)newOrder.getItems().get(0)).getGoodsName());
        marketActivityOrders.setGoodsSkuNo(((OrderItems)newOrder.getItems().get(0)).getGoodsSkuNo());
        marketActivityOrders.setGoodsSkuName(((OrderItems)newOrder.getItems().get(0)).getGoodsSkuName());
        marketActivityOrders.setActivityOrdersType("1");
        marketActivityOrders.setOrdersStatus("0");
        marketActivityOrders.setUserNo(newOrder.getUserNo());
        marketActivityOrders.setLaunchUserNo(launchUserNo);
        marketActivityOrders.setGmtCreate(new Date());
        marketActivityOrders.setGoodsId(((OrderItems)newOrder.getItems().get(0)).getGoodsId());
        marketActivityOrders.setMerchantId(newOrder.getMerchantId());
        marketActivityOrders.setMarketActivityGoodsId(marketActivityGoodsId);
        this.marketActivityOrdersMapper.insertSelective((Object)marketActivityOrders);
        newOrder.setMarketActivityOrdersId(marketActivityOrders.getId());
        newOrder = this.getOfflineInfo(newOrder);
        log.info("insert order info...{}", (Object)JSONObject.toJSONString((Object)newOrder));
        this.ordersMapper.insertSelective((Object)newOrder);
        for (OrderItems orderItems : newOrder.getItems()) {
            orderItems.setOrderId(newOrder.getId());
            orderItems.setOrderNo(newOrder.getOrderNo());
        }
        this.orderItemsMapper.insertList(newOrder.getItems());
        log.info("insert order successfully ! ");
        Config config = new Config();
        config.setMerchantId(newOrder.getMerchantId());
        Config oneByCondition = (Config)this.configService.findOneByCondition((Serializable)config);
        String appid = newOrder.getAppid();
        Long userId = newOrder.getUserId();
        Integer orderId = newOrder.getId();
        this.scheduledThreadPoolExecutor.schedule(() -> {
            log.info("close order {} schedule start ...", (Object)orders.getOrderNo());
            this.ordersService.cancel(appid, userId, orderId, null);
        }, (long)oneByCondition.getAwaitOrderPayMinute().intValue(), TimeUnit.MINUTES);
        map.put("ordersId", newOrder.getId());
        map.put("activityOrdersId", marketActivityOrders.getId());
        return map;
    }

    public Orders getOfflineInfo(Orders newOrder) {
        ArrayList<SysDimSkuPoDto> param = new ArrayList<SysDimSkuPoDto>();
        CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
        companyBrandRelation.setMerchantId(newOrder.getMerchantId());
        companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne((Object)companyBrandRelation);
        for (OrderItems item : newOrder.getItems()) {
            SysDimSkuPoDto dto = new SysDimSkuPoDto();
            Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)item.getGoodsId());
            dto.setProductCode(goods.getGoodsNo());
            dto.setSkuCode(item.getGoodsSkuNo());
            dto.setSysBrandId(companyBrandRelation.getMerchantId());
            dto.setSysCompanyId(companyBrandRelation.getCompanyId());
            param.add(dto);
        }
        List list = new ArrayList<Orders>();
        list.add(newOrder);
        try {
            list = this.offLineInfoHandlerServiceImpl.queryOfflineMemberInfoOrders(companyBrandRelation, list);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return (Orders)list.get(0);
    }

    private int checkAssembleIsFull(Orders orders) {
        List collect;
        log.info("\u62fc\u56e2\u8ba2\u5355\u5224\u65ad\u662f\u5426\u5df2\u6ee1=============");
        MarketActivityOrders mao = new MarketActivityOrders();
        if (StringUtils.isEmpty((Object)orders.getActivityOrdersNo())) {
            return 0;
        }
        mao.setLaunchUserNo(orders.getLaunchUserNo());
        mao.setActivityNo(orders.getActivityNo());
        mao.setActivityOrdersNo(orders.getActivityOrdersNo());
        mao.setTradeStatus("1");
        List select = this.marketActivityOrdersMapper.select((Object)mao);
        log.info("\u62fc\u56e2\u6210\u5458\u53c2\u6570:[{}]", JSONObject.toJSON((Object)select));
        MarketActivity ma = new MarketActivity();
        ma.setActivityNo(orders.getActivityNo());
        ma.setActivityStatus(Boolean.valueOf(true));
        ma.setActivityType("1");
        ma = (MarketActivity)this.marketActivityMapper.selectOne((Object)ma);
        if (ma == null) {
            throw new CustomException("\u6d3b\u52a8\u672a\u627e\u5230");
        }
        if (!CollectionUtils.isEmpty((Collection)select) && !CollectionUtils.isEmpty(collect = select.stream().filter(e -> "1".equals(e.getOrdersStatus())).collect(Collectors.toList()))) {
            List userNos = collect.stream().map(e -> e.getUserNo()).collect(Collectors.toList());
            log.info("\u62fc\u56e2\u6210\u5458\u4eba\u6570:[{}]", (Object)collect.size());
            if (collect.size() >= ma.getActivityPersonNum()) {
                log.warn("\u6d3b\u52a8\u53c2\u4e0e\u4eba\u6570\u5df2\u6ee1_\u6d3b\u52a8\u7f16\u53f7:[{}],\u6709\u6548\u7684\u53c2\u4e0e\u4eba\u5206\u522b\u662f:", (Object)orders.getActivityNo(), (Object)userNos.toString());
                throw new CustomException("\u6d3b\u52a8\u53c2\u4e0e\u4eba\u6570\u5df2\u6ee1,\u4e0d\u80fd\u53c2\u56e2");
            }
        }
        return 1;
    }

    public static void checkOrdersShippingInfo(Orders orders) {
        InputValidator.checkEmpty((Object)orders.getShippingName(), (String)"\u6536\u8d27\u4eba\u59d3\u540d");
        InputValidator.checkEmpty((Object)orders.getShippingMobile(), (String)"\u624b\u673a\u53f7\u7801");
        InputValidator.checkEmpty((Object)orders.getShippingProvince(), (String)"\u7701\u4efd");
        InputValidator.checkEmpty((Object)orders.getShippingCity(), (String)"\u57ce\u5e02");
        InputValidator.checkEmpty((Object)orders.getShippingDistrict(), (String)"\u5730\u533a");
        InputValidator.checkEmpty((Object)orders.getShippingAddress(), (String)"\u8be6\u7ec6\u5730\u5740");
    }

    public void cancel(String activityOrdersNo) {
        log.info("assemble cancel\u8fdb\u5165:{}", (Object)activityOrdersNo);
        Example example = new Example(MarketActivityOrders.class);
        example.createCriteria().andEqualTo("activityOrdersNo", (Object)activityOrdersNo);
        List marketActivityOrdersList = this.marketActivityOrdersMapper.selectByExample((Object)example);
        if (!CollectionUtils.isEmpty((Collection)marketActivityOrdersList)) {
            MarketActivity ma = new MarketActivity();
            ma.setActivityNo(((MarketActivityOrders)marketActivityOrdersList.get(0)).getActivityNo());
            ma = (MarketActivity)this.marketActivityMapper.selectOne((Object)ma);
            marketActivityOrdersList = marketActivityOrdersList.stream().filter(e -> "1".equals(e.getTradeStatus())).collect(Collectors.toList());
            if (marketActivityOrdersList.size() == ma.getActivityPersonNum().intValue()) {
                return;
            }
            log.info("\u62fc\u56e2\u6709\u6548\u671f\u8fc7\u671f\uff0c\u672a\u5b8c\u6210\u7684\u62fc\u56e2\u8ba2\u5355\u9700\u8981\u9000\u6b3e\u3002\u6d3b\u52a8\u8ba2\u5355\u7f16\u53f7\u4e3a{}", (Object)activityOrdersNo);
            for (MarketActivityOrders marketActivityOrders : marketActivityOrdersList) {
                Example orderItemCondif = new Example(OrderItems.class);
                orderItemCondif.createCriteria().andEqualTo("orderNo", (Object)marketActivityOrders.getOrdersNo());
                List orderItemsList = this.orderItemsMapper.selectByExample((Object)orderItemCondif);
                if (orderItemsList.size() <= 0) continue;
                orderItemsList.forEach(orderItems -> {
                    Example example1 = new Example(WechatMchNew.class);
                    example1.createCriteria().andEqualTo("merchantId", (Object)orderItems.getMerchantId());
                    WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example1);
                    if (mchNew == null) {
                        throw new CustomException("\u54c1\u724cID:" + orderItems.getMerchantId() + ",\u672a\u64cd\u4f5c\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e");
                    }
                    WechatMp wechatMp = new WechatMp();
                    wechatMp.setAppid(mchNew.getAppId());
                    WechatMch wechatMch = new WechatMch();
                    wechatMch.setMchKey(mchNew.getMchKey());
                    wechatMch.setMchNo(mchNew.getMchNo());
                    wechatMch.setP12(mchNew.getP12());
                    Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
                    RefundApplyRequest refundApplyRequest = new RefundApplyRequest();
                    refundApplyRequest.setOutTradeNo(orderItems.getOrderNo());
                    refundApplyRequest.setOutRefundNo(marketActivityOrders.getId().toString());
                    refundApplyRequest.setRefundFee(Integer.valueOf(orderItems.getItemsPayAmount().multiply(new BigDecimal("100")).intValue()));
                    refundApplyRequest.setOpUserId("admin");
                    refundApplyRequest.setRefundDesc("\u62fc\u56e2\u6709\u6548\u671f\u8fc7\u671f,\u7533\u8bf7\u9000\u6b3e");
                    refundApplyRequest.setNotifyUrl((String)this.wechatProperties.getUrls().get("activity-refund-notify"));
                    refundApplyRequest.setRefundAccount(RefundAccount.REFUND_SOURCE_UNSETTLED_FUNDS);
                    Example ordersExample = new Example(Orders.class);
                    ordersExample.createCriteria().andEqualTo("orderNo", (Object)orderItems.getOrderNo());
                    Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)ordersExample);
                    refundApplyRequest.setTotalFee(Integer.valueOf(orders.getPayAmount().multiply(new BigDecimal("100")).intValue()));
                    log.info("\u5fae\u4fe1\u9000\u6b3e\u8bf7\u6c42\u4f53===>{}", (Object)JSONObject.toJSONString((Object)refundApplyRequest));
                    try {
                        RefundApplyResponse refundApplyResponse = wepay.refund().apply(refundApplyRequest);
                        log.info("wexin pay refund result => {}", (Object)JSONObject.toJSONString((Object)refundApplyResponse));
                    }
                    catch (WepayException e) {
                        log.warn(e.getMessage(), (Throwable)e);
                        throw new CustomException(e.getMessage());
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage(), (Throwable)e);
                    }
                });
            }
        }
    }

    public void updateActivityRefund(Integer activityOrdersId, String ordersNo) {
        Example ordersExample = new Example(Orders.class);
        Boolean ifCloseOrder = true;
        ordersExample.createCriteria().andEqualTo("orderNo", (Object)ordersNo);
        Orders orders = (Orders)this.ordersMapper.selectOneByExample((Object)ordersExample);
        if (orders.getOrdersActivityType().equals("2")) {
            Example orderItemCondif = new Example(OrderItems.class);
            orderItemCondif.createCriteria().andEqualTo("orderNo", (Object)ordersNo);
            List orderItemsList = this.orderItemsMapper.selectByExample((Object)orderItemCondif);
            if (orderItemsList.size() > 0) {
                OrderItems orderItems = (OrderItems)orderItemsList.get(0);
                Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)orderItems.getGoodsId());
                Integer num = goods.getAssembleNum();
                log.info("\u8fd4\u8fd8\u524d\u7684\u5df2\u62fc\u6570\u91cf{}", (Object)num);
                if (num >= orderItems.getSaleQuantity()) {
                    goods.setAssembleNum(Integer.valueOf(num - orderItems.getSaleQuantity()));
                    this.goodsMapper.updateByPrimaryKeySelective((Object)goods);
                }
                Example example = new Example(GoodsSkuDetail.class);
                example.createCriteria().andEqualTo("skuNo", (Object)orderItems.getGoodsSkuNo()).andEqualTo("goodsId", (Object)orderItems.getGoodsId());
                GoodsSkuDetail skuDetail = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOneByExample((Object)example);
                if (skuDetail != null) {
                    Integer stock = skuDetail.getStock() + orderItems.getSaleQuantity();
                    log.info("\u8fd4\u8fd8\u540e\u7684\u5e93\u5b58\u4e3a{}", (Object)stock);
                    skuDetail.setStock(stock);
                    this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)skuDetail);
                }
                orderItems.setRefundStatus(RefundStatus.SUCCESS);
                orderItems.setGmtModified(new Date());
                this.orderItemsMapper.updateByPrimaryKeySelective((Object)orderItems);
                RefundOrder refundOrder = new RefundOrder();
                refundOrder.setOrderNo(orders.getOrderNo());
                List refundList = this.refundOrderMapper.select((Object)refundOrder);
                if (CollectionUtils.isEmpty((Collection)refundList)) {
                    this.generateRefundOrder(orders, orderItems);
                }
                for (OrderItems item : orderItemsList) {
                    if (RefundStatus.SUCCESS.equals((Object)item.getRefundStatus())) continue;
                    ifCloseOrder = false;
                    break;
                }
                OrdersPO closeOrdersPO = new OrdersPO();
                closeOrdersPO.setId(orders.getId());
                closeOrdersPO.setGmtModified(new Date());
                if (ifCloseOrder.booleanValue()) {
                    closeOrdersPO.setOrderStatus(OrdersStatusEnum.FAIL.toString());
                } else {
                    closeOrdersPO.setOrderStatus(OrdersStatusEnum.REFUND.toString());
                }
                log.info("updateActivityRefund closeOrdersPO is :{}", (Object)closeOrdersPO);
                this.ordersPOMapper.updateByPrimaryKeySelective(closeOrdersPO);
            }
        }
        MarketActivityOrders marketActivityOrders = (MarketActivityOrders)this.marketActivityOrdersMapper.selectByPrimaryKey((Object)activityOrdersId);
        marketActivityOrders.setOrdersStatus("2");
        marketActivityOrders.setGmtModified(new Date());
        this.marketActivityOrdersMapper.updateByPrimaryKeySelective((Object)marketActivityOrders);
    }

    private void generateRefundOrder(Orders orders, OrderItems orderItems) {
        RefundOrder refundOrder = new RefundOrder();
        Date date = new Date();
        refundOrder.setOrderNo(orders.getOrderNo());
        refundOrder.setMerchantId(orders.getMerchantId());
        refundOrder.setUserId(orders.getUserId());
        refundOrder.setUserName(orders.getUserName());
        refundOrder.setUserNo(orders.getUserNo());
        refundOrder.setItemId(orderItems.getId());
        refundOrder.setRefundAt(date);
        refundOrder.setGmtCreate(date);
        refundOrder.setGmtModified(date);
        refundOrder.setAuditStatus(new Byte("1"));
        refundOrder.setAuditAt(new Date());
        refundOrder.setAuditor("\u62fc\u56e2\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
        refundOrder.setRefundQuantity(orderItems.getSaleQuantity());
        refundOrder.setRefundNo(DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss") + RandomCodeUtil.randCode((int)10));
        refundOrder.setItemAmout(orderItems.getItemsPayAmount());
        refundOrder.setRefundIntegral(Integer.valueOf(0));
        refundOrder.setRefundBalance(BigDecimal.ZERO);
        log.info("\u8ba2\u5355\u9000\u6b3e\u7684\u91d1\u989d\uff1a{}", (Object)orderItems.getWepayAmount());
        refundOrder.setRefundAmount(orderItems.getWepayAmount());
        this.refundOrderMapper.insertSelective((Object)refundOrder);
        orderItems.setRefundStatus(RefundStatus.SUCCESS);
        this.orderItemsMapper.updateByPrimaryKeySelective((Object)orderItems);
        Orders param = new Orders();
        param.setId(orders.getId());
        param.setOrderStatus(OrdersStatusEnum.FAIL);
        this.ordersMapper.updateByPrimaryKeySelective((Object)param);
    }

    public Map getAssemblePicUrl(Integer merchantId) {
        HashMap map = new HashMap();
        HashMap<String, String> assemble = new HashMap<String, String>();
        HashMap<String, String> bargain = new HashMap<String, String>();
        Example example = new Example(Config.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        Config config = (Config)this.configMapper.selectOneByExample((Object)example);
        assemble.put("picUrl", config.getAssembleHeadUrl());
        assemble.put("videoUrl", config.getAssembleVideoUrl());
        bargain.put("picUrl", config.getBargainHeadUrl());
        bargain.put("videoUrl", config.getBargainVideoUrl());
        map.put("assemble", assemble);
        map.put("bargain", bargain);
        return map;
    }

    public void assembleOrdersOfflineHandler(String orderNo) {
        log.info("\u62fc\u56e2\u8ba2\u5355\u6210\u56e2\u63a8\u9001handler\u8fdb\u5165");
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setOrdersNo(orderNo);
        mao = (MarketActivityOrders)this.marketActivityOrdersMapper.selectOne((Object)mao);
        if (mao != null) {
            MarketActivityOrders maot = new MarketActivityOrders();
            maot.setActivityOrdersNo(mao.getActivityOrdersNo());
            List assembleOrders = this.marketActivityOrdersMapper.select((Object)maot);
            if (!CollectionUtils.isEmpty((Collection)assembleOrders)) {
                List ordersNos = assembleOrders.stream().map(e -> e.getOrdersNo()).collect(Collectors.toList());
                log.info("\u6210\u56e2\u51c6\u5907\u63a8\u9001\u7ebf\u4e0b\u7684\u8ba2\u5355\u53f7\u6709:[{}]", JSON.toJSON(ordersNos));
                List orders = this.collectOrdersInfo(ordersNos);
                orders.stream().forEach(e -> {
                    MallLogs mallLogs = new MallLogs();
                    String s = null;
                    try {
                        s = this.bizvaneInterface.notifyPaidOrderInfoOffLine(e);
                    }
                    catch (Exception f) {
                        mallLogs.setReason(f.getMessage());
                        log.warn("\u65b0\u589e\u8ba2\u5355\u63a8\u9001\u7ebf\u4e0b\u5931\u8d25:msg:[{}]_[{}]", (Object)f.getMessage(), e);
                        this.mallLogsService.doRecord(e, mallLogs);
                    }
                    Orders od = new Orders();
                    od.setId(e.getId());
                    if (!StringUtils.isEmpty((Object)s)) {
                        Integer result = "success".equals(s) ? 1 : 2;
                        od.setSynOfflineState(result);
                        if (od.getSynOfflineState() != null && od.getSynOfflineState().equals(2)) {
                            mallLogs.setReason("\u8c03\u7528\u8fde\u63a5\u5668\u63a5\u53e3\u5931\u8d25");
                            this.mallLogsService.doRecord(e, mallLogs);
                        }
                    } else {
                        od.setSynOfflineState(Integer.valueOf(2));
                    }
                    this.ordersMapper.updateByPrimaryKeySelective((Object)od);
                    log.info("\u6210\u56e2\u8ba2\u5355\u63a8\u9001\u7ebf\u4e0b\u6210\u529f");
                });
            }
        }
    }

    private List<Orders> collectOrdersInfo(List<String> ordersNos) {
        return ordersNos.stream().map(f -> {
            Orders orders = new Orders();
            orders.setOrderNo(f);
            orders = this.ordersMapper.selectOrdersDetailById((Object)orders);
            CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
            companyBrandRelation.setMerchantId(orders.getMerchantId());
            companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne((Object)companyBrandRelation);
            orders.setSysCompanyId(companyBrandRelation.getCompanyId());
            for (OrderItems e : orders.getItems()) {
                GoodsSpec goodsSpec;
                String[] split;
                String specIds = e.getSpecIds();
                if (com.wmeimob.fastboot.util.StringUtils.isEmpty((Object)specIds) || (split = specIds.split(",")) == null || split.length <= 0) continue;
                if (split.length >= 1) {
                    goodsSpec = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey((Object)split[0]);
                    e.setSpecCode(goodsSpec.getSpecCode());
                }
                if (split.length < 2) continue;
                goodsSpec = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey((Object)split[1]);
                e.setSpecCode(e.getSpecCode() + "," + goodsSpec.getSpecCode());
            }
            return orders;
        }).collect(Collectors.toList());
    }
}

