/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.wx_template;

import com.wmeimob.fastboot.bizvane.enums.WXMsgTemplate.WXMsgTemplateTypeEnum;
import com.wmeimob.fastboot.bizvane.service.qdqm.QdqmService;
import com.wmeimob.fastboot.bizvane.service.wx_msg_notice.WXMsgNoticeService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"wxTemplate"})
public class WxTemplateController {
    private static final Logger log = LoggerFactory.getLogger(WxTemplateController.class);
    @Autowired
    private WXMsgNoticeService wxMsgNoticeService;
    @Autowired
    private QdqmService qdqmService;

    @PostMapping(value={"getTemplate"})
    public ResponseData searchTemplateByMerchantId(@RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="templateType", required=false) Integer templateType, @RequestParam(value="goodsId", required=false) Integer goodsId) {
        log.info("WxTemplateController searchTemplateByMerchantId merchantId:{}", (Object)merchantId);
        merchantId = this.qdqmService.replaceMerchantId(goodsId, merchantId);
        if (templateType == null) {
            templateType = WXMsgTemplateTypeEnum.SECKILL_NOTICE.getCode();
        }
        return ResponseUtil.getSuccessData((Object)this.wxMsgNoticeService.searchTemplateByMerchantId(merchantId, templateType));
    }

    @PostMapping(value={"getTemplates"})
    public ResponseData searchTemplatesByMerchantId(@RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="goodsId", required=false) Integer goodsId) {
        log.info("WxTemplateController searchTemplatesByMerchantId merchantId:{}", (Object)merchantId);
        merchantId = this.qdqmService.replaceMerchantId(goodsId, merchantId);
        return ResponseUtil.getSuccessData((Object)this.wxMsgNoticeService.searchTemplatesByMerchantId(merchantId));
    }
}

