/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.seckill;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.config.BizvaneSecurityContext;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsSecKillVisitRecordPOMapper;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillStatisticalService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillGoodsStatisticalVisitRequestVO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"marketActivityGoodsSecKillStatistical"})
public class MarketActivitySecKillGoodsStatisticalController {
    private static final Logger log = LoggerFactory.getLogger(MarketActivitySecKillGoodsStatisticalController.class);
    @Autowired
    private MarketActivitySecKillStatisticalService marketActivitySecKillStatisticalService;
    @Resource
    private MarketActivityGoodsSecKillVisitRecordPOMapper goodsSecKillVisitRecordPOMapper;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;

    @PostMapping(value={"activitySecKillVisit"})
    public ResponseData activitySecKillVisit(@RequestHeader Integer merchantId, @RequestBody MarketActivitySecKillGoodsStatisticalVisitRequestVO vo) {
        log.info("MarketActivitySecKillStatisticalController activitySecKillVisit vo:{},merchantId:{}", JSON.toJSON((Object)vo), (Object)merchantId);
        vo.setMerchantId(merchantId);
        User user = BizvaneSecurityContext.getUser();
        vo.setUserNo(user.getUserNo());
        vo.setOpenId(user.getOpenid());
        vo.setSysBrandId(this.companyBrandRelationService.getBrandIdByMerchantId(merchantId));
        if (vo.getMarketActivityGoodsSeckillId() == null) {
            log.info("\u6d3b\u52a8\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            return ResponseUtil.getFailedMsg((String)"\u6d3b\u52a8\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getMarketActivityId() == null) {
            log.info("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
            return ResponseUtil.getFailedMsg((String)"\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.marketActivitySecKillStatisticalService.checkGoodsVisitRecord(vo)) {
            log.info("\u5546\u54c1\u5df2\u7ecf\u88ab\u8be5\u7528\u6237\u6d4f\u89c8\u8fc7");
            return ResponseUtil.getSuccessData((Object)"\u7edf\u8ba1\u5b8c\u6210 \u5546\u54c1\u5df2\u7ecf\u88ab\u8be5\u7528\u6237\u6d4f\u89c8\u8fc7");
        }
        return this.marketActivitySecKillStatisticalService.goodsSecKillVisit(vo);
    }
}

