/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.seckill;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.dto.FreightCalcResponse;
import com.wmeimob.fastboot.bizvane.service.seckill.MarketActivitySecKillService;
import com.wmeimob.fastboot.bizvane.service.seckill.SecKillOrderService;
import com.wmeimob.fastboot.bizvane.service.seckill.SecKillService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityGoodsSecKillRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityGoodsSecKillResponseVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivitySecKillGoodDetailResponseVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityTheLatestRequestVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityTheLatestResponseVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityTodayVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.order.SecKillOrdersConfirmVO;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"marketActivitySecKill"})
public class MarketActivitySecKillController {
    private static final Logger log = LoggerFactory.getLogger(MarketActivitySecKillController.class);
    @Autowired
    private MarketActivitySecKillService marketActivitySecKillService;
    @Autowired
    private SecKillService secKillService;
    @Autowired
    private SecKillOrderService secKillOrderService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private final String MARKET_ACTIVITY_SEC_KILL_ORDER_KEY = "market_orders:sec_kill_add:%s";

    @GetMapping(value={"queryMarketActivityMomentToday"})
    public ResponseData<MarketActivityTodayVO> queryMarketActivityMomentToday(@RequestHeader(value="merchantId") Integer merchantId) {
        log.info("MarketActivitySecKillController_queryMarketActivityMomentToday_request:{}", (Object)JSON.toJSONString((Object)merchantId));
        ResponseData marketActivityTodayVOResponseData = this.marketActivitySecKillService.queryMarketActivityMomentToday(merchantId);
        log.info("MarketActivitySecKillController_queryMarketActivityMomentToday_response:{}", (Object)JSON.toJSONString((Object)marketActivityTodayVOResponseData));
        return marketActivityTodayVOResponseData;
    }

    @PostMapping(value={"queryMarketActivityGoodsSecKillByMomentId"})
    public ResponseData<MarketActivityGoodsSecKillResponseVO> queryMarketActivityGoodsSecKillByMomentId(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody MarketActivityGoodsSecKillRequestVO requestVO) {
        log.info("MarketActivitySecKillController_queryMarketActivityGoodsSecKillByMomentId_request:{}", (Object)JSON.toJSONString((Object)merchantId));
        ResponseData marketActivityGoodsSecKillResponseVOResponseData = this.marketActivitySecKillService.queryMarketActivityGoodsSecKillByMomentId(requestVO, merchantId);
        log.info("MarketActivitySecKillController_queryMarketActivityGoodsSecKillByMomentId_response:{}", (Object)JSON.toJSONString((Object)marketActivityGoodsSecKillResponseVOResponseData));
        return marketActivityGoodsSecKillResponseVOResponseData;
    }

    @GetMapping(value={"getGoodsDetail"})
    public ResponseData<MarketActivitySecKillGoodDetailResponseVO> getGoodsDetail(@RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="goodsId") Integer goodsId, @RequestParam(value="marketActivityGoodsSecKillId") Integer marketActivityGoodsSecKillId) {
        log.info("MarketActivitySecKillController_getGoodsDetail_request:{}", (Object)JSON.toJSONString((Object)new Object[]{merchantId, goodsId, marketActivityGoodsSecKillId}));
        ResponseData marketActivitySecKillGoodDetailResponseVOResponseData = this.secKillService.goodDetail(merchantId, marketActivityGoodsSecKillId);
        log.info("MarketActivitySecKillController_getGoodsDetail_response:{}", (Object)JSON.toJSONString((Object)marketActivitySecKillGoodDetailResponseVOResponseData));
        return marketActivitySecKillGoodDetailResponseVOResponseData;
    }

    @PostMapping(value={"confirm"})
    public ResponseData<SecKillOrdersConfirmVO> secKillOrderConfirm(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody SecKillOrdersConfirmVO requestVO) {
        log.info("MarketActivitySecKillController_secKillOrderConfirm_request:{}", (Object)JSON.toJSONString((Object)requestVO));
        SecKillOrdersConfirmVO secKillOrdersConfirmVO = null;
        try {
            secKillOrdersConfirmVO = this.secKillOrderService.confirmOrder(requestVO);
        }
        catch (Exception e) {
            log.error("\u79d2\u6740confirm\u5931\u8d25:{}", (Throwable)e);
            return ResponseUtil.getFailedMsg((String)e.getMessage());
        }
        ResponseData successData = ResponseUtil.getSuccessData((Object)secKillOrdersConfirmVO);
        log.info("MarketActivitySecKillController_secKillOrderConfirm_response:{}", (Object)JSON.toJSONString((Object)successData));
        return successData;
    }

    @PostMapping(value={"confirmOK"})
    public ResponseData<SecKillOrdersConfirmVO> secKillOrderConfirmOK(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody SecKillOrdersConfirmVO requestVO) {
        log.info("MarketActivitySecKillController_secKillOrderConfirmOK_request:{}", (Object)JSON.toJSONString((Object)requestVO));
        String userNo = requestVO.getUserNo();
        if (StringUtils.isBlank((String)userNo)) {
            return ResponseUtil.getFailedMsg((String)"\u8ba2\u5355\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u4fe1\u606f!");
        }
        String key = String.format("market_orders:sec_kill_add:%s", userNo);
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (value != null) {
            throw new MallWechatException("\u8bf7\u52ff\u91cd\u590d\u7ed3\u7b97\u8ba2\u5355");
        }
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)userNo);
        SecKillOrdersConfirmVO secKillOrdersConfirmVO = null;
        try {
            secKillOrdersConfirmVO = this.secKillOrderService.confirmOrderOK(requestVO);
        }
        catch (Exception e) {
            log.error("\u79d2\u6740confirmOK\u5931\u8d25:{}", (Throwable)e);
            this.stringRedisTemplate.delete((Object)key);
            return ResponseUtil.getFailedMsg((String)e.getMessage());
        }
        ResponseData successData = ResponseUtil.getSuccessData((Object)secKillOrdersConfirmVO);
        this.stringRedisTemplate.delete((Object)key);
        log.info("MarketActivitySecKillController_ssecKillOrderConfirmOK_response:{}", (Object)JSON.toJSONString((Object)successData));
        return successData;
    }

    @PostMapping(value={"getFreight"})
    public ResponseData<FreightCalcResponse> getFreight(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody SecKillOrdersConfirmVO requestVO) {
        log.info("MarketActivitySecKillController_getFreight_request:{}", (Object)JSON.toJSONString((Object)requestVO));
        FreightCalcResponse freight = null;
        try {
            freight = this.secKillOrderService.getFreight(requestVO);
        }
        catch (Exception e) {
            log.error("\u79d2\u6740getFreight\u5931\u8d25:{}", (Throwable)e);
            return ResponseUtil.getFailedMsg((String)e.getMessage());
        }
        ResponseData successData = ResponseUtil.getSuccessData((Object)freight);
        log.info("MarketActivitySecKillController_getFreight_response:{}", (Object)JSON.toJSONString((Object)successData));
        return successData;
    }

    @PostMapping(value={"queryTheLatestMarketActivity"})
    public ResponseData<MarketActivityTheLatestResponseVO> queryTheLatestMarketActivity(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody MarketActivityTheLatestRequestVO requestVO) {
        log.info("MarketActivitySecKillController_queryTheLatestMarketActivity_request:{}", (Object)JSON.toJSONString((Object)requestVO));
        ResponseData successData = this.marketActivitySecKillService.queryTheLatestMarketActivity(requestVO, merchantId);
        log.info("MarketActivitySecKillController_queryTheLatestMarketActivity_response:{}", (Object)JSON.toJSONString((Object)successData));
        return successData;
    }
}

