/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.logistics;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.service.logistics.LogisticsService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.logistics.CourierCompanyCodeResponseVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.CourierCompanyInfoResponseVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.CourierInfo;
import com.wmeimob.fastboot.bizvane.vo.logistics.LogisticsInfoDetailsResponseVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.QueryCourierCompanyByConditionVO;
import com.wmeimob.fastboot.bizvane.vo.logistics.QueryLogisticsInfoDetailsRequestVO;
import com.wmeimob.fastboot.util.InputValidator;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"logistics"})
public class LogisticsInfoController {
    private static final Logger log = LoggerFactory.getLogger(LogisticsInfoController.class);
    @Autowired
    private LogisticsService logisticsService;

    @GetMapping(value={"queryCourierCompany"})
    public ResponseData<List<CourierCompanyInfoResponseVO>> queryCourierCompany() {
        log.info("LogisticsInfoController#queryCourierCompany");
        ResponseData data = new ResponseData();
        try {
            List courierCompanyInfoList = this.logisticsService.queryCourierCompany();
            data.setData((Object)courierCompanyInfoList);
            return data;
        }
        catch (Exception e) {
            log.warn("\u67e5\u8be2\u5feb\u9012\u516c\u53f8\u7f16\u53f7\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            data.setCode(SysResponseEnum.FAILED.getCode());
            data.setMessage(e.getMessage());
            return data;
        }
    }

    @PostMapping(value={"queryCourierCompanyByCondition"})
    public ResponseData<List<CourierCompanyInfoResponseVO>> queryCourierCompanyByCondition(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody QueryCourierCompanyByConditionVO queryCourierCompanyByConditionVo) {
        log.info("LogisticsInfoController#queryCourierCompanyByCondition\uff1a{}", (Object)JSON.toJSONString((Object)queryCourierCompanyByConditionVo));
        ResponseData data = new ResponseData();
        try {
            queryCourierCompanyByConditionVo.setMerchantId(merchantId);
            List courierCompanyInfoList = this.logisticsService.queryCourierCompanyByCondition(queryCourierCompanyByConditionVo);
            data.setData((Object)courierCompanyInfoList);
            return data;
        }
        catch (Exception e) {
            log.warn("\u67e5\u8be2\u5feb\u9012\u516c\u53f8\u7f16\u53f7\u5f02\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            data.setCode(SysResponseEnum.FAILED.getCode());
            data.setMessage(e.getMessage());
            return data;
        }
    }

    @PostMapping(value={"queryLogisticsInfoDetails"})
    public ResponseData<LogisticsInfoDetailsResponseVO> queryLogisticsInfoDetails(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody QueryLogisticsInfoDetailsRequestVO requestVo) {
        log.info("LogisticsInfoController#queryLogisticsInfoDetails\u5165\u53c2:[{}]_[{}]", (Object)merchantId, (Object)JSON.toJSONString((Object)requestVo));
        try {
            requestVo.setMerchantId(merchantId);
            InputValidator.checkEmpty((Object)requestVo.getCourierCode(), (String)"\u5feb\u9012\u5355\u53f7");
            CourierCompanyCodeResponseVO codeResponseVo = this.logisticsService.courierCompanyCodeTirByCourierCode(requestVo.getCourierCode());
            log.info("codeResponseVo:{}", (Object)JSON.toJSONString((Object)codeResponseVo));
            List courierInfoList = codeResponseVo.getCourierInfoList();
            log.info("courierInfoList:{}", (Object)JSON.toJSONString((Object)courierInfoList));
            if (CollectionUtils.isEmpty((Collection)courierInfoList)) {
                return new ResponseData(100, "\u6839\u636e\u5355\u53f7\u6ca1\u6709\u8bc6\u522b\u5230\u5feb\u9012\u516c\u53f8", null);
            }
            LogisticsInfoDetailsResponseVO logisticsInfoDetailsResponseVo = null;
            for (CourierInfo courierInfo : courierInfoList) {
                List data;
                String comCode = courierInfo.getComCode();
                if (org.apache.commons.lang.StringUtils.isEmpty((String)comCode)) continue;
                requestVo.setCourierCompanyCode(comCode);
                try {
                    logisticsInfoDetailsResponseVo = this.logisticsService.queryLogisticsInfoDetailsBy100(requestVo);
                }
                catch (Exception e) {
                    log.info(e.getMessage());
                }
                if (logisticsInfoDetailsResponseVo == null || CollectionUtils.isEmpty((Collection)(data = logisticsInfoDetailsResponseVo.getData())) || CollectionUtils.isEmpty((Collection)data)) continue;
                break;
            }
            log.info("logisticsInfoDetailsResponseVo====>:{}", (Object)JSON.toJSONString(logisticsInfoDetailsResponseVo));
            ResponseData responseVoResponseData = new ResponseData();
            if (StringUtils.isEmpty(logisticsInfoDetailsResponseVo)) {
                return new ResponseData(100, "\u6682\u65e0\u7269\u6d41\u4fe1\u606f\uff0c\u8bf7\u60a8\u7a0d\u540e\u518d\u67e5!", null);
            }
            List data = logisticsInfoDetailsResponseVo.getData();
            if (CollectionUtils.isEmpty((Collection)data)) {
                responseVoResponseData.setCode(100);
                responseVoResponseData.setMessage(JSON.toJSONString((Object)logisticsInfoDetailsResponseVo));
                responseVoResponseData.setData(null);
                return responseVoResponseData;
            }
            return new ResponseData((Object)logisticsInfoDetailsResponseVo);
        }
        catch (Exception e) {
            log.warn("\u901a\u8fc7\u5feb\u9012100\u516c\u5171API\u83b7\u53d6\u7269\u6d41\u5f02\u8be6\u60c5\u5e38:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            return new ResponseData(100, e.getMessage(), null);
        }
    }
}

