/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.goodsgroup;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.service.goodsgroup.GoodsGroupService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.GoodsGroup.GoodsGroupSearchGoodsListRequestVO;
import com.wmeimob.fastboot.bizvane.vo.GoodsGroup.GoodsGroupSearchListResponseVO;
import com.wmeimob.fastboot.util.InputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/groud"})
public class GoodsGroupController {
    private static final Logger log = LoggerFactory.getLogger(GoodsGroupController.class);
    @Autowired
    private GoodsGroupService goodsGroupService;

    @PostMapping(value={"searchGoodsGroupList"})
    public ResponseData searchGoodsGroupList(@RequestHeader Integer merchantId, @RequestBody GoodsGroupSearchListResponseVO vo) {
        log.info("GoodsGroupClassController searchGoodsGroupList merchantID:{} vo:{}", (Object)merchantId, JSON.toJSON((Object)vo));
        vo.setMerchantId(merchantId);
        PageInfo pageInfo = this.goodsGroupService.searchGoodsGroupList(vo);
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    @PostMapping(value={"searchGoodsList"})
    public ResponseData searchGoodsList(@RequestHeader Integer merchantId, @RequestBody GoodsGroupSearchGoodsListRequestVO vo) {
        log.info("GoodsGroupClassController checkGroupInUsed merchantID:{} vo:{}", (Object)merchantId, JSON.toJSON((Object)vo));
        if (vo.getId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u5220\u9664\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setMerchantId(merchantId);
        PageInfo goodsPOS = this.goodsGroupService.searchGoodsList(vo, Boolean.FALSE);
        log.info("\u67e5\u8be2\u5230\u8be5\u5206\u7ec4\u5206\u7c7b\u4fe1\u606f\u4e0b\u7684\u5546\u54c1\u662f:{}", JSON.toJSON((Object)goodsPOS));
        return ResponseUtil.getSuccessData((Object)goodsPOS);
    }

    @GetMapping(value={"groudList"})
    public ResponseData getGroudList(@RequestHeader Integer merchantId) {
        log.info("GoodsGroupClassController searchGoodsGroupList merchantID:{} vo:{}", (Object)merchantId);
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        return ResponseUtil.getSuccessData((Object)this.goodsGroupService.getGroudList(merchantId));
    }
}

