/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller.customization;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.service.customization.CustomizationService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.customization.CategoryListByGoodIdSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryDetailListSearchRequestVO;
import com.wmeimob.fastboot.bizvane.vo.customization.CustomizationCategoryListSearchRequestVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"customization"})
public class CustomizationController {
    private static final Logger log = LoggerFactory.getLogger(CustomizationController.class);
    @Autowired
    private CustomizationService customizationService;

    @GetMapping(value={"searchCustomizationList"})
    public ResponseData searchCustomizationList(@RequestHeader Integer merchantId) {
        log.info("CustomizationController#searchCustomizationList:{}", (Object)merchantId);
        return this.customizationService.searchCustomizationList(merchantId);
    }

    @PostMapping(value={"searchCategoryList"})
    public ResponseData searchCategoryList(@RequestHeader Integer merchantId, @RequestBody CustomizationCategoryListSearchRequestVO vo) {
        log.info("CustomizationController#searchCategoryList merchantId:{},vo:{}", (Object)merchantId, (Object)JSON.toJSONString((Object)vo));
        if (vo.getCustomizationRelationId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u4f20\u5165\u7684\u5b9a\u5236\u670d\u52a1\u5173\u8054\u5173\u7cfbid\u4e3a\u7a7a");
        }
        if (vo.getPageJudge() == null) {
            vo.setPageJudge(Boolean.FALSE);
        }
        vo.setMerchantId(merchantId);
        return this.customizationService.searchCategoryList(vo);
    }

    @PostMapping(value={"searchCategoryDetailList"})
    public ResponseData searchCategoryDetailList(@RequestHeader Integer merchantId, @RequestBody CustomizationCategoryDetailListSearchRequestVO vo) {
        log.info("CustomizationController#searchCategoryDetailList vo:{}", (Object)JSON.toJSONString((Object)vo));
        if (vo.getCustomizationCategoryId() == null) {
            return ResponseUtil.getFailedMsg((String)"\u76ee\u5f55\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.customizationService.searchCategoryDetailList(vo);
    }

    @GetMapping(value={"searchCategoryListByGoodId"})
    public ResponseData searchCategoryListByGoodId(@RequestParam Integer goodsId, @RequestParam Integer customizationRelationId) {
        CategoryListByGoodIdSearchRequestVO vo = new CategoryListByGoodIdSearchRequestVO();
        vo.setGoodId(goodsId);
        vo.setCustomizationRelationId(customizationRelationId);
        log.info("CustomizationController#searchCategoryListByGoodId");
        return this.customizationService.searchCategoryListByGoodId(vo);
    }
}

