/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.wmeimob.fastboot.bizvane.config.BizvaneSecurityContext;
import com.wmeimob.fastboot.bizvane.dto.SysParamConfigurationDTO;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.wrapper.BrowseWrapperService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.vo.ViewGoodsVO;
import com.wmeimob.fastboot.bizvane.vo.ViewShareGoodsInformRequestVO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"enterprise"})
public class WxEnterpriseController {
    private static final Logger log = LoggerFactory.getLogger(WxEnterpriseController.class);
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Autowired
    private WechatMchNewMapper wechatMchNewMapper;
    @Autowired
    private BrowseWrapperService browseWrapperService;

    @PostMapping(value={"goods"})
    public List<Goods> getGoodsList(@RequestBody String jsonObject) {
        List goods = (List)JSON.parseObject((String)jsonObject, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (CollectionUtils.isEmpty((Collection)goods) || StringUtils.isEmpty((Object)((Goods)goods.get(0)).getMerchantId())) {
            return null;
        }
        log.info("\u5165\u53c2:merchantId:[{}],goodsList\u957f\u5ea6:[{}],goodsList:[{}]", new Object[]{goods.size(), ((Goods)goods.get(0)).getMerchantId(), JSON.toJSON((Object)goods)});
        Example example = new Example(Goods.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("merchantId", (Object)((Goods)goods.get(0)).getMerchantId());
        criteria.andEqualTo("isDel", (Object)false);
        criteria.andIn("goodsNo", (Iterable)goods.stream().map(e -> e.getGoodsNo()).collect(Collectors.toList()));
        goods = this.goodsMapper.selectByExample((Object)example);
        log.info("\u8fd4\u53c2:goodsList:[{}]", JSON.toJSON((Object)goods));
        return goods;
    }

    @PostMapping(value={"browse"})
    public void customerBrowse(@RequestBody String viewGoodsVO) {
        log.info("browse\u5206\u4eab\u5165\u53c2:[{}]", JSON.toJSON((Object)viewGoodsVO));
        try {
            User user = BizvaneSecurityContext.getUser();
            ViewGoodsVO vg = (ViewGoodsVO)JSON.parseObject((String)viewGoodsVO, ViewGoodsVO.class);
            WechatMchNew wm = new WechatMchNew();
            Example example = new Example(WechatMchNew.class);
            example.createCriteria().andEqualTo("appId", (Object)vg.getWxAppid());
            List wechatMchNews = this.wechatMchNewMapper.selectByExample((Object)example);
            if (CollectionUtils.isEmpty((Collection)wechatMchNews)) {
                log.warn("appid:[{}]", (Object)wm.getAppId());
                throw new UserException("appid\u5339\u914d\u4e0d\u5230\u6570\u636e");
            }
            wm = (WechatMchNew)wechatMchNews.get(0);
            vg.setVisitorImgs(vg.getAvatarUrl());
            vg.setVisitorNick(vg.getNickName());
            Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)vg.getGoodsId());
            vg.setGoodsName(goods.getGoodsName());
            CompanyBrandRelation companyBrandRelation = new CompanyBrandRelation();
            companyBrandRelation.setMerchantId(wm.getMerchantId());
            companyBrandRelation = (CompanyBrandRelation)this.companyBrandRelationMapper.selectOne((Object)companyBrandRelation);
            if (companyBrandRelation != null) {
                vg.setSysBrandId(companyBrandRelation.getMerchantId().intValue());
                vg.setSysCompanyId(companyBrandRelation.getCompanyId().intValue());
                try {
                    this.browseWrapperService.fillBrowse(vg, user);
                    this.bizvaneInterface.notifyBrowse(vg);
                }
                catch (Exception e) {
                    log.warn("\u6d4f\u89c8\u63a8\u9001\u4f01\u5fae\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
                }
            }
            ViewShareGoodsInformRequestVO build = ViewShareGoodsInformRequestVO.builder().goodsName(goods.getGoodsName()).goodsNo(vg.getGoodsNo()).memberCode(vg.getMemberCode()).staffCode(vg.getStaffCode()).goodsImg(vg.getGoodsImg()).salePrise(vg.getSalePrise()).shareTime(vg.getShareTime()).visitorNick(vg.getNickName()).visitorImgs(vg.getAvatarUrl()).sysStaffId(vg.getSysStaffId()).sysStoreId(vg.getSysStoreId()).goodsId(goods.getId()).sysCompanyId(Integer.valueOf(vg.getSysCompanyId())).build();
            try {
                this.browseWrapperService.fillBrowse(build, user);
                this.bizvaneInterface.viewShareGoodsInfo(build);
            }
            catch (Exception e) {
                log.warn("\u6d4f\u89c8\u5206\u4eab\u94fe\u63a5\u63a8\u9001\u4f01\u5fae\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            }
        }
        catch (Exception e) {
            log.warn("\u63a8\u9001\u4f01\u5fae\u5931\u8d25:msg:[{}],[{}]", (Object)e.getMessage(), (Object)e);
        }
    }

    @PostMapping(value={"getAppid"})
    public String getAppid(@RequestBody String sysBrandId) {
        return this.bizvaneInterface.getAppid(sysBrandId);
    }

    @PostMapping(value={"getParamConfiguration"})
    public ResponseData<SysParamConfigurationDTO> getParamConfiguration(@RequestHeader(value="appid") String appid) {
        return this.bizvaneInterface.getParamConfiguration(appid);
    }
}

