/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.config.BizvaneSecurityContext;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.dto.MallOpenCardRequestVo;
import com.wmeimob.fastboot.bizvane.dto.MallOpenCardResponseVo;
import com.wmeimob.fastboot.bizvane.dto.WxqyLoginResponseVO;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccounts;
import com.wmeimob.fastboot.bizvane.mapper.UserCommissionAccountsMapper;
import com.wmeimob.fastboot.bizvane.po.CompanyBrandRelationPO;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.UserLoginService;
import com.wmeimob.fastboot.bizvane.service.UserServiceImpl;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.bizvane.vo.BrowseVO;
import com.wmeimob.fastboot.core.context.RequestAttributeContext;
import com.wmeimob.fastboot.open.service.MiniprogramUserService;
import com.wmeimob.fastboot.starter.security.JwtAuthenticationFilter;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import me.hao0.wechat.core.Wechat;
import me.hao0.wechat.core.WechatBuilder;
import me.hao0.wechat.model.base.EncryptWatermark;
import me.hao0.wechat.model.base.JSCode2SessionResponse;
import me.hao0.wechat.model.user.MiniprogramUserPhoneInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"user"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Resource
    private JwtAuthenticationFilter jwtAuthenticationFilter;
    @Resource
    private UserServiceImpl userService;
    @Resource
    private MiniprogramUserService miniprogramUserService;
    @Resource
    private ConfigService configService;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private UserLoginService userLoginService;
    @Autowired
    private UserCommissionAccountsMapper userCommissionAccountsMapper;

    @PostMapping(value={"forward"})
    public String decodeEncryptoData(@RequestHeader(value="appid") String appid, @RequestHeader(value="brandId") Integer brandId, @RequestBody EncryptWatermark encryptWatermark) {
        return this.userLoginService.getUser(appid, brandId, encryptWatermark).get("decrypt").toString();
    }

    @PostMapping(value={"decodePhone"})
    public MiniprogramUserPhoneInfo decodePhone(@RequestHeader(value="appid") String appid, @RequestBody EncryptWatermark encryptWatermark) {
        log.info("decodePhone request:{}", (Object)JSON.toJSONString((Object)encryptWatermark));
        MiniprogramUserPhoneInfo miniprogramUserPhoneInfo = new MiniprogramUserPhoneInfo();
        try {
            Wechat wechat = WechatBuilder.newBuilder((String)appid).build();
            User user = (User)SecurityContext.getUser();
            encryptWatermark.setSessionKey(this.miniprogramUserService.get(appid, user.getOpenid()).getSession_key());
            miniprogramUserPhoneInfo = wechat.user().decodeEncryptUserPhoneInfo(encryptWatermark);
        }
        catch (Exception e) {
            log.info("decodePhone Exception:{}", (Throwable)e);
        }
        return miniprogramUserPhoneInfo;
    }

    @GetMapping(value={"info"})
    public User getUserInfo() {
        User user = (User)SecurityContext.getUser();
        User remote = this.bizvaneInterface.getMemberInfo(user);
        if (remote == null) {
            this.userService.mergeUserWithCache(user);
            log.info("info return :{}", (Object)JSON.toJSONString((Object)user));
            return user;
        }
        return remote;
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST, RequestMethod.GET})
    @Deprecated
    public Map<String, Object> getOpenid(@RequestHeader(value="appid") String appid, @RequestHeader(value="brandId") Integer brandId, @RequestParam(value="code") String code, @RequestParam(value="memberCode", defaultValue="defaultMC") String memberCode, @RequestParam(value="sysStoreId", defaultValue="") String sysStoreId, @RequestParam(value="sysStaffId", defaultValue="") String sysStaffId) {
        JSONObject config;
        log.info("UserController#login:appid:{},brandId:{},code:{},memberCode:{}", new Object[]{appid, brandId, code, memberCode});
        JSCode2SessionResponse openidAndSessionKey = this.bizvaneInterface.getSession(appid, code);
        log.info("UserController#login openidAndSessionKey:" + JSONObject.toJSONString((Object)openidAndSessionKey));
        this.miniprogramUserService.save(appid, openidAndSessionKey);
        BrowseVO browseVO = new BrowseVO();
        browseVO.setSysStoreId(sysStoreId);
        browseVO.setSysStaffId(sysStaffId);
        this.miniprogramUserService.saveBrowse(appid, openidAndSessionKey.getOpenid(), browseVO);
        User queryParams = User.builder().openid(openidAndSessionKey.getOpenid()).unionid(openidAndSessionKey.getUnionid()).appid(appid).brandId(brandId).build();
        HashMap<String, Object> map = new HashMap<String, Object>();
        User user = this.userService.findOneByCondition(queryParams);
        log.info("===queryParams22===>:{}", (Object)queryParams);
        user.setAppid(appid);
        map.put("user", user);
        log.info("\u767b\u5f55user:[{}]", (Object)JSONObject.toJSONString((Object)user));
        try {
            config = this.bizvaneInterface.getMiniprogramRedirectConfiguration(appid);
            map.put("miniprogramConfig", config);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            JSONObject config2 = new JSONObject();
            config2.put("appId", (Object)"wxe9f923caf2a6024e");
            config2.put("url", (Object)"/pages/index/index");
            map.put("miniprogramConfig", config2);
        }
        try {
            Integer companyStoreCategory = this.bizvaneInterface.getCompanyStoreCategory(brandId).getDouble("data").intValue();
            map.put("companyStoreCategory", companyStoreCategory);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5343\u5e97\u5343\u9762\u914d\u7f6e\u5931\u8d25:{}", (Throwable)e);
            map.put("companyStoreCategory", 0);
        }
        config = new Config();
        config.setMerchantId(user.getMerchantId());
        Config oneByCondition = (Config)this.configService.findOneByCondition((Serializable)config);
        if (oneByCondition == null) {
            throw new MallWechatException("\u5546\u6237\u672a\u914d\u7f6e\uff0c\u6682\u65f6\u65e0\u6cd5\u67e5\u770b");
        }
        map.put("miniprogramTitle", oneByCondition.getTitle());
        String token = this.jwtAuthenticationFilter.getJsonWebTokenHandler().generateToken((UserDetails)user);
        map.put("access_token", token);
        if (oneByCondition.getMarketPriceDisplay() != null) {
            map.put("marketPriceDisplay", oneByCondition.getMarketPriceDisplay());
        }
        log.info("oneByCondition:{}", (Object)JSON.toJSONString((Object)oneByCondition));
        if (oneByCondition.getSalesDisplay() != null) {
            map.put("salesDisplay", oneByCondition.getSalesDisplay());
        }
        if (StringUtils.isEmpty((Object)openidAndSessionKey.getUnionid())) {
            RequestAttributeContext.getResponse().setStatus(HttpStatus.ACCEPTED.value());
        }
        if (!StringUtils.isEmpty((Object)memberCode) && !memberCode.equals("defaultMC")) {
            log.info("\u8d70\u5165\u5206\u9500\u73af\u8282");
            User user1 = new User();
            user1.setMerchantId(user.getMerchantId());
            user1.setAppid(appid);
            user1.setUserNo(memberCode);
            User shareUser = this.bizvaneInterface.getMemberInfo(user1);
            log.info("\u5206\u4eab\u8005\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)shareUser));
            UserCommissionAccounts userCommissionAccounts = this.userCommissionAccountsMapper.selectUserCommissionAccountsByUserNo(memberCode);
            log.info("\u5206\u4eab\u8005\u7684\u5206\u9500\u8d26\u6237:{}", (Object)userCommissionAccounts);
            String userNo = user.getUserNo();
            if (!StringUtils.isEmpty((Object)userNo)) {
                UserCommissionAccounts newAccounts = this.userCommissionAccountsMapper.selectUserCommissionAccountsByUserNo(userNo);
                log.info("\u672c\u4eba\u7684\u5206\u9500\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)newAccounts));
                if (newAccounts != null && newAccounts.getPid() == null) {
                    this.userCommissionAccountsMapper.updatePidByUserNo(userNo, userCommissionAccounts.getId());
                }
            }
        }
        return map;
    }

    @PostMapping(value={"wxqyLogin"})
    public ResponseData<WxqyLoginResponseVO> wxqyLogin(@RequestParam(value="appid") String appid, @RequestParam(value="code") String code) {
        ResponseData wxqyLoginResponse = this.bizvaneInterface.wxqyLogin(appid, code);
        log.info("UserController#wxqyLogin wxqyLoginResponse:{}", (Object)JSON.toJSONString((Object)wxqyLoginResponse));
        return wxqyLoginResponse;
    }

    @PostMapping(value={"openCard"})
    public ResponseData<MallOpenCardResponseVo> openCard(@RequestHeader(value="appid") String appid, @RequestHeader(value="brandId") Integer brandId, @RequestBody MallOpenCardRequestVo requestVo) {
        log.info("UserController#openCard appid:{},brandId:{},requestVo:{}", new Object[]{appid, brandId, JSON.toJSONString((Object)requestVo)});
        CompanyBrandRelationPO companyBrandRelation = this.bizvaneInterface.queryCompanyBrandRelation(brandId);
        User userSession = BizvaneSecurityContext.getUser();
        try {
            JSCode2SessionResponse jsCode2SessionResponse = this.miniprogramUserService.get(userSession.getAppid(), userSession.getOpenid());
            requestVo.setUnionId(jsCode2SessionResponse.getUnionid());
        }
        catch (Exception e) {
            log.error("\u5fae\u5546\u57ce\u5f00\u5361\u83b7\u53d6unionId\u5931\u8d25:{}", (Throwable)e);
        }
        BrowseVO browseVO = new BrowseVO();
        browseVO.setSysStoreId(requestVo.getSysStoreId());
        browseVO.setSysStaffId(requestVo.getSysStaffId());
        this.miniprogramUserService.saveBrowse(appid, requestVo.getOpenId(), browseVO);
        String memberCode = requestVo.getMemberCode();
        requestVo.setSysCompanyId(Long.valueOf(companyBrandRelation.getCompanyId().longValue()));
        requestVo.setBrandId(Long.valueOf(brandId.longValue()));
        ResponseData mallOpenCardResponseVoResponseData = this.bizvaneInterface.openCard(requestVo, browseVO);
        if (SysResponseEnum.FAILED.getCode() == mallOpenCardResponseVoResponseData.getCode()) {
            return mallOpenCardResponseVoResponseData;
        }
        log.info("\u65b0\u5f00\u5361\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)mallOpenCardResponseVoResponseData));
        String resultString = JSON.toJSONString((Object)mallOpenCardResponseVoResponseData.getData());
        log.info("resultString:{}", (Object)resultString);
        MallOpenCardResponseVo mallOpenCardResponseVo = (MallOpenCardResponseVo)JSON.parseObject((String)resultString, MallOpenCardResponseVo.class);
        Integer merchantId = mallOpenCardResponseVo.getMerchantId().intValue();
        log.info("membercode\u4f20\u5165\u53c2\u65701\uff1a{}", (Object)JSONObject.toJSONString((Object)memberCode));
        String openId = requestVo.getOpenId();
        String token = this.generateToken(appid, brandId, openId, requestVo, mallOpenCardResponseVo);
        log.info("access_token:{}", (Object)token);
        mallOpenCardResponseVo.setAccess_token(token);
        if (!StringUtils.isEmpty((Object)memberCode)) {
            log.info("\u8d70\u5165\u5206\u9500\u73af\u8282");
            User user = new User();
            user.setMerchantId(merchantId);
            user.setAppid(appid);
            user.setUserNo(memberCode);
            User shareUser = this.bizvaneInterface.getMemberInfo(user);
            log.info("\u5206\u4eab\u8005\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)shareUser));
            UserCommissionAccounts userCommissionAccounts = this.userCommissionAccountsMapper.selectUserCommissionAccountsByUserNo(memberCode);
            log.info("\u5206\u4eab\u8005\u7684\u5206\u9500\u8d26\u6237:{}", (Object)userCommissionAccounts);
            String userNo = mallOpenCardResponseVo.getMemberCode();
            if (!StringUtils.isEmpty((Object)userNo)) {
                UserCommissionAccounts newAccounts = this.userCommissionAccountsMapper.selectUserCommissionAccountsByUserNo(userNo);
                log.info("\u672c\u4eba\u7684\u5206\u9500\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)newAccounts));
                if (newAccounts != null && newAccounts.getPid() == null) {
                    this.userCommissionAccountsMapper.updatePidByUserNo(userNo, userCommissionAccounts.getId());
                }
            }
        }
        mallOpenCardResponseVoResponseData.setData((Object)mallOpenCardResponseVo);
        return mallOpenCardResponseVoResponseData;
    }

    private String generateToken(String appid, Integer brandId, String opendId, MallOpenCardRequestVo requestVo, MallOpenCardResponseVo responseVo) {
        JSCode2SessionResponse openidAndSessionKey = this.miniprogramUserService.get(appid, opendId);
        User queryParams = User.builder().openid(openidAndSessionKey.getOpenid()).unionid(openidAndSessionKey.getUnionid()).appid(appid).brandId(brandId).build();
        User user = this.userService.findOneByCondition(queryParams, requestVo, responseVo);
        user.setAppid(appid);
        user.setOpenid(opendId);
        Long serviceStoreId = responseVo.getServiceStoreId();
        if (serviceStoreId != null) {
            user.setSysStoreId(serviceStoreId);
            try {
                String storeId;
                JSONObject storeResult = this.bizvaneInterface.getofflineStoreById(serviceStoreId.toString());
                if (storeResult != null && !StringUtils.isEmpty((Object)(storeId = storeResult.getString("storeId")))) {
                    user.setOfflineStoreId(storeId);
                }
            }
            catch (Exception e) {
                log.warn("\u83b7\u53d6offlineStoreId\u5931\u8d25:{}", (Throwable)e);
            }
        }
        this.miniprogramUserService.saveUser(appid, opendId, user);
        return this.jwtAuthenticationFilter.getJsonWebTokenHandler().generateToken((UserDetails)user);
    }

    @PostMapping(value={"logOut"})
    public ResponseData<Integer> logOut(@RequestParam(value="appid") String appid, @RequestParam(value="openid") String openid) {
        return this.miniprogramUserService.logOut(appid, openid);
    }
}

