/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.config.BizvaneProperties;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccountLogs;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccounts;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.UserCommissionAccountLogsService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.vo.CreateMiniprgmQRCodeRequestVO;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.fastboot.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/commission"})
public class UserCommissionController {
    private static final Logger log = LoggerFactory.getLogger(UserCommissionController.class);
    @Resource
    private UserCommissionService userCommissionService;
    @Resource
    private UserCommissionAccountLogsService userCommissionAccountLogsService;
    @Resource
    private WechatService wechatService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private BizvaneProperties bizvaneProperties;
    private static final String USER_WXA_CODE_KEY = "wxacode:appid:%s:userNo:%s";

    @GetMapping
    @PreAuthorize(value="hasRole('USER')")
    public UserCommissionAccounts getUserCommission() {
        User user = (User)SecurityContext.getUser();
        return (UserCommissionAccounts)this.userCommissionService.findById(user.getUserNo());
    }

    @GetMapping(value={"lower"})
    @PreAuthorize(value="hasRole('USER')")
    public List getLowerList() {
        User user = (User)SecurityContext.getUser();
        UserCommissionAccounts userCommissionAccounts = new UserCommissionAccounts();
        userCommissionAccounts.setUserNo(user.getUserNo());
        List byCondition = this.userCommissionService.findByCondition((Serializable)userCommissionAccounts);
        log.info("commission # lower User:{} result:{}", (Object)JSON.toJSONString((Object)user), (Object)JSON.toJSONString((Object)byCondition));
        return byCondition;
    }

    @GetMapping(value={"lower/{id}"})
    @PreAuthorize(value="hasRole('USER')")
    public List getLowerOrderList(@PathVariable(value="id") Integer accountId) {
        UserCommissionAccountLogs accountLogs = new UserCommissionAccountLogs();
        User user = (User)SecurityContext.getUser();
        accountLogs.setUserNo(user.getUserNo());
        accountLogs.setContributionAccountId(accountId);
        return this.userCommissionAccountLogsService.selectLowerOrderList(accountLogs);
    }

    @GetMapping(value={"log"})
    @PreAuthorize(value="hasRole('USER')")
    public List getLogList(UserCommissionAccountLogs userCommissionAccountLogs) {
        User user = (User)SecurityContext.getUser();
        userCommissionAccountLogs.setUserNo(user.getUserNo());
        return this.userCommissionAccountLogsService.findByCondition((Serializable)userCommissionAccountLogs);
    }

    @PostMapping
    @PreAuthorize(value="hasRole('USER')")
    public void withdrawal(UserCommissionAccountLogs userCommissionAccountLogs) {
        User user = (User)SecurityContext.getUser();
        userCommissionAccountLogs.setOpenId(user.getOpenid());
        userCommissionAccountLogs.setUserNo(user.getUserNo());
        userCommissionAccountLogs.setMerchantId(user.getMerchantId());
        this.userCommissionAccountLogsService.add((Serializable)userCommissionAccountLogs);
    }

    @PreAuthorize(value="hasRole('USER')")
    @PostMapping(value={"binding"})
    public void binding(String userNo) {
        if (userNo == null) {
            log.info("user no is null ");
            return;
        }
        User user = (User)SecurityContext.getUser();
        if (StringUtils.isEmpty((Object)user.getUserNo()) || StringUtils.isEmpty((Object)userNo)) {
            throw new UserException("\u4f1a\u5458\u7ed1\u5b9a\u53c2\u6570\u6709\u8bef");
        }
        userNo = userNo.replaceAll("USER", "");
        log.info("\u7ed1\u5b9a\u4f1a\u5458\u53c2\u6570 {} <==To==> {}", (Object)user.getUserNo(), (Object)userNo);
        this.userCommissionService.binding(user.getUserNo(), userNo);
    }

    @PostMapping(value={"wxa-code"})
    @PreAuthorize(value="hasRole('USER')")
    public JSONObject wxaCode(@RequestHeader(value="appid") String appid, @RequestHeader(value="merchantId") Long merchantId) {
        log.info("\u5206\u9500\u4e8c\u7ef4\u7801\u5165\u53c2:[{}]", (Object)appid);
        User user = (User)SecurityContext.getUser();
        String key = String.format(USER_WXA_CODE_KEY, appid, user.getUserNo());
        String cacheBase64Code = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (!StringUtils.isEmpty((Object)cacheBase64Code)) {
            JSONObject parse = (JSONObject)JSONObject.parse((String)cacheBase64Code);
            return parse;
        }
        CreateMiniprgmQRCodeRequestVO vo = new CreateMiniprgmQRCodeRequestVO();
        vo.setScene("USER" + user.getUserNo());
        vo.setPath("pages/shouye/main");
        vo.setSysBrandId(merchantId);
        vo.setType(Integer.valueOf(2));
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getGenerateQrcodeUrl();
        JSONObject qrCode = this.bizvaneInterface.generateQrCode(vo, url);
        if (qrCode.getInteger("code") == 0) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)qrCode.toJSONString(), 3L, TimeUnit.DAYS);
        }
        log.info("\u5206\u9500\u4e8c\u7ef4\u7801\u7ed3\u679c:[{}]", (Object)qrCode.toString());
        return qrCode;
    }
}

