/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.config.BizvaneSecurityContext;
import com.wmeimob.fastboot.bizvane.dto.OrdersCountInfo;
import com.wmeimob.fastboot.bizvane.dto.OrdersQueryInfo;
import com.wmeimob.fastboot.bizvane.entity.Collect;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.service.CollectService;
import com.wmeimob.fastboot.bizvane.service.CommentsService;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.bizvane.service.impl.SendMsgToQWServiceImpl;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.OrderStatusCountVO;
import com.wmeimob.fastboot.core.context.PageContext;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/center"})
@PreAuthorize(value="hasRole('USER')")
public class UserCenterController {
    private static final Logger log = LoggerFactory.getLogger(UserCenterController.class);
    @Resource
    private OrdersService ordersService;
    @Resource
    private RefundOrderService refundOrderService;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersService;
    @Resource
    private CommentsService commentsService;
    @Resource
    private CollectService collectService;
    @Resource
    private UserService userService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private SendMsgToQWServiceImpl sendMsgToQWService;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;

    @GetMapping(value={"/index"})
    public OrdersCountInfo index(@RequestHeader(value="merchantId") Integer merchantId) {
        User user = BizvaneSecurityContext.getUser();
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        InputValidator.checkEmpty((Object)user.getOpenid(), (String)"\u53c2\u6570");
        Orders orders = new Orders();
        orders.setWechatOpenid(user.getOpenid());
        orders.setMerchantId(merchantId);
        OrdersCountInfo ordersVo = this.ordersService.getCountOrders(orders);
        return ordersVo;
    }

    @GetMapping(value={"/order"})
    public PageInfo<Orders> getOrdersList(@RequestHeader(value="merchantId") Integer merchantId, Integer orderStatus) {
        User user = BizvaneSecurityContext.getUser();
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        InputValidator.checkEmpty((Object)user.getOpenid(), (String)"\u53c2\u6570");
        OrdersQueryInfo orders = new OrdersQueryInfo();
        orders.setSysBrandId(this.companyBrandRelationService.getBrandIdByMerchantId(merchantId));
        orders.setWechatOpenid(user.getOpenid());
        orders.setQueryStatus(orderStatus);
        orders.setUserNo(user.getUserNo());
        orders.setUserId(user.getUserId());
        PageContext.startPage();
        List getOrdersList = this.ordersService.getOrdersList(orders);
        return new PageInfo(getOrdersList);
    }

    @GetMapping(value={"/orderStatusCount"})
    public ResponseData getOrdersStatusSum(@RequestHeader(value="merchantId") Integer merchantId) {
        User user = BizvaneSecurityContext.getUser();
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        InputValidator.checkEmpty((Object)user.getOpenid(), (String)"\u53c2\u6570");
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("sysBrandId", this.companyBrandRelationService.getBrandIdByMerchantId(merchantId));
        query.put("openid", user.getOpenid());
        query.put("userId", user.getUserId());
        query.put("merchantId", merchantId);
        log.info("\u67e5\u8be2\u53c2\u6570{}", JSON.toJSON(query));
        OrderStatusCountVO orderStatusCountVO = this.ordersService.getOrdersStatusSum(query);
        log.info("getOrdersStatusSum_getOrdersStatusSum{}", (Object)JSON.toJSONString((Object)orderStatusCountVO));
        return ResponseUtil.getSuccessData((Object)orderStatusCountVO);
    }

    @GetMapping(value={"/order/detail/{id}"})
    public Orders getOrdersDetail(@PathVariable(value="id") Integer id) {
        Orders orders = (Orders)this.commonOrdersService.findById(id);
        return orders;
    }

    @PostMapping(value={"/order/evaluate/{id}"})
    public void evaluateOrder(@PathVariable(value="id") Integer id, @RequestBody OrdersQueryInfo orders) {
        log.info("\u8ba2\u5355\u8bc4\u4ef7\u5165\u53c2:[{}]", JSON.toJSON((Object)orders));
        User user = BizvaneSecurityContext.getUser();
        log.info("wechat-UserCenterController-/order/evaluate\u63a5\u53e3user:{}", (Object)JSON.toJSONString((Object)user));
        User remoteUser = (User)this.userService.findOneByCondition((Serializable)user);
        try {
            this.commentsService.evaluateOrder(id, orders, remoteUser);
        }
        catch (Exception e) {
            log.warn("\u4e2a\u4eba\u4e2d\u5fc3\u8ba2\u5355\u8bc4\u4ef7\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    @PostMapping(value={"/order/refund/{itemId}"})
    public JSONObject refundOrder(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="itemId") Integer itemId, HttpServletRequest request) {
        String refundType = request.getParameter("refundType");
        String refundReason = request.getParameter("refundReason");
        if (!StringUtils.isEmpty((Object)refundReason)) {
            try {
                refundReason = URLDecoder.decode(refundReason, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                log.warn("refundReason\u89e3\u7801\u5931\u8d25");
                refundReason = "\u9ed8\u8ba4\u539f\u56e0";
            }
        }
        String refundShippingNo = request.getParameter("refundShippingNo");
        log.info("\u8ba2\u5355\u7533\u8bf7\u552e\u540e\u5165\u53c2:itemId{},refundType:{},refundReason:{},refundShippingNo:{}", new Object[]{itemId, refundType, refundReason, refundShippingNo});
        RefundOrder refundOrders = new RefundOrder();
        refundOrders.setRefundType(Integer.valueOf(Integer.parseInt(refundType)));
        refundOrders.setRefundReason(refundReason);
        refundOrders.setRefundShippingNo(refundShippingNo);
        JSONObject object = new JSONObject();
        object.put("code", (Object)0);
        try {
            refundOrders.setSysBrandId(this.companyBrandRelationService.getBrandIdByMerchantId(merchantId));
            refundOrders.setMerchantId(merchantId);
            this.ordersService.refundOrder(itemId, refundOrders);
        }
        catch (Exception e) {
            object.put("code", (Object)-1);
            object.put("msg", (Object)e.getMessage());
        }
        return object;
    }

    @GetMapping(value={"refundOrder"})
    public List getRefundOrderList(@RequestHeader(value="merchantId") Integer merchantId) {
        User user = BizvaneSecurityContext.getUser();
        RefundOrder refundOrder = new RefundOrder();
        refundOrder.setUserId(user.getUserId());
        refundOrder.setValid(Integer.valueOf(1));
        refundOrder.setSysBrandId(this.companyBrandRelationService.getBrandIdByMerchantId(merchantId));
        return this.refundOrderService.findByCondition((Serializable)refundOrder);
    }

    @GetMapping(value={"/refundOrder/detail/{id}"})
    public RefundOrder getRefundOrderDetail(@PathVariable(value="id") Integer id) {
        RefundOrder orders = (RefundOrder)this.refundOrderService.findById(id);
        return orders;
    }

    @GetMapping(value={"/refundOrder/item/{id}"})
    public RefundOrder findById(@PathVariable(value="id") Integer id) {
        return this.refundOrderService.findRefundOrderById(id);
    }

    @GetMapping(value={"collect"})
    public List getCollectList(@RequestHeader(value="merchantId") Integer merchantId) {
        User user = BizvaneSecurityContext.getUser();
        Collect collect = new Collect();
        collect.setMerchantId(merchantId);
        collect.setWechatOpenid(user.getOpenid());
        return this.collectService.findByCondition((Serializable)collect);
    }

    @DeleteMapping(value={"collect"})
    public void updateCollect(@RequestBody Integer[] idArr) {
        log.info("\u5220\u9664collect\u8fdb\u5165");
        this.collectService.delete(idArr);
    }

    @PostMapping(value={"collect"})
    public void updateCollect(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Collect collect) {
        User user = BizvaneSecurityContext.getUser();
        collect.setMerchantId(merchantId);
        collect.setWechatOpenid(user.getOpenid());
        log.info("collect\u5165\u53c2:[{}]_user:[{}]", JSON.toJSON((Object)collect), JSON.toJSON((Object)user));
        this.collectService.add((Serializable)collect);
        try {
            Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)collect.getFavoriteId());
            this.sendMsgToQWService.sendGoodsMsg(goods, user.getUserNo(), 3);
        }
        catch (Exception e) {
            log.warn("\u6536\u85cf\u5546\u54c1\u901a\u77e5\u4f01\u5fae\u5931\u8d25:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
        }
    }
}

