/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.wmeimob.fastboot.baison.dto.requestVO.BaisonOrderCancelDelivery;
import com.wmeimob.fastboot.baison.dto.responseVO.BaisonResponseDTO;
import com.wmeimob.fastboot.baison.service.E3OrderService;
import com.wmeimob.fastboot.bizvane.dto.OrdersQueryInfo;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.entity.UserAddress;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.UserAddressService;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"user/address"})
public class UserAddressController {
    private static final Logger log = LoggerFactory.getLogger(UserAddressController.class);
    @Resource
    private UserAddressService userAddressService;
    @Resource(name="commonConfigService")
    private ConfigService configService;
    @Resource
    private OrdersMapper ordersMapper;
    @Resource
    private E3OrderService e3OrderService;

    @PostMapping
    public void add(@RequestBody UserAddress userAddress) {
        this.userAddressService.add((Serializable)this.fillUserId(userAddress));
    }

    private UserAddress fillUserId(UserAddress userAddress) {
        SecurityContext.getUser();
        User user = (User)SecurityContext.getUser();
        userAddress.setUserId(user.getUserId());
        return userAddress;
    }

    @PutMapping
    public void update(@RequestBody UserAddress userAddress) {
        this.userAddressService.update((Serializable)this.fillUserId(userAddress));
        User user = (User)SecurityContext.getUser();
        log.info("test");
        Config config = new Config();
        config.setMerchantId(user.getMerchantId());
        Config oneByCondition = (Config)this.configService.findOneByCondition((Serializable)config);
        if (oneByCondition.getErpSystem().endsWith("E3")) {
            log.info("e3\u53d6\u6d88\u8ba2\u5355\u63a5\u53e3 :{}", (Object)user.getUsername());
            OrdersQueryInfo ordersQueryInfo = new OrdersQueryInfo();
            ordersQueryInfo.setUserId(user.getUserId());
            List orders = this.ordersMapper.selectOrderListByCondition(ordersQueryInfo);
            if (orders.size() > 0) {
                try {
                    for (Orders order : orders) {
                        BaisonOrderCancelDelivery requestVO = new BaisonOrderCancelDelivery();
                        requestVO.setDeal_code(order.getOrderNo());
                        BaisonResponseDTO dto = this.e3OrderService.orderCancelDelivery(requestVO);
                        log.info("e3\u53d6\u6d88\u8ba2\u5355\u8c03\u7528\u63a5\u53e3\u7ed3\u679c :{}", (Object)dto);
                    }
                }
                catch (Exception exception) {}
            } else {
                log.info("\u8be5\u7528\u6237\u8fd8\u6ca1\u6709\u4e0b\u8ba2\u5355");
            }
        }
    }

    @GetMapping
    public List<UserAddress> list(UserAddress userAddress) {
        return this.userAddressService.findByCondition((Serializable)this.fillUserId(userAddress));
    }

    @DeleteMapping(value={"{id}"})
    public void delete(@PathVariable Integer id) {
        this.userAddressService.delete(id, (Serializable)this.fillUserId(new UserAddress()));
    }

    @GetMapping(value={"default"})
    public UserAddress getUserDefault() {
        return this.userAddressService.queryDefault(this.fillUserId(new UserAddress()));
    }
}

