/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.config.BizvaneProperties;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.vo.CreateMiniprgmQRCodeRequestVO;
import com.wmeimob.fastboot.util.DateUtil;
import com.wmeimob.fastboot.util.StringUtils;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"guide"})
@RestController
public class ShopperGuiderController {
    private static final Logger log = LoggerFactory.getLogger(ShopperGuiderController.class);
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private static final String SOLAR_CODE_KEY = "solarCode:merchantId:%s:goodsId:%s";
    private static final String SOLAR_MEMBER_CODE_KEY = "solarCode:memberCode:merchantId:%s:path:%s:guiderShare:%s";
    @Autowired
    private BizvaneProperties bizvaneProperties;

    @GetMapping(value={"wxGuideQrPic"})
    public JSONObject wxaCode(@RequestHeader(value="merchantId") Long merchantId, @RequestParam(value="path") String path, @RequestParam(value="guiderShare") String guiderShare, @RequestParam(value="memberCode") String memberCode) {
        String data;
        log.info("\u751f\u6210\u4e8c\u7ef4\u7801\u5165\u53c2:merchant[{}]\uff0cpath:[{}],guiderShare:[{}]", new Object[]{merchantId, path, guiderShare});
        String scene = guiderShare;
        CreateMiniprgmQRCodeRequestVO vo = new CreateMiniprgmQRCodeRequestVO();
        vo.setScene(scene);
        vo.setPath(path);
        vo.setSysBrandId(merchantId);
        vo.setType(Integer.valueOf(2));
        String[] split = guiderShare.split(",");
        String goodsId = split[split.length - 1];
        String key = String.format(SOLAR_CODE_KEY, merchantId, goodsId);
        String type = split[0];
        if (!StringUtils.isEmpty((Object)memberCode)) {
            String memberCodeKey = String.format(SOLAR_MEMBER_CODE_KEY, merchantId, path, guiderShare);
            this.stringRedisTemplate.opsForValue().set((Object)memberCodeKey, (Object)memberCode);
        }
        if ("1".equals(type)) {
            String localTime;
            String shareTime = split[split.length - 2];
            if (!StringUtils.isEmpty((Object)shareTime)) {
                shareTime = shareTime.substring(0, shareTime.length() - 4);
            }
            if ((localTime = DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHH")).equals(shareTime) && this.stringRedisTemplate.hasKey((Object)key).booleanValue()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("data", this.stringRedisTemplate.opsForValue().get((Object)key));
                jsonObject.put("code", (Object)0);
                return jsonObject;
            }
            vo.setType(Integer.valueOf(1));
            Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)Integer.parseInt(goodsId));
            vo.setImgUrl(goods.getCoverImg());
        }
        String url = this.bizvaneProperties.getRequestPrefix() + this.bizvaneProperties.getGenerateQrcodeUrl();
        JSONObject jsonObject = this.bizvaneInterface.generateQrCode(vo, url);
        if (vo.getType().equals(1) && !StringUtils.isEmpty((Object)(data = jsonObject.getString("data"))) && this.stringRedisTemplate.hasKey((Object)key).booleanValue()) {
            this.stringRedisTemplate.opsForValue().getAndSet((Object)key, (Object)data);
        }
        if (jsonObject != null) {
            log.info("\u751f\u6210\u4e8c\u7ef4\u7801\u8fd4\u53c2:[{}]", (Object)jsonObject.toString());
        } else {
            log.info("\u751f\u6210\u4e8c\u7ef4\u7801\u8fd4\u53c2\u4e3a\u7a7a");
        }
        return jsonObject;
    }

    @GetMapping(value={"getMemberCode"})
    public JSONObject getMemberCode(@RequestHeader(value="merchantId") Long merchantId, @RequestParam(value="path") String path, @RequestParam(value="guiderShare") String guiderShare) {
        JSONObject result = new JSONObject();
        String memberCodeKey = String.format(SOLAR_MEMBER_CODE_KEY, merchantId, path, guiderShare);
        log.info("getMemberCode rediskey:{}", (Object)memberCodeKey);
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)memberCodeKey);
        log.info("getMemberCode redisvalue:{}", (Object)value);
        result.put("data", (Object)value);
        result.put("code", (Object)0);
        return result;
    }
}

