/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.dto.ShopCartDTO;
import com.wmeimob.fastboot.bizvane.entity.ShopCart;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.bizvane.service.ShopCartService;
import com.wmeimob.fastboot.bizvane.service.impl.SendMsgToQWServiceImpl;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"shop-carts"})
public class ShopCartController {
    private static final Logger log = LoggerFactory.getLogger(ShopCartController.class);
    @Resource
    private ShopCartService shopCartService;
    @Autowired
    private SendMsgToQWServiceImpl sendMsgToQWService;

    @PostMapping
    public void add(@RequestBody ShopCart shopCart, @RequestHeader(value="sysStoreId", required=false, defaultValue="505171") Integer storeId, @RequestHeader(value="merchantId") Integer merchantId) {
        if (storeId != null && storeId > 0) {
            shopCart.setSysStoreId(storeId + "");
        }
        if (merchantId != null) {
            shopCart.setMerchantId(merchantId);
        }
        log.info("\u6dfb\u52a0\u8d2d\u7269\u8f66:{}", (Object)shopCart);
        try {
            this.shopCartService.add((Serializable)this.getCondition1(shopCart));
            this.sendMsgToQWService.sendShopCartGoodsMsg(shopCart, 2);
        }
        catch (UserException e) {
            throw new UserException("\u60a8\u8fd8\u672a\u6fc0\u6d3b\u4f1a\u5458\uff0c\u70b9\u51fb\u7acb\u5373\u6388\u6743");
        }
        catch (Exception e) {
            log.warn("\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallWechatException(e.getMessage());
        }
    }

    @DeleteMapping(value={"{id}"})
    public void delete(@PathVariable(value="id") Integer id) {
        ShopCart shopCart = new ShopCart();
        shopCart.setId(id);
        this.shopCartService.delete(id, (Serializable)this.getCondition(shopCart));
    }

    @GetMapping(value={"count"})
    public Integer getShopCart(HttpServletRequest request) {
        Integer brandId = Integer.parseInt(request.getHeader("brandId"));
        ShopCart shopCart1 = this.getCondition();
        shopCart1.setBrandId(brandId);
        log.info("\u5546\u54c1\u8be6\u60c5\u8d2d\u7269\u8f66\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)shopCart1));
        return this.shopCartService.queryCount(shopCart1);
    }

    @DeleteMapping
    public void deleteAll(@RequestBody Integer[] idArr) {
        this.shopCartService.delete(idArr);
    }

    @GetMapping
    public PageInfo<ShopCartDTO> getShopCarts(HttpServletRequest request) {
        Integer merchantId = Integer.parseInt(request.getHeader("merchantId"));
        Integer brandId = Integer.parseInt(request.getHeader("brandId"));
        log.info("ShopCartController#getShopCarts merchantId:{},brandId:{}", (Object)merchantId, (Object)brandId);
        return this.shopCartService.getAllShopCard(merchantId, brandId);
    }

    private ShopCart getCondition() {
        User user = (User)SecurityContext.getUser();
        ShopCart shopCart = new ShopCart();
        shopCart.setWechatOpenid(user.getOpenid());
        shopCart.setMerchantId(user.getMerchantId());
        log.info("\u8d2d\u7269\u8f66\u767b\u5f55\u4fe1\u606f:user:[{}]\uff0cshopUser:", JSONObject.toJSON((Object)user), JSONObject.toJSON((Object)shopCart));
        return shopCart;
    }

    private ShopCart getCondition(ShopCart shopCart) {
        User user = (User)SecurityContext.getUser();
        shopCart.setMerchantId(user.getMerchantId());
        shopCart.setWechatOpenid(user.getOpenid());
        shopCart.setSysStoreId("" + user.getSysStoreId());
        log.info("\u8d2d\u7269\u8f66\u767b\u5f55\u4fe1\u606f:user:[{}]", JSONObject.toJSON((Object)shopCart));
        return shopCart;
    }

    private ShopCart getCondition1(ShopCart shopCart) {
        User user = (User)SecurityContext.getUser();
        if (user != null) {
            shopCart.setUserNo(user.getUserNo());
            shopCart.setMerchantId(user.getMerchantId());
            shopCart.setWechatOpenid(user.getOpenid());
            if (user.getSysStoreId() != null) {
                shopCart.setSysStoreId(user.getSysStoreId() + "");
            }
            shopCart.setUserId(user.getUserId() != null ? Integer.valueOf(user.getUserId().intValue()) : null);
        }
        log.info("\u8d2d\u7269\u8f66\u767b\u5f55\u4fe1\u606f:user:[{}]", JSONObject.toJSON((Object)shopCart));
        return shopCart;
    }
}

