/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mzlion.core.lang.Assert;
import com.mzlion.core.lang.CollectionUtils;
import com.mzlion.core.lang.StringUtils;
import com.wmeimob.fastboot.bizvane.config.BizvaneProperties;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.dto.CouponDTO;
import com.wmeimob.fastboot.bizvane.dto.FreightCalcResponse;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.OrderDeliveryDetail;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.SelfMentionRange;
import com.wmeimob.fastboot.bizvane.enums.ShippingModeEnum;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.bizvane.mapper.OrderDeliveryDetailMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ConfigPOMapper;
import com.wmeimob.fastboot.bizvane.po.ConfigPO;
import com.wmeimob.fastboot.bizvane.po.ConfigPOExample;
import com.wmeimob.fastboot.bizvane.service.ActivityService;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.CouponService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import com.wmeimob.fastboot.bizvane.service.OrderPresellExpandService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.OrdersServiceImpl;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.bizvane.service.qdqm.QdqmService;
import com.wmeimob.fastboot.bizvane.utils.response.SysResponseEnum;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import me.hao0.wepay.model.pay.JsPayResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"orders"})
@PreAuthorize(value="hasRole('USER')")
public class OrdersController {
    private static final Logger log = LoggerFactory.getLogger(OrdersController.class);
    @Resource
    private OrdersService ordersService;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersServiceImpl;
    @Resource
    private UserService userService;
    @Resource
    private CouponService couponService;
    @Resource
    private ActivityService activityService;
    @Resource
    private UserCommissionService userCommissionService;
    @Resource
    private OrdersServiceImpl ordersServiceImpl;
    @Resource
    private ConfigPOMapper configPOMapper;
    @Autowired
    private MarketActivityService marketActivityService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Autowired
    private BizvaneProperties bizvaneProperties;
    @Resource
    private OrderDeliveryDetailMapper orderDeliveryDetailMapper;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;
    @Autowired
    private OrderPresellExpandService orderPresellExpandService;
    @Autowired
    private QdqmService qdqmService;

    @PostMapping(value={"pay-confirm"})
    public Orders payConfirm(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid", required=false) String appid, @RequestHeader(value="sysStoreId", required=false, defaultValue="505171") Integer sysStoreId, @RequestHeader(value="offlineStoreId", required=false, defaultValue="26572") String offlineStoreId, @RequestBody Orders createObject) {
        log.info("OrdersController#payConfirm merchantId:{},appid:{},sysStoreId:{},offlineStoreId:{},createObject:{}", new Object[]{merchantId, appid, sysStoreId, offlineStoreId, createObject});
        User user = (User)SecurityContext.getUser();
        merchantId = this.qdqmService.replaceMerchantId(createObject.getGoodsId(), merchantId);
        log.info("OrdersController#payConfirm user:{}", (Object)JSON.toJSONString((Object)user));
        Object[] storeSelfPrice = this.bizvaneProperties.getStoreSelfPrice();
        log.info("OrdersController#payConfirm storeSelfPrice:{}", (Object)JSON.toJSONString((Object)storeSelfPrice));
        if (ArrayUtils.isNotEmpty((Object[])storeSelfPrice) && Arrays.asList(storeSelfPrice).contains(user.getMerchantId()) && StringUtils.isEmpty((String)offlineStoreId)) {
            throw new MallWechatException("\u672a\u83b7\u53d6\u5230\u7528\u6237\u95e8\u5e97\u4fe1\u606f");
        }
        createObject.setUserId(user.getUserId());
        createObject.setUserNo(user.getUserNo());
        createObject.setWechatUnionId(user.getUnionid());
        createObject.setMerchantId(merchantId);
        createObject.setOfflineStoreId(offlineStoreId);
        createObject.setSysStoreId("" + sysStoreId);
        log.info("OrdersController#payConfirm createObject:{}", (Object)JSONObject.toJSONString((Object)createObject));
        try {
            return this.ordersService.payConfirm(createObject);
        }
        catch (UserException e) {
            throw new UserException("\u8bf7\u6388\u6743\u6ce8\u518c\u540e\u8fdb\u884c\u64cd\u4f5c");
        }
        catch (CustomException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new CustomException(e.getMessage());
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new MallWechatException(e.getMessage());
        }
    }

    @PostMapping
    public Orders add(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestBody Orders createObject, @RequestHeader(value="sysStoreId", required=false, defaultValue="505171") String sysStoreId, @RequestHeader(value="offlineStoreId", required=false, defaultValue="26572") String offlineStoreId) {
        log.info("orders#add:{}", (Object)createObject);
        User user = (User)SecurityContext.getUser();
        log.info("wechat-OrdersController-\u8ba2\u5355\u65b0\u589eadd\u63a5\u53e3-user:{}", (Object)JSON.toJSONString((Object)user));
        User queryUser = (User)this.userService.findOneByCondition((Serializable)user);
        log.info("wechat-OrdersController-\u8ba2\u5355\u65b0\u589eadd\u63a5\u53e3-queryUser:{}", JSON.toJSON((Object)queryUser));
        merchantId = this.qdqmService.replaceMerchantId(createObject.getGoodsId(), merchantId);
        Integer brandIdByMerchantId = this.companyBrandRelationService.getBrandIdByMerchantId(merchantId);
        createObject.setSysBrandId(brandIdByMerchantId);
        createObject.setWechatOpenid(user.getOpenid());
        createObject.setUserNo(user.getUserNo());
        createObject.setMerchantId(merchantId);
        createObject.setUserId(user.getUserId());
        createObject.setUserName(queryUser.getFullName());
        createObject.setAppid(appid);
        createObject.setMobile(queryUser.getUserPhone());
        createObject.setSysStoreId(sysStoreId);
        if (StringUtils.isEmpty((String)queryUser.getOfflineStoreId())) {
            createObject.setOfflineStoreId(offlineStoreId);
        } else {
            createObject.setOfflineStoreId(queryUser.getOfflineStoreId());
        }
        User tempUser = new User();
        Orders newOrder = new Orders();
        tempUser.setBrandId(queryUser.getBrandId());
        tempUser.setSysCompanyId(queryUser.getSysCompanyId());
        tempUser.setUnionid(queryUser.getUnionid());
        tempUser.setUserNo(queryUser.getUserNo());
        UserDiscountDTO memberLevel = this.userService.getUserDiscountInfo(tempUser);
        createObject.setMemberLevelName(memberLevel.getMemberLevelName());
        Boolean parentState = this.userCommissionService.findParentState(queryUser.getUserNo());
        createObject.setEnabledCommission(parentState);
        createObject.setWechatUnionId(queryUser.getUnionid());
        if (createObject.getShippingMode() != null && ShippingModeEnum.SELF_MENTION.getCode().equals(String.valueOf(createObject.getShippingMode()))) {
            log.info("\u81ea\u63d0\u8ba2\u5355\u8fdb\u884c\u53c2\u6570\u64cd\u4f5c");
            createObject.setShippingAddress(createObject.getPickStoreAddress());
            createObject.setShippingDistrict(null);
            createObject.setShippingMobile(queryUser.getUserPhone());
            createObject.setShippingCity(null);
            createObject.setShippingProvince(null);
            createObject.setShippingName(queryUser.getFullName());
        }
        this.ordersService.inventoryReductionAdvance(createObject);
        try {
            newOrder = (Orders)this.ordersService.add((Serializable)createObject);
            log.info("OrdersController#add newOrder:{}", (Object)JSON.toJSONString((Object)newOrder));
        }
        catch (Exception e) {
            log.warn("\u8ba2\u5355\u65b0\u589e\u5931\u8d25:", (Throwable)e);
            this.ordersService.inventoryResumeAdvance(createObject);
            if (!StringUtils.isEmpty((String)newOrder.getOrderNo())) {
                this.ordersService.voidOrder(newOrder.getOrderNo());
            }
            throw new MallWechatException(e.getMessage());
        }
        return createObject;
    }

    @PostMapping(value={"freight"})
    public FreightCalcResponse getFreight(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestHeader(value="sysStoreId", required=false, defaultValue="505171") Integer sysStoreId, @RequestHeader(value="offlineStoreId", required=false, defaultValue="26572") String offlineStoreId, @RequestBody Orders orders) {
        log.info("Get Freight From Orders {}", (Object)JSONObject.toJSONString((Object)orders));
        if (ShippingModeEnum.SELF_MENTION.getCode().equals(String.valueOf(orders.getShippingMode())) || ShippingModeEnum.OPTIONAL.getCode().equals(String.valueOf(orders.getShippingMode())) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orders.getShippingProvince())) {
            FreightCalcResponse freightCalcResponse = new FreightCalcResponse();
            freightCalcResponse.setFreightFee(BigDecimal.ZERO);
            freightCalcResponse.setFreightDeduction(BigDecimal.ZERO);
            return freightCalcResponse;
        }
        User user = (User)SecurityContext.getUser();
        merchantId = this.qdqmService.replaceMerchantId(orders.getGoodsId(), merchantId);
        orders.setUserNo(user.getUserNo());
        orders.setUserId(user.getUserId());
        orders.setMerchantId(merchantId);
        orders.setWechatUnionId(user.getUnionid());
        if (StringUtils.isEmpty((String)orders.getSysStoreId())) {
            orders.setSysStoreId(sysStoreId + "");
        }
        if (StringUtils.isEmpty((String)orders.getOfflineStoreId())) {
            orders.setOfflineStoreId(offlineStoreId);
        }
        Orders od = this.ordersService.payConfirm(orders);
        od.setShippingProvince(this.filterRegionName(orders.getShippingProvince(), "\u7701"));
        od.setShippingCity(this.filterRegionName(orders.getShippingCity(), "\u5e02"));
        od.setShippingDistrict(this.filterRegionName(orders.getShippingDistrict(), "\u533a"));
        return this.ordersService.getFreight(od);
    }

    private String filterRegionName(String name, String filter) {
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        int filterId = name.lastIndexOf(filter);
        if (filterId != -1) {
            return name.substring(0, filterId);
        }
        return name;
    }

    @GetMapping(value={"/{id}"})
    public Orders getOrdersById(@PathVariable(value="id") Integer id) {
        UserDiscountDTO userDiscountDTO;
        Config config;
        log.info("\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u8fdb\u5165\u3002\u3002");
        User user = (User)SecurityContext.getUser();
        user.setMerchantId(user.getBrandId());
        log.info("\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5user:[{}]", JSON.toJSON((Object)user));
        Orders orders = (Orders)this.commonOrdersServiceImpl.findById(id);
        Integer[] storeSelfPrice = this.bizvaneProperties.getStoreSelfPrice();
        if (storeSelfPrice != null && storeSelfPrice.length != 0 && Arrays.asList(storeSelfPrice).contains(orders.getMerchantId()) && "ZYPS".equals(orders.getShippingVendor())) {
            OrderDeliveryDetail odd = new OrderDeliveryDetail();
            odd.setOrderId(id);
            odd = (OrderDeliveryDetail)this.orderDeliveryDetailMapper.selectOne((Object)odd);
            orders.setDeliverPhone(odd.getDeliverPhone());
            orders.setDeliverPersonName(odd.getDeliverName());
        }
        orders = this.marketActivityService.convertOrdersResult(orders);
        Assert.notNull((Object)orders, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        if (!orders.getUserNo().equals(user.getUserNo())) {
            throw new MallWechatException("\u8ba2\u5355\u672a\u627e\u5230");
        }
        if (orders.getPriceSystem().equals(0) && (config = this.configService.findSysConfig(user.getMerchantId())) != null && user != null && config.getPriceDisplay().equals(1) && (userDiscountDTO = this.userService.getUserDiscountInfo(user)) != null && userDiscountDTO.getDiscount() != null) {
            orders.getItems().forEach(hotGoods -> hotGoods.setVipPrice(hotGoods.getSalePrice().multiply(userDiscountDTO.getDiscount()).setScale(2, 4)));
        }
        return orders;
    }

    @DeleteMapping(value={"{id}"})
    public void deleteOrders(@PathVariable Integer id) {
        Orders od = this.getOrdersById(id);
        this.ordersService.delete(od.getId());
    }

    @PostMapping(value={"amount"})
    public Orders calumniateByCoupons(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestHeader(value="sysStoreId", required=false, defaultValue="505171") Integer sysStoreId, @RequestHeader(value="offlineStoreId", required=false, defaultValue="26572") String offlineStoreId, @RequestBody Orders createObject) {
        log.info("OrdersController#calumniateByCoupons merchantId:{},appid:{},sysStoreId:{},offlineStoreId:{},createObject:{}", new Object[]{merchantId, appid, sysStoreId, offlineStoreId, createObject});
        merchantId = this.qdqmService.replaceMerchantId(createObject.getGoodsId(), merchantId);
        createObject.setMerchantId(merchantId);
        User user = (User)SecurityContext.getUser();
        createObject.setUserNo(user.getUserNo());
        createObject.setMerchantId(merchantId);
        createObject.setUserId(user.getUserId());
        createObject.setAppid(appid);
        createObject.setWechatUnionId(user.getUnionid());
        if (StringUtils.isEmpty((String)createObject.getSysStoreId())) {
            createObject.setSysStoreId(sysStoreId + "");
        }
        if (StringUtils.isEmpty((String)createObject.getOfflineStoreId())) {
            createObject.setOfflineStoreId(offlineStoreId);
        }
        CouponDTO couponDTO = (CouponDTO)this.couponService.findById(Integer.valueOf(createObject.getCouponNo()));
        log.info("OrdersController#calumniateByCoupons couponDTO:{}", (Object)JSON.toJSONString((Object)couponDTO));
        Orders calcByCoupon = this.ordersService.calcOrdersByCoupons(couponDTO, createObject);
        return calcByCoupon;
    }

    @GetMapping(value={"active-goods"})
    public List<Goods> getActiveGoods(@RequestHeader(value="merchantId") Integer merchantId, BigDecimal amount, Integer goodsId) {
        merchantId = this.qdqmService.replaceMerchantId(goodsId, merchantId);
        return this.activityService.queryCurrentGiftGoodsByAmount(merchantId, amount);
    }

    @PutMapping(value={"confirm"})
    public void updateOrdersToConfirm(Integer ordersId) {
        User user = (User)SecurityContext.getUser();
        Orders orders = new Orders();
        orders.setUserId(user.getUserId());
        orders.setId(ordersId);
        this.commonOrdersServiceImpl.confirm(orders);
    }

    @PostMapping(value={"close"})
    public JSONObject close(@RequestHeader(value="appid") String appid, HttpServletRequest request) {
        String idPara = request.getParameter("id");
        log.info("\u53d6\u6d88\u8ba2\u5355\u63a5\u53e3\u5165\u53c2id:{}", (Object)idPara);
        Integer id = Integer.parseInt(idPara);
        User user = (User)SecurityContext.getUser();
        JSONObject result = new JSONObject();
        result.put("code", (Object)0);
        int i = this.orderPresellExpandService.cancelPreSellOrderPreprocessing(id);
        if (i > 0) {
            result.put("code", (Object)SysResponseEnum.ORDER_PRE_SELL_PART_PAY_COMMIT.getCode());
            result.put("msg", (Object)SysResponseEnum.ORDER_PRE_SELL_PART_PAY_COMMIT.getMessage());
            log.info("\u53d6\u6d88\u8ba2\u5355\u63a5\u53e3\u5165\u53c2result:{}", (Object)JSON.toJSONString((Object)result));
            return result;
        }
        try {
            this.ordersService.cancel(appid, user.getUserId(), id, null);
        }
        catch (Exception e) {
            log.warn("\u53d6\u6d88\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw new MallWechatException(e.getMessage());
        }
        return result;
    }

    @GetMapping(value={"payment"})
    public JsPayResponse getJspayResponse(@RequestHeader(value="appid") String appid, Integer ordersId) {
        JsPayResponse jsPayResponse = null;
        try {
            jsPayResponse = this.ordersService.payment(ordersId, appid);
            log.info("\u652f\u4ed8\u7b7e\u540d\u8fd4\u56de===>{}", (Object)JSONObject.toJSONString((Object)jsPayResponse));
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u5fae\u4fe1\u652f\u4ed8\u7b7e\u540d\u5931\u8d25:msg:[{}]_[{}]", (Object)e.getMessage(), (Object)e);
            throw new MallWechatException(e.getMessage());
        }
        return jsPayResponse;
    }

    @GetMapping(value={"getUserIntegral"})
    public Integer getUserIntegral(@RequestParam(value="userNo") String userNo) {
        log.info("\u83b7\u53d6\u4f1a\u5458\u79ef\u5206\u4f59\u989d");
        if (StringUtils.isEmpty((String)userNo)) {
            User user = (User)SecurityContext.getUser();
            userNo = user.getUserNo();
        }
        return this.ordersServiceImpl.getUserIntegral(userNo);
    }

    @GetMapping(value={"getIntegralProportion"})
    public BigDecimal getIntegralProportion(@RequestParam(value="userNo") String userNo) {
        log.info("\u83b7\u53d6\u79ef\u5206\u5151\u6362\u6bd4\u4f8b");
        if (StringUtils.isEmpty((String)userNo)) {
            User user = (User)SecurityContext.getUser();
            userNo = user.getUserNo();
        }
        return this.ordersServiceImpl.getIntegralProportion(userNo);
    }

    @GetMapping(value={"getUserBalance"})
    public BigDecimal getUserBalance(@RequestParam(value="userNo") String userNo) {
        log.info("\u83b7\u53d6\u4f1a\u5458\u5361\u4f59\u989d");
        if (StringUtils.isEmpty((String)userNo)) {
            User user = (User)SecurityContext.getUser();
            userNo = user.getUserNo();
        }
        return this.ordersServiceImpl.getUserBalance(userNo);
    }

    @GetMapping(value={"wscConsumeIntegralChange"})
    public RestResult wscConsumeIntegralChange(@RequestParam(value="userNo") String memberCode, @RequestParam(value="integral") Integer integral, @RequestParam(value="orderNo") String orderNo) {
        log.info("\u5fae\u5546\u57ce\u6263\u51cf\u79ef\u5206");
        if (StringUtils.isEmpty((String)memberCode)) {
            User user = (User)SecurityContext.getUser();
            memberCode = user.getUserNo();
        }
        return this.ordersServiceImpl.wscConsumeIntegralChange(memberCode, integral, orderNo);
    }

    @GetMapping(value={"wscConsumeBalance"})
    public RestResult wscConsumeBalance(@RequestParam(value="userNo") String memberCode, @RequestParam(value="balance") BigDecimal balance, @RequestParam(value="orderNo") String orderNo) {
        log.info("\u5fae\u5546\u57ce\u6263\u51cf\u4f59\u989d");
        if (StringUtils.isEmpty((String)memberCode)) {
            User user = (User)SecurityContext.getUser();
            memberCode = user.getUserNo();
        }
        return this.ordersServiceImpl.wscConsumeBalance(memberCode, balance, orderNo);
    }

    @GetMapping(value={"storeList"})
    public Map<String, Object> getStoreList(@RequestHeader(value="merchantId") String merchantId, @RequestParam(value="lat") String lat, @RequestParam(value="lng") String lng, @RequestParam(value="userNo") String userNo, @RequestParam(value="searchValue") String searchValue, @RequestParam(value="pageNum", required=false) Integer pageNum) {
        log.info("\u81ea\u63d0\u83b7\u53d6\u95e8\u5e97\u5217\u8868");
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONArray storeList = null;
        if (StringUtils.isEmpty((String)userNo)) {
            User user = (User)SecurityContext.getUser();
            userNo = user.getUserNo();
        }
        ConfigPOExample configPOExample = new ConfigPOExample();
        Integer merchantID = Integer.valueOf(merchantId);
        configPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantID);
        List configPOS = this.configPOMapper.selectByExample(configPOExample);
        log.info("\u67e5\u8be2\u51fa\u7684\u914d\u7f6e");
        if (CollectionUtils.isEmpty((Collection)configPOS)) {
            map.put("code", -1);
            map.put("msg", "\u6ca1\u6709\u67e5\u5230\u8be5\u5546\u6237\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return map;
        }
        if (configPOS.size() > 1) {
            map.put("code", -1);
            map.put("msg", "\u6709\u591a\u4e2a\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return map;
        }
        Integer isWholeStore = ((ConfigPO)configPOS.get(0)).getSelfMentionRange();
        if (isWholeStore == null) {
            log.info("\u8be5\u6570\u636e\u6ca1\u6709\u914d\u7f6e\u81ea\u63d0\u8303\u56f4\uff0c\u9ed8\u8ba4\u662f\u670d\u52a1\u95e8\u5e97");
            isWholeStore = SelfMentionRange.SERVICE_STORE.getCode();
        }
        try {
            storeList = this.bizvaneInterface.getStoreList(lat, lng, merchantId, userNo, searchValue, isWholeStore, pageNum);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            map.put("code", -1);
            map.put("msg", e.getMessage());
            return map;
        }
        if (storeList == null) {
            map.put("code", -1);
            map.put("msg", "\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
            return map;
        }
        map.put("code", 0);
        map.put("data", storeList.toJSONString());
        return map;
    }

    @GetMapping(value={"checkCompany"})
    public JSONObject checkCompanyInfoValid(@RequestParam(value="corporation", required=false) String corporation, @RequestParam(value="corporationIdCard", required=false) String corporationIdCard, @RequestParam(value="corporationTel", required=false) String corporationTel, @RequestParam(value="corporationPassword", required=false) String corporationPassword) {
        Orders orders = new Orders();
        OrderItems orderItems = new OrderItems();
        orderItems.setCorporation(corporation);
        orderItems.setCorporationIdCard(corporationIdCard);
        orderItems.setCorporationPassword(corporationPassword);
        orderItems.setCorporationTel(corporationTel);
        ArrayList<OrderItems> list = new ArrayList<OrderItems>();
        list.add(orderItems);
        orders.setItems(list);
        return this.ordersServiceImpl.checkCompanyValid(orders);
    }

    @GetMapping(value={"/getOfflineStoreInfo/{sysStoreId}"})
    public JSONObject queryOfflineStoreInfo(@PathVariable(value="sysStoreId") String sysStoreId) {
        return this.bizvaneInterface.getofflineStoreById(sysStoreId);
    }
}

