/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mzlion.core.lang.Assert;
import com.wmeimob.fastboot.bizvane.config.BizvaneProperties;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpec;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.enums.OrderPreSellPayTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.OrderPreSellStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PushFlagEnum;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.enums.ShippingModeEnum;
import com.wmeimob.fastboot.bizvane.enums.WXMsgTemplate.WXMsgTemplateTypeEnum;
import com.wmeimob.fastboot.bizvane.event.RefundEvent;
import com.wmeimob.fastboot.bizvane.event.payorder.impl.OrderPayEnterpriseListener;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSpecMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ConfigPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrderItemsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.OrdersPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.WechatMchPOMapper;
import com.wmeimob.fastboot.bizvane.po.ConfigPO;
import com.wmeimob.fastboot.bizvane.po.ConfigPOExample;
import com.wmeimob.fastboot.bizvane.po.OrderItemsPO;
import com.wmeimob.fastboot.bizvane.po.OrderItemsPOExample;
import com.wmeimob.fastboot.bizvane.po.OrderPresellExpandPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPO;
import com.wmeimob.fastboot.bizvane.po.OrdersPOExample;
import com.wmeimob.fastboot.bizvane.service.AssembleService;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.bizvane.service.OrderPresellExpandService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.OrdersServiceImpl;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import com.wmeimob.fastboot.bizvane.service.SendOrderMsgRecordService;
import com.wmeimob.fastboot.bizvane.service.impl.CommonOrdersServiceImpl;
import com.wmeimob.fastboot.bizvane.service.seckill.SecKillGoodsStockService;
import com.wmeimob.fastboot.bizvane.service.wx_msg_notice.WXMsgNoticeService;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.vo.selfpick.SelfPickNoticeRequestVO;
import com.wmeimob.fastboot.bizvane.vo.wx_msg_template.WXMsgTemplateNoticeVO;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.wechat.util.XmlUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/notify"})
public class NotifyController {
    private static final Logger log = LoggerFactory.getLogger(NotifyController.class);
    public static final String SUCCESS = "SUCCESS";
    private static final String ALGORITHM = "AES";
    private static final String ALGORITHM_MODE_PADDING = "AES/ECB/PKCS5Padding";
    @Autowired
    private GoodsSkuDetailService goodsSkuDetailService;
    @Resource
    private OrdersService orderService;
    @Autowired
    private WXMsgNoticeService wxMsgNoticeService;
    @Autowired
    private BizvaneProperties bizvaneProperties;
    @Resource
    private WechatService wechatService;
    @Resource
    private RefundOrderService refundOrderService;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private WechatMchNewMapper wechatMchNewMapper;
    @Resource
    private AssembleService assembleService;
    @Resource
    private ConfigPOMapper configPOMapper;
    @Resource
    private GoodsSpecMapper goodsSpecMapper;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SecKillGoodsStockService secKillGoodsStockService;
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private SendOrderMsgRecordService sendOrderMsgRecordService;
    @Resource
    private OrderItemsPOMapper orderItemsPOMapper;
    @Resource
    private OrdersPOMapper ordersPOMapper;
    @Autowired
    private OrderPresellExpandService orderPresellExpandService;
    @Resource
    private WechatMchPOMapper wechatMchPOMapper;
    @Autowired
    private OrdersServiceImpl ordersService;
    @Autowired
    private CommonOrdersServiceImpl commonOrdersService;
    @Resource
    private OrdersMapper ordersMapper;
    @Autowired
    private OrderPayEnterpriseListener orderPayEnterpriseListener;

    @PostMapping(value={"/wechat/refund"})
    public String refundcallback(HttpServletRequest request) {
        try {
            Map paymentMap = XmlUtil.readStringXmlOut((InputStream)request.getInputStream());
            String return_code = (String)paymentMap.get("return_code");
            String appid = (String)paymentMap.get("appid");
            log.info("refundcallback paymentMap==>" + JSONObject.toJSONString((Object)paymentMap));
            Example example = new Example(WechatMchNew.class);
            example.createCriteria().andEqualTo("appId", (Object)appid);
            List mchNewList = this.wechatMchNewMapper.selectByExample((Object)example);
            if (CollectionUtils.isEmpty((Collection)mchNewList)) {
                throw new CustomException("appid=" + appid + ",\u672a\u5b8c\u6210\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e");
            }
            WechatMchNew mchNew = (WechatMchNew)mchNewList.get(0);
            if (return_code.equals("SUCCESS")) {
                String req_info = (String)paymentMap.get("req_info");
                String s = NotifyController.decryptData((String)req_info, (String)mchNew.getMchKey());
                Map stringStringMap = XmlUtil.readStringXmlOut((String)s);
                log.info("refundcallback req_info==>" + JSONObject.toJSONString((Object)stringStringMap));
                String out_refund_no = (String)stringStringMap.get("out_refund_no");
                String refund_status = (String)stringStringMap.get("refund_status");
                if (refund_status.equals("SUCCESS")) {
                    log.info("\u6210\u529f\u8fdb\u884c\u9000\u6b3e\u56de\u8c03");
                    if (out_refund_no.contains("FIRST")) {
                        this.bookingRefundProcessingFirst(out_refund_no);
                    } else if (out_refund_no.contains("LAST")) {
                        this.bookingRefundProcessingLast(out_refund_no);
                    }
                    if (out_refund_no.contains("REPART") || out_refund_no.contains("REBALANCE")) {
                        String orderNo = out_refund_no.replace("REPART", "").replace("REBALANCE", "");
                        this.refundVirtualProcessing(orderNo);
                    } else {
                        String refundNo = out_refund_no.replace("FIRST", "").replace("LAST", "");
                        this.refundProcessing(refundNo);
                    }
                    return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
                }
            }
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
    }

    private void refundVirtualProcessing(String orderNo) {
        try {
            OrderItemsPOExample orderItemsPOExample = new OrderItemsPOExample();
            orderItemsPOExample.createCriteria().andOrderNoEqualTo(orderNo).andValidEqualTo(Boolean.TRUE);
            List orderItemsPOS = this.orderItemsPOMapper.selectByExample(orderItemsPOExample);
            OrderItems orderItems = new OrderItems();
            orderItems.setId(((OrderItemsPO)orderItemsPOS.get(0)).getId());
            orderItems.setRefundStatus(RefundStatus.SUCCESS);
            this.orderService.updateRefundItems(orderItems);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5b9a\u91d1\u9884\u552e\u865a\u62df\u8ba2\u5355 orderItem\u72b6\u6001\u5931\u8d25:{}", (Throwable)e);
        }
    }

    private void bookingRefundProcessingFirst(String out_refund_no) {
        log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355_\u5b9a\u91d1\u9000\u6b3e\u56de\u8c03\u6210\u529f\u5904\u7406!");
        OrderPresellExpandPO orderPresellExpandPO = this.orderPresellExpandService.refundSuccess(out_refund_no);
        Integer orderId = orderPresellExpandPO.getOrderId();
        OrdersPO ordersPO = this.ordersPOMapper.selectByPrimaryKey(orderId);
        String refundNo = orderPresellExpandPO.getRefundNo();
        Integer presellStatus = ordersPO.getPresellStatus();
        if (OrderPreSellStatusEnum.PART_PAY_PORTION.getCode().equals(presellStatus)) {
            this.refundProcessing(refundNo);
        }
    }

    private void skuStockRefund(Integer orderItemId) {
        log.info("skuStockRefund#orderItemId#256:{}", (Object)orderItemId);
        OrderItemsPOExample orderItemsPOExample = new OrderItemsPOExample();
        orderItemsPOExample.createCriteria().andIdEqualTo(orderItemId);
        List orderItemsPOS = this.orderItemsPOMapper.selectByExample(orderItemsPOExample);
        log.info("skuStockRefund#orderItemsPOS#256:{}", (Object)JSON.toJSONString((Object)orderItemsPOS));
        List customSkuInfo = this.convertToSkuInfo(orderItemsPOS);
        customSkuInfo.forEach(o -> o.setStock(Integer.valueOf(-o.getStock().intValue())));
        this.goodsSkuDetailService.inventoryReduction(customSkuInfo);
    }

    private List<GoodsSkuDetail> convertToSkuInfo(List<OrderItemsPO> orderItems) {
        ArrayList<GoodsSkuDetail> skuInfoList = new ArrayList<GoodsSkuDetail>();
        for (OrderItemsPO item : orderItems) {
            GoodsSkuDetail skuInfo = new GoodsSkuDetail();
            skuInfo.setGoodsId(item.getGoodsId());
            skuInfo.setSkuNo(item.getGoodsSkuNo());
            skuInfo.setGoodsName(item.getGoodsName());
            skuInfo.setStock(item.getSaleQuantity());
            skuInfoList.add(skuInfo);
        }
        return skuInfoList;
    }

    private void bookingRefundProcessingLast(String out_refund_no) {
        log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355_\u5c3e\u6b3e\u9000\u6b3e\u56de\u8c03\u6210\u529f\u5904\u7406!");
        OrderPresellExpandPO orderPresellExpandPO = this.orderPresellExpandService.refundSuccess(out_refund_no);
        Integer orderId = orderPresellExpandPO.getOrderId();
        OrdersPO ordersPO = this.ordersPOMapper.selectByPrimaryKey(orderId);
        String refundNo = orderPresellExpandPO.getRefundNo();
        Integer presellStatus = ordersPO.getPresellStatus();
        if (OrderPreSellStatusEnum.PART_PAY_ALL.getCode().equals(presellStatus)) {
            this.scheduledThreadPoolExecutor.schedule(() -> {
                log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355_\u5c3e\u6b3e\u9000\u6b3e\u5ef6\u8fdf\u66f4\u65b0\u5b9e\u9645\u9000\u5355!");
                this.refundProcessing(refundNo);
            }, 5L, TimeUnit.SECONDS);
        }
    }

    private void refundProcessing(String out_refund_no) {
        RefundOrder refundOrder;
        block8: {
            refundOrder = (RefundOrder)this.refundOrderService.findById(out_refund_no);
            log.info("\u76f8\u5173\u9000\u5355\u6570\u636e\uff1a{}", JSON.toJSON((Object)refundOrder));
            this.bizvaneInterface.notifyRefundApplied(refundOrder);
            try {
                this.sendOrderMsgRecordService.updateRefundOrderSuccess(out_refund_no);
                if (refundOrder.getMerchantId() != null) {
                    ConfigPOExample configPOExample = new ConfigPOExample();
                    configPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(refundOrder.getMerchantId());
                    List configPOS = this.configPOMapper.selectByExample(configPOExample);
                    log.info("refundProcessing#configPOS#328:{}", (Object)JSON.toJSONString((Object)configPOS));
                    if (CollectionUtils.isEmpty((Collection)configPOS)) {
                        throw new MallWechatException("\u5546\u6237\u914d\u7f6e\u4e0d\u5b58\u5728");
                    }
                    ConfigPO configPO = (ConfigPO)configPOS.get(0);
                    if (configPO.getApiInventoryUpdate().booleanValue()) {
                        log.info("refundProcessing#skuStockRefund_start#334");
                        this.skuStockRefund(refundOrder.getItemId());
                    }
                    break block8;
                }
                throw new MallWechatException("\u9000\u5355\u5546\u6237id\u4e0d\u5b58\u5728");
            }
            catch (Exception e2) {
                log.error("\u9000\u5355:{}\u66f4\u65b0\u786e\u8ba4\u9000\u6b3e\u72b6\u6001\u5931\u8d25", (Object)out_refund_no, (Object)e2);
            }
        }
        this.secKillGoodsStockService.inventoryIncrease(refundOrder.getOrderNo());
        try {
            Orders orders = this.orderService.findOneByCondition(refundOrder.getOrderNo(), refundOrder.getItemId());
            refundOrder = this.buildForOffLine(refundOrder, orders);
            refundOrder.getItems().forEach(e -> {
                String[] split;
                String specIds = e.getSpecIds();
                if (!StringUtils.isEmpty((String)specIds) && (split = specIds.split(",")) != null && split.length > 0) {
                    GoodsSpec goodsSpec;
                    if (split.length >= 1) {
                        goodsSpec = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey((Object)split[0]);
                        e.setSpecCode(goodsSpec.getSpecCode());
                    }
                    if (split.length >= 2) {
                        goodsSpec = (GoodsSpec)this.goodsSpecMapper.selectByPrimaryKey((Object)split[1]);
                        e.setSpecCode(e.getSpecCode() + "," + goodsSpec.getSpecCode());
                    }
                }
            });
            Integer pushFlag = refundOrder.getRefundType().equals(1) ? PushFlagEnum.REFUND.getPushFlag() : PushFlagEnum.REFUND_GOODS.getPushFlag();
            RefundEvent refundEvent = new RefundEvent((Object)this.applicationContext, refundOrder, pushFlag);
            this.applicationContext.publishEvent((ApplicationEvent)refundEvent);
            log.info("\u5fae\u4fe1\u4ed8\u6b3e\u63a8\u9001\u7ebf\u4e0b\u5b8c\u6210");
            OrderItems orderItems = new OrderItems();
            orderItems.setId(refundOrder.getItemId());
            orderItems.setRefundStatus(RefundStatus.SUCCESS);
            this.orderService.updateRefundItems(orderItems);
            OrderItemsPOExample checkAllRefunded = new OrderItemsPOExample();
            checkAllRefunded.createCriteria().andValidEqualTo(Boolean.TRUE).andOrderNoEqualTo(refundOrder.getOrderNo()).andRefundStatusNotEqualTo(RefundStatus.SUCCESS.toString());
            List orderItemsPOS = this.orderItemsPOMapper.selectByExample(checkAllRefunded);
            log.info("Item Not In Refund Success:{}", JSON.toJSON((Object)orderItemsPOS));
            if (CollectionUtils.isEmpty((Collection)orderItemsPOS)) {
                log.info("Close Order");
                OrdersPO allRefundUpdate = new OrdersPO();
                allRefundUpdate.setOrderStatus(OrdersStatusEnum.FAIL.toString());
                OrdersPOExample allRefundUpdateExample = new OrdersPOExample();
                allRefundUpdateExample.createCriteria().andValidEqualTo(Boolean.TRUE).andOrderNoEqualTo(refundOrder.getOrderNo());
                this.ordersPOMapper.updateByExampleSelective(allRefundUpdate, allRefundUpdateExample);
            }
        }
        catch (Exception e3) {
            log.warn(e3.getMessage(), (Throwable)e3);
        }
    }

    public static String decryptData(String base64Data, String mchKey) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        SecretKeySpec key = new SecretKeySpec(DigestUtils.md5DigestAsHex((byte[])mchKey.getBytes()).toLowerCase().getBytes(), "AES");
        cipher.init(2, key);
        byte[] bytes = cipher.doFinal(Base64.getDecoder().decode(base64Data));
        return new String(bytes);
    }

    private RefundOrder buildForOffLine(RefundOrder refundOrder, Orders orders) {
        refundOrder.setItems(orders.getItems());
        refundOrder.setGoodsName(((OrderItems)orders.getItems().get(0)).getGoodsName());
        refundOrder.setVipName(orders.getVipName());
        refundOrder.setErpStoreId(orders.getErpStoreId());
        refundOrder.setErpStoreCode(orders.getErpStoreCode());
        refundOrder.setErpGuideCode(orders.getErpGuideCode());
        refundOrder.setErpGuideId(orders.getErpGuideId());
        refundOrder.setOfflineCardNo(orders.getOfflineCardNo());
        refundOrder.setErpId(orders.getErpId());
        return refundOrder;
    }

    @PostMapping(value={"/wechat/pay"})
    public String paycallback(HttpServletRequest request) {
        try {
            Map paymentMap = XmlUtil.readStringXmlOut((InputStream)request.getInputStream());
            log.info("\u652f\u4ed8\u56de\u8c03=>{}", (Object)JSONObject.toJSONString((Object)paymentMap));
            String result_code = (String)paymentMap.get("result_code");
            if (result_code.equals("SUCCESS")) {
                String out_trade_no = (String)paymentMap.get("out_trade_no");
                String source_code = out_trade_no.replace("FIRST", "").replace("LAST", "");
                Orders orders1 = this.orderService.findOrderByOrderNo(source_code);
                log.info("\u6839\u636e\u652f\u4ed8\u56de\u8c03\u67e5\u8be2\u7684\u8ba2\u5355\u6240\u5728\u7684\u5546\u6237id:{}", (Object)orders1.getMerchantId());
                Example example = new Example(WechatMchNew.class);
                example.createCriteria().andEqualTo("appId", paymentMap.get("appid")).andEqualTo("merchantId", (Object)orders1.getMerchantId());
                WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
                WechatMp wechatMp = new WechatMp();
                wechatMp.setAppid(mchNew.getAppId());
                WechatMch wechatMch = new WechatMch();
                wechatMch.setMchKey(mchNew.getMchKey());
                wechatMch.setMchNo(mchNew.getMchNo());
                wechatMch.setP12(mchNew.getP12());
                Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
                Boolean aBoolean = wepay.notifies().verifySign(paymentMap);
                if (aBoolean.booleanValue()) {
                    String transaction_id = (String)paymentMap.get("transaction_id");
                    Assert.notNull((Object)out_trade_no, (String)"out_trade_no null");
                    if (out_trade_no.contains("FIRST")) {
                        this.bookingOrderProcessingFirst(transaction_id, out_trade_no, orders1);
                    } else if (out_trade_no.contains("LAST")) {
                        this.bookingOrderProcessingLast(transaction_id, out_trade_no, source_code, orders1);
                        this.successOrder(transaction_id, source_code);
                    } else {
                        this.successOrder(transaction_id, source_code);
                        this.orderProcessing(transaction_id, source_code);
                    }
                    log.info("\u8ba2\u5355{}\u4ed8\u6b3e\u901a\u77e5\u5904\u7406\u5b8c\u6bd5.", (Object)out_trade_no);
                    return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
                }
            }
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
    }

    private void bookingOrderProcessingFirst(String transaction_id, String out_trade_no, Orders orders) {
        log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355 \u5b9a\u91d1\u652f\u4ed8\u6210\u529f\u5904\u7406!");
        this.scheduledThreadPoolExecutor.execute(() -> {
            String orderNo = this.orderPresellExpandService.paySuccess(out_trade_no, transaction_id, OrderPreSellStatusEnum.PART_PAY_PORTION.getCode());
            try {
                this.orderPresellExpandService.cancelClosePartOrderJob(orders.getId());
                OrderPresellExpandPO orderPresellExpandPO = this.orderPresellExpandService.queryByOrderNoWithType(orderNo, OrderPreSellPayTypeEnum.PART_PAY_ALL.getCode());
                this.orderPresellExpandService.addCloseBalanceOrderJob(orders.getId(), orderPresellExpandPO);
            }
            catch (Exception e) {
                log.error("\u53d6\u6d88\u9884\u552e\u8ba2\u5355  - \u5b9a\u91d1\u53d6\u6d88job error:{}", (Throwable)e);
            }
        });
    }

    private void bookingOrderProcessingLast(String transaction_id, String out_trade_no, String source_no, Orders orders) {
        log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355 \u5c3e\u6b3e\u652f\u4ed8\u6210\u529f\u5904\u7406!");
        this.scheduledThreadPoolExecutor.execute(() -> {
            String orderNo = this.orderPresellExpandService.paySuccess(out_trade_no, transaction_id, OrderPreSellStatusEnum.PART_PAY_ALL.getCode());
            try {
                this.orderPresellExpandService.cancelCloseBalanceOrderJob(orders.getId());
            }
            catch (Exception e) {
                log.error("\u53d6\u6d88\u9884\u552e\u8ba2\u5355  - \u5c3e\u6b3e\u53d6\u6d88job error:{}", (Throwable)e);
            }
            log.info("\u5b9a\u91d1\u9884\u552e\u8ba2\u5355 \u5c3e\u6b3e\u652f\u4ed8\u6210\u529f\u5904\u7406 --> \u6e90\u8ba2\u5355");
            this.orderProcessing(transaction_id, source_no);
        });
    }

    private void successOrder(String transaction_id, String out_trade_no) {
        Orders orders = new Orders();
        orders.setTransactionId(transaction_id);
        orders.setOrderNo(out_trade_no);
        this.orderService.updateForPaySuccess(orders);
    }

    private void orderProcessing(String transaction_id, String out_trade_no) {
        this.scheduledThreadPoolExecutor.execute(() -> {
            Orders orderByOrderNo = this.orderService.findOrderByOrderNo(out_trade_no);
            try {
                log.info("orderByOrderNo\uff1a{}out_trade_no:{}", JSON.toJSON((Object)orderByOrderNo), (Object)out_trade_no);
                if (Integer.valueOf(ShippingModeEnum.SELF_MENTION.getCode()).equals(orderByOrderNo.getShippingMode())) {
                    log.info("orderByOrderNo#startPush");
                    SelfPickNoticeRequestVO requestVO = new SelfPickNoticeRequestVO();
                    requestVO.setBuyerName(orderByOrderNo.getUserName());
                    requestVO.setBuyerPhone(orderByOrderNo.getMobile());
                    requestVO.setOrderNo(out_trade_no);
                    requestVO.setRefundTime(null);
                    requestVO.setSysBrandId(orderByOrderNo.getSysBrandId());
                    requestVO.setSysCompanyId(orderByOrderNo.getSysCompanyId());
                    requestVO.setOrderTime(DateUtil.format((Date)orderByOrderNo.getGmtCreate(), (String)DateUtil.ymdhms));
                    requestVO.setOfflineStoreId(orderByOrderNo.getPickStoreId());
                    requestVO.setWxNick(orderByOrderNo.getUserName());
                    this.bizvaneInterface.selfPickedOrderNoticeShow(requestVO, this.bizvaneProperties.getShowSelfPickedOrderNoticeUrl());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info(e.getMessage());
            }
            try {
                log.info("\u5f00\u59cb\u63a8\u9001\u5fae\u4fe1\u4e0b\u5355\u8ba2\u9605\u6d88\u606f");
                WXMsgTemplateNoticeVO wxMsgTemplateNoticeVO = new WXMsgTemplateNoticeVO();
                wxMsgTemplateNoticeVO.setMerchantId(orderByOrderNo.getMerchantId());
                wxMsgTemplateNoticeVO.setOrderId(orderByOrderNo.getId());
                wxMsgTemplateNoticeVO.setTemplateType(WXMsgTemplateTypeEnum.ADDORDER_NOTICE);
                this.wxMsgNoticeService.payOrderNoticePre(wxMsgTemplateNoticeVO);
            }
            catch (Exception e) {
                log.info(e.getMessage(), (Throwable)e);
            }
            try {
                Orders param = new Orders();
                param.setId(orderByOrderNo.getId());
                Orders od = this.ordersMapper.selectOrdersDetailById((Object)param);
                this.orderPayEnterpriseListener.dispose(od, od.getMerchantId());
            }
            catch (Exception e) {
                log.error("\u8425\u9500\u8ba2\u5355dispose ERROR:{}", (Throwable)e);
            }
        });
    }

    @PostMapping(value={"/wechat/activityRefund"})
    public String activityRefundcallback(HttpServletRequest request) {
        log.info("\u62fc\u56e2\u9000\u6b3e\u8fdb\u5165");
        try {
            Map paymentMap = XmlUtil.readStringXmlOut((InputStream)request.getInputStream());
            String return_code = (String)paymentMap.get("return_code");
            String appid = (String)paymentMap.get("appid");
            String mchNo = (String)paymentMap.get("mch_id");
            log.info("refundcallback paymentMap==>" + JSONObject.toJSONString((Object)paymentMap));
            Example example = new Example(WechatMchNew.class);
            example.createCriteria().andEqualTo("mchNo", (Object)mchNo);
            List mchNewList = this.wechatMchNewMapper.selectByExample((Object)example);
            if (CollectionUtils.isEmpty((Collection)mchNewList)) {
                throw new MallWechatException("appid=" + appid + ",\u672a\u5b8c\u6210\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e");
            }
            WechatMchNew mchNew = (WechatMchNew)mchNewList.get(0);
            if (return_code.equals("SUCCESS")) {
                log.info("activityRefundcallback return_code is success");
                String req_info = (String)paymentMap.get("req_info");
                String s = NotifyController.decryptData((String)req_info, (String)mchNew.getMchKey());
                Map stringStringMap = XmlUtil.readStringXmlOut((String)s);
                log.info("refundcallback req_info==>" + JSONObject.toJSONString((Object)stringStringMap));
                String out_refund_no = (String)stringStringMap.get("out_refund_no");
                String out_trade_no = (String)stringStringMap.get("out_trade_no");
                String refund_status = (String)stringStringMap.get("refund_status");
                if (refund_status.equals("SUCCESS")) {
                    log.info("\u6210\u529f\u8fdb\u884c\u62fc\u56e2\u9000\u6b3e\u56de\u8c03");
                    this.assembleService.updateActivityRefund(new Integer(out_refund_no), out_trade_no);
                    return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
                }
            }
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
    }
}

