/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.config.BizvaneProperties;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassify;
import com.wmeimob.fastboot.bizvane.entity.GoodsPropValueCustom;
import com.wmeimob.fastboot.bizvane.entity.IndexSubjectImg;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.GoodsClassifyService;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.HotGoodsService;
import com.wmeimob.fastboot.bizvane.service.IndexSubjectService;
import com.wmeimob.fastboot.bizvane.service.IndexV3ServiceImpl;
import com.wmeimob.fastboot.bizvane.service.impl.CommonConfigServiceImpl;
import com.wmeimob.fastboot.bizvane.service.order.OrderOperationService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.GuessGoodsVO;
import com.wmeimob.fastboot.core.context.PageContext;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.StringUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mall"})
public class MallController {
    private static final Logger log = LoggerFactory.getLogger(MallController.class);
    @Resource
    private IndexSubjectService indexSubjectService;
    @Resource
    private HotGoodsService hotGoodsService;
    @Resource
    private GoodsService goodsService;
    @Resource
    private GoodsClassifyService goodsClassifyService;
    @Resource(name="commonConfigService")
    private ConfigService configService;
    @Autowired
    private IndexV3ServiceImpl indexService;
    @Autowired
    private CommonConfigServiceImpl commonConfigService;
    @Autowired
    private BizvaneProperties bizvaneProperties;
    @Autowired
    private OrderOperationService orderOperationService;

    @GetMapping(value={"/index"})
    public Map<String, Object> index(@RequestHeader(value="merchantId") Integer merchantId) {
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        IndexSubjectImg indexSubjectImg = this.indexSubjectService.getIndexSubjectImg(merchantId);
        map.put("indexSubjectImg", indexSubjectImg);
        Config config = this.configService.findSysConfig(merchantId);
        map.put("title", config.getTitle());
        return map;
    }

    @GetMapping(value={"/subject/detail/{id}"})
    public IndexSubjectImg getSubject(@PathVariable(value="id") Integer id) {
        return this.indexSubjectService.getIndexSubjectById(id);
    }

    @GetMapping(value={"/index2"})
    public Map<String, Object> index2(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="sysStoreId", required=false, defaultValue="505171") Integer storeId) {
        return this.indexService.indexWrapper(merchantId, storeId);
    }

    @GetMapping(value={"/indexV3"})
    public Map<String, Object> indexV3(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="sysStoreId", required=false, defaultValue="505171") Integer storeId) {
        return this.indexService.indexV3(merchantId, storeId);
    }

    @GetMapping(value={"/subject/detail2/{id}"})
    public Map<String, Object> getSubject(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="id") Integer id) {
        IndexSubjectImg indexSubjectImg = this.indexSubjectService.getIndexSubjectById(id);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("indexSubjectImg", indexSubjectImg);
        List list = this.hotGoodsService.getSubHotGoods(merchantId, indexSubjectImg.getId());
        map.put("list", list);
        return map;
    }

    @GetMapping(value={"/classify"})
    public List<GoodsClassify> getClassifyList(@RequestHeader(value="merchantId") Integer merchantId) {
        InputValidator.checkEmpty((Object)merchantId, (String)"\u53c2\u6570");
        try {
            GoodsClassify classify;
            Iterator car;
            Config sysConfig = this.commonConfigService.findSysConfig(merchantId);
            List result = this.goodsClassifyService.getClassifyList(merchantId);
            if (!sysConfig.getBargain().booleanValue()) {
                car = result.iterator();
                while (car.hasNext()) {
                    classify = (GoodsClassify)car.next();
                    if (!classify.getCoding().equals("bargain")) continue;
                    car.remove();
                }
            }
            if (!sysConfig.getAssemble().booleanValue()) {
                car = result.iterator();
                while (car.hasNext()) {
                    classify = (GoodsClassify)car.next();
                    if (!classify.getCoding().equals("assemble")) continue;
                    car.remove();
                }
            }
            return result;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @GetMapping(value={"/goods/detail/{goodsId}"})
    public Map<String, Object> goodDetail(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="sysStoreId", required=false, defaultValue="505171") Integer storeId, @PathVariable(value="goodsId") Integer goodsId, String memberCode) {
        return this.indexService.goodDetailWrapper(merchantId, goodsId, storeId, memberCode);
    }

    @GetMapping(value={"/goods/detailV3/{goodsId}"})
    public Map<String, Object> goodDetailV3(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="sysStoreId", required=false, defaultValue="505171") Integer storeId, @PathVariable(value="goodsId") Integer goodsId, String memberCode) {
        Integer[] storeSelfPrice = this.bizvaneProperties.getStoreSelfPrice();
        if (storeSelfPrice != null && storeSelfPrice.length != 0 && Arrays.asList(storeSelfPrice).contains(merchantId) && StringUtils.isEmpty((Object)storeId)) {
            throw new MallWechatException("\u67e5\u8be2\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5");
        }
        return this.indexService.goodDetailV3(merchantId, goodsId, storeId, memberCode);
    }

    @GetMapping(value={"/goods/pros/{goodsId}"})
    public List<GoodsPropValueCustom> getGoodsPros(@PathVariable(value="goodsId") Integer goodsId) {
        InputValidator.checkEmpty((Object)goodsId, (String)"\u53c2\u6570");
        List list = this.goodsService.getGoodsPropsByGoodsId(goodsId);
        return list;
    }

    @GetMapping(value={"/goods/evaluate/{goodsId}"})
    public HashMap<String, Object> getGoodsEvaluate(@PathVariable(value="goodsId") Integer goodsId) {
        InputValidator.checkEmpty((Object)goodsId, (String)"\u53c2\u6570");
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        PageContext.startPage();
        List comments = this.goodsService.getGoodsEvaluate(goodsId);
        map.put("comments", new PageInfo(comments));
        Integer[] sumGrade = new Integer[]{0};
        BigDecimal degress = new BigDecimal("0");
        if (null != comments && !comments.isEmpty()) {
            comments.forEach(x -> {
                sumGrade[0] = sumGrade[0] + x.getGoodsGrade();
            });
            degress = new BigDecimal(sumGrade[0]).divide(new BigDecimal(comments.size()), 1, 4).multiply(new BigDecimal("2"));
        }
        map.put("degress", degress);
        return map;
    }

    @GetMapping(value={"findByGroudId"})
    public ResponseData findByGroudId(@RequestHeader Integer merchantId, Integer groudId, Integer page, Integer pageSize, Boolean pageJudge) {
        return this.goodsService.findByGroudId(merchantId, groudId, page, pageSize, pageJudge);
    }

    @PostMapping(value={"guessGoods"})
    public ResponseData guessGoods(@RequestHeader Integer merchantId, @RequestBody GuessGoodsVO guessGoodsVO) {
        log.info("MallController_guessGoods{}", JSON.toJSON((Object)guessGoodsVO));
        PageInfo pageInfo = this.goodsService.guessGoods(merchantId, guessGoodsVO);
        return ResponseUtil.getSuccessData((Object)pageInfo);
    }

    @PostMapping(value={"/notifyForCloseOrderById/{orderId}"})
    public ResponseData notifyForCloseOrderById(@PathVariable(value="orderId") Integer orderId) {
        ResponseData responseData = this.orderOperationService.notifyForCloseOrderById(orderId);
        return responseData;
    }
}

