/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.GoodsQueryDTO;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.IndexV3ServiceImpl;
import com.wmeimob.fastboot.bizvane.service.impl.SendMsgToQWServiceImpl;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"goods"})
public class GoodsController {
    private static final Logger log = LoggerFactory.getLogger(GoodsController.class);
    @Autowired
    private SendMsgToQWServiceImpl sendMsgToQWService;
    @Autowired
    private IndexV3ServiceImpl indexV3Service;
    @Autowired
    private GoodsService goodsService;

    @GetMapping
    public PageInfo<Goods> classifyIndex(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="sysStoreId", required=false, defaultValue="505171") Integer storeId, GoodsQueryDTO goodsQueryDTO) {
        log.info("GoodsController#classifyIndex merchantId:{},storeId:{},goodsQueryDTO:{}", new Object[]{merchantId, storeId, JSON.toJSONString((Object)goodsQueryDTO)});
        return this.indexV3Service.classifyIndex(goodsQueryDTO, merchantId, storeId);
    }

    @GetMapping(value={"V1"})
    public PageInfo<Goods> classifyIndexV1(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="sysStoreId", required=false, defaultValue="505171") Integer storeId, GoodsQueryDTO goodsQueryDTO) {
        return this.indexV3Service.classifyIndex(goodsQueryDTO, merchantId, storeId);
    }

    @PostMapping(value={"memberLookGoods/{memberCode}"})
    public void lookGoods(@PathVariable(value="memberCode") String memberCode, @RequestBody Goods goods) {
        log.info("\u4e13\u5c5e\u4f1a\u5458\u67e5\u770b\u5546\u54c1\u901a\u77e5\u4f01\u5fae\u5165\u53c2:memberCode:[{}],goods:[{}]", (Object)memberCode, JSON.toJSON((Object)goods));
        this.sendMsgToQWService.sendGoodsMsg(goods, memberCode, 1);
    }

    @PostMapping(value={"findByNo"})
    public ResponseData lookGoods(@RequestHeader(value="merchantId") Integer merchantId, String goodsNo) {
        log.info("\u6839\u636egoodsNo\u67e5\u8be2\u5546\u54c1\u4fe1\u606f:merchantId:[{}],goodsNo:[{}]", (Object)merchantId, (Object)goodsNo);
        GoodsPO byNo = this.goodsService.findByNo(merchantId, goodsNo);
        return ResponseUtil.getSuccessData((Object)byNo);
    }
}

