/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.BargainPlayers;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.exception.UserException;
import com.wmeimob.fastboot.bizvane.service.BargainPlayersService;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.CutDownService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.fastboot.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"cutDown"})
public class CutDownProcessingController {
    private static final Logger log = LoggerFactory.getLogger(CutDownProcessingController.class);
    @Autowired
    private CutDownService cutDownService;
    @Resource
    private UserService userService;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;
    @Resource
    private UserCommissionService userCommissionService;
    @Autowired
    private BargainPlayersService bargainPlayersService;

    @GetMapping(value={"getActivityGoodList"})
    public JSONObject getActivityGoodList(@RequestHeader(value="merchantId") Integer merchantId) {
        List activityGoodList = this.cutDownService.getActivityGoodList(merchantId);
        JSONObject result = new JSONObject();
        result.put("code", (Object)0);
        result.put("data", (Object)activityGoodList);
        return result;
    }

    @GetMapping(value={"getActivityGoodListByMe"})
    public JSONObject getActivityGoodListByMe(@RequestHeader(value="merchantId") Integer merchantId) {
        User user = (User)SecurityContext.getUser();
        JSONObject result = new JSONObject();
        result.put("code", (Object)0);
        List activityGoodListByMe = this.cutDownService.getActivityGoodListByMe(user.getUserNo(), merchantId);
        result.put("data", (Object)activityGoodListByMe);
        return result;
    }

    @GetMapping(value={"getGoodsDetail"})
    public Map getGoodsDetail(@RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="goodsNo") String goodsNo, @RequestParam(value="marketActivityNo") String marketActivityNo, @RequestParam(value="activityOrdersId", required=false) String activityOrdersId, @RequestParam(value="goodsId") Integer goodsId) {
        User user = (User)SecurityContext.getUser();
        MarketActivityGoods goods = new MarketActivityGoods();
        goods.setGoodsNo(goodsNo);
        goods.setGoodsId(goodsId);
        if (!StringUtils.isEmpty((Object)activityOrdersId)) {
            if (!"-100".equals(activityOrdersId)) {
                goods.setActivityOrdersId(Integer.valueOf(Integer.parseInt(activityOrdersId)));
            } else {
                goods.setActivityOrdersId(null);
            }
        }
        goods.setMarketActivityNo(marketActivityNo);
        goods.setMerchantId(merchantId);
        goods.setUserNo(user.getUserNo());
        return this.cutDownService.getGoodsDetail(goods);
    }

    @PostMapping(value={"confirm"})
    public JSONObject confirm(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Orders orders) {
        User user = (User)SecurityContext.getUser();
        orders.setUserId(user.getUserId());
        orders.setUserNo(user.getUserNo());
        orders.setWechatUnionId(user.getUnionid());
        orders.setMerchantId(merchantId);
        JSONObject result = new JSONObject();
        log.info("\u780d\u4ef7confirm\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)orders));
        result.put("code", (Object)0);
        Orders confirm = this.cutDownService.confirm(orders);
        result.put("data", (Object)confirm);
        return result;
    }

    @PostMapping(value={"confirmOk"})
    public Map confirmOk(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestBody Orders createObject) {
        Boolean parentState;
        User user = (User)SecurityContext.getUser();
        log.info("wechat-CutDownProcessingController-confirmOk\u63a5\u53e3-user:{}", (Object)JSON.toJSONString((Object)user));
        User queryUser = (User)this.userService.findOneByCondition((Serializable)user);
        createObject.setWechatOpenid(user.getOpenid());
        createObject.setUserNo(user.getUserNo());
        createObject.setMerchantId(merchantId);
        createObject.setUserId(user.getUserId());
        createObject.setUserName(queryUser.getFullName());
        createObject.setAppid(appid);
        createObject.setSysBrandId(this.companyBrandRelationService.getBrandIdByMerchantId(merchantId));
        createObject = this.copy(createObject, queryUser);
        try {
            parentState = this.userCommissionService.findParentState(queryUser.getUserNo());
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u4e0a\u7ea7\u5206\u9500\u5f02\u5e38{}", (Object)e.getMessage());
            parentState = false;
        }
        createObject.setEnabledCommission(parentState);
        createObject.setWechatUnionId(queryUser.getUnionid());
        log.info("\u780d\u4ef7confirmOk\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)createObject));
        return this.cutDownService.addOrders(createObject);
    }

    private Orders copy(Orders createObject, User queryUser) {
        createObject.setMobile(queryUser.getUserPhone());
        User tempUser = new User();
        tempUser.setBrandId(queryUser.getBrandId());
        tempUser.setSysCompanyId(queryUser.getSysCompanyId());
        tempUser.setUnionid(queryUser.getUnionid());
        tempUser.setUserNo(queryUser.getUserNo());
        UserDiscountDTO memberLevel = this.userService.getUserDiscountInfo(tempUser);
        createObject.setMemberLevelName(memberLevel.getMemberLevelName());
        return createObject;
    }

    @PostMapping(value={"addMarketOrders"})
    public JSONObject addMarketOrders(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestBody Orders createObject) {
        User user = (User)SecurityContext.getUser();
        log.info("wechat-CutDownProcessingController-addMarketOrders\u63a5\u53e3-user:{}", (Object)JSON.toJSONString((Object)user));
        User queryUser = (User)this.userService.findOneByCondition((Serializable)user);
        createObject.setWechatOpenid(user.getOpenid());
        createObject.setUserNo(user.getUserNo());
        createObject.setMerchantId(merchantId);
        createObject.setUserId(user.getUserId());
        createObject.setUserName(queryUser.getFullName());
        createObject.setAppid(appid);
        createObject.setLaunchUserNo(user.getUserNo());
        createObject.setWechatUnionId(queryUser.getUnionid());
        JSONObject result = new JSONObject();
        result.put("code", (Object)0);
        log.info("\u780d\u4ef7addMarketOrders\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)createObject));
        MarketActivityOrders order = this.cutDownService.addMarketOrders(createObject);
        result.put("data", (Object)order);
        return result;
    }

    @PostMapping(value={"helpFriendsInfo"})
    public JSONObject helpFriendsInfo(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody MarketActivityOrders marketActivityOrders) {
        marketActivityOrders.setMerchantId(merchantId);
        JSONObject result = new JSONObject();
        result.put("code", (Object)0);
        log.info("\u780d\u4ef7helpFriendsInfo\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)marketActivityOrders));
        MarketActivityOrders query = this.cutDownService.helpFriendsInfo(marketActivityOrders);
        result.put("data", (Object)query);
        return result;
    }

    @PostMapping(value={"helpCut"})
    public JSONObject helpCut(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody MarketActivityOrders marketActivityOrders) {
        User user = (User)SecurityContext.getUser();
        log.info("CutDownProcessingController#helpCut merchantId:{},marketActivityOrders:{},user:{}", new Object[]{merchantId, JSON.toJSONString((Object)marketActivityOrders), JSON.toJSONString((Object)user)});
        User queryUser = (User)this.userService.findOneByCondition((Serializable)user);
        JSONObject result = new JSONObject();
        result.put("code", (Object)0);
        if (StringUtils.isEmpty((Object)queryUser.getUserNo()) || StringUtils.isEmpty((Object)marketActivityOrders.getLaunchUserNo())) {
            throw new UserException("\u7528\u6237\u4fe1\u606f\u672a\u62ff\u5230\uff0c\u4e0d\u80fd\u780d\u4ef7");
        }
        if (marketActivityOrders.getLaunchUserNo().equals(queryUser.getUserNo())) {
            result.put("code", (Object)1);
            result.put("msg", (Object)"\u4e0d\u80fd\u81ea\u5df1\u7ed9\u81ea\u5df1\u780d\u4ef7");
        }
        if (marketActivityOrders.getId() == null) {
            throw new MallWechatException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        marketActivityOrders.setMerchantId(merchantId);
        ((BargainPlayers)marketActivityOrders.getBargainPlayers().get(0)).setOpenId(queryUser.getOpenid());
        marketActivityOrders.setOpenId(queryUser.getOpenid());
        marketActivityOrders.setUserNo(queryUser.getUserNo());
        log.info("\u780d\u4ef7helpCut\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)marketActivityOrders));
        String helpCut = this.cutDownService.helpCut(marketActivityOrders);
        result.put("data", (Object)helpCut);
        return result;
    }

    @GetMapping(value={"/flushBarginPlays"})
    @ResponseBody
    public RestResult flushBarginPlays(@RequestParam(value="activityOrdersId") String activityOrdersId) {
        log.info("flushBarginPlays\u7684\u5165\u53c2activityOrdersId:{}", (Object)activityOrdersId);
        return this.bargainPlayersService.queryBarginPlays(activityOrdersId);
    }
}

