/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.mzlion.core.lang.StringUtils;
import com.wmeimob.fastboot.bizvane.dto.CouponDTO;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.CouponService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.core.context.PageContext;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"coupons"})
@PreAuthorize(value="hasRole('USER')")
public class CouponController {
    private static final Logger log = LoggerFactory.getLogger(CouponController.class);
    @Resource
    private CouponService couponService;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersServiceImpl;
    @Resource
    private BizvaneInterface bizvaneInterface;

    @GetMapping
    public List<CouponDTO> getCoupons() {
        User user = (User)SecurityContext.getUser();
        return this.couponService.findByCondition((Serializable)CouponDTO.builder().userNo(user.getUserNo()).merchantId(user.getBrandId()).build());
    }

    @PostMapping(value={"mine-box"})
    public Map<String, Object> getMyCoupon(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestHeader(value="sysStoreId", required=false, defaultValue="505171") Integer sysStoreId, @RequestHeader(value="offlineStoreId", required=false, defaultValue="26572") String offlineStoreId, @RequestBody Orders createObject) {
        log.info("CouponController#getMyCoupon merchantId:{},appid:{},sysStoreId:{},offlineStoreId:{},createObject:{}", new Object[]{merchantId, appid, sysStoreId, offlineStoreId, createObject});
        Integer pageIndex = PageContext.pageIndex();
        User user = (User)SecurityContext.getUser();
        createObject.setMerchantId(merchantId);
        createObject.setUserNo(user.getUserNo());
        createObject.setMerchantId(merchantId);
        createObject.setUserId(user.getUserId());
        createObject.setAppid(appid);
        createObject.setWechatUnionId(user.getUnionid());
        if (StringUtils.isEmpty((String)createObject.getSysStoreId())) {
            createObject.setSysStoreId(sysStoreId + "");
        }
        if (StringUtils.isEmpty((String)createObject.getOfflineStoreId())) {
            createObject.setOfflineStoreId(offlineStoreId);
        }
        return this.couponService.findMineCoupons(CouponDTO.builder().userNo(user.getUserNo()).merchantId(user.getBrandId()).build(), pageIndex, createObject);
    }

    @PostMapping(value={"mine"})
    public Map<String, Object> pickupCoupon(CouponDTO couponDTO) {
        User user = (User)SecurityContext.getUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberInfoModel.brandId", user.getMerchantId());
        map.put("memberInfoModel.memberCode", user.getUserNo());
        map.put("couponDefinitionId", couponDTO.getDefinitionId());
        map.put("mktActivityId", couponDTO.getActivityId());
        map.put("activityType", 4);
        return this.couponService.addCoupon(map);
    }

    @GetMapping(value={"mine/{id}"})
    public CouponDTO getDetailById(@PathVariable Integer id) {
        return (CouponDTO)this.couponService.findById(id);
    }

    @GetMapping(value={"/getCouponReceiveStatus"})
    public ResponseData getCouponReceiveStatus(Long couponIds) {
        User user = (User)SecurityContext.getUser();
        JSONObject param = new JSONObject();
        param.put("memberCode", (Object)user.getMerchantId());
        param.put("couponIds", (Object)user.getUserNo());
        param.put("brandId", (Object)couponIds);
        return this.bizvaneInterface.getCouponReceiveStatus(param);
    }
}

