/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.config.MallWechatException;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.mapper.ConfigMapper;
import com.wmeimob.fastboot.bizvane.service.AssembleService;
import com.wmeimob.fastboot.bizvane.service.CompanyBrandRelationService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"assemble"})
public class AssembleController {
    private static final Logger log = LoggerFactory.getLogger(AssembleController.class);
    @Autowired
    private AssembleService assembleService;
    @Resource
    private UserService userService;
    @Resource
    private UserCommissionService userCommissionService;
    @Autowired
    private ConfigMapper configMapper;
    @Autowired
    private CompanyBrandRelationService companyBrandRelationService;

    @GetMapping(value={"getActivityGoodList"})
    public List<MarketActivityGoods> getActivityGoodList(@RequestHeader(value="merchantId") Integer merchantId) {
        return this.assembleService.getActivityGoodList(merchantId);
    }

    @GetMapping(value={"getActivityGoodListByMe"})
    public List<MarketActivityGoods> getActivityGoodListByMe(@RequestHeader(value="merchantId") Integer merchantId) {
        User user = (User)SecurityContext.getUser();
        return this.assembleService.getActivityGoodListByMe(user.getUserNo(), merchantId);
    }

    @GetMapping(value={"getOrdersDetail"})
    public MarketActivityOrders getOrdersDetail(@RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="activityOrdersId") Integer activityOrdersId) {
        return this.assembleService.getOrdersDetail(activityOrdersId, merchantId);
    }

    @GetMapping(value={"getGoodsDetail"})
    public Map getGoodsDetail(@RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="goodsNo") String goodsNo, @RequestParam(value="marketActivityNo") String marketActivityNo) {
        log.info("AssembleController#getGoodsDetail merchantId:{},goodsNo:{},marketActivityNo:{}", new Object[]{merchantId, goodsNo, marketActivityNo});
        User user = (User)SecurityContext.getUser();
        log.info("AssembleController#getGoodsDetail user:{}", (Object)JSON.toJSONString((Object)user));
        return this.assembleService.getGoodsDetail(goodsNo, merchantId, marketActivityNo, user.getUserNo());
    }

    @PostMapping(value={"confirm"})
    public Orders confirm(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Orders orders) {
        log.info("POST...method:\u62fc\u56e2 confirm....params===>{}", (Object)JSONObject.toJSONString((Object)orders));
        User user = (User)SecurityContext.getUser();
        orders.setUserId(user.getUserId());
        orders.setUserNo(user.getUserNo());
        orders.setWechatUnionId(user.getUnionid());
        orders.setMerchantId(merchantId);
        if (orders.getLaunchUserNo() != null && orders.getLaunchUserNo().equals(user.getUserNo())) {
            throw new MallWechatException("\u4e0d\u80fd\u53c2\u4e0e\u81ea\u5df1\u53d1\u8d77\u7684\u62fc\u56e2");
        }
        return this.assembleService.confirm(orders);
    }

    @PostMapping(value={"confirmOk"})
    public Map confirmOk(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestBody Orders createObject) {
        User user = (User)SecurityContext.getUser();
        log.info("wechat-AssembleController-confirmOk\u63a5\u53e3-user:{}", (Object)JSON.toJSONString((Object)user));
        User queryUser = (User)this.userService.findOneByCondition((Serializable)user);
        createObject.setWechatOpenid(user.getOpenid());
        createObject.setUserNo(user.getUserNo());
        createObject.setMerchantId(merchantId);
        createObject.setUserId(user.getUserId());
        createObject.setUserName(queryUser.getFullName());
        createObject.setAppid(appid);
        createObject.setSysBrandId(this.companyBrandRelationService.getBrandIdByMerchantId(merchantId));
        createObject = this.copy(createObject, queryUser);
        Boolean parentState = this.userCommissionService.findParentState(queryUser.getUserNo());
        createObject.setEnabledCommission(parentState);
        createObject.setWechatUnionId(queryUser.getUnionid());
        return this.assembleService.addOrders(createObject);
    }

    private Orders copy(Orders createObject, User queryUser) {
        createObject.setMobile(queryUser.getUserPhone());
        User tempUser = new User();
        tempUser.setBrandId(queryUser.getBrandId());
        tempUser.setSysCompanyId(queryUser.getSysCompanyId());
        tempUser.setUnionid(queryUser.getUnionid());
        tempUser.setUserNo(queryUser.getUserNo());
        UserDiscountDTO memberLevel = this.userService.getUserDiscountInfo(tempUser);
        createObject.setMemberLevelName(memberLevel.getMemberLevelName());
        return createObject;
    }

    @GetMapping(value={"getAssemblePicUrl"})
    public Map getAssemblePicUrl(@RequestHeader(value="merchantId") Integer merchantId) {
        return this.assembleService.getAssemblePicUrl(merchantId);
    }

    @GetMapping(value={"getConfig"})
    @ResponseBody
    public Config getConfig(@RequestHeader(value="merchantId") Integer merchantId) {
        Config condition = new Config();
        condition.setMerchantId(merchantId);
        Config config = (Config)this.configMapper.selectOne((Object)condition);
        return config;
    }
}

