/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.config;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.starter.security.interfaces.JsonWebTokenEncoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;

class WechatJsonWebTokenEncoder
implements JsonWebTokenEncoder {
    private static final Logger log = LoggerFactory.getLogger(WechatJsonWebTokenEncoder.class);

    protected WechatJsonWebTokenEncoder() {
    }

    public Map<String, Object> encode(UserDetails userDetails) {
        User user = (User)userDetails;
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("openid", user.getOpenid());
        claims.put("userNo", user.getUserNo());
        claims.put("appid", user.getAppid());
        claims.put("roles", user.getAuthorities());
        claims.put("unionid", user.getUnionid());
        claims.put("merchantId", user.getMerchantId());
        claims.put("brandId", user.getBrandId());
        claims.put("userId", user.getUserId());
        claims.put("sysStoreId", user.getSysStoreId());
        claims.put("offlineStoreId", user.getOfflineStoreId());
        claims.put("levelId", user.getLevelId());
        log.debug("WechatJsonWebTokenEncoder.\u8bbe\u7f6e\u8fdb\u53bb\u7684user:[{}]", JSON.toJSON((Object)user));
        return claims;
    }
}

