/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.config;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.BizvaneRole;
import com.wmeimob.fastboot.starter.security.interfaces.JsonWebTokenDecoder;
import io.jsonwebtoken.Claims;
import java.io.Serializable;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

class WechatJsonWebTokenDecoder
implements JsonWebTokenDecoder {
    private static final Logger log = LoggerFactory.getLogger(WechatJsonWebTokenDecoder.class);

    protected WechatJsonWebTokenDecoder() {
    }

    public UserDetails decode(Claims claims) {
        String openid = (String)claims.get((Object)"openid");
        String userNo = (String)claims.get((Object)"userNo");
        String appid = (String)claims.get((Object)"appid");
        String unionId = (String)claims.get((Object)"unionid");
        Integer merchantId = (Integer)claims.get((Object)"merchantId");
        Integer brandId = (Integer)claims.get((Object)"brandId");
        Number userId = (Number)claims.get((Object)"userId");
        Number sysStoreId = (Number)claims.get((Object)"sysStoreId");
        Integer levelId = (Integer)claims.get((Object)"levelId");
        User user = new User();
        user.setOpenid(openid);
        user.setUserNo(userNo);
        user.setAppid(appid);
        user.setUnionid(unionId);
        user.setMerchantId(merchantId);
        user.setBrandId(brandId);
        user.setLevelId(levelId);
        log.info("WechatJsonWebTokenDecoder.\u5904\u7406\u5b8c\u6210\u7684user:[{}]", JSON.toJSON((Object)user));
        if (claims.containsKey((Object)"offlineStoreId") && claims.get((Object)"offlineStoreId") != null) {
            user.setOfflineStoreId((String)claims.get((Object)"offlineStoreId"));
        }
        log.debug("WechatJsonWebTokenDecoder.\u5904\u7406\u5b8c\u6210\u7684user:[{}]", JSON.toJSON((Object)user));
        if (userId != null) {
            user.setUserId(Long.valueOf(userId.longValue()));
        }
        if (sysStoreId != null) {
            user.setSysStoreId(Long.valueOf(sysStoreId.longValue()));
        }
        ArrayList<GrantedAuthority & Serializable> authorities = new ArrayList<GrantedAuthority & Serializable>();
        authorities.add(() -> ((BizvaneRole)BizvaneRole.USER).role());
        user.setAuthorities(authorities);
        return user;
    }
}

