/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.config;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.enums.BizvaneRole;
import com.wmeimob.fastboot.core.startup.WmeimobStartUpRunnable;
import com.wmeimob.fastboot.core.startup.WmeimobStartUpRunnableProvider;
import com.wmeimob.fastboot.starter.security.JsonWebTokenHandler;
import com.wmeimob.fastboot.starter.security.JwtAuthenticationFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
@EnableAspectJAutoProxy(exposeProxy=true)
public class BizvaneStartUp
implements WmeimobStartUpRunnableProvider {
    private static final Logger log = LoggerFactory.getLogger(BizvaneStartUp.class);
    @Resource
    protected JwtAuthenticationFilter jwtAuthenticationTokenFilter;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public void run(WmeimobStartUpRunnable wmeimobStartUpRunnable) {
        wmeimobStartUpRunnable.run(WmeimobStartUpRunnable.Mode.OVERRIDE, () -> {
            JsonWebTokenHandler jsonWebTokenHandler = this.jwtAuthenticationTokenFilter.getJsonWebTokenHandler();
            jsonWebTokenHandler.setJsonWebTokenDecoder(claims -> {
                String openid = (String)claims.get((Object)"openid");
                String userNo = (String)claims.get((Object)"userNo");
                String appid = (String)claims.get((Object)"appid");
                String unionId = (String)claims.get((Object)"unionid");
                Integer merchantId = (Integer)claims.get((Object)"merchantId");
                Integer brandId = (Integer)claims.get((Object)"brandId");
                Number userId = (Number)claims.get((Object)"userId");
                Number sysStoreId = (Number)claims.get((Object)"sysStoreId");
                Integer levelId = (Integer)claims.get((Object)"levelId");
                User user = new User();
                user.setOpenid(openid);
                user.setUserNo(userNo);
                user.setAppid(appid);
                user.setUnionid(unionId);
                user.setMerchantId(merchantId);
                user.setBrandId(brandId);
                user.setLevelId(levelId);
                log.info("\u5904\u7406\u5b8c\u6210\u7684user:[{}]", JSON.toJSON((Object)user));
                user.setOfflineStoreId(claims.containsKey((Object)"offlineStoreId") ? (String)claims.get((Object)"offlineStoreId") : null);
                log.debug("\u5904\u7406\u5b8c\u6210\u7684user:[{}]", JSON.toJSON((Object)user));
                if (userId != null) {
                    user.setUserId(Long.valueOf(userId.longValue()));
                }
                if (sysStoreId != null) {
                    user.setSysStoreId(Long.valueOf(sysStoreId.longValue()));
                }
                ArrayList<GrantedAuthority & Serializable> authorities = new ArrayList<GrantedAuthority & Serializable>();
                authorities.add(() -> ((BizvaneRole)BizvaneRole.USER).role());
                user.setAuthorities(authorities);
                return user;
            });
            jsonWebTokenHandler.setJsonWebTokenEncoder(userDetails -> {
                User user = (User)userDetails;
                HashMap<String, Object> claims = new HashMap<String, Object>();
                claims.put("openid", user.getOpenid());
                claims.put("userNo", user.getUserNo());
                claims.put("appid", user.getAppid());
                claims.put("roles", user.getAuthorities());
                claims.put("unionid", user.getUnionid());
                claims.put("merchantId", user.getMerchantId());
                claims.put("brandId", user.getBrandId());
                claims.put("userId", user.getUserId());
                claims.put("sysStoreId", user.getSysStoreId());
                claims.put("offlineStoreId", user.getOfflineStoreId());
                claims.put("levelId", user.getLevelId());
                log.debug("\u8bbe\u7f6e\u8fdb\u53bb\u7684user:[{}]", JSON.toJSON((Object)user));
                return claims;
            });
            jsonWebTokenHandler.setJsonWebTokenReplayAttacksDefiniens((ud, token) -> {
                User user = (User)ud;
                this.stringRedisTemplate.opsForValue().set((Object)("opens:authorizer_appids:" + user.getAppid() + ":openids:" + user.getOpenid() + ":token"), (Object)token);
            });
            jsonWebTokenHandler.setJsonWebTokenReplayAttacksDetector((token, userDetails) -> {
                User user = (User)userDetails;
                String cacheToken = (String)this.stringRedisTemplate.opsForValue().get((Object)("opens:authorizer_appids:" + user.getAppid() + ":openids:" + user.getOpenid() + ":token"));
                if (!token.equals(cacheToken)) {
                    throw new BadCredentialsException("\u65e0\u6548\u7684token");
                }
            });
        });
    }
}

