/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.config;

import com.wmeimob.fastboot.bizvane.config.BizvaneJsonWebTokenHandler;
import com.wmeimob.fastboot.starter.security.JsonWebToken;
import com.wmeimob.fastboot.starter.security.interfaces.JsonWebTokenDecoder;
import com.wmeimob.fastboot.starter.security.interfaces.JsonWebTokenEncoder;
import com.wmeimob.fastboot.starter.security.interfaces.impl.UserJsonWebTokenDecoder;
import com.wmeimob.fastboot.starter.security.interfaces.impl.UserJsonWebTokenEncoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.RequestHeaderAuthenticationFilter;

public class BizvaneJwtAuthenticationFilter
extends RequestHeaderAuthenticationFilter {
    private BizvaneJsonWebTokenHandler jsonWebTokenHandler;
    public static final String DEFAULT_HEADER = "Authorization";
    private AuthenticationManager authenticationManager;

    public BizvaneJsonWebTokenHandler getJsonWebTokenHandler() {
        return this.jsonWebTokenHandler;
    }

    @Autowired
    public BizvaneJwtAuthenticationFilter(JsonWebToken jsonWebToken) {
        BizvaneJsonWebTokenHandler jsonWebTokenHandler = new BizvaneJsonWebTokenHandler();
        this.setExceptionIfHeaderMissing(false);
        String queryHeader = DEFAULT_HEADER;
        if (jsonWebToken != null && jsonWebToken.getHeader() != null) {
            queryHeader = jsonWebToken.getHeader();
        }
        this.setPrincipalRequestHeader(queryHeader);
        jsonWebTokenHandler.setJsonWebToken(jsonWebToken);
        jsonWebTokenHandler.setJsonWebTokenDecoder((JsonWebTokenDecoder)new UserJsonWebTokenDecoder());
        jsonWebTokenHandler.setJsonWebTokenEncoder((JsonWebTokenEncoder)new UserJsonWebTokenEncoder());
        jsonWebTokenHandler.setJsonWebTokenReplayAttacksDetector((a, b) -> {});
        jsonWebTokenHandler.setJsonWebTokenReplayAttacksDefiniens((a, b) -> {});
        this.jsonWebTokenHandler = jsonWebTokenHandler;
    }

    @Autowired
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
        super.setAuthenticationManager(authenticationManager);
    }
}

